# Consent forbid data access except for Break-Glass - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consent forbid data access except for Break-Glass**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](Consent-ex-dissent-intermediate-break-glass.xml.md) 
*  [JSON](Consent-ex-dissent-intermediate-break-glass.json.md) 

## Example Consent: Consent forbid data access except for Break-Glass

Profile: [IHE PCF Explicit Intermediate Consent](StructureDefinition-IHE.PCF.consentIntermediate.md)

Security Label: test health data (Details: ActReason code HTEST = 'test health data')

**status**: Active

**scope**: Privacy Consent

**category**: Consent

**patient**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**dateTime**: 2022-06-13

**performer**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**organization**: [Organization somewhere org](Organization-ex-organization.md)

**source**: [DocumentReference: status = current; type = Release of information consent; description = The captured signed document](DocumentReference-ex-documentreference.md)

### Policies

| | |
| :--- | :--- |
| - | **Uri** |
| * | [https://profiles.ihe.net/ITI/PCF/Policy-break-glass-only](volume-1.md#break-glass-only) |

> **provision****type**: Opt Out
> **provision****type**: Opt In

### Actors

| | | |
| :--- | :--- | :--- |
| - | **Role** | **Reference** |
| * | information recipient | [Group Those users that the organization authorizes to use Break-Glass](Group-ex-privilegedUsers.md) |

**purpose**:[ActReason BTG](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-BTG): break the glass

### Notes:

#### IUA Access Token

This Consent denies all access except for break-glass; thus any access request that has not declared break-glass purposeOfUse (BTG), or for which the user is not authorized to declare break-glass; would be rejected and not given any access token. This rejection would be recognized by users that know that they are authorized to break-glass that they might choose to declare a break-glass safety concern. There might be more refined user-interface or user-experience than this, but specification of that user-interface is out of the scope of PCF.

Provided an [ITI-71](other.md#updates-to-iti-71) is requested by an authorized user with PurposeOfUse indicating break-glass, then this would result in a PERMIT access token issued. That token would have the following residual element to inform the **Consent Enforcement Point** that it needs to restrict the results.

* The restriction to the given purpose (FooBar) would be expressed in the `ihe_iua` extension 
* The other `ihe_iua` extension parameters are not shown below
 
* The consent is indicated in the `ihe_pcf` 
* no `residual` element is provided, indicating that no residual rules need be enforced
 

```
"extensions" : {
  "ihe_iua" : {
    ...
    "purpose_of_use" : [{
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "BTG"
    }]
  }
  "ihe_pcf" : {
    "patient_id" : "http://example.org/fhir/Patient/ex-patient",
    "doc_id" : ["http://example.org/fhir/Consent/ex-consent-intermediate-dissent-break-glass"]
  }
}

```

| | | |
| :--- | :--- | :--- |
|  [<prev](Consent-ex-consent-intermediate-data.ttl.md) | [top](#top) |  [next>](Consent-ex-dissent-intermediate-break-glass.xml.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

