# Consent allowing most sharing but NOT data authored by a practitioner - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consent allowing most sharing but NOT data authored by a practitioner**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](Consent-ex-consent-intermediate-not-authoredby.xml.md) 
*  [JSON](Consent-ex-consent-intermediate-not-authoredby.json.md) 

## Example Consent: Consent allowing most sharing but NOT data authored by a practitioner

Profile: [IHE PCF Explicit Intermediate Consent](StructureDefinition-IHE.PCF.consentIntermediate.md)

Security Label: test health data (Details: ActReason code HTEST = 'test health data')

**status**: Active

**scope**: Privacy Consent

**category**: Consent

**patient**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**dateTime**: 2022-06-13

**performer**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**organization**: [Organization somewhere org](Organization-ex-organization.md)

**source**: [DocumentReference: status = current; type = Release of information consent; description = The captured signed document](DocumentReference-ex-documentreference.md)

### Policies

| | |
| :--- | :--- |
| - | **Uri** |
| * | [http://example.org/policies/basePrivacyConsentPolicy.txt](http://example.org/policies/basePrivacyConsentPolicy.txt) |

> **provision****type**: Opt In**purpose**:[ActReason TREAT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-TREAT): treatment,[ActReason HPAYMT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-HPAYMT): healthcare payment,[ActReason HOPERAT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-HOPERAT): healthcare operations
> **provision****type**: Opt Out

### Data

| | | |
| :--- | :--- | :--- |
| - | **Meaning** | **Reference** |
| * | AuthoredBy | [Practitioner: telecom = Practitioner@example.com](Practitioner-ex-practitioner.md) |



### Notes:

#### IUA Access Token

Provided an [ITI-71](other.md#updates-to-iti-71) results in a PERMIT access token issued. That token would have the following residual element to inform the **Consent Enforcement Point** that it needs to restrict the results.

Given that the token will express the permit portion, the `residual` would need to express the refinement. In this case the oAuth token and scope will address a general permit, and thus the `residual` need only express the forbid to information authored by the given practitioner.

The token would need to include an `ihe_pcf` extension to point at this consent, and that would include a `residual` to express the refinement. Shown as followed:

* The restriction to the given purpose (Treatment, Payment, and Operations) would be expressed in the `ihe_iua` extension 
* The other `ihe_iua` extension parameters are not shown below
 
* The restriction to forbid data authored by the given practitioner would be expressed

```
"extensions" : {
  "ihe_iua" : {
    ...
    "purpose_of_use" : [{
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "TREAT"
      },{
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "HPAYMT"
      },{
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "HOPERAT"
    }]
  }
  "ihe_pcf" : {
    "patient_id" : "http://example.org/fhir/Patient/ex-patient",
    "doc_id" : ["http://example.org/fhir/Consent/ex-consent-intermediate-not-authoredby"],
    "residual" : [
      {
        "type" : "deny",
        "data" : [{
            "meaning" : "authoredby",
            "reference" : {
            "reference" : "http://example.org/fhir/Practitioner/ex-practitioner"
            }
        }]
      }
    ]
  }
}

```

| | | |
| :--- | :--- | :--- |
|  [<prev](Consent-ex-consent-intermediate-timeframe.ttl.md) | [top](#top) |  [next>](Consent-ex-consent-intermediate-not-authoredby.xml.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

