# Consent for purpose of treatment example - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consent for purpose of treatment example**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](Consent-ex-consent-basic-treat.xml.md) 
*  [JSON](Consent-ex-consent-basic-treat.json.md) 

## Example Consent: Consent for purpose of treatment example

Profile: [IHE PCF Explicit Basic Consent](StructureDefinition-IHE.PCF.consentBasic.md)

Security Label: test health data (Details: ActReason code HTEST = 'test health data')

**status**: Active

**scope**: Privacy Consent

**category**: Consent

**patient**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**dateTime**: 2022-06-13

**performer**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**organization**: [Organization somewhere org](Organization-ex-organization.md)

**source**: [DocumentReference: status = current; type = Release of information consent; description = The captured signed document](DocumentReference-ex-documentreference.md)

### Policies

| | |
| :--- | :--- |
| - | **Uri** |
| * | [http://example.org/policies/basePrivacyConsentPolicy.txt](http://example.org/policies/basePrivacyConsentPolicy.txt) |

> **provision****type**: Opt In**purpose**:[ActReason TREAT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-TREAT): treatment,[ActReason HPAYMT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-HPAYMT): healthcare payment,[ActReason HOPERAT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-HOPERAT): healthcare operations

### Notes:

#### IUA Access Token

Provided an [ITI-71](other.md#updates-to-iti-71) results in a PERMIT access token issued. That token would have the following PCF specific element to inform the **Consent Enforcement Point**.

In this case there is no residual, as the Consent expresses that authorization be given for a given purpose of use. Possibly with scope restrictions based on other business rules, such as a subset of actions (CRUDE) and resources. No token would be issued by ITI-71 for users not authorized, or requests beyond the set of purpose of use.

* The restriction to the given purpose (FooBar) would be expressed in the `ihe_iua` extension 
* The other `ihe_iua` extension parameters are not shown below
 
* The consent is indicated in the `ihe_pcf` 
* no `residual` element is provided, indicating that no residual rules need be enforced
 

```
"extensions" : {
  "ihe_iua" : {
    ...
    "purpose_of_use" : [{
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "TREAT"
      },{
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "HPAYMT"
      },{
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "HOPERAT"
    }]
  }
  "ihe_pcf" : {
    "patient_id" : "http://example.org/fhir/Patient/ex-patient",
    "doc_id" : ["http://example.org/fhir/Consent/ex-consent-basic-treat"]
  }
}

```

| | | |
| :--- | :--- | :--- |
|  [<prev](Consent-ex-consent-basic-research.ttl.md) | [top](#top) |  [next>](Consent-ex-consent-basic-treat.xml.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

