# Consent for treatment example with ink signature - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consent for treatment example with ink signature**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](Consent-ex-consent-basic-ink.xml.md) 
*  [JSON](Consent-ex-consent-basic-ink.json.md) 

## Example Consent: Consent for treatment example with ink signature

Profile: [IHE PCF Explicit Basic Consent](StructureDefinition-IHE.PCF.consentBasic.md)

Security Label: test health data (Details: ActReason code HTEST = 'test health data')

**status**: Active

**scope**: Privacy Consent

**category**: Consent

**patient**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**dateTime**: 2022-06-13

**performer**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**organization**: [Organization somewhere org](Organization-ex-organization.md)

**source**: [DocumentReference: status = current](DocumentReference-ex-consent-ink.md)

### Policies

| | |
| :--- | :--- |
| - | **Uri** |
| * | [http://example.org/policies/basePrivacyConsentPolicy.txt](http://example.org/policies/basePrivacyConsentPolicy.txt) |

> **provision****type**: Opt In**purpose**:[ActReason TREAT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-TREAT): treatment,[ActReason HPAYMT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-HPAYMT): healthcare payment,[ActReason HOPERAT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-HOPERAT): healthcare operations

### Notes:

#### IUA Access Token

The [ITI-71](other.md#updates-to-iti-71) processing is exactly the same as [Basic Consent to sharing for Treatment policy](Consent-ex-consent-basic-treat.md#notes).

| | | |
| :--- | :--- | :--- |
|  [<prev](Consent-ex-consent-expired-treat.ttl.md) | [top](#top) |  [next>](Consent-ex-consent-basic-ink.xml.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

