# Consent allowing NORMAL and focused access to Mental Health or Sexual Health data - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consent allowing NORMAL and focused access to Mental Health or Sexual Health data**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.xml.md) 
*  [JSON](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.json.md) 

## Example Consent: Consent allowing NORMAL and focused access to Mental Health or Sexual Health data

Profile: [IHE PCF Explicit Advanced Consent](StructureDefinition-IHE.PCF.consentAdvanced.md)

Security Label: test health data (Details: ActReason code HTEST = 'test health data')

**status**: Active

**scope**: Privacy Consent

**category**: Consent

**patient**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**dateTime**: 2022-06-13

**performer**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**organization**: [Organization somewhere org](Organization-ex-organization.md)

**source**: [DocumentReference: status = current; type = Release of information consent; description = The captured signed document](DocumentReference-ex-documentreference.md)

### Policies

| | |
| :--- | :--- |
| - | **Uri** |
| * | [http://example.org/policies/basePrivacyConsentPolicy.txt](http://example.org/policies/basePrivacyConsentPolicy.txt) |

> **provision****type**: Opt In**securityLabel**:[Confidentiality N](http://terminology.hl7.org/6.5.0/CodeSystem-v3-Confidentiality.html#v3-Confidentiality-N): normal**purpose**:[ActReason TREAT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-TREAT): treatment,[ActReason HPAYMT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-HPAYMT): healthcare payment,[ActReason HOPERAT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-HOPERAT): healthcare operations
> **provision****type**: Opt In

### Actors

| | | |
| :--- | :--- | :--- |
| - | **Role** | **Reference** |
| * | information recipient | [Practitioner: telecom = Practitioner@example.com](Practitioner-ex-practitioner.md) |

**securityLabel**:[ActCode PSY](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-PSY): psychiatry disorder information sensitivity,[ActCode SDV](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html#v3-ActCode-SDV): sexual assault, abuse, or domestic violence information sensitivity

### Notes:

#### IUA Access Token

Provided an [ITI-71](other.md#updates-to-iti-71) results in a PERMIT access token issued. That token would have the following residual element to inform the **Consent Enforcement Point** that it needs to restrict the results.

Given that the token will express the permit portion, the `residual` would need to express the refinement. This case allows treatment access to normal data, and carves out mental health data and sexual health data as accessible only to [Practitioner](Practitioner-ex-practitioner.md). The oAuth token would be expressing a general permit for most users to the given patient data. Possibly with scope restrictions based on other business rules, such as a subset of actions (CRUDE) and resources.

The token would need to include an `ihe_pcf` extension to point at this consent, and that would include a `residual` to express the refinement. Shown as followed:

For Users that are not [Practitioner](Practitioner-ex-practitioner.md), the token **result** will be no different than consent to [allow NORMAL data access](Consent-ex-consent-advanced-normal.md).

* ITI-71 [access token](Consent-ex-consent-advanced-normal.md#notes)

For the User [Practitioner](Practitioner-ex-practitioner.md), the token **result** will be:

* The restriction to the given purpose (Treatment, Payment, and Operations) would be expressed in the `ihe_iua` extension 
* The other `ihe_iua` extension parameters are not shown below
 
* The restriction to just normal data would need to be expressed: 
* First as a forbid everything
* Second as a permit normal data
* Third is to permit Mental Health data and Sexual Health Data
 

```
"extensions" : {
  "ihe_iua" : {
    ...
    "purpose_of_use" : [{
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "TREAT"
      },{
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "HPAYMT"
      },{
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "HOPERAT"
    }]
  }
  "ihe_pcf" : {
    "patient_id" : "http://example.org/fhir/Patient/ex-patient",
    "doc_id" : ["http://example.org/fhir/Consent/ex-consent-intermediate-authoredby"],
    "residual" : [
      {
        "type" : "forbid",
      },{
        "type" : "permit",
        "securityLabel" : [{
            "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
            "code" : "N"
        }]
      },{
        "type" : "permit",
        "securityLabel" : [{
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "PSY"
          },{
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "SDV"
        }]
      }
    ]
  }
}

```

| | | |
| :--- | :--- | :--- |
|  [<prev](Consent-ex-consent-advanced-normal-break-glass-restricted.ttl.md) | [top](#top) |  [next>](Consent-ex-consent-advanced-normal-focused-psy-or-sdv.xml.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

