# Consent allowing NORMAL and break-glass access to RESTRICTED data - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consent allowing NORMAL and break-glass access to RESTRICTED data**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](Consent-ex-consent-advanced-normal-break-glass-restricted.xml.md) 
*  [JSON](Consent-ex-consent-advanced-normal-break-glass-restricted.json.md) 

## Example Consent: Consent allowing NORMAL and break-glass access to RESTRICTED data

Profile: [IHE PCF Explicit Advanced Consent](StructureDefinition-IHE.PCF.consentAdvanced.md)

Security Label: test health data (Details: ActReason code HTEST = 'test health data')

**status**: Active

**scope**: Privacy Consent

**category**: Consent

**patient**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**dateTime**: 2022-06-13

**performer**: [Jack Smith Male, DoB: 1923-07-25](Patient-ex-patient.md)

**organization**: [Organization somewhere org](Organization-ex-organization.md)

**source**: [DocumentReference: status = current; type = Release of information consent; description = The captured signed document](DocumentReference-ex-documentreference.md)

### Policies

| | |
| :--- | :--- |
| - | **Uri** |
| * | [http://example.org/policies/basePrivacyConsentPolicy.txt](http://example.org/policies/basePrivacyConsentPolicy.txt) |

> **provision****type**: Opt In**securityLabel**:[Confidentiality N](http://terminology.hl7.org/6.5.0/CodeSystem-v3-Confidentiality.html#v3-Confidentiality-N): normal**purpose**:[ActReason TREAT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-TREAT): treatment,[ActReason HPAYMT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-HPAYMT): healthcare payment,[ActReason HOPERAT](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-HOPERAT): healthcare operations
> **provision****type**: Opt In

### Actors

| | | |
| :--- | :--- | :--- |
| - | **Role** | **Reference** |
| * | information recipient | [Group Those users that the organization authorizes to use Break-Glass](Group-ex-privilegedUsers.md) |

**securityLabel**:[Confidentiality R](http://terminology.hl7.org/6.5.0/CodeSystem-v3-Confidentiality.html#v3-Confidentiality-R): restricted**purpose**:[ActReason BTG](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html#v3-ActReason-BTG): break the glass

### Notes:

#### IUA Access Token

Provided an [ITI-71](other.md#updates-to-iti-71) results in a PERMIT access token issued:

* For most users the **result** will be no different than consent to [allow NORMAL data access](Consent-ex-consent-advanced-normal.md) 
* ITI-71 [access token](Consent-ex-consent-advanced-normal.md#notes)
 
* For the break-glass authored users that have declared break-glass the **result** will be no different than consent to [allow NORMAL and RESTRICTED data access](Consent-ex-consent-advanced-normal-restricted.md) 
* ITI-71 [access token](Consent-ex-consent-advanced-normal-restricted.md#notes)
 

| | | |
| :--- | :--- | :--- |
|  [<prev](ValueSet-AdvancedSecurityTagVS.ttl.md) | [top](#top) |  [next>](Consent-ex-consent-advanced-normal-break-glass-restricted.xml.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

