# PCF Consent Registry Actor - Privacy Consent on FHIR (PCF) v1.1.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PCF Consent Registry Actor**

Privacy Consent on FHIR (PCF), published by IHE IT Infrastructure Technical Committee. This guide is not an authorized publication; it is the continuous build for version 1.1.1-current built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/IHE/ITI.PCF/](https://github.com/IHE/ITI.PCF/) and changes regularly. See the [Directory of published versions](https://profiles.ihe.net/ITI/PCF/history.html)

*  [Narrative Content](#) 
*  [XML](CapabilityStatement-IHE.PCF.consentRegistry.xml.md) 
*  [JSON](CapabilityStatement-IHE.PCF.consentRegistry.json.md) 

## CapabilityStatement: PCF Consent Registry Actor 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/PCF/CapabilityStatement/IHE.PCF.consentRegistry | *Version*:1.1.1-current |
| Active as of 2023-02-14 | *Computable Name*:IHE_PCF_consentRegistry |

 
CapabilityStatement for Consent Registry Actor. 
Explain 
* provides [Access Consent [ITI-108]](ITI-108.md) to store and support access to Privacy Consent Resources
 

 [Raw OpenAPI-Swagger Definition file](IHE.PCF.consentRegistry.openapi.json) | [Download](IHE.PCF.consentRegistry.openapi.json) 

## IHE PCF Consent Registry

* Implementation Guide Version: 1.1.1-current 
* FHIR Version: 4.0.1 
* Supported Formats: `application/fhir+xml`, `application/fhir+json`
* Published on: 2023-02-14 
* Published by: IHE IT Infrastructure Technical Committee 

> **Note to Implementers: FHIR Capabilities**Any FHIR capability may be 'allowed' by the system unless explicitly marked as 'SHALL NOT'. A few items are marked as MAY in the Implementation Guide to highlight their potential relevance to the use case.

## FHIR RESTful Capabilities

### Mode: server

PCF Consent Registry actor provides capability to record, search, and manage Consents.

**Security**

> 

Recommend [ATNA](https://profiles.ihe.net/ITI/TF/Volume1/ch-9.html), encouraged [IHE-IUA](https://profiles.ihe.net/ITI/IUA/index.html) or [SMART-app-launch](http://www.hl7.org/fhir/smart-app-launch/)


**Summary of System-wide Interactions**

* Supports the `search-system`interaction.

### Capabilities by Resource/Profile

#### Summary

The summary table lists the resources that are part of this configuration, and for each resource it lists:

* The relevant profiles (if any)
* The interactions supported by each resource (**R**ead, **S**earch, **U**pdate, and **C**reate, are always shown, while **VR**ead, **P**atch, **D**elete, **H**istory on **I**nstance, or **H**istory on **T**ype are only present if at least one of the resources has support for them.
* The required, recommended, and some optional search parameters (if any).
* The linked resources enabled for `_include`
* The other resources enabled for `_revinclude`
* The operations on the resource (if any)

| | | | | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [Consent](#Consent1-1) |   | y | y | y | y | y | _lastUpdated, _id, status, patient, patient.identifier, actor |  |  |  |

-------

#### Resource Conformance: supported Consent

Core FHIR Resource

[Consent](http://hl7.org/fhir/R4/consent.html)

Reference Policy

Interaction summary

* Supports `create`, `read`, `update`, `delete`, `search-type`.

Documentation
> 

PCF transaction [Access Consent [ITI-108]](ITI-108.md)


Search Parameters


 

| | | |
| :--- | :--- | :--- |
|  [<prev](CapabilityStatement-IHE.PCF.consentRecorder.ttl.md) | [top](#top) |  [next>](CapabilityStatement-IHE.PCF.consentRegistry-testing.md) |

 IG © 2023+ [IHE IT Infrastructure Technical Committee](https://www.ihe.net/ihe_domains/it_infrastructure/). Package ihe.iti.pcf#1.1.1-current based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-07 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[New Issue](https://github.com/IHE/ITI.PCF/issues/new/choose)|[Issues](https://github.com/IHE/ITI.PCF/issues)[Version History](https://profiles.ihe.net/ITI/PCF/history.html)|![](assets/images/cc-by.png)|[Propose a change![](external.png)](https://www.ihe.net/resources/public_comment/) 

