# Provide Document Bundle with complete UnContained Comprehensive metadata of one document - Mobile access to Health Documents (MHD) v4.2.3

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Provide Document Bundle with complete UnContained Comprehensive metadata of one document**

## Example Bundle: Provide Document Bundle with complete UnContained Comprehensive metadata of one document

Example of a complete uncontained comprehensive Provide Document Bundle for a publication.

* The bundle contains 
* SubmissionSet - identifies one documentReference
* Folder - identifies one documentReference
* DocumentReference - One DocumentReference
* Binary - the document
* the Practitioner and Organization are references
* the Patient is also a reference to a PIXm/PDQm retrieved Resource.
 

Response [example](Bundle-ex-response-unContainedComprehensiveProvideDocumentBundleCompt.md)

Profile: [MHD UnContained Comprehensive Provide Document Bundle](StructureDefinition-IHE.MHD.UnContained.Comprehensive.ProvideBundle.md)

Security Label: test health data (Details: ActReason code HTEST = 'test health data')

Bundle ex-unContainedComprehensiveProvideDocumentBundleComplete of type transaction

-------

Entry 1 - fullUrl = urn:uuid:aaaaaaaa-bbbb-cccc-dddd-e00666600001

Resource List:

> SubmissionSet with Patient

Request:

```
POST List

```

-------

Entry 2 - fullUrl = urn:uuid:aaaaaaaa-bbbb-cccc-dddd-e00666600002

Resource DocumentReference:

> 

Profile: [MHD DocumentReference Comprehensive UnContained References Option](StructureDefinition-IHE.MHD.UnContained.Comprehensive.DocumentReference.md)

Security Label: test health data (Details: ActReason code HTEST = 'test health data')

**identifier**:[Uniform Resource Identifier (URI)](http://terminology.hl7.org/6.3.0/NamingSystem-uri.html)/urn:oid:1.2.840.113556.1.8000.2554.53432.348.12973.17740.34205.4355.50220.62012 (use: usual, )**status**: Current**type**:Patient summary Document**category**:History of Immunization note**subject**:[John Schmidt Other, DoB: 1923-07-25](Patient-ex-patient.md)**date**: 2020-02-01 23:50:50-0500**author**:
* [Organization nowhere](Organization-ex-organization.md)
* [Practitioner: telecom = JohnMoehrke@gmail.com](Practitioner-ex-practitioner.md)

### RelatesTos

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Target** |
| * | Appends | [DocumentReference: masterIdentifier = OID:1.2.840.113556.1.8000.2554.58783.21864.3474.19410.44358.58254.41281.46340 (use: usual, ); identifier = UUID:0c287d32-01e3-4d87-9953-9fcc9404eb21 (use: official, ); status = current; type = Addendum Document; category = History of Immunization note; date = 2020-12-31 23:50:50-0500; description = Example of a Comprehensive DocumentReference resource. This is fully filled for all mandatory elements and all optional elements.; securityLabel = normal](DocumentReference-ex-DocumentReferenceComprehensive.md) |

**description**:

a complete comprehensive metadata document reference

**securityLabel**:restricted
> **content**

### Attachments

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **ContentType** | **Language** | **Url** | **Size** | **Hash** | **Title** | **Creation** |
| * | text/plain | en | [Binary: text/plain (16 bytes base64)](Bundle-ex-unContainedComprehensiveProvideDocumentBundleComplete.md#urn-uuid-aaaaaaaa-bbbb-cccc-dddd-e00666600003) | 11 | `MGE0ZDU1YThkNzc4ZTUwMjJmYWI3MDE5NzdjNWQ4NDBiYmM0ODZkMA==` | Hello World | 2020-02-01 23:50:50-0500 |



Request:

```
POST DocumentReference

```

-------

Entry 3 - fullUrl = urn:uuid:aaaaaaaa-bbbb-cccc-dddd-e00666600003

Resource Binary:

> 

Security Label: test health data (Details: ActReason code HTEST = 'test health data')

**contentType**: text/plain**data**:`SGVsbG8gV29ybGQ=`

Request:

```
POST Binary

```



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "ex-unContainedComprehensiveProvideDocumentBundleComplete",
  "meta" : {
    "profile" : [
      "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.ProvideBundle"
    ],
    "security" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "HTEST"
      }
    ]
  },
  "type" : "transaction",
  "timestamp" : "2004-10-05T11:50:50-05:00",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:aaaaaaaa-bbbb-cccc-dddd-e00666600001",
      "resource" : {
        "resourceType" : "List",
        "id" : "aaaaaaaa-bbbb-cccc-dddd-e00666600001",
        "meta" : {
          "profile" : [
            "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.SubmissionSet"
          ],
          "security" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
              "code" : "HTEST"
            }
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"List_aaaaaaaa-bbbb-cccc-dddd-e00666600001\"> </a>SubmissionSet with Patient</div>"
        },
        "extension" : [
          {
            "url" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-designationType",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "225728007"
                }
              ]
            }
          },
          {
            "url" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-sourceId",
            "valueIdentifier" : {
              "value" : "urn:oid:1.2.3.4"
            }
          },
          {
            "url" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-intendedRecipient",
            "valueReference" : {
              "reference" : "Practitioner/ex-practitioner"
            }
          }
        ],
        "identifier" : [
          {
            "use" : "usual",
            "system" : "urn:ietf:rfc:3986",
            "value" : "urn:oid:1.2.840.113556.1.8000.2554.58783.21864.3474.19410.44358.58254.41281.46351"
          }
        ],
        "status" : "current",
        "mode" : "working",
        "title" : "Hello World SubmissionSet",
        "code" : {
          "coding" : [
            {
              "system" : "https://profiles.ihe.net/ITI/MHD/CodeSystem/MHDlistTypes",
              "code" : "submissionset"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/ex-patient"
        },
        "date" : "2004-10-25T23:50:50-05:00",
        "source" : {
          "extension" : [
            {
              "url" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-authorOrg",
              "valueReference" : {
                "reference" : "Organization/ex-organization"
              }
            }
          ],
          "reference" : "Practitioner/ex-practitioner"
        },
        "note" : [
          {
            "text" : "Comments about Hello World SubmissionSet"
          }
        ],
        "entry" : [
          {
            "item" : {
              "reference" : "urn:uuid:aaaaaaaa-bbbb-cccc-dddd-e00666600002"
            }
          }
        ]
      },
      "request" : {
        "method" : "POST",
        "url" : "List"
      }
    },
    {
      "fullUrl" : "urn:uuid:aaaaaaaa-bbbb-cccc-dddd-e00666600002",
      "resource" : {
        "resourceType" : "DocumentReference",
        "id" : "aaaaaaaa-bbbb-cccc-dddd-e00666600002",
        "meta" : {
          "profile" : [
            "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.UnContained.Comprehensive.DocumentReference"
          ],
          "security" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
              "code" : "HTEST"
            }
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DocumentReference_aaaaaaaa-bbbb-cccc-dddd-e00666600002\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DocumentReference aaaaaaaa-bbbb-cccc-dddd-e00666600002</b></p><a name=\"aaaaaaaa-bbbb-cccc-dddd-e00666600002\"> </a><a name=\"hcaaaaaaaa-bbbb-cccc-dddd-e00666600002\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-IHE.MHD.UnContained.Comprehensive.DocumentReference.html\">MHD DocumentReference Comprehensive UnContained References Option</a></p><p style=\"margin-bottom: 0px\">Security Label: test health data (Details: ActReason code HTEST = 'test health data')</p></div><p><b>masterIdentifier</b>: <a href=\"http://terminology.hl7.org/6.3.0/NamingSystem-uri.html\" title=\"As defined by RFC 3986 (http://www.ietf.org/rfc/rfc3986.txt)(with many schemes defined in many RFCs). For OIDs and UUIDs, use the URN form (urn:oid:(note: lowercase) and urn:uuid:). See http://www.ietf.org/rfc/rfc3001.txt and http://www.ietf.org/rfc/rfc4122.txt \r\n\r\nThis oid is used as an identifier II.root to indicate the the extension is an absolute URI (technically, an IRI). Typically, this is used for OIDs and GUIDs. Note that when this OID is used with OIDs and GUIDs, the II.extension should start with urn:oid or urn:uuid: \r\n\r\nNote that this OID is created to aid with interconversion between CDA and FHIR - FHIR uses urn:ietf:rfc:3986 as equivalent to this OID. URIs as identifiers appear more commonly in FHIR.\r\n\r\nThis OID may also be used in CD.codeSystem.\">Uniform Resource Identifier (URI)</a>/urn:oid:1.2.840.113556.1.8000.2554.53432.348.12973.17740.34205.4355.50220.62012 (use: usual, )</p><p><b>status</b>: Current</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 60591-5}\">Patient summary Document</span></p><p><b>category</b>: <span title=\"Codes:{http://loinc.org 11369-6}\">History of Immunization note</span></p><p><b>subject</b>: <a href=\"Patient-ex-patient.html\">John Schmidt  Other, DoB: 1923-07-25</a></p><p><b>date</b>: 2020-02-01 23:50:50-0500</p><p><b>author</b>: </p><ul><li><a href=\"Organization-ex-organization.html\">Organization nowhere</a></li><li><a href=\"Practitioner-ex-practitioner.html\">Practitioner: telecom = JohnMoehrke@gmail.com</a></li></ul><p><b>authenticator</b>: <a href=\"Organization-ex-organization.html\">Organization nowhere</a></p><h3>RelatesTos</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Target</b></td></tr><tr><td style=\"display: none\">*</td><td>Appends</td><td><a href=\"DocumentReference-ex-DocumentReferenceComprehensive.html\">DocumentReference: masterIdentifier = OID:1.2.840.113556.1.8000.2554.58783.21864.3474.19410.44358.58254.41281.46340 (use: usual, ); identifier = UUID:0c287d32-01e3-4d87-9953-9fcc9404eb21 (use: official, ); status = current; type = Addendum Document; category = History of Immunization note; date = 2020-12-31 23:50:50-0500; description = Example of a Comprehensive DocumentReference resource. This is fully filled for all mandatory elements and all optional elements.; securityLabel = normal</a></td></tr></table><p><b>description</b>: a complete comprehensive metadata document reference</p><p><b>securityLabel</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-Confidentiality R}\">restricted</span></p><blockquote><p><b>content</b></p><h3>Attachments</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>ContentType</b></td><td><b>Language</b></td><td><b>Url</b></td><td><b>Size</b></td><td><b>Hash</b></td><td><b>Title</b></td><td><b>Creation</b></td></tr><tr><td style=\"display: none\">*</td><td>text/plain</td><td>English</td><td><a href=\"Bundle-ex-unContainedComprehensiveProvideDocumentBundleComplete.html#urn-uuid-aaaaaaaa-bbbb-cccc-dddd-e00666600003\">Binary: text/plain (16 bytes base64)</a></td><td>11</td><td><code>MGE0ZDU1YThkNzc4ZTUwMjJmYWI3MDE5NzdjNWQ4NDBiYmM0ODZkMA==</code></td><td>Hello World</td><td>2020-02-01 23:50:50-0500</td></tr></table><p><b>format</b>: <a href=\"https://profiles.ihe.net/fhir/ihe.formatcode.fhir/1.4.0/CodeSystem-formatcode.html#formatcode-urn.58ihe.58iti.58xds-sd.58text.582008\">IHE Format Code set for use with Document Sharing: urn:ihe:iti:xds-sd:text:2008</a> (ITI XDS-SD TEXT)</p></blockquote><h3>Contexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Event</b></td><td><b>Period</b></td><td><b>FacilityType</b></td><td><b>PracticeSetting</b></td><td><b>SourcePatientInfo</b></td><td><b>Related</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode PATDOC}\">patient documentation task</span></td><td>1990-02-01 23:50:50-0500 --&gt; 2020-02-01 23:50:50-0500</td><td><span title=\"Codes:{http://snomed.info/sct 82242000}\">Children's hospital</span></td><td><span title=\"Codes:{http://snomed.info/sct 408467006}\">Adult mental illness - specialty (qualifier value)</span></td><td><a href=\"Patient-ex-patient.html\">John Schmidt  Other, DoB: 1923-07-25</a></td><td>Identifier: <a href=\"http://terminology.hl7.org/6.3.0/NamingSystem-uri.html\" title=\"As defined by RFC 3986 (http://www.ietf.org/rfc/rfc3986.txt)(with many schemes defined in many RFCs). For OIDs and UUIDs, use the URN form (urn:oid:(note: lowercase) and urn:uuid:). See http://www.ietf.org/rfc/rfc3001.txt and http://www.ietf.org/rfc/rfc4122.txt \r\n\r\nThis oid is used as an identifier II.root to indicate the the extension is an absolute URI (technically, an IRI). Typically, this is used for OIDs and GUIDs. Note that when this OID is used with OIDs and GUIDs, the II.extension should start with urn:oid or urn:uuid: \r\n\r\nNote that this OID is created to aid with interconversion between CDA and FHIR - FHIR uses urn:ietf:rfc:3986 as equivalent to this OID. URIs as identifiers appear more commonly in FHIR.\r\n\r\nThis OID may also be used in CD.codeSystem.\">Uniform Resource Identifier (URI)</a>/urn:uuid:7d5bb8ac-68ee-4926-85e7-baaaaaaaaaad</td></tr></table></div>"
        },
        "masterIdentifier" : {
          "use" : "usual",
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:oid:1.2.840.113556.1.8000.2554.53432.348.12973.17740.34205.4355.50220.62012"
        },
        "status" : "current",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "11369-6"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "Patient/ex-patient"
        },
        "date" : "2020-02-01T23:50:50-05:00",
        "author" : [
          {
            "reference" : "Organization/ex-organization"
          },
          {
            "reference" : "Practitioner/ex-practitioner"
          }
        ],
        "authenticator" : {
          "reference" : "Organization/ex-organization"
        },
        "relatesTo" : [
          {
            "code" : "appends",
            "target" : {
              "reference" : "DocumentReference/ex-DocumentReferenceComprehensive"
            }
          }
        ],
        "description" : "a complete comprehensive metadata document reference",
        "securityLabel" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
                "code" : "R"
              }
            ]
          }
        ],
        "content" : [
          {
            "attachment" : {
              "contentType" : "text/plain",
              "language" : "en",
              "url" : "urn:uuid:aaaaaaaa-bbbb-cccc-dddd-e00666600003",
              "size" : 11,
              "hash" : "MGE0ZDU1YThkNzc4ZTUwMjJmYWI3MDE5NzdjNWQ4NDBiYmM0ODZkMA==",
              "title" : "Hello World",
              "creation" : "2020-02-01T23:50:50-05:00"
            },
            "format" : {
              "system" : "http://ihe.net/fhir/ihe.formatcode.fhir/CodeSystem/formatcode",
              "code" : "urn:ihe:iti:xds-sd:text:2008"
            }
          }
        ],
        "context" : {
          "event" : [
            {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "PATDOC"
                }
              ]
            }
          ],
          "period" : {
            "start" : "1990-02-01T23:50:50-05:00",
            "end" : "2020-02-01T23:50:50-05:00"
          },
          "facilityType" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "82242000"
              }
            ]
          },
          "practiceSetting" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "408467006"
              }
            ]
          },
          "sourcePatientInfo" : {
            "reference" : "Patient/ex-patient"
          },
          "related" : [
            {
              "identifier" : {
                "system" : "urn:ietf:rfc:3986",
                "value" : "urn:uuid:7d5bb8ac-68ee-4926-85e7-baaaaaaaaaad"
              }
            }
          ]
        }
      },
      "request" : {
        "method" : "POST",
        "url" : "DocumentReference"
      }
    },
    {
      "fullUrl" : "urn:uuid:aaaaaaaa-bbbb-cccc-dddd-e00666600003",
      "resource" : {
        "resourceType" : "Binary",
        "id" : "aaaaaaaa-bbbb-cccc-dddd-e00666600003",
        "meta" : {
          "security" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
              "code" : "HTEST"
            }
          ]
        },
        "contentType" : "text/plain",
        "data" : "SGVsbG8gV29ybGQ="
      },
      "request" : {
        "method" : "POST",
        "url" : "Binary"
      }
    }
  ]
}

```
