# 2:3.106 Generate Metadata [ITI-106] - Mobile access to Health Documents (MHD) v5.0.0-current

* [**Table of Contents**](toc.md)
* **2:3.106 Generate Metadata [ITI-106]**

## 2:3.106 Generate Metadata [ITI-106]

This section corresponds to transaction [ITI-106] of the IHE Technical Framework. Transaction [ITI-106] is used by the Document Source and Document Recipient Actors. The Generate Metadata [ITI-106] transaction is used to transmit a structured and coded document (i.e., CDA or FHIR-Document) and have the Document Recipient create associated metadata.

### 2:3.106.1 Scope

The Generate Metadata [ITI-106] transaction passes a Generate Metadata Request from a Document Source to a Document Recipient.

### 2:3.106.2 Actors Roles

**Table 2:3.106.2-1: Actor Roles**

| | |
| :--- | :--- |
| [Document Source](1331_actors_and_transactions.md#133111-document-source) | Sends document to the Document Recipient |
| [Document Recipient](1331_actors_and_transactions.md#133113-document-recipient) | Accepts the document and creates metadata |

### 2:3.106.3 Referenced Standards

**HL7 FHIR** Revision 5.0.0 found at [http://hl7.org/fhir/R5/](http://hl7.org/fhir/R5/)

### 2:3.106.4 Messages

**Figure 2:3.106.4-1: Generate Metadata Interactions**

#### 2:3.106.4.1 Generate Metadata Request Message

This message uses the FHIR [Operation](http://hl7.org/fhir/R5/operations.html) method on the target Generate Metadata endpoint to convey the document.

##### 2:3.106.4.1.1 Trigger Events

This method is invoked when the Document Source needs to submit one structured and coded document to a Document Recipient.

##### 2:3.106.4.1.2 Message Semantics

The Document Source shall initiate an http `POST` operation request as defined in FHIR [Operations](http://hl7.org/fhir/R5/operations.html) using the [Generate Metadata Operation Definition](OperationDefinition-generate-metadata.md) on the `DocumentReference` endpoint.

```
POST http://fhir.someserver.org/fhir/DocumentReference/$generate-metadata

```

The Document Source provides the document. It can be provided in either a Binary or a Bundle form.

* Binary resource, used with a CDA document, might be used with a FHIR-Document
* Bundle resource, must be a Document kind Bundle. aka, [FHIR-Document](http://hl7.org/fhir/R5/documents.html)

For a representative profile of Parameters see [IHE.MHD.GenerateMetadata.Parameters.In](StructureDefinition-IHE.MHD.GenerateMetadata.Parameters.In.md). This includes examples of [Parameters input](StructureDefinition-IHE.MHD.GenerateMetadata.Parameters.In-examples.md).

##### 2:3.106.4.1.3 Expected Actions

The Document Recipient shall accept both media types `application/fhir+json` and `application/fhir+xml`.

On receipt of the Generate Metadata Request Message, the Document Recipient shall read the existing document and confirm that the document is sufficiently structured and coded for processing. The Document Recipient may impose specific constraints on the input document, such as conforming to [International Patient Summary (IPS)](https://confluence.hl7.org/display/PC/International+Patient+Summary) or [Consolidated Clinical Document Architecture (C-CDA) 2.1](https://www.hl7.org/ccdasearch/). These constraints may be further refined within the Community. The Document Recipient shall persist the document, the Bundle will be persisted using the original mime-type from the operation. The Document Recipient shall persist the document in a format consistent with the media type in DocumentReference.attachment.contentType. It may make the document available in other formats, for example, making a FHIR Document Bundle submitted in XML format available in JSON format, but it is not required to. The Document Recipient shall generate a valid DocumentReference resource given the document content. The DocumentReference that is generated may be an existing DocumentReference or may be a new one as necessary. The DocumentReference.content.attachment.url shall point at the persisted document.

Note that persist methodology will depend on the actors and functionality grouped with the Document Recipient. For example when grouped with a XDS Document Source, the persistence is achieved using XDS; when grouped with MHDS, the persistence is achieved at the MHDS Document Registry. The Document Recipient may need to produce a SubmissionSet derived off of the DocumentReference, such as when persistence is via XDS, XDR, or MHDS where a SubmissionSet is required to track the provenance of the publication request.

The Document Recipient shall extract the document, generate the DocumentReference metadata, and translate the DocumentReference metadata elements into a SubmissionSet following the [PCC TF-2: 4.1 Medical Document Binding to Document Sharing Metadata](https://profiles.ihe.net/ITI/sIPS/pcc.html#41-medical-document-binding-to-document-sharing-metadata), and may have further metadata translation requirements specified by the local Document Sharing Community policy.

The Document Recipient shall generate Document Sharing metadata requirements as specified for attributes [ITI TF-3: Table 4.3.1-3: “Sending Actor Metadata Attribute Optionality”](https://profiles.ihe.net/ITI/TF/Volume3/ch-4.3.html#4.3.1).

* The Document Recipient that supports the [Comprehensive Metadata](1332_actor_options.md#13322-xds-on-fhir-option) or the [XDS on FHIR](1332_actor_options.md#13322-xds-on-fhir-option) Option shall generate metadata consistent with column “XDS DS”;

###### 2:3.106.4.1.3.1 Grouping with Actors in other Document Sharing Profiles

This section applies to grouping MHD Document Recipient with [XDS](https://profiles.ihe.net/ITI/TF/Volume1/ch-10.html) [Document Source](https://profiles.ihe.net/ITI/TF/Volume1/ch-10.html#10.1.1.1) Actor, [XDR](https://profiles.ihe.net/ITI/TF/Volume1/ch-15.html) Document Source Actor, [XDR](https://profiles.ihe.net/ITI/TF/Volume1/ch-15.html) Limited-Metadata Document Source Actor, and [XDM](https://profiles.ihe.net/ITI/TF/Volume1/ch-16.html) Portable Media Creator Actor (e.g., with the [XDM ZIP over Email Option](https://profiles.ihe.net/ITI/TF/Volume1/ch-16.html#16.2.3)).

The Document Recipient shall transform the DocumentReference content into a proper message for the given grouped actor (e.g., the XDS Document Source using the Provide and Register Document Set-b [[ITI-41]](https://profiles.ihe.net/ITI/TF/Volume2/ITI-41.html) transaction). The Document Recipient shall create appropriate metadata from Resources in the FHIR DocumentReference Resource, including SubmissionSet, and DocumentEntry.

Where values provided are References to FHIR resources (e.g., DocumentReference.encounter), the Reference should be converted to a [Document Sharing`CXi`Identifier Datatype](https://profiles.ihe.net/ITI/TF/Volume3/ch-4.2.html#4.2.3.1.7) for recording in the Document Sharing ebRIM using the Identifier Type Codes when appropriate (see [Appendix Z.9.1.2](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.9.1.2-xds-cxi-mapped-to-fhir-identifier-type) ). The conversion may be by using the referenced Resource business .identifier. Note, there is not an obvious conversion of a reference .id to `CXi` identifier. Note that DocumentReference.encounter would be mapped into DocumentEntry.referenceIdList as an Identifier Type Code of `urn:ihe:iti:xds:2015:encounterId`.

Some FHIR elements do not translate to XDS concepts; the handling of these elements is left to the implementer of the Document Recipient.

Upon successful conversion of the FHIR DocumentReference to XDS Document Sharing metadata, the grouped source actor shall execute the appropriate transaction. The transaction result, and any error or warning messages, shall be reported to the MHD Document Source. The Document Recipient is responsible for translating the response to the appropriate HTTP Status Code and FHIR OperationOutcome Resource in the Generate Metadata Response Message.

#### 2:3.106.4.2 Generate Metadata Response Message

The Document Recipient responds with success or failure

##### 2:3.106.4.2.1 Trigger Events

This message shall be sent when a success or error condition needs to be communicated. Success is only indicated once the document is received and completely processed and persisted as appropriate to the Document Recipient Actor configuration.

##### 2:3.106.4.2.2 Message Semantics

The Document Recipient upon success returns a Parameter resource with a reference to the DocumentReference.

The Document Recipient returns an OperationOutcome upon failure.

##### 2:3.106.4.2.3 Expected Actions

The Document Source processes the results according to application-defined rules.

#### 2:3.106.4.3 CapabilityStatement Resource

Document Recipient shall provide a CapabilityStatement Resource as described in [ITI TF-2x: Appendix Z.3](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.3-capabilitystatement-resource) indicating the transaction has been implemented.

* Requirements CapabilityStatement for [Document Recipient Generate Metadata Option](CapabilityStatement-IHE.MHD.DocumentRecipient.Generate.md). This indicates that the Generate Metadata Option is declared.

Document Source should provide a CapabilityStatement Resource as described in [ITI TF-2x: Appendix Z.3](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.3-capabilitystatement-resource) indicating the transaction has been implemented.

* Requirements CapabilityStatement for [Document Source Generate Metadata Metadata Option](CapabilityStatement-IHE.MHD.DocumentSource.Generate.md). This indicates that the Generate Metadata Option is declared.

### 2:3.106.5 Security Considerations

See [MHD Security Considerations](1335_security_considerations.md).

#### 2:3.106.5.1 Security Audit Considerations

The security audit criteria are similar to those for the Provide and Register Document Set-b [ITI-41](https://profiles.ihe.net/ITI/TF/Volume2/ITI-41.html) transaction as this transaction does export a document.

##### 2:3.106.5.1.1 Document Source Audit

The Document Source when grouped with ATNA Secure Node or Secure Application Actor shall be able to record a [Generate Metadata Audit Event Log](StructureDefinition-IHE.MHD.GenerateMetadata.Audit.Source.md). [Audit Example for a Generate Metadata Transaction from source perspective](AuditEvent-ex-auditGenerateMetadata-source.md).

##### 2:3.106.5.1.2 Document Recipient Audit

The Document Recipient when grouped with ATNA Secure Node or Secure Application Actor shall be able to record a [Generate Metadata Audit Event Log](StructureDefinition-IHE.MHD.GenerateMetadata.Audit.Recipient.md). [Audit Example for a Generate Metadata Bundle Transaction from recipient perspective](AuditEvent-ex-auditGenerateMetadata-recipient.md).

