# Download and Analysis - Mobile access to Health Documents (MHD) v5.0.0-current

* [**Table of Contents**](toc.md)
* **Download and Analysis**

## Download and Analysis

You can download:

* [this entire guide](full-ig.zip),
* the definition resources in [json](definitions.json.zip), [xml](definitions.xml.zip), [ttl](definitions.ttl.zip), or [csv](csvs.zip) format, or
* the example resources in [json](examples.json.zip), [xml](examples.xml.zip) or [ttl](examples.ttl.zip) format.

The source code for this Implementation Guide can be found on [IHE ITI.MHD Github Repo](https://github.com/IHE/ITI.MHD).

#### Cross Version Analysis

#### Dependency Table



#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* Some content from IHE® Copyright © 2015 [IHE International, Inc](http://www.ihe.net/Governance/#Intellectual_Property) .

* [IHE Format Code set for use with Document Sharing](http://tx.fhir.org/r5/ValueSet/formatcode): [Bundle/FindDocumentReferences](Bundle-FindDocumentReferences.md), [Bundle/ex-ProvideDocumentBundle-addToFolder](Bundle-ex-ProvideDocumentBundle-addToFolder.md)...Show 15 more,[Bundle/ex-comprehensiveProvideDocumentBundleComplete](Bundle-ex-comprehensiveProvideDocumentBundleComplete.md),[Bundle/ex-comprehensiveProvideDocumentBundleDocument](Bundle-ex-comprehensiveProvideDocumentBundleDocument.md),[Bundle/ex-comprehensiveProvideDocumentBundleMultiple](Bundle-ex-comprehensiveProvideDocumentBundleMultiple.md),[Bundle/ex-comprehensiveProvideDocumentBundleReplace](Bundle-ex-comprehensiveProvideDocumentBundleReplace.md),[Bundle/ex-comprehensiveProvideDocumentBundleSimple](Bundle-ex-comprehensiveProvideDocumentBundleSimple.md),[Bundle/ex-dummyBundleDocAndBinary](Bundle-ex-dummyBundleDocAndBinary.md),[Bundle/ex-minimalProvideDocumentBundleSimple](Bundle-ex-minimalProvideDocumentBundleSimple.md),[Bundle/ex-minimalProvideDocumentBundleSimpleContained](Bundle-ex-minimalProvideDocumentBundleSimpleContained.md),[Bundle/ex-unContainedComprehensiveProvideDocumentBundleComplete](Bundle-ex-unContainedComprehensiveProvideDocumentBundleComplete.md),[DocumentReference/ex-DocumentReferenceComprehensive](DocumentReference-ex-DocumentReferenceComprehensive.md),[DocumentReference/ex-DocumentReferenceComprehensiveDelayedAssembly](DocumentReference-ex-DocumentReferenceComprehensiveDelayedAssembly.md),[DocumentReference/ex-DocumentReferenceComprehensiveOnDemand](DocumentReference-ex-DocumentReferenceComprehensiveOnDemand.md),[DocumentReference/ex-DocumentReferenceComprehensiveWithBinary](DocumentReference-ex-DocumentReferenceComprehensiveWithBinary.md),[DocumentReference/ex-DocumentReferenceUnContained](DocumentReference-ex-DocumentReferenceUnContained.md)and[DocumentReference/ex-DocumentReferenceUnContainedFully](DocumentReference-ex-DocumentReferenceUnContainedFully.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright © 2011 by the National Electrical Manufacturers Association.

* [Audit Event ID](http://terminology.hl7.org/6.5.0/CodeSystem-audit-event-type.html): [AuditEvent/ex-auditFindDocumentLists-consumer](AuditEvent-ex-auditFindDocumentLists-consumer.md), [AuditEvent/ex-auditFindDocumentLists-responder](AuditEvent-ex-auditFindDocumentLists-responder.md)...Show 25 more,[AuditEvent/ex-auditFindDocumentReferences-consumer](AuditEvent-ex-auditFindDocumentReferences-consumer.md),[AuditEvent/ex-auditFindDocumentReferences-post-responder](AuditEvent-ex-auditFindDocumentReferences-post-responder.md),[AuditEvent/ex-auditFindDocumentReferences-responder](AuditEvent-ex-auditFindDocumentReferences-responder.md),[AuditEvent/ex-auditGenerateMetadata-recipient](AuditEvent-ex-auditGenerateMetadata-recipient.md),[AuditEvent/ex-auditGenerateMetadata-source](AuditEvent-ex-auditGenerateMetadata-source.md),[AuditEvent/ex-auditRetrieveDocument-consumer](AuditEvent-ex-auditRetrieveDocument-consumer.md),[AuditEvent/ex-auditRetrieveDocument-responder](AuditEvent-ex-auditRetrieveDocument-responder.md),[AuditEvent/ex-auditSimplifiedPublish-recipient](AuditEvent-ex-auditSimplifiedPublish-recipient.md),[AuditEvent/ex-auditSimplifiedPublish-source](AuditEvent-ex-auditSimplifiedPublish-source.md),[AuditFindDocumentListsConsumer](StructureDefinition-IHE.MHD.FindDocumentLists.Audit.Consumer.md),[AuditFindDocumentListsResponder](StructureDefinition-IHE.MHD.FindDocumentLists.Audit.Responder.md),[AuditFindDocumentReferencesConsumer](StructureDefinition-IHE.MHD.FindDocumentReferences.Audit.Consumer.md),[AuditFindDocumentReferencesResponder](StructureDefinition-IHE.MHD.FindDocumentReferences.Audit.Responder.md),[AuditGenerateMetadataRecipient](StructureDefinition-IHE.MHD.GenerateMetadata.Audit.Recipient.md),[AuditGenerateMetadataSource](StructureDefinition-IHE.MHD.GenerateMetadata.Audit.Source.md),[AuditRetrieveDocumentConsumer](StructureDefinition-IHE.MHD.RetrieveDocument.Audit.Consumer.md),[AuditRetrieveDocumentResponder](StructureDefinition-IHE.MHD.RetrieveDocument.Audit.Responder.md),[AuditSimplifiedPublishRecipient](StructureDefinition-IHE.MHD.SimplifiedPublish.Audit.Recipient.md),[AuditSimplifiedPublishSource](StructureDefinition-IHE.MHD.SimplifiedPublish.Audit.Source.md),[Create](StructureDefinition-IHE.BasicAudit.MHD5.Create.md),[PatientCreate](StructureDefinition-IHE.BasicAudit.MHD5.PatientCreate.md),[PatientQuery](StructureDefinition-IHE.BasicAudit.MHD5.PatientQuery.md),[PatientRead](StructureDefinition-IHE.BasicAudit.MHD5.PatientRead.md),[Query](StructureDefinition-IHE.BasicAudit.MHD5.Query.md)and[Read](StructureDefinition-IHE.BasicAudit.MHD5.Read.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright Â© 2011 by the National Electrical Manufacturers Association.

* [DICOM Controlled Terminology Definitions](http://tx.fhir.org/r5/ValueSet/DCM): [AuditEvent/ex-auditFindDocumentLists-consumer](AuditEvent-ex-auditFindDocumentLists-consumer.md), [AuditEvent/ex-auditFindDocumentLists-responder](AuditEvent-ex-auditFindDocumentLists-responder.md)...Show 29 more,[AuditEvent/ex-auditFindDocumentReferences-consumer](AuditEvent-ex-auditFindDocumentReferences-consumer.md),[AuditEvent/ex-auditFindDocumentReferences-post-responder](AuditEvent-ex-auditFindDocumentReferences-post-responder.md),[AuditEvent/ex-auditFindDocumentReferences-responder](AuditEvent-ex-auditFindDocumentReferences-responder.md),[AuditEvent/ex-auditGenerateMetadata-recipient](AuditEvent-ex-auditGenerateMetadata-recipient.md),[AuditEvent/ex-auditGenerateMetadata-source](AuditEvent-ex-auditGenerateMetadata-source.md),[AuditEvent/ex-auditProvideBundle-recipient](AuditEvent-ex-auditProvideBundle-recipient.md),[AuditEvent/ex-auditProvideBundle-source](AuditEvent-ex-auditProvideBundle-source.md),[AuditEvent/ex-auditRetrieveDocument-consumer](AuditEvent-ex-auditRetrieveDocument-consumer.md),[AuditEvent/ex-auditRetrieveDocument-responder](AuditEvent-ex-auditRetrieveDocument-responder.md),[AuditEvent/ex-auditSimplifiedPublish-recipient](AuditEvent-ex-auditSimplifiedPublish-recipient.md),[AuditEvent/ex-auditSimplifiedPublish-source](AuditEvent-ex-auditSimplifiedPublish-source.md),[AuditFindDocumentListsConsumer](StructureDefinition-IHE.MHD.FindDocumentLists.Audit.Consumer.md),[AuditFindDocumentListsResponder](StructureDefinition-IHE.MHD.FindDocumentLists.Audit.Responder.md),[AuditFindDocumentReferencesConsumer](StructureDefinition-IHE.MHD.FindDocumentReferences.Audit.Consumer.md),[AuditFindDocumentReferencesResponder](StructureDefinition-IHE.MHD.FindDocumentReferences.Audit.Responder.md),[AuditGenerateMetadataRecipient](StructureDefinition-IHE.MHD.GenerateMetadata.Audit.Recipient.md),[AuditGenerateMetadataSource](StructureDefinition-IHE.MHD.GenerateMetadata.Audit.Source.md),[AuditProvideBundleRecipient](StructureDefinition-IHE.MHD.ProvideBundle.Audit.Recipient.md),[AuditProvideBundleSource](StructureDefinition-IHE.MHD.ProvideBundle.Audit.Source.md),[AuditRetrieveDocumentConsumer](StructureDefinition-IHE.MHD.RetrieveDocument.Audit.Consumer.md),[AuditRetrieveDocumentResponder](StructureDefinition-IHE.MHD.RetrieveDocument.Audit.Responder.md),[AuditSimplifiedPublishRecipient](StructureDefinition-IHE.MHD.SimplifiedPublish.Audit.Recipient.md),[AuditSimplifiedPublishSource](StructureDefinition-IHE.MHD.SimplifiedPublish.Audit.Source.md),[Create](StructureDefinition-IHE.BasicAudit.MHD5.Create.md),[PatientCreate](StructureDefinition-IHE.BasicAudit.MHD5.PatientCreate.md),[PatientQuery](StructureDefinition-IHE.BasicAudit.MHD5.PatientQuery.md),[PatientRead](StructureDefinition-IHE.BasicAudit.MHD5.PatientRead.md),[Query](StructureDefinition-IHE.BasicAudit.MHD5.Query.md)and[Read](StructureDefinition-IHE.BasicAudit.MHD5.Read.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [Bundle/ex-ProvideDocumentBundle-addToFolder](Bundle-ex-ProvideDocumentBundle-addToFolder.md), [Bundle/ex-comprehensiveProvideDocumentBundleComplete](Bundle-ex-comprehensiveProvideDocumentBundleComplete.md)...Show 14 more,[Bundle/ex-comprehensiveProvideDocumentBundleDocument](Bundle-ex-comprehensiveProvideDocumentBundleDocument.md),[Bundle/ex-comprehensiveProvideDocumentBundleMultiple](Bundle-ex-comprehensiveProvideDocumentBundleMultiple.md),[Bundle/ex-comprehensiveProvideDocumentBundleReplace](Bundle-ex-comprehensiveProvideDocumentBundleReplace.md),[Bundle/ex-comprehensiveProvideDocumentBundleSimple](Bundle-ex-comprehensiveProvideDocumentBundleSimple.md),[Bundle/ex-dummyBundleDocAndBinary](Bundle-ex-dummyBundleDocAndBinary.md),[Bundle/ex-fhir-document-bundle](Bundle-ex-fhir-document-bundle.md),[Bundle/ex-unContainedComprehensiveProvideDocumentBundleComplete](Bundle-ex-unContainedComprehensiveProvideDocumentBundleComplete.md),[DocumentReference/ex-DocumentReferenceComprehensive](DocumentReference-ex-DocumentReferenceComprehensive.md),[DocumentReference/ex-DocumentReferenceComprehensiveDelayedAssembly](DocumentReference-ex-DocumentReferenceComprehensiveDelayedAssembly.md),[DocumentReference/ex-DocumentReferenceComprehensiveOnDemand](DocumentReference-ex-DocumentReferenceComprehensiveOnDemand.md),[DocumentReference/ex-DocumentReferenceComprehensiveWithBinary](DocumentReference-ex-DocumentReferenceComprehensiveWithBinary.md),[DocumentReference/ex-DocumentReferenceUnContained](DocumentReference-ex-DocumentReferenceUnContained.md),[DocumentReference/ex-DocumentReferenceUnContainedFully](DocumentReference-ex-DocumentReferenceUnContainedFully.md)and[Parameters/ex-input-doc-bundle](Parameters-ex-input-doc-bundle.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* SNOMED Clinical Terms&reg; (SNOMED CT&reg;): [Bundle/FindDocumentReferences](Bundle-FindDocumentReferences.md), [Bundle/ex-ProvideDocumentBundle-addToFolder](Bundle-ex-ProvideDocumentBundle-addToFolder.md)...Show 19 more,[Bundle/ex-comprehensiveProvideDocumentBundleComplete](Bundle-ex-comprehensiveProvideDocumentBundleComplete.md),[Bundle/ex-comprehensiveProvideDocumentBundleDocument](Bundle-ex-comprehensiveProvideDocumentBundleDocument.md),[Bundle/ex-comprehensiveProvideDocumentBundleMultiple](Bundle-ex-comprehensiveProvideDocumentBundleMultiple.md),[Bundle/ex-comprehensiveProvideDocumentBundleReplace](Bundle-ex-comprehensiveProvideDocumentBundleReplace.md),[Bundle/ex-comprehensiveProvideDocumentBundleSimple](Bundle-ex-comprehensiveProvideDocumentBundleSimple.md),[Bundle/ex-fhir-document-bundle](Bundle-ex-fhir-document-bundle.md),[Bundle/ex-unContainedComprehensiveProvideDocumentBundleComplete](Bundle-ex-unContainedComprehensiveProvideDocumentBundleComplete.md),[DocumentReference/ex-DocumentReferenceComprehensive](DocumentReference-ex-DocumentReferenceComprehensive.md),[DocumentReference/ex-DocumentReferenceComprehensiveDelayedAssembly](DocumentReference-ex-DocumentReferenceComprehensiveDelayedAssembly.md),[DocumentReference/ex-DocumentReferenceComprehensiveOnDemand](DocumentReference-ex-DocumentReferenceComprehensiveOnDemand.md),[DocumentReference/ex-DocumentReferenceComprehensiveWithBinary](DocumentReference-ex-DocumentReferenceComprehensiveWithBinary.md),[DocumentReference/ex-DocumentReferenceUnContained](DocumentReference-ex-DocumentReferenceUnContained.md),[DocumentReference/ex-DocumentReferenceUnContainedFully](DocumentReference-ex-DocumentReferenceUnContainedFully.md),[List/ex-compEmailPackage](List-ex-compEmailPackage.md),[List/ex-compFolder](List-ex-compFolder.md),[List/ex-compSubmissionSetFull](List-ex-compSubmissionSetFull.md),[List/ex-compSubmissionSetFullUnContained](List-ex-compSubmissionSetFullUnContained.md),[List/ex-compSubmissionSetList](List-ex-compSubmissionSetList.md)and[Parameters/ex-input-doc-bundle](Parameters-ex-input-doc-bundle.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-clinical.html): [Bundle/ex-comprehensiveProvideDocumentBundleDocument](Bundle-ex-comprehensiveProvideDocumentBundleDocument.md), [Bundle/ex-fhir-document-bundle](Bundle-ex-fhir-document-bundle.md) and [Parameters/ex-input-doc-bundle](Parameters-ex-input-doc-bundle.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-verification.html): [Bundle/ex-comprehensiveProvideDocumentBundleDocument](Bundle-ex-comprehensiveProvideDocumentBundleDocument.md), [Bundle/ex-fhir-document-bundle](Bundle-ex-fhir-document-bundle.md) and [Parameters/ex-input-doc-bundle](Parameters-ex-input-doc-bundle.md)
* [AuditEventOutcome](http://terminology.hl7.org/6.5.0/CodeSystem-audit-event-outcome.html): [AuditEvent/ex-auditFindDocumentLists-consumer](AuditEvent-ex-auditFindDocumentLists-consumer.md), [AuditEvent/ex-auditFindDocumentLists-responder](AuditEvent-ex-auditFindDocumentLists-responder.md)...Show 27 more,[AuditEvent/ex-auditFindDocumentReferences-consumer](AuditEvent-ex-auditFindDocumentReferences-consumer.md),[AuditEvent/ex-auditFindDocumentReferences-post-responder](AuditEvent-ex-auditFindDocumentReferences-post-responder.md),[AuditEvent/ex-auditFindDocumentReferences-responder](AuditEvent-ex-auditFindDocumentReferences-responder.md),[AuditEvent/ex-auditGenerateMetadata-recipient](AuditEvent-ex-auditGenerateMetadata-recipient.md),[AuditEvent/ex-auditGenerateMetadata-source](AuditEvent-ex-auditGenerateMetadata-source.md),[AuditEvent/ex-auditProvideBundle-recipient](AuditEvent-ex-auditProvideBundle-recipient.md),[AuditEvent/ex-auditProvideBundle-source](AuditEvent-ex-auditProvideBundle-source.md),[AuditEvent/ex-auditRetrieveDocument-consumer](AuditEvent-ex-auditRetrieveDocument-consumer.md),[AuditEvent/ex-auditRetrieveDocument-responder](AuditEvent-ex-auditRetrieveDocument-responder.md),[AuditEvent/ex-auditSimplifiedPublish-recipient](AuditEvent-ex-auditSimplifiedPublish-recipient.md),[AuditEvent/ex-auditSimplifiedPublish-source](AuditEvent-ex-auditSimplifiedPublish-source.md),[AuditFindDocumentListsConsumer](StructureDefinition-IHE.MHD.FindDocumentLists.Audit.Consumer.md),[AuditFindDocumentListsResponder](StructureDefinition-IHE.MHD.FindDocumentLists.Audit.Responder.md),[AuditFindDocumentReferencesConsumer](StructureDefinition-IHE.MHD.FindDocumentReferences.Audit.Consumer.md),[AuditFindDocumentReferencesResponder](StructureDefinition-IHE.MHD.FindDocumentReferences.Audit.Responder.md),[AuditGenerateMetadataRecipient](StructureDefinition-IHE.MHD.GenerateMetadata.Audit.Recipient.md),[AuditGenerateMetadataSource](StructureDefinition-IHE.MHD.GenerateMetadata.Audit.Source.md),[AuditRetrieveDocumentConsumer](StructureDefinition-IHE.MHD.RetrieveDocument.Audit.Consumer.md),[AuditRetrieveDocumentResponder](StructureDefinition-IHE.MHD.RetrieveDocument.Audit.Responder.md),[AuditSimplifiedPublishRecipient](StructureDefinition-IHE.MHD.SimplifiedPublish.Audit.Recipient.md),[AuditSimplifiedPublishSource](StructureDefinition-IHE.MHD.SimplifiedPublish.Audit.Source.md),[Create](StructureDefinition-IHE.BasicAudit.MHD5.Create.md),[PatientCreate](StructureDefinition-IHE.BasicAudit.MHD5.PatientCreate.md),[PatientQuery](StructureDefinition-IHE.BasicAudit.MHD5.PatientQuery.md),[PatientRead](StructureDefinition-IHE.BasicAudit.MHD5.PatientRead.md),[Query](StructureDefinition-IHE.BasicAudit.MHD5.Query.md)and[Read](StructureDefinition-IHE.BasicAudit.MHD5.Read.md)
* [DoseAndRateType](http://terminology.hl7.org/6.5.0/CodeSystem-dose-rate-type.html): [Bundle/ex-comprehensiveProvideDocumentBundleDocument](Bundle-ex-comprehensiveProvideDocumentBundleDocument.md), [Bundle/ex-fhir-document-bundle](Bundle-ex-fhir-document-bundle.md) and [Parameters/ex-input-doc-bundle](Parameters-ex-input-doc-bundle.md)
* [AuditEventEntityRole](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html): [AuditEvent/ex-auditFindDocumentLists-consumer](AuditEvent-ex-auditFindDocumentLists-consumer.md), [AuditEvent/ex-auditFindDocumentLists-responder](AuditEvent-ex-auditFindDocumentLists-responder.md)...Show 29 more,[AuditEvent/ex-auditFindDocumentReferences-consumer](AuditEvent-ex-auditFindDocumentReferences-consumer.md),[AuditEvent/ex-auditFindDocumentReferences-post-responder](AuditEvent-ex-auditFindDocumentReferences-post-responder.md),[AuditEvent/ex-auditFindDocumentReferences-responder](AuditEvent-ex-auditFindDocumentReferences-responder.md),[AuditEvent/ex-auditGenerateMetadata-recipient](AuditEvent-ex-auditGenerateMetadata-recipient.md),[AuditEvent/ex-auditGenerateMetadata-source](AuditEvent-ex-auditGenerateMetadata-source.md),[AuditEvent/ex-auditProvideBundle-recipient](AuditEvent-ex-auditProvideBundle-recipient.md),[AuditEvent/ex-auditProvideBundle-source](AuditEvent-ex-auditProvideBundle-source.md),[AuditEvent/ex-auditRetrieveDocument-consumer](AuditEvent-ex-auditRetrieveDocument-consumer.md),[AuditEvent/ex-auditRetrieveDocument-responder](AuditEvent-ex-auditRetrieveDocument-responder.md),[AuditEvent/ex-auditSimplifiedPublish-recipient](AuditEvent-ex-auditSimplifiedPublish-recipient.md),[AuditEvent/ex-auditSimplifiedPublish-source](AuditEvent-ex-auditSimplifiedPublish-source.md),[AuditFindDocumentListsConsumer](StructureDefinition-IHE.MHD.FindDocumentLists.Audit.Consumer.md),[AuditFindDocumentListsResponder](StructureDefinition-IHE.MHD.FindDocumentLists.Audit.Responder.md),[AuditFindDocumentReferencesConsumer](StructureDefinition-IHE.MHD.FindDocumentReferences.Audit.Consumer.md),[AuditFindDocumentReferencesResponder](StructureDefinition-IHE.MHD.FindDocumentReferences.Audit.Responder.md),[AuditGenerateMetadataRecipient](StructureDefinition-IHE.MHD.GenerateMetadata.Audit.Recipient.md),[AuditProvideBundleRecipient](StructureDefinition-IHE.MHD.ProvideBundle.Audit.Recipient.md),[AuditProvideBundleSource](StructureDefinition-IHE.MHD.ProvideBundle.Audit.Source.md),[AuditRetrieveDocumentConsumer](StructureDefinition-IHE.MHD.RetrieveDocument.Audit.Consumer.md),[AuditRetrieveDocumentResponder](StructureDefinition-IHE.MHD.RetrieveDocument.Audit.Responder.md),[AuditSimplifiedPublishRecipient](StructureDefinition-IHE.MHD.SimplifiedPublish.Audit.Recipient.md),[AuditSimplifiedPublishSource](StructureDefinition-IHE.MHD.SimplifiedPublish.Audit.Source.md),[Create](StructureDefinition-IHE.BasicAudit.MHD5.Create.md),[PatientCreate](StructureDefinition-IHE.BasicAudit.MHD5.PatientCreate.md),[PatientQuery](StructureDefinition-IHE.BasicAudit.MHD5.PatientQuery.md),[PatientRead](StructureDefinition-IHE.BasicAudit.MHD5.PatientRead.md),[Query](StructureDefinition-IHE.BasicAudit.MHD5.Query.md),[Read](StructureDefinition-IHE.BasicAudit.MHD5.Read.md)and[RestObjectRoles](ValueSet-RestObjectRoles.md)
* [Audit Event Source Type](http://terminology.hl7.org/6.5.0/CodeSystem-security-source-type.html): [AuditEvent/ex-auditFindDocumentLists-consumer](AuditEvent-ex-auditFindDocumentLists-consumer.md), [AuditEvent/ex-auditFindDocumentLists-responder](AuditEvent-ex-auditFindDocumentLists-responder.md)...Show 11 more,[AuditEvent/ex-auditFindDocumentReferences-consumer](AuditEvent-ex-auditFindDocumentReferences-consumer.md),[AuditEvent/ex-auditFindDocumentReferences-post-responder](AuditEvent-ex-auditFindDocumentReferences-post-responder.md),[AuditEvent/ex-auditFindDocumentReferences-responder](AuditEvent-ex-auditFindDocumentReferences-responder.md),[AuditEvent/ex-auditGenerateMetadata-recipient](AuditEvent-ex-auditGenerateMetadata-recipient.md),[AuditEvent/ex-auditGenerateMetadata-source](AuditEvent-ex-auditGenerateMetadata-source.md),[AuditEvent/ex-auditProvideBundle-recipient](AuditEvent-ex-auditProvideBundle-recipient.md),[AuditEvent/ex-auditProvideBundle-source](AuditEvent-ex-auditProvideBundle-source.md),[AuditEvent/ex-auditRetrieveDocument-consumer](AuditEvent-ex-auditRetrieveDocument-consumer.md),[AuditEvent/ex-auditRetrieveDocument-responder](AuditEvent-ex-auditRetrieveDocument-responder.md),[AuditEvent/ex-auditSimplifiedPublish-recipient](AuditEvent-ex-auditSimplifiedPublish-recipient.md)and[AuditEvent/ex-auditSimplifiedPublish-source](AuditEvent-ex-auditSimplifiedPublish-source.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Bundle/ex-comprehensiveProvideDocumentBundleComplete](Bundle-ex-comprehensiveProvideDocumentBundleComplete.md), [Bundle/ex-comprehensiveProvideDocumentBundleDocument](Bundle-ex-comprehensiveProvideDocumentBundleDocument.md)...Show 7 more,[Bundle/ex-fhir-document-bundle](Bundle-ex-fhir-document-bundle.md),[Bundle/ex-unContainedComprehensiveProvideDocumentBundleComplete](Bundle-ex-unContainedComprehensiveProvideDocumentBundleComplete.md),[DocumentReference/ex-DocumentReferenceComprehensive](DocumentReference-ex-DocumentReferenceComprehensive.md),[DocumentReference/ex-DocumentReferenceComprehensiveDelayedAssembly](DocumentReference-ex-DocumentReferenceComprehensiveDelayedAssembly.md),[DocumentReference/ex-DocumentReferenceUnContainedFully](DocumentReference-ex-DocumentReferenceUnContainedFully.md),[Encounter/ex-encounter](Encounter-ex-encounter.md)and[Parameters/ex-input-doc-bundle](Parameters-ex-input-doc-bundle.md)
* [ActReason](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html): [AuditEvent/ex-auditFindDocumentLists-consumer](AuditEvent-ex-auditFindDocumentLists-consumer.md), [AuditEvent/ex-auditFindDocumentLists-responder](AuditEvent-ex-auditFindDocumentLists-responder.md)...Show 56 more,[AuditEvent/ex-auditFindDocumentReferences-consumer](AuditEvent-ex-auditFindDocumentReferences-consumer.md),[AuditEvent/ex-auditFindDocumentReferences-post-responder](AuditEvent-ex-auditFindDocumentReferences-post-responder.md),[AuditEvent/ex-auditFindDocumentReferences-responder](AuditEvent-ex-auditFindDocumentReferences-responder.md),[AuditEvent/ex-auditGenerateMetadata-recipient](AuditEvent-ex-auditGenerateMetadata-recipient.md),[AuditEvent/ex-auditGenerateMetadata-source](AuditEvent-ex-auditGenerateMetadata-source.md),[AuditEvent/ex-auditProvideBundle-recipient](AuditEvent-ex-auditProvideBundle-recipient.md),[AuditEvent/ex-auditProvideBundle-source](AuditEvent-ex-auditProvideBundle-source.md),[AuditEvent/ex-auditRetrieveDocument-consumer](AuditEvent-ex-auditRetrieveDocument-consumer.md),[AuditEvent/ex-auditRetrieveDocument-responder](AuditEvent-ex-auditRetrieveDocument-responder.md),[AuditEvent/ex-auditSimplifiedPublish-recipient](AuditEvent-ex-auditSimplifiedPublish-recipient.md),[AuditEvent/ex-auditSimplifiedPublish-source](AuditEvent-ex-auditSimplifiedPublish-source.md),[Binary/ex-b-binary](Binary-ex-b-binary.md),[Binary/ex-binary](Binary-ex-binary.md),[Bundle/ex-ProvideDocumentBundle-addToFolder](Bundle-ex-ProvideDocumentBundle-addToFolder.md),[Bundle/ex-comprehensiveProvideDocumentBundleComplete](Bundle-ex-comprehensiveProvideDocumentBundleComplete.md),[Bundle/ex-comprehensiveProvideDocumentBundleDocument](Bundle-ex-comprehensiveProvideDocumentBundleDocument.md),[Bundle/ex-comprehensiveProvideDocumentBundleMultiple](Bundle-ex-comprehensiveProvideDocumentBundleMultiple.md),[Bundle/ex-comprehensiveProvideDocumentBundleReplace](Bundle-ex-comprehensiveProvideDocumentBundleReplace.md),[Bundle/ex-comprehensiveProvideDocumentBundleSimple](Bundle-ex-comprehensiveProvideDocumentBundleSimple.md),[Bundle/ex-dummyBundleDocAndBinary](Bundle-ex-dummyBundleDocAndBinary.md),[Bundle/ex-findDocumentListsResponse](Bundle-ex-findDocumentListsResponse.md),[Bundle/ex-findDocumentReferencesResponse](Bundle-ex-findDocumentReferencesResponse.md),[Bundle/ex-minimalProvideDocumentBundleSimple](Bundle-ex-minimalProvideDocumentBundleSimple.md),[Bundle/ex-minimalProvideDocumentBundleSimpleContained](Bundle-ex-minimalProvideDocumentBundleSimpleContained.md),[Bundle/ex-response-comprehensiveProvideDocumentBundleComplete](Bundle-ex-response-comprehensiveProvideDocumentBundleComplete.md),[Bundle/ex-response-comprehensiveProvideDocumentBundleMultiple](Bundle-ex-response-comprehensiveProvideDocumentBundleMultiple.md),[Bundle/ex-response-comprehensiveProvideDocumentBundleSimple](Bundle-ex-response-comprehensiveProvideDocumentBundleSimple.md),[Bundle/ex-response-minimalProvideDocumentBundleSimple](Bundle-ex-response-minimalProvideDocumentBundleSimple.md),[Bundle/ex-response-minimalProvideDocumentBundleSimpleContained](Bundle-ex-response-minimalProvideDocumentBundleSimpleContained.md),[Bundle/ex-response-unContainedComprehensiveProvideDocumentBundleCompt](Bundle-ex-response-unContainedComprehensiveProvideDocumentBundleCompt.md),[Bundle/ex-unContainedComprehensiveProvideDocumentBundleComplete](Bundle-ex-unContainedComprehensiveProvideDocumentBundleComplete.md),[Device/ex-device](Device-ex-device.md),[DocumentReference/ex-DocumentReferenceComprehensive](DocumentReference-ex-DocumentReferenceComprehensive.md),[DocumentReference/ex-DocumentReferenceComprehensiveDelayedAssembly](DocumentReference-ex-DocumentReferenceComprehensiveDelayedAssembly.md),[DocumentReference/ex-DocumentReferenceComprehensiveOnDemand](DocumentReference-ex-DocumentReferenceComprehensiveOnDemand.md),[DocumentReference/ex-DocumentReferenceComprehensiveWithBinary](DocumentReference-ex-DocumentReferenceComprehensiveWithBinary.md),[DocumentReference/ex-DocumentReferenceMinimal](DocumentReference-ex-DocumentReferenceMinimal.md),[DocumentReference/ex-DocumentReferenceMinimalEncounter](DocumentReference-ex-DocumentReferenceMinimalEncounter.md),[DocumentReference/ex-DocumentReferenceSimplifiedPublish](DocumentReference-ex-DocumentReferenceSimplifiedPublish.md),[DocumentReference/ex-DocumentReferenceUnContained](DocumentReference-ex-DocumentReferenceUnContained.md),[DocumentReference/ex-DocumentReferenceUnContainedFully](DocumentReference-ex-DocumentReferenceUnContainedFully.md),[DocumentReference/ex-documentreference](DocumentReference-ex-documentreference.md),[DocumentReference/ex-documentreference2](DocumentReference-ex-documentreference2.md),[Encounter/ex-encounter](Encounter-ex-encounter.md),[List/ex-compEmailPackage](List-ex-compEmailPackage.md),[List/ex-compFolder](List-ex-compFolder.md),[List/ex-compSubmissionSetFull](List-ex-compSubmissionSetFull.md),[List/ex-compSubmissionSetFullUnContained](List-ex-compSubmissionSetFullUnContained.md),[List/ex-compSubmissionSetList](List-ex-compSubmissionSetList.md),[List/ex-list](List-ex-list.md),[List/ex-minimalFolder](List-ex-minimalFolder.md),[List/ex-minimalSubmissionSet](List-ex-minimalSubmissionSet.md),[Parameters/ex-input-binary](Parameters-ex-input-binary.md),[Patient/ex-patient](Patient-ex-patient.md),[Practitioner/ex-practitioner](Practitioner-ex-practitioner.md)and[nowhere](Organization-ex-organization.md)
* [Confidentiality](http://terminology.hl7.org/6.5.0/CodeSystem-v3-Confidentiality.html): [Bundle/FindDocumentReferences](Bundle-FindDocumentReferences.md), [Bundle/ex-ProvideDocumentBundle-addToFolder](Bundle-ex-ProvideDocumentBundle-addToFolder.md)...Show 12 more,[Bundle/ex-comprehensiveProvideDocumentBundleComplete](Bundle-ex-comprehensiveProvideDocumentBundleComplete.md),[Bundle/ex-comprehensiveProvideDocumentBundleDocument](Bundle-ex-comprehensiveProvideDocumentBundleDocument.md),[Bundle/ex-comprehensiveProvideDocumentBundleMultiple](Bundle-ex-comprehensiveProvideDocumentBundleMultiple.md),[Bundle/ex-comprehensiveProvideDocumentBundleReplace](Bundle-ex-comprehensiveProvideDocumentBundleReplace.md),[Bundle/ex-comprehensiveProvideDocumentBundleSimple](Bundle-ex-comprehensiveProvideDocumentBundleSimple.md),[Bundle/ex-unContainedComprehensiveProvideDocumentBundleComplete](Bundle-ex-unContainedComprehensiveProvideDocumentBundleComplete.md),[DocumentReference/ex-DocumentReferenceComprehensive](DocumentReference-ex-DocumentReferenceComprehensive.md),[DocumentReference/ex-DocumentReferenceComprehensiveDelayedAssembly](DocumentReference-ex-DocumentReferenceComprehensiveDelayedAssembly.md),[DocumentReference/ex-DocumentReferenceComprehensiveOnDemand](DocumentReference-ex-DocumentReferenceComprehensiveOnDemand.md),[DocumentReference/ex-DocumentReferenceComprehensiveWithBinary](DocumentReference-ex-DocumentReferenceComprehensiveWithBinary.md),[DocumentReference/ex-DocumentReferenceUnContained](DocumentReference-ex-DocumentReferenceUnContained.md)and[DocumentReference/ex-DocumentReferenceUnContainedFully](DocumentReference-ex-DocumentReferenceUnContainedFully.md)
* [ParticipationType](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationType.html): [AuditFindDocumentListsConsumer](StructureDefinition-IHE.MHD.FindDocumentLists.Audit.Consumer.md), [AuditFindDocumentListsResponder](StructureDefinition-IHE.MHD.FindDocumentLists.Audit.Responder.md)...Show 10 more,[AuditFindDocumentReferencesConsumer](StructureDefinition-IHE.MHD.FindDocumentReferences.Audit.Consumer.md),[AuditFindDocumentReferencesResponder](StructureDefinition-IHE.MHD.FindDocumentReferences.Audit.Responder.md),[AuditRetrieveDocumentConsumer](StructureDefinition-IHE.MHD.RetrieveDocument.Audit.Consumer.md),[AuditRetrieveDocumentResponder](StructureDefinition-IHE.MHD.RetrieveDocument.Audit.Responder.md),[Create](StructureDefinition-IHE.BasicAudit.MHD5.Create.md),[DataSources](ValueSet-DataSources.md),[PatientQuery](StructureDefinition-IHE.BasicAudit.MHD5.PatientQuery.md),[PatientRead](StructureDefinition-IHE.BasicAudit.MHD5.PatientRead.md),[Query](StructureDefinition-IHE.BasicAudit.MHD5.Query.md)and[Read](StructureDefinition-IHE.BasicAudit.MHD5.Read.md)
* [Orderable Drug Form](http://terminology.hl7.org/6.5.0/CodeSystem-v3-orderableDrugForm.html): [Bundle/ex-comprehensiveProvideDocumentBundleDocument](Bundle-ex-comprehensiveProvideDocumentBundleDocument.md), [Bundle/ex-fhir-document-bundle](Bundle-ex-fhir-document-bundle.md) and [Parameters/ex-input-doc-bundle](Parameters-ex-input-doc-bundle.md)


