# ex-input-doc-bundle - Mobile access to Health Documents (MHD) v4.2.4-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ex-input-doc-bundle**

## Example Parameters: ex-input-doc-bundle

Profile: [IHE MHD GenerateMetadata Parameters In](StructureDefinition-IHE.MHD.GenerateMetadata.Parameters.In.md)

## Parameters



## Resource Content

```json
{
  "resourceType" : "Parameters",
  "id" : "ex-input-doc-bundle",
  "meta" : {
    "profile" : [
      "https://profiles.ihe.net/ITI/MHD/StructureDefinition/IHE.MHD.GenerateMetadata.Parameters.In"
    ]
  },
  "parameter" : [
    {
      "name" : "document",
      "resource" : {
        "resourceType" : "Bundle",
        "id" : "ex-fhir-document-bundle",
        "meta" : {
          "lastUpdated" : "2013-05-28T22:12:21Z"
        },
        "identifier" : {
          "system" : "urn:ietf:rfc:3986",
          "value" : "urn:uuid:0c3151bd-1cbf-4d64-b04d-cd9187a4c6e0"
        },
        "type" : "document",
        "timestamp" : "2013-05-28T22:12:21Z",
        "entry" : [
          {
            "fullUrl" : "http://example.org/fhir/Composition/180f219f-97a8-486d-99d9-ed631fe4fc57",
            "resource" : {
              "resourceType" : "Composition",
              "id" : "180f219f-97a8-486d-99d9-ed631fe4fc57",
              "meta" : {
                "lastUpdated" : "2013-05-28T22:12:21Z"
              },
              "status" : "final",
              "type" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "28655-9"
                  }
                ],
                "text" : "Discharge Summary from Responsible Clinician"
              },
              "subject" : {
                "reference" : "Patient/fdoc-patient"
              },
              "encounter" : {
                "reference" : "Encounter/fdoc-encounter"
              },
              "date" : "2013-02-01T12:30:02Z",
              "author" : [
                {
                  "reference" : "Practitioner/fdoc-practitioner"
                }
              ],
              "title" : "Discharge Summary",
              "section" : [
                {
                  "title" : "Reason for admission",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "29299-5",
                        "display" : "Reason for visit Narrative"
                      }
                    ]
                  },
                  "text" : {
                    "status" : "additional",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table><thead><tr><td>Details</td><td/></tr></thead><tbody><tr><td>Acute Asthmatic attack. Was wheezing for days prior to admission.</td><td/></tr></tbody></table></div>"
                  },
                  "entry" : [
                    {
                      "reference" : "Observation/fdoc-observation"
                    }
                  ]
                },
                {
                  "title" : "Medications on Discharge",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "10183-2",
                        "display" : "Hospital discharge medications Narrative"
                      }
                    ]
                  },
                  "text" : {
                    "status" : "additional",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table><thead><tr><td>Medication</td><td>Last Change</td><td>Last ChangeReason</td></tr></thead><tbody><tr><td>Theophylline 200mg BD after meals</td><td>continued</td></tr><tr><td>Ventolin Inhaler</td><td>stopped</td><td>Getting side effect of tremor</td></tr></tbody></table></div>"
                  },
                  "entry" : [
                    {
                      "reference" : "MedicationRequest/fdoc-medicationrequest"
                    },
                    {
                      "reference" : "MedicationStatement/fdoc-medicationstatement"
                    }
                  ]
                },
                {
                  "title" : "Known allergies",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "48765-2",
                        "display" : "Allergies and adverse reactions Document"
                      }
                    ]
                  },
                  "text" : {
                    "status" : "additional",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><table><thead><tr><td>Allergen</td><td>Reaction</td></tr></thead><tbody><tr><td>Doxycycline</td><td>Hives</td></tr></tbody></table></div>"
                  },
                  "entry" : [
                    {
                      "reference" : "AllergyIntolerance/fdoc-allergyintolerance"
                    }
                  ]
                }
              ]
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/Practitioner/fdoc-practitioner",
            "resource" : {
              "resourceType" : "Practitioner",
              "id" : "fdoc-practitioner",
              "identifier" : [
                {
                  "system" : "http://www.acme.org/practitioners",
                  "value" : "23"
                }
              ],
              "name" : [
                {
                  "family" : "Careful",
                  "given" : ["Adam"],
                  "prefix" : ["Dr"]
                }
              ]
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/Patient/fdoc-patient",
            "resource" : {
              "resourceType" : "Patient",
              "id" : "fdoc-patient",
              "active" : true,
              "name" : [
                {
                  "text" : "Eve Everywoman",
                  "family" : "Everywoman1",
                  "given" : ["Eve"]
                }
              ],
              "telecom" : [
                {
                  "system" : "phone",
                  "value" : "555-555-2003",
                  "use" : "work"
                }
              ],
              "gender" : "female",
              "birthDate" : "1955-01-06",
              "address" : [
                {
                  "use" : "home",
                  "line" : ["2222 Home Street"]
                }
              ]
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/Encounter/fdoc-encounter",
            "resource" : {
              "resourceType" : "Encounter",
              "id" : "fdoc-encounter",
              "identifier" : [
                {
                  "system" : "http://www.example.org/encounters",
                  "value" : "S100"
                }
              ],
              "status" : "finished",
              "class" : {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                "code" : "IMP",
                "display" : "inpatient encounter"
              },
              "type" : [
                {
                  "text" : "Orthopedic Admission"
                }
              ],
              "subject" : {
                "reference" : "Patient/fdoc-patient"
              },
              "period" : {
                "start" : "2013-01-20T12:30:02Z",
                "end" : "2013-02-01T12:30:02Z"
              },
              "hospitalization" : {
                "dischargeDisposition" : {
                  "text" : "Discharged to care of GP"
                }
              }
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/Observation/fdoc-observation",
            "resource" : {
              "resourceType" : "Observation",
              "id" : "fdoc-observation",
              "status" : "final",
              "code" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "46241-6"
                  }
                ],
                "text" : "Reason for admission"
              },
              "subject" : {
                "reference" : "Patient/fdoc-patient"
              },
              "encounter" : {
                "reference" : "Encounter/fdoc-encounter"
              },
              "valueString" : "Acute Asthmatic attack. Was wheezing for days prior to admission."
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/MedicationRequest/fdoc-medicationrequest",
            "resource" : {
              "resourceType" : "MedicationRequest",
              "id" : "fdoc-medicationrequest",
              "status" : "unknown",
              "intent" : "order",
              "medicationCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "66493003"
                  }
                ],
                "text" : "Theophylline 200mg"
              },
              "subject" : {
                "reference" : "Patient/fdoc-patient"
              },
              "requester" : {
                "reference" : "Practitioner/fdoc-practitioner"
              },
              "reasonCode" : [
                {
                  "text" : "Management of Asthma"
                }
              ],
              "dosageInstruction" : [
                {
                  "additionalInstruction" : [
                    {
                      "text" : "Take with Food"
                    }
                  ],
                  "timing" : {
                    "repeat" : {
                      "frequency" : 2,
                      "period" : 1,
                      "periodUnit" : "d"
                    }
                  },
                  "route" : {
                    "coding" : [
                      {
                        "system" : "http://snomed.info/sct",
                        "code" : "394899003",
                        "display" : "oral administration of treatment"
                      }
                    ]
                  },
                  "doseAndRate" : [
                    {
                      "type" : {
                        "coding" : [
                          {
                            "system" : "http://terminology.hl7.org/CodeSystem/dose-rate-type",
                            "code" : "ordered",
                            "display" : "Ordered"
                          }
                        ]
                      },
                      "doseQuantity" : {
                        "value" : 1,
                        "unit" : "tablet",
                        "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm",
                        "code" : "TAB"
                      }
                    }
                  ]
                }
              ]
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/MedicationStatement/fdoc-medicationstatement",
            "resource" : {
              "resourceType" : "MedicationStatement",
              "id" : "fdoc-medicationstatement",
              "status" : "active",
              "statusReason" : [
                {
                  "text" : "Management of Asthma"
                }
              ],
              "medicationCodeableConcept" : {
                "text" : "Ventolin Inhaler"
              },
              "subject" : {
                "reference" : "Patient/fdoc-patient"
              },
              "dateAsserted" : "2013-05-05T16:13:03Z"
            }
          },
          {
            "fullUrl" : "http://example.org/fhir/AllergyIntolerance/fdoc-allergyintolerance",
            "resource" : {
              "resourceType" : "AllergyIntolerance",
              "id" : "fdoc-allergyintolerance",
              "clinicalStatus" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
                    "code" : "active",
                    "display" : "Active"
                  }
                ]
              },
              "verificationStatus" : {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
                    "code" : "confirmed",
                    "display" : "Confirmed"
                  }
                ]
              },
              "type" : "allergy",
              "criticality" : "high",
              "code" : {
                "text" : "Doxycycline"
              },
              "patient" : {
                "reference" : "Patient/fdoc-patient"
              },
              "recordedDate" : "2012-09-17",
              "reaction" : [
                {
                  "manifestation" : [
                    {
                      "text" : "Hives"
                    }
                  ]
                }
              ]
            }
          }
        ]
      }
    }
  ]
}

```
