# 2:3.105 Simplified Publish [ITI-105] - Mobile access to Health Documents (MHD) v4.2.4-current

* [**Table of Contents**](toc.md)
* **2:3.105 Simplified Publish [ITI-105]**

## 2:3.105 Simplified Publish [ITI-105]

This section corresponds to transaction [ITI-105] of the IHE Technical Framework. Transaction [ITI-105] is used by the Document Source and Document Recipient Actors. The Simplified Publish [ITI-105] transaction is used to transmit a document and the document metadata.

### 2:3.105.1 Scope

The Simplified Publish [ITI-105] transaction passes a Simplified Publish Request from a Document Source to a Document Recipient.

### 2:3.105.2 Actors Roles

**Table 2:3.105.2-1: Actor Roles**

| | |
| :--- | :--- |
| [Document Source](1331_actors_and_transactions.md#133111-document-source) | Sends document and metadata to the Document Recipient |
| [Document Recipient](1331_actors_and_transactions.md#133113-document-recipient) | Accepts the document and metadata sent from the Document Source |

### 2:3.105.3 Referenced Standards

**HL7 FHIR** Revision 4.0.1 found at [http://hl7.org/fhir/R4/](http://hl7.org/fhir/R4/)

### 2:3.105.4 Messages

**Figure 2:3.105.4-1: Simplified Publish Interactions**

#### 2:3.105.4.1 Simplified Publish Request Message

This message uses the HTTP POST method on the target Simplified Publish endpoint to convey the metadata and the document as a FHIR DocumentReference.

##### 2:3.105.4.1.1 Trigger Events

This method is invoked when the Document Source needs to submit one document to a Document Recipient.

##### 2:3.105.4.1.2 Message Semantics

The Document Source shall initiate a FHIR “create” action by sending an HTTP POST request method composed of a FHIR [Simplified Publish DocumentReference](StructureDefinition-IHE.MHD.SimplifiedPublish.DocumentReference.md), with the document encoded in the `DocumentReference.content.attachment.data` element. Refer to [ITI TF-3: 4.5.1](32_fhir_maps.md) for details on the FHIR Resources and how Document Sharing metadata attributes are mapped.

The media type of the HTTP body shall be either `application/fhir+json` or `application/fhir+xml`.

The Simplified Publish message is sent to the DocumentReference at the base URL as defined in FHIR. See [FHIR http.html](http://hl7.org/fhir/R4/http.html) for the definition of “HTTP” access methods and “base”.

```
[base]/DocumentReference

```

The Document Source shall assure the [Simplified Publish DocumentReference](StructureDefinition-IHE.MHD.SimplifiedPublish.DocumentReference.md) resource are consistent with the [Document Sharing metadata](https://profiles.ihe.net/ITI/TF/Volume3/index.html#4) requirements as specified for attributes [ITI TF-3: Table 4.3.1-3 “Sending Actor Metadata Attribute Optionality”](https://profiles.ihe.net/ITI/TF/Volume3/ch-4.3.html#4.3.1). The Document Source that supports the [Comprehensive Metadata](1332_actor_options.md#13322-xds-on-fhir-option) or the [XDS on FHIR](1332_actor_options.md#13322-xds-on-fhir-option) Options shall assure consistency with column “XDS DS”; otherwise, the Document Source shall assure consistency with column “XDR MS”. Except that the Document Source does not need to provide any entryUUID values, as the entryUUID will be populated by the Document Recipient when necessary.

###### 2:3.105.4.1.2.1 DocumentReference Resources

For complete information on constructing a FHIR [Simplified Publish DocumentReference](StructureDefinition-IHE.MHD.SimplifiedPublish.DocumentReference.md) Resource metadata requirements. Recommend to populate all elements possible.

When resources are `contained` , see [ITI TF-3: 4.5.1](32_fhir_maps.md), they shall be contained using the FHIR contained method (see [FHIR references.html#contained](http://hl7.org/fhir/R4/references.html#contained) ).

The Document Source shall populate accurate .hash and .size for the raw document content artifact, that has been base64encoded in the `DocumentReference.content.attachment.data` element.

The `DocumentReference.subject` value shall be populated with the identity of the Patient.

###### 2:3.105.4.1.2.2 Patient Identity

The DocumentReference.subject value shall be a Reference to a FHIR Patient Resource. The Patient Reference shall be a Patient Resource hosted on a commonly accessible server.

* A Patient Reference to a commonly accessible server may be obtained through use of [PDQm](https://profiles.ihe.net/ITI/TF/Volume1/ch-38.html), [PIXm](https://profiles.ihe.net/ITI/TF/Volume1/ch-41.html), [PMIR](https://profiles.ihe.net/ITI/TF/Volume1/ch-49.html), or by some other means.
* A commonly accessible logical reference using Patient Identifier, instead of a literal reference, may be acceptable where there is a common Identifier, such as a national individual identifier.

When the [UnContained Reference Option](1332_actor_options.md#13323-uncontained-reference-option) is used, there is no need to populate the sourcePatientInfo element. Otherwise, when sourcePatientInfo is provided, the DocumentReference.context.sourcePatientInfo shall be a reference to a “contained” Patient Resource. That is, the source patient info is encoded in a Patient Resource within the DocumentReference.contained element (see [FHIR references.html#contained](http://hl7.org/fhir/R4/references.html#contained) ).

###### 2:3.105.4.1.2.3 Replace, Transform, Signs, and Append Associations

The DocumentReference.relatesTo element indicates an association between DocumentReference resources. The relatesTo.target element in the provided DocumentReference points at the pre-existing DocumentReference that is being replaced, transformed, signed, or appended. The relatesTo.code element in the provided DocumentReference shall be the appropriate relationship type code defined in [FHIR valueset-document-relationship-type.html](http://hl7.org/fhir/R4/valueset-document-relationship-type.html). If a DocumentReference will be replaced, the to be replaced DocumentReference needs to be added and updated to status `superseded` within the transaction bundle.

##### 2:3.105.4.1.3 Expected Actions

The Document Recipient shall accept both media types `application/fhir+json` and `application/fhir+xml`.

On receipt of the Simplified Publish Request Message, the Document Recipient shall validate the DocumentReference resource provided, extract the document from the DocumentReference.content.attachment.data element, create a Binary and SubmissionSet derived off of the DocumentReference, and respond with one of the HTTP codes defined in the response [Message Semantics](#23105412-message-semantics).

The Document Recipient should verify the FHIR resource elements for consistency with the Document Sharing metadata requirements as specified for attributes [ITI TF-3: Table 4.3.1-3: “Sending Actor Metadata Attribute Optionality”](https://profiles.ihe.net/ITI/TF/Volume3/ch-4.3.html#4.3.1).

* The Document Recipient that supports the [Comprehensive Metadata](1332_actor_options.md#13322-xds-on-fhir-option) or the [XDS on FHIR](1332_actor_options.md#13322-xds-on-fhir-option) Option should validate against column “XDS DS”;
* Otherwise the Document Recipient should validate against column “XDR MS”.

The Document Recipient shall extract the document, translate the DocumentReference metadata elements into a SubmissionSet following the [PCC TF-2: 4.1 Medical Document Binding to Document Sharing Metadata](https://profiles.ihe.net/ITI/sIPS/pcc.html#41-medical-document-binding-to-document-sharing-metadata), and may have further metadata translation requirements specified by the local Document Sharing Community policy.

A Document Recipient is allowed to be robust for non-compliant resources that violate the Document Sharing metadata requirements.

If necessary for processing, the Document Recipient shall retrieve Resources referenced by absolute URLs in the FHIR DocumentReference Resource.

If the Document Recipient encounters any errors or if any validation fails, the Document Recipient shall return an error using a FHIR OperationOutcome. If appropriate, it shall use error codes from [ITI TF-3: Table 4.2.4.1-2](https://profiles.ihe.net/ITI/TF/Volume3/ch-4.2.html#4.2.4.1).

If the DocumentReference Resource is populated with a relatesTo element and the Document Recipient does not support the relatesTo.code value given, it shall return a warning message, as indicated in **Table 2:3.65.4.1.3-1: Warning message when relatesTo code is not supported**.

**Table 2:3.65.4.1.3-1: Warning message when relatesTo code is not supported**

| | |
| :--- | :--- |
| replaces | PartialReplaceContentNotProcessed |
| transforms | PartialTransformContentNotProcessed |
| appends | PartialAppendContentNotProcessed |

###### 2:3.105.4.1.3.1 Grouping with Actors in other Document Sharing Profiles

This section applies to grouping MHD Document Recipient with [XDS](https://profiles.ihe.net/ITI/TF/Volume1/ch-10.html) [Document Source](https://profiles.ihe.net/ITI/TF/Volume1/ch-10.html#10.1.1.1) Actor, [XDR](https://profiles.ihe.net/ITI/TF/Volume1/ch-15.html) Document Source Actor, [XDR](https://profiles.ihe.net/ITI/TF/Volume1/ch-15.html) Limited-Metadata Document Source Actor, and [XDM](https://profiles.ihe.net/ITI/TF/Volume1/ch-16.html) Portable Media Creator Actor (e.g., with the [XDM ZIP over Email Option](https://profiles.ihe.net/ITI/TF/Volume1/ch-16.html#16.2.3) ).

The Document Recipient shall transform the DocumentReference content into a proper message for the given grouped actor (e.g., the XDS Document Source using the Provide and Register Document Set-b [[ITI-41]](https://profiles.ihe.net/ITI/TF/Volume2/ITI-41.html) transaction). The Document Recipient shall create appropriate metadata from Resources in the FHIR DocumentReference Resource, including SubmissionSet, and DocumentEntry.

Where values provided are References to FHIR resources (e.g., DocumentReference.encounter), the Reference should be converted to a [Document Sharing`CXi`Identifier Datatype](https://profiles.ihe.net/ITI/TF/Volume3/ch-4.2.html#4.2.3.1.7) for recording in the Document Sharing ebRIM using the Identifier Type Codes when appropriate (see [Appendix Z.9.1.2](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.9.1.2-xds-cxi-mapped-to-fhir-identifier-type) ). The conversion may be by using the referenced Resource business .identifier. Note, there is not an obvious conversion of a reference .id to `CXi` identifier. Note that DocumentReference.encounter would be mapped into DocumentEntry.referenceIdList as an Identifier Type Code of `urn:ihe:iti:xds:2015:encounterId`.

If the Provide Document Bundle Message contains a DocumentReference with a relatesTo element, the code shall be translated using the [AssociationType vs RelatesTo ConceptMap](ConceptMap-AssociationTypeVsRelatesTo.md).

Some FHIR elements do not translate to XDS concepts; the handling of these elements is left to the implementer of the Document Recipient.

Upon successful conversion of the FHIR DocumentReference to XDS Document Sharing metadata, the grouped source actor shall execute the appropriate transaction. The transaction result, and any error or warning messages, shall be reported to the MHD Document Source. The Document Recipient is responsible for translating the response to the appropriate HTTP Status Code and FHIR OperationOutcome Resource in the Simplified Publish Response Message.

#### 2:3.105.4.2 Simplified Publish Response Message

The Document Recipient returns a HTTP Status code appropriate to the processing outcome, conforming to the create transaction specification requirements as specified in [FHIR http.html#create](http://hl7.org/fhir/R4/http.html#create).

##### 2:3.105.4.2.1 Trigger Events

This message shall be sent when a success or error condition needs to be communicated. Success is only indicated once the document is received and completely processed and persisted as appropriate to the Document Recipient Actor configuration.

##### 2:3.105.4.2.2 Message Semantics

To enable the Document Source to know the outcome of processing the transaction, and the identities assigned to the resources by the Document Recipient, the Document Recipient shall return the DocumentReference as created. The Document Recipient shall comply with FHIR [FHIR http.html#ops](http://hl7.org/fhir/R4/http.html#ops).

##### 2:3.105.4.2.3 Expected Actions

The Document Source processes the results according to application-defined rules.

#### 2:3.105.4.3 CapabilityStatement Resource

Document Recipient shall provide a CapabilityStatement Resource as described in [ITI TF-2x: Appendix Z.3](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.3-capabilitystatement-resource) indicating the transaction has been implemented.

* Requirements CapabilityStatement for [Document Recipient Simplified Publish Option](CapabilityStatement-IHE.MHD.DocumentRecipient.Simplified.md). This indicates that the Simplified Publish Option is declared.

Document Source should provide a CapabilityStatement Resource as described in [ITI TF-2x: Appendix Z.3](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.3-capabilitystatement-resource) indicating the transaction has been implemented.

* Requirements CapabilityStatement for [Document Source Simplified Publish Metadata Option](CapabilityStatement-IHE.MHD.DocumentSource.Simplified.md). This indicates that the Simplified Publish Option is declared.

### 2:3.105.5 Security Considerations

See [MHD Security Considerations](1335_security_considerations.md).

#### 2:3.105.5.1 Security Audit Considerations

The security audit criteria are similar to those for the Provide and Register Document Set-b [[ITI-41]](https://profiles.ihe.net/ITI/TF/Volume2/ITI-41.html) transaction as this transaction does export a document.

##### 2:3.105.5.1.1 Document Source Audit

The Document Source when grouped with ATNA Secure Node or Secure Application Actor shall be able to record a [Simplified Publish Audit Event Log](StructureDefinition-IHE.MHD.SimplifiedPublish.Audit.Source.md). [Audit Example for a Simplified Publish Bundle Transaction from source perspective](AuditEvent-ex-auditSimplifiedPublish-source.md).

##### 2:3.105.5.1.2 Document Recipient Audit

The Document Recipient when grouped with ATNA Secure Node or Secure Application Actor shall be able to record a [Simplified Publish Audit Event Log](StructureDefinition-IHE.MHD.SimplifiedPublish.Audit.Recipient.md). [Audit Example for a Simplified Publish Bundle Transaction from recipient perspective](AuditEvent-ex-auditSimplifiedPublish-recipient.md).

