# The homeCommunityId where this artifact lives - Mobile access to Health Documents (MHD) v4.2.4-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **The homeCommunityId where this artifact lives**

## Extension: The homeCommunityId where this artifact lives 

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-HomeCommunityId | *Version*:4.2.4-current |
| Active as of 2025-11-06 | *Computable Name*:HomeCommunityId |

The globally unique, immutable, identifier of the homeCommunityId entity where this artifact exists. The format of the identifier is an OID.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [MHD common List with designationType](StructureDefinition-IHE.MHD.List.md) and [MHD DocumentReference Minimal](StructureDefinition-IHE.MHD.Minimal.DocumentReference.md)
* Examples for this Extension: [Bundle/ex-findDocumentReferencesResponse](Bundle-ex-findDocumentReferencesResponse.md)
* Search Parameters using this Extension: [HomeCommunityId](SearchParameter-IHE-HomeCommunityIds.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ihe.iti.mhd|current/StructureDefinition/ihe-HomeCommunityId)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ihe-HomeCommunityId.csv), [Excel](StructureDefinition-ihe-HomeCommunityId.xlsx), [Schematron](StructureDefinition-ihe-HomeCommunityId.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ihe-HomeCommunityId",
  "url" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-HomeCommunityId",
  "version" : "4.2.4-current",
  "name" : "HomeCommunityId",
  "title" : "The homeCommunityId where this artifact lives",
  "status" : "active",
  "date" : "2025-11-06T17:57:38+00:00",
  "publisher" : "IHE IT Infrastructure Technical Committee",
  "contact" : [
    {
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ihe.net/ihe_domains/it_infrastructure/"
        }
      ]
    },
    {
      "telecom" : [
        {
          "system" : "email",
          "value" : "iti@ihe.net"
        }
      ]
    },
    {
      "name" : "IHE IT Infrastructure Technical Committee",
      "telecom" : [
        {
          "system" : "email",
          "value" : "iti@ihe.net"
        }
      ]
    }
  ],
  "description" : "The globally unique, immutable, identifier of the homeCommunityId entity where this artifact exists. The format of the identifier is an OID.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001",
          "display" : "World"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "DocumentReference"
    },
    {
      "type" : "element",
      "expression" : "List"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "The homeCommunityId where this artifact lives",
        "definition" : "The globally unique, immutable, identifier of the homeCommunityId entity where this artifact exists. The format of the identifier is an OID."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-HomeCommunityId"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Extension.value[x].system",
        "path" : "Extension.value[x].system",
        "patternUri" : "urn:ietf:rfc:3986"
      },
      {
        "id" : "Extension.value[x].value",
        "path" : "Extension.value[x].value",
        "constraint" : [
          {
            "key" : "mhd-startswithoid",
            "severity" : "error",
            "human" : "value must start with urn:oid:",
            "expression" : "startsWith('urn:oid:')",
            "source" : "https://profiles.ihe.net/ITI/MHD/StructureDefinition/ihe-HomeCommunityId"
          }
        ]
      }
    ]
  }
}

```
