# ihe.iti.deid#0.0.1-current: De-Identification Profile

## Pages

* [De-Identification Handbook Home](index.md)
* [Techniques](algorithms.md)
* [Process](process.md)
* [References](references.md)
* [Security Considerations](security.md)
* [FHIR Example](fhir-example.md)
* [Introduction](intro.md)
* [IHE Use](ihe-use.md)
* [IPS EHDS2](ips-ehds-example.md)
* [Significant Changes and Issues](issues.md)
* [HL7 v2 Example](hl7-example.md)
* [DICOM Example](dicom-example.md)
* [Family Planning Example](family-planning.md)
* [Data Types](data-types.md)
* [Artifacts Summary](artifacts.md)
* [Concepts](concepts.md)
* [Download and Analysis](download.md)

## Resources

### CodeSystems

* [Entity Type for De-Identification](CodeSystem-DeIdentificationEntityType.md)

### ValueSets

* [Entity Type for De-Identification valueset](ValueSet-DeIdentificationEntityTypeVS.md)
* [Audit Event Subtype for De-Identification](ValueSet-IHE.BasicAudit.DeIdentification.Subtype.md)

### Resource Profiles

* [Audit Event for De-Identification at Source](StructureDefinition-IHE.BasicAudit.DeIdentification.Source.md)

### CapabilityStatements

* [IHE DeId Audit Creator](CapabilityStatement-IHE.DeId.AuditCreator.md)

### ImplementationGuides

* [De-Identification Profile](index.md)

### Examples

* [ex-auditDeIdentification-source (AuditEvent)](AuditEvent-ex-auditDeIdentification-source.md)
* [ex-auditReIdentification-source (AuditEvent)](AuditEvent-ex-auditReIdentification-source.md)
* [6603561c-2888-4355-9df4-23675f6eb458 (Bundle)](Bundle-6603561c-2888-4355-9df4-23675f6eb458.md)
* [80c516fd-9c84-4924-875b-bf0048979ae1 (Bundle)](Bundle-80c516fd-9c84-4924-875b-bf0048979ae1.md)
* [e817cefe-a7c4-487a-8116-be23cf865f3f (Bundle)](Bundle-e817cefe-a7c4-487a-8116-be23cf865f3f.md)
* [39c9964c-96b7-442d-afc1-2702106a9e57 (Patient)](Patient-39c9964c-96b7-442d-afc1-2702106a9e57.md)
* [6274d469-7a4d-4a66-a261-e5e7b71af267 (Patient)](Patient-6274d469-7a4d-4a66-a261-e5e7b71af267.md)
* [d174bd1a-b368-41e6-83a2-af77f2b3c60f (Patient)](Patient-d174bd1a-b368-41e6-83a2-af77f2b3c60f.md)
