# IPS EHDS2 - De-Identification Profile v0.0.1-current

* [**Table of Contents**](toc.md)
* **IPS EHDS2**

## IPS EHDS2

### Purpose and Overview

This exemplar demonstrates how the IHE De-Identification Handbook’s process framework is applied a fictitious epidemiologic example that conforms to the secondary use requirements defined by the EHDS2. This example leverages the International Patient Summary (IPS) and the Vital Records Death Reporting (VRDR) profiles for conveying study data content for this secondary-use scenario. It serves as a concise de-identification example: defining purpose, recipients, multi-stage process, risk thresholds, and element-by-element treatment to preserve research utility while protecting privacy. See the methodology overview in [Process](process.md).

### Context Analysis

#### Purpose of collecting data

The permitted purpose for this example is Public Interest research in Public/Occupational Health to study co-morbidities, mortality, occupational risks, and treatment effects. The dataset must be minimized and de-identified to preserve utility (longitudinal trends, outcomes, medication impacts) while controlling re-identification risk per permit conditions.

The region is under threat of outbreak for a novel virus causing influenza-like-symptoms. An approved public health monitoring program wishes to review primary health information from across multiple jurisdictions for impacts of co-morbidities, mortality rates, and occupational health risks. The study also intends to review the population health impact for medication treatments, including vaccination. The purpose of the research request reflects a permitted purpose of use, Public Interest in the area of Public, Occupational Health. Data for this study represents categories from Healthcare, Medicinal products, Areas of Public Health, Areas of Occupational Health, and possibly Serious cross-border threats.

##### Permitted Uses

The Health Information Exchange system has defined the following standard permitted uses (Art 53 a-c). The standard healthcare purposes of use specified by ISO TC215 14265: Health Informatics - Classification of purposes for processing personal health information concepts associated with these EHDS2 defined purposes are provided in italicized subbullets:

* Improving the delivery of care, Treatment, Optimization and providing healthcare 
* **Treatment** 
* **Clinical Care Provision to an Individual Subject of Care**
* **Emergency Care Provision to an Individual Subject of Care**
* **Support of Care Activities within the Provider Organization for an Individual Subject of Care**
* **Subject of Care Uses**
 
* **Operations**
* **Health Service Management and Quality Assurance**
 
* Public Interest in the area of Public, Occupational Health and Policy Making and Regulatory Activities, Statistics, national, multinational, and Union level official statistics 
* **Public Health** 
* **Public Health Surveillance, Disease Control**
* **Population Health Management**
* **Public Safety Emergency**
 
 
* Scientific Research contributing to public health or health technology assessment with the aim of benefitting the end users 
* **Research**
 
* Vocational and Higher Education Teaching Activities 
* **Education**
 

##### Uses NOT Permitted

The Health Information Exchange system has define the following standard are not permitted uses:

* carrying out advertising or marketing activities; 
* **Market Studies**
 

No corresponding purpose of use is defined by EHDS2 as either permitted or not permitted, so the assumption is the following ISO-defined standard classifications of use purposes are not permitted uses:

* **Legal Procedure**
* **Enabling the payment of care provision to an individual subject of care**

Additional regulation purposes from Article 54 not permitted:

* Taking decisions detrimental to a natural person or a group of natural persons based on their electronic health data; in order to qualify as 'decisions' for the purposes of this point, they have to produce legal, social or economic eUects or similarly significantly aUect those natural persons;
* developing products or services that may harm individuals, public health or society at large, such as illicit drugs, alcoholic beverages, tobacco and nicotine products, weaponry or products or services which are designed or modified in such a way that they create addiction, contravene public order or cause a risk for human health;
* carrying out activities in conflict with ethical provisions laid down in national law.

#### Data recipients

* Researchers granted a Data Permit under HDAB oversight
* HDAB staff and Intermediation entity performing de-identification and release
* Authorized analytics environments (controlled access; data use agreements)

#### Data flow

This data flow implements the methodology’s end-to-end analysis described in [Process → Analyze the context → Data flow](process.md). It maps: source clinical systems → HDAB Intermediation (Stage 2) → controlled recipients, and highlights multi-stage requirements, environments, and constraints.

##### end-to-end data flow

* Before the de-identification processing, EHDS 2 regulations specify that the Health Data User conducts data discovery to identify data that is available for the study, and that an application for a data permit be submitted and approved. The Data Discovery leveraging the HealthDCAT Application Profile (HealthDCAT-AP), a specification developed by the European Commission DG SANTE to fulfill the requirements of Article 77 of Regulation (EU) 2025/327 [[OJ L, 2025/327, 5.3.2025](https://healthdataeu.pages.code.europa.eu/healthdcat-ap/releases/release-5/#bib-oj%20l,%202025/327,%205.3.2025)] establishing the European Health Data Space (EHDS). This determines that the information is available within the HDAB Information Resources, indicating data is available in a standard International Patient Summary (IPS), and mortality data in the Vital Records Death Reporting (IHE VRDR) standard formats as indicated in the conformsTo attribute (see https://healthdataeu.pages.code.europa.eu/healthdcat-ap/releases/release-5/).
* The user submits a Data Access Permit application (drawn from example at: https://data-access.dsa.ec.europa.eu/public/hta/data-access), and requests data access authorization providing [in the Research project-specific information](https://healthdataeu.pages.code.europa.eu/healthdcat-ap/releases/release-5/) section: 
* Information on the type and format of the data requested, indicates International Patient Summary format for the data, indicating the specific [attributes from that standard content needed for the study and applicable](https://data-access.dsa.ec.europa.eu/public/hta/data-access) de-identification methods should be used to preserve sufficient information to fulfill the study.
* The researcher also provides a date range of access needed for a 3-year period.
 
* access justifications are provided indicating the value of the proposed research
* The purpose of use is indicated as Scientific Research
* Data elements requested that are sensitive include de-identification methods to be used that will retain sufficient information for the research study.

The following diagram from the EHDS2 M7.2 Draft guideline on data minimisation, pseudonymisation, anonymisation and synthetic data depicts the EHDS user journey for the full process, highlighting the areas within the process that address data minimization, pseudonymization and anonymization:

**Figure: EHDS User Journey**
Once a Data Permit is granted, the third phase, Data Preparation, begins. The HDAB prepares the data set according to the permit content and de-identification to be applied. The EHDS2 M7.2 Draft guideline on data minimisation, pseudonymisation, anonymisation and synthetic data depicts a High-level architecture for safe disclosure of anonymized data, processing results, and synthetic data:

**Figure: HDAB High-level Architecture for Safe Disclosure**
##### Data Source

* Clinical sources: IPS-conformant EHR exports (FHIR R4) from provider organizations across jurisdictions; scoped to Patient demographics, Problems, Procedures, Medications, Allergies, Results, Immunizations, and relevant social/pregnancy history needed for the public/occupational health purpose.
* Vital records: VRDR mortality data from civil registries, limited to attributes necessary for surveillance (e.g., death date, cause categories, age bands, residence generalization).
* Agreements: Source data use agreements and HDAB permit terms define allowable elements, pre-release minimization, and any source-side pseudonymization.

##### Data Environments

* Landing zone: Secure HDAB intake environment receiving permitted data from sources; access is restricted and audited.
* Processing zone: HDAB Intermediation environment applying approved minimization, generalization, pseudonymization/anonymization, and outlier suppression according to the permit and risk model.
* Analysis zone: Authorized recipient environments (controlled access or enclave) where researchers analyze de-identified data under data use agreements; outbound sharing is prohibited.
* Transfer controls: Encrypted transport, authenticated endpoints, and governance monitoring across zones to manage context risk.

##### Multi-stage Requirements

* Stage 1 (at sources or by HDAB with source access): Basic minimization and, where applicable, reversible pseudonymization to safely transfer data to HDAB; direct identifiers removed or replaced per source/HDAB capability.
* Stage 2 (HDAB Intermediation): Advanced de-identification (irreversible pseudonymization, date shifting, generalization, suppression) with quantitative/qualitative risk assessment to meet the defined threshold.
* Stage 3 (recipients): Verification that received datasets meet permit-specified privacy level; usage confined to approved analyses in controlled environments with no re-identification attempts.

##### Regulatory Constraints

* The HDAB data access application management process is primarily set out in Articles 67–69 of the EHDS regulation, which define the procedural context that any organisational or technical solution for secondary use data applications must align with. Articles 67 and 69 includes the requirements for the common application forms for data access applications and data requests, respectively, to be used by applicants, and which provides the essential information for the processing of applications. Article 68 governs the issuance of data permits and the associated obligations of HDABs, whereas Article 69 provides similar provisions for data requests.
* The secondary use of electronic health data is based on pseudonymised or anonymised data, in order to preclude the identification of the data subjects (Recital 53 in the EHDS regulation)
* Data anonymisation, pseudonymisation, and linkage techniques are addressed in M7.2 Technical specification for Health Data Access Bodies on data minimisation and de-identification, and M7.5 Guideline for Health Data Access Bodies on linkage of health datasets.

### Data assessment

#### Data content

The Dataset is primarily structured clinical data from IPS (FHIR R4) and mortality attributes from VRDR (FHIR R4). It is longitudinal (multiple records per subject across time), minimizes free text (procedure descriptions removed), excludes imaging, and contains no binary device logs. Semi-structured risks (filenames, metadata) are minimized by standardized export and HDAB processing.

Policy for secondary use includes data minimisation for the use of secondary health data. This includes limiting the amount, type, and granularity of data during data preparation. The application for data access includes a request for the following data and de-identification methods:

##### Patient

* Pseudonymized name
* Patient location is important to the study. Address locations generalized to the initial 3-digits of the postal code for data minimization
* Administrative gender is an important metric in the study and will be included
* Date of birth will be used to determine and convey a generalized agegroup. The Date of birth, if included, will be Synthetic Data applied by date shifting within age-group breakdown
* Preferred language will be omitted for data-minimization
* Patient identifier sent as a pseudonymized identifier that is applied to the same patient over time
* Insurance information will be omitted for data-minimization
* Given the potential for identifying health risks to come subjects of care, the data is to be reversibly pseudonymized to support tracking of patient care related to the event across health care facilities and settings.

##### Problems

* Problems will be key to determining primary conditions, symptoms, co-morbidities, and clinical outcomes.
* Conditions will be reviewed for potential identifiable outliers for suppression.
* Procedures
* Medications 
* Medications are needed to identify treatment and contraindication impact
 
* Dates associated with medications are relative to incident and treatment dates. Data is collected but protected by data-shifting the study records
* Other attributes associated with Allergies and intolerances are removed for data-minimization
* Allergies and intolerances will support clinical outcome measures 
* Allergy Agent
* Onset date is needed relative to incident and treatment dates. Data is collected but protected by data-shifting the study records
* Reaction
* Other attributes associated with Allergies and intolerances are removed for data-minimization
 

###### Results

* Observation resulted is needed to inform the detection of infectious agents and clinical metrics
* Observation value is needed for metrics
* Observation date is needed relative to incident and treatment dates. Data is collected but protected by data-shifting the study records
* Other attributes associated with Results are removed for data minimization

###### Immunizations

* Vaccine for type of disease is needed to assess treatments and measure mitigation results
* Date of immunization is needed relative to incident and treatment dates. Data is collected but protected by data-shifting the study records
* Other attributes associated with Immunizations are removed for data minimization
* Medical Devices are not needed for the study 
* This section may be empty with a data absent reason of 'masked'
 
* Social History lifestyle factor information is needed to measure potential environmental impact including 
* Occupation either usual occupation or current occupation is needed to identify incidents and to help identify risk factors associated with identified occupations
* Industry either usual industry or current industry is needed to identify incidents and to help identify risk factors associated with identified occupations
 
* Occupation and Industry will be reviewed for outliers and suppressed
* All other attributes associated with Social History are removed for data minimization
* Pregnancy History 
* Pregnancy status pregnancy information is needed for the study to review potential impact of the incident on pregnancy
* Estimated Delivery date is needed relative to incident and treatment dates. Data is collected but protected by data-shifting the study records
* Other attributes associated with Pregnancy History are removed for data minimization
 
* Mortality data is available through vital records offices. The mortality data will include: 
* Pseudonymized name
* Pseudonymized identifier
* Date of death is needed relative to incident and treatment dates. Data is collected but protected by data-shifting the study records
* Cause of death
* All other mortality data is omitted for data-minimization
* Residence generalization aligned with the residence identified by the health record
 
* The application is reviewed and a Data Access permit is granted
* The Health Data Access Body (HDAB) uses an Intermediation entity for pseudonymizaton, and data preparation to prepare the data using approved anonymization, pseudonymization, generalization, suppression, and randomization methods according to the permit.
* A second pass removes potentially identifying outlier data from the dataset for privacy protection. While the identification of outliers is not required by the EHDS regulations, the HDAB performs this analysis to optimize privacy protection before releasing the data set.

##### Data subject

Population comprises patients across multiple jurisdictions potentially affected by an influenza-like outbreak, including general clinical populations, occupational cohorts, and pregnant individuals. Key characteristics: broad age range with age-group generalization; diverse geographies with postal code generalization; mixed gender distribution; inclusion of sensitive clinical conditions (Problems, Immunizations, Mortality) requiring controlled handling.

##### Data type

Distinct types include structured records (IPS sections: Patient, Problems, Procedures, Medications, Allergies, Results, Immunizations, Social/Pregnancy History) and structured mortality data (VRDR). Auxiliary information that can hide identifiers (file names, directory paths, embedded metadata) is excluded or standardized in HDAB pipelines; provenance is retained separately for audit.

##### Data attribute type

* Direct Identifiers (DI): Patient Name, Telecom, Patient ID, Mortality Name/Identifier; removed or pseudonymized per table.
* Quasi-Identifiers (QI): Date of Birth, Deceased date, postal code, onset/observation dates, occupation/industry, pregnancy status, cause of death; generalized, date-shifted, or outlier-suppressed.
* Sensitive Attributes (SA): diagnoses, results values, medications; preserved with linkage protections to prevent singling out; free text minimized.
* Non-Identifiers (NI): many codes and categorical values (e.g., product code, agent categories) that do not identify individuals on their own; preserved when safe.

##### Dataset properties

* Age of data: within permit window (requested 3-year period); more recent data handled with conservative thresholds.
* Number of subjects: potentially large multi-jurisdictional cohort; supports k-anonymity.
* Volume: moderate to large; processed centrally by HDAB with offline terminology.
* Data quality: standardized IPS/VRDR coding; free text minimized to reduce identifier leakage; longitudinal consistency maintained via pseudonymization.

### Determine de-identification goals

#### General goals

* Prevent Identification: remove or transform DIs and reduce QI combinability.
* Control Risk: meet non-public average thresholds with outlier protections.
* Preserve Utility: maintain longitudinal and outcomes analyses for permitted research.

#### Determine specific goals

* Entities: patients (primary), providers/facilities (as needed to avoid indirect identification).
* All unspecified IPS data elements are removed for data minimization.
* Identifiability target: Irreversibly Pseudonymized Data (see [Concepts](concepts.md#Identifiability)).
* Risk threshold: Non-public average risk ≤ 0.075, with outlier protections (see [Process → Determine goals](process.md)).
* Rationale: controlled sharing via permits; medium attack possibility and impact; sensitive health data.
* Element-level specification (Data Elements)

Data Types: The IPS format requested contains primarily structured data with some attributes containing textual data content. There are no Medical imaging data, Bio-signal data, Genetic data, Textual data, or Multi-modal data. Available to this research study through the IPS structured format.

This implements the element-by-element de-identification design as defined in [Process](process.md). The `Identifier Type` (DI/QI/NI) classification and `Handling/Notes` capture the selected transformations for each data element available in the source IPS and VRDR standardized content.

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Patient | Patient Name | Structured | Direct Identifier | Reversibly pseudonymized (name) |
| Patient | ID | Structured | Direct Identifier | Reversibly pseudonymized (identifier) |
| Patient | Date of Birth | Structured | Quasi-identifier | Synthetic data via date shifting within age-group breakdown |
| Patient | Gender | Structured | Quasi-identifier | Included; important study metric |
| Patient | Telecom | Structured | Direct Identifier | Omitted for data minimization |
| Patient | Deceased indicator | Structured | Quasi-identifier | Included |
| Patient | Deceased date | Structured | Quasi-identifier | Synthetic data via date shifting relative to shifted date of birth |
| Patient | Patient address | Structured | Quasi-identifier | Generalize to first 3 digits of postal code |
| Patient | Preferred language | Structured | Quasi-identifier | Not requested; omitted for data minimization |
| Patient | General Practitioner | Structured | Quasi-identifier | Omitted for data minimization |
| Patient | Insurance | Structured | Quasi-identifier | Omitted for data minimization |
| Problems | Problem Type | Structured | Non-identifying | Unchanged |
| Problems | Diagnosis | Structured | Quasi-identifier | Reviewed for potential identifiable outliers for suppression |
| Problems | Severity | Structured | Non-identifying | Unchanged |
| Problems | Onset Date | Structured | Quasi-identifier | Subject to date shifting relative to shifted birth date |
| Problems | Problem Status | Structured | Non-identifying | Omitted for data minimization |
| Problems | Specialist Contact | Structured | Quasi-identifier | Omitted for data minimization |
| Procedures | Procedure code | Structured | Non-identifying | Unchanged |
| Procedures | Procedure description | Textual | Quasi-identifier | Omitted due to potential free-text privacy issues |
| Procedures | Body site | Structured | Non-identifying | Unchanged |
| Procedures | Procedure date | Structured | Quasi-identifier | Subject to date shifting relative to shifted birth date |
| Medication Summary | Product code | Structured | Non-identifying | Unchanged |
| Medication Summary | Product common name and strength | Textual | Non-identifying | Unchanged if known; coded product code not required |
| Medication Summary | Active ingredient substance code | Structured | Non-identifying | Unchanged |
| Medication Summary | Active ingredient strength | Structured | Non-identifying | Unchanged |
| Medication Summary | Period of medication use | Structured | Quasi-identifier | Subject to date shifting relative to shifted birth date |
| Medication Summary | Route of administration | Structured | Non-identifying | Not requested; omitted for data minimization |
| Medication Summary | Dose quantity | Structured | Non-identifying | Unchanged |
| Medication Summary | Dose frequency | Structured | Non-identifying | Unchanged |
| Allergies/Intolerances | Clinical status | Structured | Non-identifying | Unchanged |
| Allergies/Intolerances | Onset date | Structured | Quasi-identifier | Subject to date shifting relative to shifted birth date |
| Allergies/Intolerances | End date | Structured | Quasi-identifier | Subject to date shifting relative to shifted birth date |
| Allergies/Intolerances | Criticality | Structured | Non-identifying | Unchanged |
| Allergies/Intolerances | Certainty | Structured | Non-identifying | Unchanged |
| Allergies/Intolerances | Type of propensity | Structured | Non-identifying | Unchanged |
| Allergies/Intolerances | Diagnosis | Structured | Quasi-identifier | Omitted for data minimization (outlier risk) |
| Allergies/Intolerances | Reaction manifestation | Structured | Non-identifying | Unchanged |
| Allergies/Intolerances | Reaction severity | Structured | Non-identifying | Unchanged |
| Allergies/Intolerances | Agent code | Structured | Non-identifying | Unchanged |
| Allergies/Intolerances | Agent category | Structured | Non-identifying | Unchanged |
| Results | Date of observation | Structured | Quasi-identifier | Subject to date shifting relative to shifted birth date |
| Results | Observation type | Structured | Non-identifying | Unchanged |
| Results | Result description | Textual | Non-identifying | Not requested; omitted for data minimization |
| Results | Result value | Structured | Non-identifying | Unchanged |
| Results | Observation result | Structured | Non-identifying | Unchanged |
| Results | Performer | Structured | Non-identifying | Omitted for data minimization |
| Results | Observer | Structured | Non-identifying | Omitted for data minimization |
| Immunizations | Vaccine (type of disease) | Structured | Non-identifying | Unchanged |
| Immunizations | Date of immunization | Structured | Quasi-identifier | Subject to date shifting relative to shifted birth date |
| Immunizations | Number in series of doses | Structured | Non-identifying | Unchanged |
| Immunizations | Target disease | Structured | Non-identifying | Omitted for data minimization |
| Immunizations | Product name | Textual | Non-identifying | Omitted for data minimization |
| Immunizations | Product administration | Structured | Non-identifying | Omitted for data minimization |
| Immunizations | Performer | Structured | Non-identifying | Omitted for data minimization |
| Immunizations | Route of administration | Structured | Non-identifying | Omitted for data minimization |
| Social History | Occupation | Structured | Quasi-identifier | Subject to date shifting relative to shifted birth date; review for identifiable outliers |
| Social History | Industry | Structured | Quasi-identifier | Subject to date shifting relative to shifted birth date; review for identifiable outliers |
| Pregnancy History | Pregnancy status | Structured | Non-identifying | Unchanged |
| Pregnancy History | Estimated delivery date | Structured | Quasi-identifier | Subject to date shifting relative to shifted birth date |
| Medical Devices | Device data required | Structured | Non-identifying | Not needed for the study; data absent reason marked as 'masked' |
| Mortality | Name | Structured | Direct Identifier | Reversibly pseudonymized (name) |
| Mortality | Identifier | Structured | Direct Identifier | Reversibly pseudonymized (identifier) |
| Mortality | Date of death | Structured | Quasi-identifier | Synthetic data via date shifting within age-group breakdown |
| Mortality | Cause of death | Structured | Quasi-identifier | Reviewed for potential identifiable outliers for suppression |

### Assess re-identification risk

#### qualitative evaluation

Direct identifiers (DI) in IPS/VRDR are removed or pseudonymized prior to release:

* Patient: `Patient.name`, `Patient.telecom`, and local `Patient.identifier` are pseudonymized (reversible at source if operationally required; irreversible within HDAB Intermediation for release). `Patient.address` is not de-identified in Stage 1, and is generalized (e.g., to 3-digit postal code) in Stage 2.
* Mortality: `VRDR.name` and `VRDR.identifier` are pseudonymized; `VRDR.dateOfDeath` is date-shifted within age-band policy. Decedent address (`Patient.address` in the VRDR document) is generalized in Stage 2.
* Performer/Provider references and free-text fields (e.g., `Procedure.description`, `Observation.note`) are omitted to avoid latent identifiers.

Quasi-identifiers (QI) intentionally retained for utility include: age group (derived from `Patient.birthDate`), 3-digit postal code (from `Patient.address`), `Patient.gender`, occupation and industry (Social History), clinically relevant event dates (onset, procedure, immunization, observation) after controlled date shifting, pregnancy status, and cause-of-death categories. Sensitive attributes (SA) such as diagnoses, result values, medications are preserved but protected by linkage controls and outlier suppression.

Given remaining QIs, qualitative classification alone is insufficient. After transformations, the target qualitative state is Irreversibly Pseudonymized Data suitable for non-public controlled sharing, pending quantitative risk confirmation.

#### quantitative evaluation

Apply k-anonymity to the structured IPS/VRDR release using project-specific QIs:

* AgeBand (derived from `Patient.birthDate` → age groups)
* Postal3 (first 3 digits from `Patient.address.postalCode`)
* Gender (`Patient.gender`)
* OccupationCategory, IndustryCategory (from Social History)
* EventDateBuckets (month-level buckets for shifted dates: `Condition.onsetDateTime`, `Procedure.performed[x]`, `Immunization.occurrence[x]`, `Observation.effective[x]`)

Compute equivalence classes on the tuple (AgeBand, Postal3, Gender, OccupationCategory, IndustryCategory, EventDateBuckets). For VRDR, use (AgeBand, Postal3, Gender, DeathMonthBucket, CauseCategory) with cause-of-death aggregated to broad categories to avoid singling out.

Compare overall risk to threshold: enforce average risk ≤ 0.075 while controlling outliers by generalizing buckets (e.g., widen age bands, aggregate occupations/industries, coarsen date buckets) or suppressing small classes. As an additional safeguard, cap maximum risk by ensuring minimum class size (e.g., f ≥ 20) for released groups to keep θ ≤ 0.05 where required for sensitive subsets.

For aggregate publication, apply Differential Privacy to counts/rates using a strict ε consistent with context risk; document privacy budgets and composition across queries.

##### Calculating data risk

Use per-record risk θᵢ = 1/fᵢ with class size fᵢ; compute maximum risk R_{d,b} and average risk R_{d,c} across classes; select R_{d,c} for non-public sharing and control high-risk outliers.

##### Calculating context risk

Estimate R_c = max(T1 deliberate, T2 inadvertent, T3 breach) per [Process](process.md). For permit-based controlled sharing, R_c < 1 due to contractual and technical controls; document the rationale and safeguards.

##### Calculating overall risk

Compute R = R_d × R_c for k-anonymity-based releases and confirm R meets the threshold; for DP aggregates, select ε aligned to context risk and enforce privacy budgets consistently.

### Attack modeling

##### Select data sharing model

Controlled Public Sharing (Data Use Agreement) governed by HDAB permits; enclave access may be used for higher sensitivity analyses.

##### Determine attack type

Anticipate identity, membership, and attribute attacks with background knowledge; mitigate via generalization, date shifting, and outlier suppression.

##### Identify data privacy model

Primary: k-anonymity for structured IPS releases; Optional: Differential Privacy for published aggregate statistics.

### Multi-stage De-identification Design

* Stage 1 (Preliminary, source/early pipeline): remove obvious direct identifiers; apply reversible pseudonyms where operationally required; prepare generalization plans (e.g., 3-digit postal code).


  Stage 1 Element-level de-identification rules
* Stage 2 (Advanced, HDAB Intermediation): irreversible pseudonymization; date shifting relative to birth/incident; generalization/suppression of quasi-identifiers; outlier review; quantitative risk check (equivalence classes); ensure semantic validity.


  Stage 2 Element-level de-identification rules
* Stage 3 (Recipient Verification): recipient-side verification of risk level and constraints; use enclave or controlled environments when appropriate.

See [Process → Multi-stage design](process.md).

### Governance & Controls

* Access control: least privilege; roles for policy, execution, supervision.
* Secrets management: salts, random seeds, and mapping tables stored in secure vaults; limited access.
* Secure transfer + encryption: SFTP/HTTPS; AES-256 at rest; auditable provenance.
* Documentation: retain element-level specification, scripts/config, validation reports (see [Process → Governance](process.md)).

#### Process Identifiers

Batch IDs, transformation logs, and audit trails generated during de-identification are maintained and protected. Mapping tables and seeds are segregated with strict access controls.

### Outcome & Classification

Released dataset classification: Irreversibly Pseudonymized Data for non-public controlled sharing, meeting average risk ≤ 0.075 with safeguards. Residual risks are managed via suppression/generalization and contractual controls; utility confirmed for population metrics and longitudinal trends.

### FHIR Examples

#### FHIR IPS Example

##### IPS Data Element Mappings (FHIR)

The table maps IPS data elements to their FHIR paths and summarizes the applied de-identification method across stages (Stage 1 for direct identifiers; Stage 2 for quasi-identifiers and minimization). Where elements are removed, Data Absent Reason (`masked`) is used per FHIR guidance.

| | | | |
| :--- | :--- | :--- | :--- |
| Patient | Patient Name | Patient.name | Stage 1: pseudonymize; retain pseudonym |
| Patient | ID | Patient.identifier | Stage 1: pseudonymize; retain pseudonym |
| Patient | Telecom | Patient.telecom.extension(data-absent-reason) | Stage 1: omit value + DAR masked |
| Patient | Date of Birth | Patient.birthDate | Stage 2: date shift (age-group policy) |
| Patient | Gender | Patient.gender | Included (QI) |
| Patient | Deceased indicator | Patient.deceasedBoolean | Included |
| Patient | Deceased date | Patient.deceasedDateTime | Stage 2: date shift |
| Patient | Address (postal code) | Patient.address[0].postalCode | Stage 2: generalize to 3-digit |
| Patient | Preferred language | Patient.communication.language | Omit (minimization) |
| Patient | General Practitioner | Patient.generalPractitioner.extension(data-absent-reason) | Stage 2: omit value + DAR masked |
| Patient | Insurance | Patient.extension(url='urn:example:insurance') | Omit (minimization) |
| Problems | Problem Type | Condition.category | Included |
| Problems | Diagnosis | Condition.code | Included; outlier review if needed |
| Problems | Severity | Condition.severity | Included |
| Problems | Onset Date | Condition.onsetDateTime | Stage 2: date shift |
| Problems | Problem Status | Condition.clinicalStatus.extension(data-absent-reason) | Stage 2: omit value + DAR masked |
| Problems | Specialist Contact | Condition.asserter.extension(data-absent-reason) | Stage 2: omit value + DAR masked |
| Problems | Verification Status | Condition.verificationStatus | Included |
| Procedures | Procedure code | Procedure.code.coding | Included |
| Procedures | Procedure description | Procedure.code._text.extension(data-absent-reason) | Stage 2: omit text + DAR masked |
| Procedures | Note | Procedure.note.extension(data-absent-reason) | Stage 2: omit value + DAR masked |
| Procedures | Body site | Procedure.bodySite | Included |
| Procedures | Procedure date | Procedure.performedDateTime | Stage 2: date shift |
| Medication Summary | Product code | MedicationStatement.contained(Medication).code | Included |
| Medication Summary | Common name & strength | Medication.code.text; Medication.ingredient.strength | Include when coded; omit free-text if risky |
| Medication Summary | Active ingredient code | Medication.ingredient.itemCodeableConcept | Included |
| Medication Summary | Period of use | MedicationStatement.effectivePeriod | Stage 2: date shift |
| Medication Summary | Route of administration | MedicationStatement.dosage.route.extension(data-absent-reason) | Stage 2: omit value + DAR masked |
| Medication Summary | Dose quantity | MedicationStatement.dosage.doseAndRate[0].doseQuantity | Included |
| Medication Summary | Dose frequency | MedicationStatement.dosage.timing | Included |
| Allergies | Clinical status | AllergyIntolerance.clinicalStatus | Included |
| Allergies | Onset date | AllergyIntolerance.onsetDateTime | Stage 2: date shift |
| Allergies | End date | AllergyIntolerance.lastOccurrence | Stage 2: date shift |
| Allergies | Criticality | AllergyIntolerance.criticality | Included |
| Allergies | Certainty | AllergyIntolerance.verificationStatus | Included |
| Allergies | Type of propensity | AllergyIntolerance.type | Included |
| Allergies | Diagnosis (extension) | AllergyIntolerance.extension(url='urn:example:allergy-diagnosis') | Omit (minimization; outlier risk) |
| Allergies | Reaction manifestation | AllergyIntolerance.reaction.manifestation | Included |
| Allergies | Reaction severity | AllergyIntolerance.reaction.severity | Included |
| Allergies | Agent code | AllergyIntolerance.code | Included |
| Allergies | Agent category | AllergyIntolerance.category | Included |
| Results | Date of observation | Observation.effectiveDateTime | Stage 2: date shift |
| Results | Observation type | Observation.code | Included |
| Results | Result value | Observation.valueQuantity | Included |
| Results | Result description | Observation.note.extension(data-absent-reason) | Stage 2: omit value + DAR masked |
| Results | Performer | Observation.performer.extension(data-absent-reason) | Stage 2: omit value + DAR masked |
| Results | Observer (extension) | Observation.extension(url='urn:example:observer') | Omit (minimization) |
| Immunizations | Vaccine (type of disease) | Immunization.vaccineCode | Included |
| Immunizations | Date of immunization | Immunization.occurrenceDateTime | Stage 2: date shift |
| Immunizations | Number in series | Immunization.protocolApplied.doseNumberPositiveInt | Included |
| Immunizations | Target disease | Immunization.protocolApplied.targetDisease.extension(data-absent-reason) | Stage 2: omit value + DAR masked |
| Immunizations | Product name | Immunization.vaccineCode.text | Omit (minimization) |
| Immunizations | Product administration | Immunization.doseQuantity/site/route.extension(data-absent-reason) | Stage 2: omit value(s) + DAR masked |
| Immunizations | Performer | Immunization.performer | Omit (minimization) |
| Social History | Occupation | Observation(valueString) where code=11341-5 | Include; review outliers; date-shift the observation date |
| Social History | Industry | Observation(valueString) where code=21843-6 | Include; review outliers; date-shift the observation date |
| Pregnancy | Pregnancy status | Observation(valueCodeableConcept) where code=82810-3 | Included |
| Pregnancy | Estimated delivery date | Observation(valueDateTime) where code=11778-8 | Stage 2: date shift |
| Medical Devices | Device data required | DeviceUseStatement.device.extension(data-absent-reason) | Stage 2: omit value + DAR masked |
| Medical Devices | Note | DeviceUseStatement.note | Included (non-identifying) |
| Mortality | Name | Observation.extension(url='urn:example:decedentName').valueHumanName | Stage 1/2: pseudonymize |
| Mortality | Identifier | Observation.identifier | Stage 1/2: pseudonymize |
| Mortality | Date of death | Observation.effectiveDateTime | Stage 2: date shift |
| Mortality | Cause of death | Observation.valueCodeableConcept | Included; outlier review |

##### Original Identified IPS Document Bundle Link example

Example view of the Origional IPS document for a pandemic patient [Secondary Use Pandemnic IPS Patient Original Identified IPS Document](ex-Bundle-secondaryUse-pandemnicIPS-example-patient-1-stage-0.md)

##### Original Identified IPS Document Bundle

```
{
  "resourceType": "Bundle",
  "type": "document",
  "timestamp": "2024-07-01T00:00:00Z",
  "entry": [
    {
      "fullUrl": "Composition/ips-comp-1",
      "resource": {
        "resourceType": "Composition",
        "id": "ips-comp-1",
        "meta": {"profile": ["http://hl7.org/fhir/uv/ips/StructureDefinition/Composition"]},
        "status": "final",
        "type": {"coding": [{"system": "http://loinc.org", "code": "60591-5", "display": "Patient summary Document"}]},
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "date": "2024-07-01T00:00:00Z",
        "author": [{"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}],
        "title": "International Patient Summary",
        "confidentiality": "N",
        "section": [
          {"title": "Problems", "entry": [{"reference": "Condition/cond-1"}]},
          {"title": "Procedures", "entry": [{"reference": "Procedure/proc-1"}]},
          {"title": "Medication Summary", "entry": [{"reference": "MedicationStatement/medstmt-1"}]},
          {"title": "Allergies and Intolerances", "entry": [{"reference": "AllergyIntolerance/allergy-1"}]},
          {"title": "Results", "entry": [{"reference": "Observation/obs-hb-1"}]},
          {"title": "Immunizations", "entry": [{"reference": "Immunization/imm-1"}]},
          {"title": "Social History", "entry": [{"reference": "Observation/obs-occ-1"}, {"reference": "Observation/obs-ind-1"}]},
          {"title": "Pregnancy History", "entry": [{"reference": "Observation/obs-prg-1"}, {"reference": "Observation/obs-edd-1"}]},
          {"title": "Medical Devices", "entry": [{"reference": "DeviceUseStatement/dus-1"}]},
          {"title": "Mortality", "entry": [{"reference": "Observation/obs-cod-1"}]}
        ]
      }
    },
    {
      "fullUrl": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f",
      "resource": {
        "resourceType": "Patient",
        "id": "d174bd1a-b368-41e6-83a2-af77f2b3c60f",
        "identifier": [{"system": "https://standards.digital.health.nz/ns/nhi-id", "value": "ABC1234"}],
        "name": [{"family": "JORDANA", "given": ["Patricia"]}],
        "telecom": [{"system": "phone", "use": "mobile", "value": "07 850 9900"}],
        "gender": "female",
        "birthDate": "1956-09-30",
        "deceasedBoolean": true,
        "deceasedDateTime": "2024-06-30",
        "address": [{"postalCode": "3210"}],
        "communication": [{"language": {"coding": [{"system": "urn:ietf:bcp:47", "code": "en-NZ"}]}}],
        "generalPractitioner": [{"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}],
        "extension": [{"url": "urn:example:insurance", "valueString": "NZ-ACC-PLAN"}]
      }
    },
    {
      "fullUrl": "Condition/cond-1",
      "resource": {
        "resourceType": "Condition",
        "id": "cond-1",
        "category": [{"coding": [{"system": "http://terminology.hl7.org/CodeSystem/condition-category", "code": "problem-list-item"}]}],
        "code": {"coding": [{"system": "http://snomed.info/sct", "code": "59621000", "display": "Essential hypertension"}]},
        "severity": {"coding": [{"system": "http://snomed.info/sct", "code": "255604002", "display": "Mild"}]},
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "onsetDateTime": "2016-05-25",
        "clinicalStatus": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/condition-clinical", "code": "active"}]},
        "verificationStatus": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/condition-ver-status", "code": "confirmed"}]},
        "asserter": {"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}
      }
    },
    {
      "fullUrl": "Procedure/proc-1",
      "resource": {
        "resourceType": "Procedure",
        "id": "proc-1",
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://snomed.info/sct", "code": "80146002", "display": "Appendectomy"}], "text": "Laparoscopic appendectomy"},
        "note": [{"text": "Laparoscopic appendectomy performed"}],
        "bodySite": [{"coding": [{"system": "http://snomed.info/sct", "code": "66754008", "display": "Appendix structure"}]}],
        "performedDateTime": "2018-03-10"
      }
    },
    {
      "fullUrl": "MedicationStatement/medstmt-1",
      "resource": {
        "resourceType": "MedicationStatement",
        "id": "medstmt-1",
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "contained": [{
          "resourceType": "Medication",
          "id": "med1",
          "code": {"coding": [{"system": "http://www.whocc.no/atc", "code": "J01CA", "display": "Penicillins"}], "text": "Amoxicillin 500 mg"},
          "ingredient": [{"itemCodeableConcept": {"coding": [{"system": "http://snomed.info/sct", "code": "372687004", "display": "Amoxicillin"}]}, "strength": {"numerator": {"value": 500, "unit": "mg"}, "denominator": {"value": 1, "unit": "tablet"}}}]
        }],
        "medicationReference": {"reference": "#med1"},
        "effectivePeriod": {"start": "2024-01-01", "end": "2024-02-01"},
        "dosage": [{
          "route": {"coding": [{"system": "http://snomed.info/sct", "code": "26643006", "display": "Oral route"}]},
          "doseAndRate": [{"doseQuantity": {"value": 500, "unit": "mg"}}],
          "timing": {"repeat": {"frequency": 3, "period": 1, "periodUnit": "d"}}
        }]
      }
    },
    {
      "fullUrl": "AllergyIntolerance/allergy-1",
      "resource": {
        "resourceType": "AllergyIntolerance",
        "id": "allergy-1",
        "patient": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "clinicalStatus": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "code": "active"}]},
        "verificationStatus": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "code": "confirmed"}]},
        "type": "allergy",
        "category": ["medication"],
        "code": {"coding": [{"system": "http://snomed.info/sct", "code": "764146007", "display": "Penicillin"}]},
        "extension": [{"url": "urn:example:allergy-diagnosis", "valueCodeableConcept": {"coding": [{"system": "http://snomed.info/sct", "code": "294954003", "display": "Allergy to penicillin"}]}}],
        "onsetDateTime": "2015-04-01",
        "lastOccurrence": "2015-05-01",
        "criticality": "high",
        "reaction": [{
          "manifestation": [{"coding": [{"system": "http://snomed.info/sct", "code": "271807003", "display": "Rash"}]}],
          "severity": "moderate"
        }]
      }
    },
    {
      "fullUrl": "Observation/obs-hb-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-hb-1",
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "718-7", "display": "Hemoglobin"}]},
        "effectiveDateTime": "2023-11-01",
        "valueQuantity": {"value": 13.2, "unit": "g/dL"},
        "interpretation": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation", "code": "N", "display": "Normal"}]},
        "note": [{"text": "Routine CBC"}],
        "performer": [{"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}],
        "extension": [{"url": "urn:example:observer", "valueReference": {"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}}]
      }
    },
    {
      "fullUrl": "Immunization/imm-1",
      "resource": {
        "resourceType": "Immunization",
        "id": "imm-1",
        "patient": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "vaccineCode": {"coding": [{"system": "http://snomed.info/sct", "code": "1119349007", "display": "COVID-19 vaccine"}], "text": "Comirnaty"},
        "occurrenceDateTime": "2024-05-01",
        "protocolApplied": [{"doseNumberPositiveInt": 2, "targetDisease": [{"coding": [{"system": "http://snomed.info/sct", "code": "840539006", "display": "COVID-19"}]}]}],
        "doseQuantity": {"value": 0.5, "unit": "mL"},
        "site": {"text": "Left deltoid region"},
        "route": {"coding": [{"system": "http://snomed.info/sct", "code": "34206005", "display": "Intramuscular route"}]},
        "performer": [{"actor": {"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}}]
      }
    },
    {
      "fullUrl": "Observation/obs-occ-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-occ-1",
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "11341-5", "display": "History of Occupation"}]},
        "valueString": "Nurse",
        "effectiveDateTime": "2020-01-15"
      }
    },
    {
      "fullUrl": "Observation/obs-ind-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-ind-1",
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "21843-6", "display": "Industry of employment"}]},
        "valueString": "Healthcare",
        "effectiveDateTime": "2020-01-15"
      }
    },
    {
      "fullUrl": "Observation/obs-prg-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-prg-1",
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "82810-3", "display": "Pregnancy status"}]},
        "valueCodeableConcept": {"coding": [{"system": "http://snomed.info/sct", "code": "77386006", "display": "Pregnant"}]}
      }
    },
    {
      "fullUrl": "Observation/obs-edd-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-edd-1",
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "11778-8", "display": "Estimated delivery date"}]},
        "valueDateTime": "2024-12-01"
      }
    },
    {
      "fullUrl": "DeviceUseStatement/dus-1",
      "resource": {
        "resourceType": "DeviceUseStatement",
        "id": "dus-1",
        "status": "completed",
        "device": {"reference": "Device/eumfh-70-275-2"},
        "note": [{"text": "Device data required"}],
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"}
      }
    },
    {
      "fullUrl": "Observation/obs-cod-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-cod-1",
        "identifier": [{"system": "urn:vrdr:id", "value": "VRDR-2024-0001"}],
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "81956-5", "display": "Cause of death"}]},
        "effectiveDateTime": "2024-06-30",
        "valueCodeableConcept": {"coding": [{"system": "http://snomed.info/sct", "code": "840539006", "display": "COVID-19"}]},
        "extension": [{"url": "urn:example:decedentName", "valueHumanName": {"family": "JORDANA", "given": ["Patricia"]}}]
      }
    }
  ]
}

```

##### Pseudonymized IPS Document Bundle (Stage 1)

Example view of the Pseudonymized Bundle document for the pandemic patient example [Secondary Use Pandemnic IPS Patient Pseudonymized IPS Document](ex-DeathCertificateDocument-Bundle-pandemnicIPS-example-patient-1-stage-1.md)

```
{
  "resourceType": "Bundle",
  "type": "document",
  "timestamp": "2024-07-01T00:00:00Z",
  "meta": {
    "security": [
      {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
    ]
  },
  "entry": [
    {
      "fullUrl": "Composition/ips-comp-1",
      "resource": {
        "resourceType": "Composition",
        "id": "ips-comp-1",
        "meta": {
          "profile": ["http://hl7.org/fhir/uv/ips/StructureDefinition/Composition"],
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "status": "final",
        "type": {"coding": [{"system": "http://loinc.org", "code": "60591-5", "display": "Patient summary Document"}]},
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "date": "2024-07-01T00:00:00Z",
        "author": [{"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}],
        "title": "International Patient Summary",
        "confidentiality": "N",
        "section": [
          {"title": "Problems", "entry": [{"reference": "Condition/cond-1"}]},
          {"title": "Procedures", "entry": [{"reference": "Procedure/proc-1"}]},
          {"title": "Medication Summary", "entry": [{"reference": "MedicationStatement/medstmt-1"}]},
          {"title": "Allergies and Intolerances", "entry": [{"reference": "AllergyIntolerance/allergy-1"}]},
          {"title": "Results", "entry": [{"reference": "Observation/obs-hb-1"}]},
          {"title": "Immunizations", "entry": [{"reference": "Immunization/imm-1"}]},
          {"title": "Social History", "entry": [{"reference": "Observation/obs-occ-1"}, {"reference": "Observation/obs-ind-1"}]},
          {"title": "Pregnancy History", "entry": [{"reference": "Observation/obs-prg-1"}, {"reference": "Observation/obs-edd-1"}]},
          {"title": "Medical Devices", "entry": [{"reference": "DeviceUseStatement/dus-1"}]},
          {"title": "Mortality", "entry": [{"reference": "Observation/obs-cod-1"}]}
        ]
      }
    },
    {
      "fullUrl": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f",
      "resource": {
        "resourceType": "Patient",
        "id": "d174bd1a-b368-41e6-83a2-af77f2b3c60f",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"},
            {"system": "http://ihe.net/CodeSystem/deid-handling", "code": "masked", "display": "Contains masked elements"}
          ]
        },
        "identifier": [{"system": "urn:example:psyn", "value": "PID-7ac6997e"}],
        "name": [{"family": "Psyn", "given": ["001"]}],
        "telecom": [{
          "extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]
        }],
        "gender": "female",
        "birthDate": "1956-09-30",
        "deceasedBoolean": true,
        "deceasedDateTime": "2024-06-30",
        "address": [{"postalCode": "3210"}],
        "communication": [{"language": {"coding": [{"system": "urn:ietf:bcp:47", "code": "en-NZ"}]}}],
        "generalPractitioner": [{"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}],
        "extension": [{"url": "urn:example:insurance", "valueString": "NZ-ACC-PLAN"}]
      }
    },
    {
      "fullUrl": "Condition/cond-1",
      "resource": {
        "resourceType": "Condition",
        "id": "cond-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "category": [{"coding": [{"system": "http://terminology.hl7.org/CodeSystem/condition-category", "code": "problem-list-item"}]}],
        "code": {"coding": [{"system": "http://snomed.info/sct", "code": "59621000", "display": "Essential hypertension"}]},
        "severity": {"coding": [{"system": "http://snomed.info/sct", "code": "255604002", "display": "Mild"}]},
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "onsetDateTime": "2016-05-25",
        "clinicalStatus": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/condition-clinical", "code": "active"}]},
        "verificationStatus": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/condition-ver-status", "code": "confirmed"}]},
        "asserter": {"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}
      }
    },
    {
      "fullUrl": "Procedure/proc-1",
      "resource": {
        "resourceType": "Procedure",
        "id": "proc-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://snomed.info/sct", "code": "80146002", "display": "Appendectomy"}], "text": "Laparoscopic appendectomy"},
        "note": [{"text": "Laparoscopic appendectomy performed"}],
        "bodySite": [{"coding": [{"system": "http://snomed.info/sct", "code": "66754008", "display": "Appendix structure"}]}],
        "performedDateTime": "2018-03-10"
      }
    },
    {
      "fullUrl": "MedicationStatement/medstmt-1",
      "resource": {
        "resourceType": "MedicationStatement",
        "id": "medstmt-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "contained": [{
          "resourceType": "Medication",
          "id": "med1",
          "code": {"coding": [{"system": "http://www.whocc.no/atc", "code": "J01CA", "display": "Penicillins"}], "text": "Amoxicillin 500 mg"},
          "ingredient": [{"itemCodeableConcept": {"coding": [{"system": "http://snomed.info/sct", "code": "372687004", "display": "Amoxicillin"}]}, "strength": {"numerator": {"value": 500, "unit": "mg"}, "denominator": {"value": 1, "unit": "tablet"}}}]
        }],
        "medicationReference": {"reference": "#med1"},
        "effectivePeriod": {"start": "2024-01-01", "end": "2024-02-01"},
        "dosage": [{
          "route": {"coding": [{"system": "http://snomed.info/sct", "code": "26643006", "display": "Oral route"}]},
          "doseAndRate": [{"doseQuantity": {"value": 500, "unit": "mg"}}],
          "timing": {"repeat": {"frequency": 3, "period": 1, "periodUnit": "d"}}
        }]
      }
    },
    {
      "fullUrl": "AllergyIntolerance/allergy-1",
      "resource": {
        "resourceType": "AllergyIntolerance",
        "id": "allergy-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "patient": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "clinicalStatus": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "code": "active"}]},
        "verificationStatus": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "code": "confirmed"}]},
        "type": "allergy",
        "category": ["medication"],
        "code": {"coding": [{"system": "http://snomed.info/sct", "code": "764146007", "display": "Penicillin"}]},
        "extension": [{"url": "urn:example:allergy-diagnosis", "valueCodeableConcept": {"coding": [{"system": "http://snomed.info/sct", "code": "294954003", "display": "Allergy to penicillin"}]}}],
        "onsetDateTime": "2015-04-01",
        "lastOccurrence": "2015-05-01",
        "criticality": "high",
        "reaction": [{
          "manifestation": [{"coding": [{"system": "http://snomed.info/sct", "code": "271807003", "display": "Rash"}]}],
          "severity": "moderate"
        }]
      }
    },
    {
      "fullUrl": "Observation/obs-hb-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-hb-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "718-7", "display": "Hemoglobin"}]},
        "effectiveDateTime": "2023-11-01",
        "valueQuantity": {"value": 13.2, "unit": "g/dL"},
        "interpretation": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation", "code": "N", "display": "Normal"}]},
        "note": [{"text": "Routine CBC"}],
        "performer": [{"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}],
        "extension": [{"url": "urn:example:observer", "valueReference": {"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}}]
      }
    },
    {
      "fullUrl": "Immunization/imm-1",
      "resource": {
        "resourceType": "Immunization",
        "id": "imm-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "patient": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "vaccineCode": {"coding": [{"system": "http://snomed.info/sct", "code": "1119349007", "display": "COVID-19 vaccine"}], "text": "Comirnaty"},
        "occurrenceDateTime": "2024-05-01",
        "protocolApplied": [{"doseNumberPositiveInt": 2, "targetDisease": [{"coding": [{"system": "http://snomed.info/sct", "code": "840539006", "display": "COVID-19"}]}]}],
        "doseQuantity": {"value": 0.5, "unit": "mL"},
        "site": {"text": "Left deltoid region"},
        "route": {"coding": [{"system": "http://snomed.info/sct", "code": "34206005", "display": "Intramuscular route"}]},
        "performer": [{"actor": {"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}}]
      }
    },
    {
      "fullUrl": "Observation/obs-occ-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-occ-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "11341-5", "display": "History of Occupation"}]},
        "valueString": "Nurse",
        "effectiveDateTime": "2020-01-15"
      }
    },
    {
      "fullUrl": "Observation/obs-ind-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-ind-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "21843-6", "display": "Industry of employment"}]},
        "valueString": "Healthcare",
        "effectiveDateTime": "2020-01-15"
      }
    },
    {
      "fullUrl": "Observation/obs-prg-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-prg-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "82810-3", "display": "Pregnancy status"}]},
        "valueCodeableConcept": {"coding": [{"system": "http://snomed.info/sct", "code": "77386006", "display": "Pregnant"}]}
      }
    },
    {
      "fullUrl": "Observation/obs-edd-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-edd-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "11778-8", "display": "Estimated delivery date"}]},
        "valueDateTime": "2024-12-01"
      }
    },
    {
      "fullUrl": "DeviceUseStatement/dus-1",
      "resource": {
        "resourceType": "DeviceUseStatement",
        "id": "dus-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "status": "completed",
        "device": {"reference": "Device/eumfh-70-275-2"},
        "note": [{"text": "Device data required"}],
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"}
      }
    },
    {
      "fullUrl": "Observation/obs-cod-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-cod-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage1-pseudonymized", "display": "Stage 1 pseudonymized"}
          ]
        },
        "identifier": [{"system": "urn:example:psyn", "value": "VRDR-PSYN-0001"}],
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "81956-5", "display": "Cause of death"}]},
        "effectiveDateTime": "2024-06-30",
        "valueCodeableConcept": {"coding": [{"system": "http://snomed.info/sct", "code": "840539006", "display": "COVID-19"}]},
        "extension": [{"url": "urn:example:decedentName", "valueHumanName": {"family": "Psyn", "given": ["001"]}}]
      }
    }
  ]
}

```

Notes:

* Only direct identifiers are processed in Stage 1 (name, identifier, telecom).
* Redaction: Patient.telecom value removed and marked with data absent reason = "masked".
* Pseudonymization: Patient and Mortality identifiers/names replaced with consistent pseudonyms.
* Security Labels: meta.security added to mark de-identification status.

##### Pseudonymized IPS Document Bundle (Stage 2)

Example view of the Stage 2 Pseudonymized IPS Bundle document for the pandemic patient example [Secondary Use Pandemnic IPS Patient Stage 2 Pseudonymized IPS Document](ex-Bundle-secondaryUse-pandemnicIPS-example-patient-1-stage-2.md)

```
{
  "resourceType": "Bundle",
  "type": "document",
  "timestamp": "2024-07-01T00:00:00Z",
  "meta": {
    "security": [
      {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
    ]
  },
  "entry": [
    {
      "fullUrl": "Composition/ips-comp-1",
      "resource": {
        "resourceType": "Composition",
        "id": "ips-comp-1",
        "meta": {
          "profile": ["http://hl7.org/fhir/uv/ips/StructureDefinition/Composition"],
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "status": "final",
        "type": {"coding": [{"system": "http://loinc.org", "code": "60591-5", "display": "Patient summary Document"}]},
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "date": "2024-07-01T00:00:00Z",
        "author": [{"reference": "Practitioner/816cf057-b736-4e08-baed-cc21e081b784"}],
        "title": "International Patient Summary",
        "confidentiality": "N",
        "section": [
          {"title": "Problems", "entry": [{"reference": "Condition/cond-1"}]},
          {"title": "Procedures", "entry": [{"reference": "Procedure/proc-1"}]},
          {"title": "Medication Summary", "entry": [{"reference": "MedicationStatement/medstmt-1"}]},
          {"title": "Allergies and Intolerances", "entry": [{"reference": "AllergyIntolerance/allergy-1"}]},
          {"title": "Results", "entry": [{"reference": "Observation/obs-hb-1"}]},
          {"title": "Immunizations", "entry": [{"reference": "Immunization/imm-1"}]},
          {"title": "Social History", "entry": [{"reference": "Observation/obs-occ-1"}, {"reference": "Observation/obs-ind-1"}]},
          {"title": "Pregnancy History", "entry": [{"reference": "Observation/obs-prg-1"}, {"reference": "Observation/obs-edd-1"}]},
          {"title": "Medical Devices", "entry": [{"reference": "DeviceUseStatement/dus-1"}]},
          {"title": "Mortality", "entry": [{"reference": "Observation/obs-cod-1"}]}
        ]
      }
    },
    {
      "fullUrl": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f",
      "resource": {
        "resourceType": "Patient",
        "id": "d174bd1a-b368-41e6-83a2-af77f2b3c60f",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"},
            {"system": "http://ihe.net/CodeSystem/deid-handling", "code": "masked", "display": "Contains masked elements"}
          ]
        },
        "identifier": [{"system": "urn:example:psyn2", "value": "PID-9f8b1ea1"}],
        "name": [{"family": "Psyn", "given": ["001"]}],
        "telecom": [{
          "extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]
        }],
        "gender": "female",
        "birthDate": "1956-10-15",
        "deceasedBoolean": true,
        "deceasedDateTime": "2024-07-15",
        "address": [{"postalCode": "321"}],
        
        "generalPractitioner": [{
          "extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]
        }]
      }
    },
    {
      "fullUrl": "Condition/cond-1",
      "resource": {
        "resourceType": "Condition",
        "id": "cond-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "category": [{"coding": [{"system": "http://terminology.hl7.org/CodeSystem/condition-category", "code": "problem-list-item"}]}],
        "code": {"coding": [{"system": "http://snomed.info/sct", "code": "59621000", "display": "Essential hypertension"}]},
        "severity": {"coding": [{"system": "http://snomed.info/sct", "code": "255604002", "display": "Mild"}]},
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "onsetDateTime": "2016-06-10",
        "clinicalStatus": {
          "extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]
        },
        "verificationStatus": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/condition-ver-status", "code": "confirmed"}]},
        "asserter": {
          "extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]
        }
      }
    },
    {
      "fullUrl": "Procedure/proc-1",
      "resource": {
        "resourceType": "Procedure",
        "id": "proc-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {
          "coding": [{"system": "http://snomed.info/sct", "code": "80146002", "display": "Appendectomy"}],
          "_text": {"extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]}
        },
        "note": [{"extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]}],
        "bodySite": [{"coding": [{"system": "http://snomed.info/sct", "code": "66754008", "display": "Appendix structure"}]}],
        "performedDateTime": "2018-03-25"
      }
    },
    {
      "fullUrl": "MedicationStatement/medstmt-1",
      "resource": {
        "resourceType": "MedicationStatement",
        "id": "medstmt-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "contained": [{
          "resourceType": "Medication",
          "id": "med1",
          "code": {"coding": [{"system": "http://www.whocc.no/atc", "code": "J01CA", "display": "Penicillins"}], "text": "Amoxicillin 500 mg"},
          "ingredient": [{"itemCodeableConcept": {"coding": [{"system": "http://snomed.info/sct", "code": "372687004", "display": "Amoxicillin"}]}, "strength": {"numerator": {"value": 500, "unit": "mg"}, "denominator": {"value": 1, "unit": "tablet"}}}]
        }],
        "medicationReference": {"reference": "#med1"},
        "effectivePeriod": {"start": "2024-01-18", "end": "2024-02-18"},
        "dosage": [{
          "route": {
            "extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]
          },
          "doseAndRate": [{"doseQuantity": {"value": 500, "unit": "mg"}}],
          "timing": {"repeat": {"frequency": 3, "period": 1, "periodUnit": "d"}}
        }]
      }
    },
    {
      "fullUrl": "AllergyIntolerance/allergy-1",
      "resource": {
        "resourceType": "AllergyIntolerance",
        "id": "allergy-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "patient": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "clinicalStatus": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "code": "active"}]},
        "verificationStatus": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "code": "confirmed"}]},
        "type": "allergy",
        "category": ["medication"],
        "code": {"coding": [{"system": "http://snomed.info/sct", "code": "764146007", "display": "Penicillin"}]},
        "onsetDateTime": "2015-04-18",
        "lastOccurrence": "2015-05-18",
        "criticality": "high",
        "reaction": [{
          "manifestation": [{"coding": [{"system": "http://snomed.info/sct", "code": "271807003", "display": "Rash"}]}],
          "severity": "moderate"
        }]
      }
    },
    {
      "fullUrl": "Observation/obs-hb-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-hb-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "718-7", "display": "Hemoglobin"}]},
        "effectiveDateTime": "2023-11-18",
        "valueQuantity": {"value": 13.2, "unit": "g/dL"},
        "interpretation": {"coding": [{"system": "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation", "code": "N", "display": "Normal"}]},
        "note": [{"extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]}],
        "performer": [{"extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]}]
      }
    },
    {
      "fullUrl": "Immunization/imm-1",
      "resource": {
        "resourceType": "Immunization",
        "id": "imm-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "patient": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "vaccineCode": {"coding": [{"system": "http://snomed.info/sct", "code": "1119349007", "display": "COVID-19 vaccine"}]},
        "occurrenceDateTime": "2024-05-18",
        "protocolApplied": [{
          "doseNumberPositiveInt": 2,
          "targetDisease": [{"extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]}]
        }],
        "doseQuantity": {"extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]},
        "site": {"extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]},
        "route": {"extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]}
      }
    },
    {
      "fullUrl": "Observation/obs-occ-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-occ-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "11341-5", "display": "History of Occupation"}]},
        "valueString": "Nurse",
        "effectiveDateTime": "2020-01-31"
      }
    },
    {
      "fullUrl": "Observation/obs-ind-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-ind-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "21843-6", "display": "Industry of employment"}]},
        "valueString": "Healthcare",
        "effectiveDateTime": "2020-01-31"
      }
    },
    {
      "fullUrl": "Observation/obs-prg-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-prg-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "82810-3", "display": "Pregnancy status"}]},
        "valueCodeableConcept": {"coding": [{"system": "http://snomed.info/sct", "code": "77386006", "display": "Pregnant"}]}
      }
    },
    {
      "fullUrl": "Observation/obs-edd-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-edd-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "11778-8", "display": "Estimated delivery date"}]},
        "valueDateTime": "2024-12-18"
      }
    },
    {
      "fullUrl": "DeviceUseStatement/dus-1",
      "resource": {
        "resourceType": "DeviceUseStatement",
        "id": "dus-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "status": "completed",
        "device": {"extension": [{"url": "http://hl7.org/fhir/StructureDefinition/data-absent-reason", "valueCode": "masked"}]},
        "note": [{"text": "Device data required"}],
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"}
      }
    },
    {
      "fullUrl": "Observation/obs-cod-1",
      "resource": {
        "resourceType": "Observation",
        "id": "obs-cod-1",
        "meta": {
          "security": [
            {"system": "http://ihe.net/CodeSystem/deid-status", "code": "stage2-pseudonymized", "display": "Stage 2 pseudonymized"}
          ]
        },
        "identifier": [{"system": "urn:example:psyn2", "value": "VRDR-PSYN2-0001"}],
        "subject": {"reference": "Patient/d174bd1a-b368-41e6-83a2-af77f2b3c60f"},
        "code": {"coding": [{"system": "http://loinc.org", "code": "81956-5", "display": "Cause of death"}]},
        "effectiveDateTime": "2024-07-15",
        "valueCodeableConcept": {"coding": [{"system": "http://snomed.info/sct", "code": "840539006", "display": "COVID-19"}]},
        "extension": [{"url": "urn:example:decedentName", "valueHumanName": {"family": "Psyn", "given": ["001"]}}]
      }
    }
  ]
}

```

Notes:

* Stage 2 applies quasi-identifier handling: date shifting (relative to birth/incident), postal code generalization (to 3-digits), and removal of requested attributes.
* Data Absent Reason: added on masked elements (e.g., MedicationStatement.dosage.route, Immunization.route/dose/site, DeviceUseStatement.device).
* Security Labels: `meta.security` tags set to `stage2-pseudonymized` for Bundle and resources.
* Redaction & Generalization: provider references and free-text removed where specified; postal code generalized.
* Pseudonymization: irreversible patient and mortality identifiers (`urn:example:psyn2`) while preserving referential integrity.

#### FHIR VRDR Example (Death Certificate Document)

##### VRDR Data Element Mappings (FHIR)

This example shows a minimized VRDR Death Certificate Document Bundle using the VRDR profiles. Only the following data elements are carried forward: Date of Death, Cause of Death, Decedent name, Decedent address, Decedent occupation, and Decedent industry.

| | | | |
| :--- | :--- | :--- | :--- |
| Document | Death Certificate Document | Bundle.meta.profile | VRDR Bundle profile used |
| Document | Death Certificate | Composition.meta.profile | VRDR Composition profile used |
| Decedent | Name | Patient.name | Stage 1: reversible pseudonymization |
| Decedent | Address | Patient.address | Stage 2: generalize |
| Death | Date of death | Observation.valueDateTime where code=81956-5 | Stage 2: date shift (optionally truncate time) |
| Death | Automated underlying cause of death | Observation.valueCodeableConcept where code=80358-5 | Included |
| Social History | Usual occupation | Observation.valueCodeableConcept where code=21843-8 | Included (review outliers) |
| Social History | Usual industry | Observation.component.valueCodeableConcept where component.code=21844-6 | Included (review outliers) |

##### Original Identified VRDR Death Certificate Document Bundle

```
{
  "resourceType": "Bundle",
  "type": "document",
  "timestamp": "2024-07-01T00:00:00Z",
  "meta": {
    "profile": [
      "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-certificate-document"
    ]
  },
  "entry": [
    {
      "fullUrl": "Composition/vrdr-death-certificate-1",
      "resource": {
        "resourceType": "Composition",
        "id": "vrdr-death-certificate-1",
        "meta": {
          "profile": [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-certificate"
          ]
        },
        "status": "final",
        "type": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "64297-5",
              "display": "Death certificate"
            }
          ]
        },
        "subject": {"reference": "Patient/decedent-1"},
        "date": "2024-07-01T00:00:00Z",
        "title": "U.S. Standard Certificate of Death",
        "section": [
          {
            "code": {
              "coding": [
                {
                  "system": "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code": "DecedentDemographics"
                }
              ]
            },
            "entry": [
              {"reference": "Patient/decedent-1"},
              {"reference": "Observation/vrdr-usual-work-1"}
            ]
          },
          {
            "code": {
              "coding": [
                {
                  "system": "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code": "DeathInvestigation"
                }
              ]
            },
            "entry": [{"reference": "Observation/vrdr-death-date-1"}]
          },
          {
            "code": {
              "coding": [
                {
                  "system": "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code": "CodedContent"
                }
              ]
            },
            "entry": [{"reference": "Observation/vrdr-auto-ucod-1"}]
          }
        ]
      }
    },
    {
      "fullUrl": "Patient/decedent-1",
      "resource": {
        "resourceType": "Patient",
        "id": "decedent-1",
        "name": [
          {
            "family": "MARTIN",
            "given": ["Avery"]
          }
        ],
        "address": [
          {
            "line": ["12 Maple Street"],
            "city": "Boston",
            "state": "MA",
            "postalCode": "02110",
            "country": "US"
          }
        ]
      }
    },
    {
      "fullUrl": "Observation/vrdr-death-date-1",
      "resource": {
        "resourceType": "Observation",
        "id": "vrdr-death-date-1",
        "meta": {
          "profile": [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-date"
          ]
        },
        "status": "final",
        "code": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "81956-5",
              "display": "Date+time of death"
            }
          ]
        },
        "subject": {"reference": "Patient/decedent-1"},
        "valueDateTime": "2020-04-05T14:30:00Z"
      }
    },
    {
      "fullUrl": "Observation/vrdr-usual-work-1",
      "resource": {
        "resourceType": "Observation",
        "id": "vrdr-usual-work-1",
        "meta": {
          "profile": [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-decedent-usual-work"
          ]
        },
        "status": "final",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/observation-category",
                "code": "social-history"
              }
            ]
          }
        ],
        "code": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "21843-8",
              "display": "History of Usual Occupation"
            }
          ]
        },
        "subject": {"reference": "Patient/decedent-1"},
        "valueCodeableConcept": {
          "coding": [
            {
              "system": "urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.43.48.3",
              "code": "4221",
              "display": "Travel agency and related clerks"
            }
          ],
          "text": "4221 | Travel agency and related clerks"
        },
        "component": [
          {
            "code": {
              "coding": [
                {
                  "system": "http://loinc.org",
                  "code": "21844-6",
                  "display": "History of Usual industry"
                }
              ]
            },
            "valueCodeableConcept": {
              "coding": [
                {
                  "system": "urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.43.48.2",
                  "code": "5110",
                  "display": "Passenger air transport"
                }
              ],
              "text": "5110 Passenger air transport"
            }
          }
        ]
      }
    },
    {
      "fullUrl": "Observation/vrdr-auto-ucod-1",
      "resource": {
        "resourceType": "Observation",
        "id": "vrdr-auto-ucod-1",
        "meta": {
          "profile": [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-automated-underlying-cause-of-death"
          ]
        },
        "status": "final",
        "code": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "80358-5",
              "display": "Cause of death.underlying [Automated]"
            }
          ]
        },
        "subject": {"reference": "Patient/decedent-1"},
        "valueCodeableConcept": {
          "coding": [
            {
              "system": "http://hl7.org/fhir/sid/icd-10",
              "code": "U07.1",
              "display": "COVID-19"
            }
          ]
        }
      }
    }
  ]
}

```

##### Pseudonymized VRDR Death Certificate Document Bundle (Stage 1)

```
{
  "resourceType": "Bundle",
  "type": "document",
  "timestamp": "2024-07-01T00:00:00Z",
  "meta": {
    "profile": [
      "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-certificate-document"
    ],
    "security": [
      {
        "system": "http://ihe.net/CodeSystem/deid-status",
        "code": "stage1-pseudonymized",
        "display": "Stage 1 pseudonymized"
      }
    ]
  },
  "entry": [
    {
      "fullUrl": "Composition/vrdr-death-certificate-1",
      "resource": {
        "resourceType": "Composition",
        "id": "vrdr-death-certificate-1",
        "meta": {
          "profile": [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-certificate"
          ],
          "security": [
            {
              "system": "http://ihe.net/CodeSystem/deid-status",
              "code": "stage1-pseudonymized",
              "display": "Stage 1 pseudonymized"
            }
          ]
        },
        "status": "final",
        "type": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "64297-5",
              "display": "Death certificate"
            }
          ]
        },
        "subject": {"reference": "Patient/decedent-1"},
        "date": "2024-07-01T00:00:00Z",
        "title": "U.S. Standard Certificate of Death",
        "section": [
          {
            "code": {
              "coding": [
                {
                  "system": "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code": "DecedentDemographics"
                }
              ]
            },
            "entry": [
              {"reference": "Patient/decedent-1"},
              {"reference": "Observation/vrdr-usual-work-1"}
            ]
          },
          {
            "code": {
              "coding": [
                {
                  "system": "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code": "DeathInvestigation"
                }
              ]
            },
            "entry": [{"reference": "Observation/vrdr-death-date-1"}]
          },
          {
            "code": {
              "coding": [
                {
                  "system": "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code": "CodedContent"
                }
              ]
            },
            "entry": [{"reference": "Observation/vrdr-auto-ucod-1"}]
          }
        ]
      }
    },
    {
      "fullUrl": "Patient/decedent-1",
      "resource": {
        "resourceType": "Patient",
        "id": "decedent-1",
        "meta": {
          "security": [
            {
              "system": "http://ihe.net/CodeSystem/deid-status",
              "code": "stage1-pseudonymized",
              "display": "Stage 1 pseudonymized"
            }
          ]
        },
        "identifier": [
          {
            "system": "urn:example:psyn",
            "value": "VRDR-PID-0001"
          }
        ],
        "name": [
          {
            "family": "Psyn",
            "given": ["001"]
          }
        ],
        "address": [
          {
            "line": ["12 Maple Street"],
            "city": "Boston",
            "state": "MA",
            "postalCode": "02110",
            "country": "US"
          }
        ]
      }
    },
    {
      "fullUrl": "Observation/vrdr-death-date-1",
      "resource": {
        "resourceType": "Observation",
        "id": "vrdr-death-date-1",
        "meta": {
          "profile": [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-date"
          ],
          "security": [
            {
              "system": "http://ihe.net/CodeSystem/deid-status",
              "code": "stage1-pseudonymized",
              "display": "Stage 1 pseudonymized"
            }
          ]
        },
        "status": "final",
        "code": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "81956-5",
              "display": "Date+time of death"
            }
          ]
        },
        "subject": {"reference": "Patient/decedent-1"},
        "valueDateTime": "2020-04-05T14:30:00Z"
      }
    },
    {
      "fullUrl": "Observation/vrdr-usual-work-1",
      "resource": {
        "resourceType": "Observation",
        "id": "vrdr-usual-work-1",
        "meta": {
          "profile": [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-decedent-usual-work"
          ],
          "security": [
            {
              "system": "http://ihe.net/CodeSystem/deid-status",
              "code": "stage1-pseudonymized",
              "display": "Stage 1 pseudonymized"
            }
          ]
        },
        "status": "final",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/observation-category",
                "code": "social-history"
              }
            ]
          }
        ],
        "code": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "21843-8",
              "display": "History of Usual Occupation"
            }
          ]
        },
        "subject": {"reference": "Patient/decedent-1"},
        "valueCodeableConcept": {
          "coding": [
            {
              "system": "urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.43.48.3",
              "code": "4221",
              "display": "Travel agency and related clerks"
            }
          ],
          "text": "4221 | Travel agency and related clerks"
        },
        "component": [
          {
            "code": {
              "coding": [
                {
                  "system": "http://loinc.org",
                  "code": "21844-6",
                  "display": "History of Usual industry"
                }
              ]
            },
            "valueCodeableConcept": {
              "coding": [
                {
                  "system": "urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.43.48.2",
                  "code": "5110",
                  "display": "Passenger air transport"
                }
              ],
              "text": "5110 Passenger air transport"
            }
          }
        ]
      }
    },
    {
      "fullUrl": "Observation/vrdr-auto-ucod-1",
      "resource": {
        "resourceType": "Observation",
        "id": "vrdr-auto-ucod-1",
        "meta": {
          "profile": [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-automated-underlying-cause-of-death"
          ],
          "security": [
            {
              "system": "http://ihe.net/CodeSystem/deid-status",
              "code": "stage1-pseudonymized",
              "display": "Stage 1 pseudonymized"
            }
          ]
        },
        "status": "final",
        "code": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "80358-5",
              "display": "Cause of death.underlying [Automated]"
            }
          ]
        },
        "subject": {"reference": "Patient/decedent-1"},
        "valueCodeableConcept": {
          "coding": [
            {
              "system": "http://hl7.org/fhir/sid/icd-10",
              "code": "U07.1",
              "display": "COVID-19"
            }
          ]
        }
      }
    }
  ]
}

```

Notes:

* Stage 1 applies reversible pseudonymization to direct identifiers needed for linkage (decedent name and identifier).
* Decedent address is not de-identified in Stage 1; it is generalized in Stage 2.
* Date of death, cause of death, and usual work elements are carried forward unchanged in Stage 1.

##### Pseudonymized VRDR Death Certificate Document Bundle (Stage 2)

```
{
  "resourceType": "Bundle",
  "type": "document",
  "timestamp": "2024-07-01T00:00:00Z",
  "meta": {
    "profile": [
      "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-certificate-document"
    ],
    "security": [
      {
        "system": "http://ihe.net/CodeSystem/deid-status",
        "code": "stage2-pseudonymized",
        "display": "Stage 2 pseudonymized"
      }
    ]
  },
  "entry": [
    {
      "fullUrl": "Composition/vrdr-death-certificate-1",
      "resource": {
        "resourceType": "Composition",
        "id": "vrdr-death-certificate-1",
        "meta": {
          "profile": [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-certificate"
          ],
          "security": [
            {
              "system": "http://ihe.net/CodeSystem/deid-status",
              "code": "stage2-pseudonymized",
              "display": "Stage 2 pseudonymized"
            }
          ]
        },
        "status": "final",
        "type": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "64297-5",
              "display": "Death certificate"
            }
          ]
        },
        "subject": {"reference": "Patient/decedent-1"},
        "date": "2024-07-01T00:00:00Z",
        "title": "U.S. Standard Certificate of Death",
        "section": [
          {
            "code": {
              "coding": [
                {
                  "system": "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code": "DecedentDemographics"
                }
              ]
            },
            "entry": [
              {"reference": "Patient/decedent-1"},
              {"reference": "Observation/vrdr-usual-work-1"}
            ]
          },
          {
            "code": {
              "coding": [
                {
                  "system": "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code": "DeathInvestigation"
                }
              ]
            },
            "entry": [{"reference": "Observation/vrdr-death-date-1"}]
          },
          {
            "code": {
              "coding": [
                {
                  "system": "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code": "CodedContent"
                }
              ]
            },
            "entry": [{"reference": "Observation/vrdr-auto-ucod-1"}]
          }
        ]
      }
    },
    {
      "fullUrl": "Patient/decedent-1",
      "resource": {
        "resourceType": "Patient",
        "id": "decedent-1",
        "meta": {
          "security": [
            {
              "system": "http://ihe.net/CodeSystem/deid-status",
              "code": "stage2-pseudonymized",
              "display": "Stage 2 pseudonymized"
            }
          ]
        },
        "identifier": [
          {
            "system": "urn:example:psyn2",
            "value": "VRDR-PID-9f8b1ea1"
          }
        ],
        "name": [
          {
            "family": "Psyn",
            "given": ["001"]
          }
        ],
        "address": [
          {
            "state": "MA",
            "postalCode": "021",
            "country": "US"
          }
        ]
      }
    },
    {
      "fullUrl": "Observation/vrdr-death-date-1",
      "resource": {
        "resourceType": "Observation",
        "id": "vrdr-death-date-1",
        "meta": {
          "profile": [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-date"
          ],
          "security": [
            {
              "system": "http://ihe.net/CodeSystem/deid-status",
              "code": "stage2-pseudonymized",
              "display": "Stage 2 pseudonymized"
            }
          ]
        },
        "status": "final",
        "code": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "81956-5",
              "display": "Date+time of death"
            }
          ]
        },
        "subject": {"reference": "Patient/decedent-1"},
        "valueDateTime": "2020-04-18"
      }
    },
    {
      "fullUrl": "Observation/vrdr-usual-work-1",
      "resource": {
        "resourceType": "Observation",
        "id": "vrdr-usual-work-1",
        "meta": {
          "profile": [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-decedent-usual-work"
          ],
          "security": [
            {
              "system": "http://ihe.net/CodeSystem/deid-status",
              "code": "stage2-pseudonymized",
              "display": "Stage 2 pseudonymized"
            }
          ]
        },
        "status": "final",
        "category": [
          {
            "coding": [
              {
                "system": "http://terminology.hl7.org/CodeSystem/observation-category",
                "code": "social-history"
              }
            ]
          }
        ],
        "code": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "21843-8",
              "display": "History of Usual Occupation"
            }
          ]
        },
        "subject": {"reference": "Patient/decedent-1"},
        "valueCodeableConcept": {
          "coding": [
            {
              "system": "urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.43.48.3",
              "code": "4221",
              "display": "Travel agency and related clerks"
            }
          ],
          "text": "4221 | Travel agency and related clerks"
        },
        "component": [
          {
            "code": {
              "coding": [
                {
                  "system": "http://loinc.org",
                  "code": "21844-6",
                  "display": "History of Usual industry"
                }
              ]
            },
            "valueCodeableConcept": {
              "coding": [
                {
                  "system": "urn:oid:1.3.6.1.4.1.19376.1.5.3.1.3.43.48.2",
                  "code": "5110",
                  "display": "Passenger air transport"
                }
              ],
              "text": "5110 Passenger air transport"
            }
          }
        ]
      }
    },
    {
      "fullUrl": "Observation/vrdr-auto-ucod-1",
      "resource": {
        "resourceType": "Observation",
        "id": "vrdr-auto-ucod-1",
        "meta": {
          "profile": [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-automated-underlying-cause-of-death"
          ],
          "security": [
            {
              "system": "http://ihe.net/CodeSystem/deid-status",
              "code": "stage2-pseudonymized",
              "display": "Stage 2 pseudonymized"
            }
          ]
        },
        "status": "final",
        "code": {
          "coding": [
            {
              "system": "http://loinc.org",
              "code": "80358-5",
              "display": "Cause of death.underlying [Automated]"
            }
          ]
        },
        "subject": {"reference": "Patient/decedent-1"},
        "valueCodeableConcept": {
          "coding": [
            {
              "system": "http://hl7.org/fhir/sid/icd-10",
              "code": "U07.1",
              "display": "COVID-19"
            }
          ]
        }
      }
    }
  ]
}

```

Notes:

* Stage 2 applies quasi-identifier handling: date shifting for date of death (example shown), and generalized address (3-digit postal prefix).
* Identifiers are irreversibly pseudonymized while preserving referential integrity within the bundle.

### CDA Example

This CDA example mirrors the FHIR IPS sample data and uses CDA-specific masking via `nullFlavor` (e.g., `MSK`) for removed elements.

#### IPS Data Element Mappings (CDA)

The table maps IPS data elements to their CDA paths and summarizes the applied de-identification method across stages (Stage 1 for direct identifiers; Stage 2 for quasi-identifiers and minimization). Where elements are removed, CDA uses nullFlavor = "MSK".

| | | | |
| :--- | :--- | :--- | :--- |
| Patient | Patient Name | ClinicalDocument/recordTarget/patientRole/patient/name | Stage 1: mask via nullFlavor='MSK'; Stage 2: remain masked |
| Patient | ID | ClinicalDocument/recordTarget/patientRole/id | Stage 1: pseudonymize; Stage 2: irreversible pseudonym |
| Patient | Telecom | ClinicalDocument/recordTarget/patientRole/telecom | Stage 1/2: omit value; set nullFlavor='MSK' |
| Patient | Date of Birth | ClinicalDocument/recordTarget/patientRole/patient/birthTime | Stage 2: date shift or mask with age band |
| Patient | Gender | ClinicalDocument/recordTarget/patientRole/patient/administrativeGenderCode | Included (QI) |
| Patient | Address (postal code) | ClinicalDocument/recordTarget/patientRole/addr/postalCode | Stage 2: generalize to 3-digit |
| Patient | Preferred language | ClinicalDocument/languageCode | Omit (minimization) |
| Patient | General Practitioner | ClinicalDocument/documentationOf/serviceEvent/performer | Omit (minimization) |
| Patient | Insurance | ClinicalDocument/coverage (local extension) | Omit (minimization) |
| Problems | Diagnosis | ClinicalDocument/component/section[code=10154-3]/entry/observation/code | Included |
| Problems | Onset Date | ClinicalDocument/component/section[code=10154-3]/entry/observation/effectiveTime@value | Stage 2: date shift |
| Problems | Problem Status | ClinicalDocument/component/section[code=10154-3]/entry/observation/statusCode | Omit (minimization) |
| Problems | Specialist Contact | ClinicalDocument/component/section[code=10154-3]/entry/author/assignedAuthor | Omit (minimization) |
| Procedures | Procedure code | ClinicalDocument/component/section[Procedures]/entry/procedure/code | Included |
| Procedures | Procedure description | ClinicalDocument/component/section[Procedures]/entry/procedure/text | Stage 2: omit free-text; nullFlavor='MSK' if present |
| Procedures | Body site | ClinicalDocument/component/section[Procedures]/entry/procedure/targetSiteCode | Included |
| Procedures | Procedure date | ClinicalDocument/component/section[Procedures]/entry/procedure/effectiveTime@value | Stage 2: date shift |
| Medication Summary | Product code | ClinicalDocument/component/section[Medications]/entry/substanceAdministration/consumable/manufacturedProduct/code | Included |
| Medication Summary | Common name & strength | ClinicalDocument/component/section[Medications]/entry/substanceAdministration/consumable/manufacturedProduct/code@displayName | Include when coded; omit free-text if risky |
| Medication Summary | Period of use | ClinicalDocument/component/section[Medications]/entry/substanceAdministration/effectiveTime | Stage 2: date shift |
| Medication Summary | Route of administration | ClinicalDocument/component/section[Medications]/entry/substanceAdministration/routeCode | Stage 2: omit value; nullFlavor='MSK' |
| Medication Summary | Dose quantity | ClinicalDocument/component/section[Medications]/entry/substanceAdministration/doseQuantity | Included |
| Medication Summary | Dose frequency | ClinicalDocument/component/section[Medications]/entry/substanceAdministration/entryRelationship/sequenceNumber | Included (if present) |
| Allergies | Clinical status | ClinicalDocument/component/section[code=48765-2]/entry/observation/statusCode | Included |
| Allergies | Onset date | ClinicalDocument/component/section[code=48765-2]/entry/observation/effectiveTime@value | Stage 2: date shift |
| Allergies | End date | ClinicalDocument/component/section[code=48765-2]/entry/observation/effectiveTime/high@value | Stage 2: date shift |
| Allergies | Reaction manifestation | ClinicalDocument/component/section[code=48765-2]/entry/observation/value | Included |
| Results | Date of observation | ClinicalDocument/component/section[Results]/entry/observation/effectiveTime@value | Stage 2: date shift |
| Results | Observation type | ClinicalDocument/component/section[Results]/entry/observation/code | Included |
| Results | Result value | ClinicalDocument/component/section[Results]/entry/observation/value | Included |
| Results | Result description | ClinicalDocument/component/section[Results]/entry/observation/text | Stage 2: omit; nullFlavor='MSK' |
| Results | Performer | ClinicalDocument/component/section[Results]/entry/observation/performer | Omit (minimization) |
| Results | Observer | ClinicalDocument/component/section[Results]/entry/observation/author/assignedAuthor | Omit (minimization) |
| Immunizations | Vaccine (type of disease) | ClinicalDocument/component/section[code=11369-6]/entry/substanceAdministration/consumable/manufacturedProduct/code | Included |
| Immunizations | Date of immunization | ClinicalDocument/component/section[code=11369-6]/entry/substanceAdministration/effectiveTime@value | Stage 2: date shift |
| Immunizations | Product name | ClinicalDocument/component/section[code=11369-6]/entry/substanceAdministration/consumable/manufacturedProduct/code@displayName | Omit (minimization) |
| Immunizations | Product administration | ClinicalDocument/component/section[code=11369-6]/entry/substanceAdministration/doseQuantity/siteCode/routeCode | Stage 2: omit value(s); nullFlavor='MSK' |
| Immunizations | Performer | ClinicalDocument/component/section[code=11369-6]/entry/substanceAdministration/performer | Omit (minimization) |
| Social History | Occupation | ClinicalDocument/component/section[Social History]/entry/observation[code=11341-5]/value@value | Include; review outliers; date-shift observation date |
| Social History | Industry | ClinicalDocument/component/section[Social History]/entry/observation[code=21843-6]/value@value | Include; review outliers; date-shift observation date |
| Pregnancy | Pregnancy status | ClinicalDocument/component/section[Pregnancy]/entry/observation[code=82810-3]/value@code | Included |
| Pregnancy | Estimated delivery date | ClinicalDocument/component/section[Pregnancy]/entry/observation[code=11778-8]/value@value | Stage 2: date shift |
| Medical Devices | Device data required | ClinicalDocument/component/section[Medical Devices]/entry/supply/participant[@typeCode='DEV'] | Not needed; set nullFlavor='MSK' or omit |

#### Original Identified CDA (IPS subset)

```
<ClinicalDocument xmlns="urn:hl7-org:v3">
  <recordTarget>
    <patientRole>
      <id root="https://standards.digital.health.nz/ns/nhi-id" extension="ABC1234"/>
      <addr><postalCode>3210</postalCode></addr>
      <telecom value="tel:+64-07-850-9900" use="HP"/>
      <patient>
        <name><given>Patricia</given><family>JORDANA</family></name>
        <administrativeGenderCode code="F"/>
        <birthTime value="19560930"/>
      </patient>
    </patientRole>
  </recordTarget>
  <component>
    <section>
      <code code="10154-3" codeSystem="2.16.840.1.113883.6.1" displayName="Problem List"/>
      <entry>
        <observation classCode="OBS" moodCode="EVN">
          <code code="59621000" codeSystem="2.16.840.1.113883.6.96" displayName="Essential hypertension"/>
          <effectiveTime value="20160525"/>
        </observation>
      </entry>
    </section>
  </component>
  <component>
    <section>
      <code code="11369-6" codeSystem="2.16.840.1.113883.6.1" displayName="Immunizations"/>
      <entry>
        <substanceAdministration classCode="SBADM" moodCode="EVN">
          <effectiveTime value="20240501"/>
          <consumable>
            <manufacturedProduct>
              <code code="1119349007" codeSystem="2.16.840.1.113883.6.96" displayName="COVID-19 vaccine"/>
            </manufacturedProduct>
          </consumable>
        </substanceAdministration>
      </entry>
    </section>
  </component>
</ClinicalDocument>

```

#### After Stage 1 (Pseudonymized CDA)

Direct identifiers are removed or pseudonymized; removed elements are marked using `nullFlavor="MSK"`.

```
<ClinicalDocument xmlns="urn:hl7-org:v3">
  <recordTarget>
    <patientRole>
      <id root="urn:example:psyn" extension="PID-7ac6997e"/>
      <addr><postalCode>3210</postalCode></addr>
      <telecom nullFlavor="MSK"/>
      <patient>
        <name nullFlavor="MSK"/>
        <administrativeGenderCode code="F"/>
        <birthTime value="19560930"/>
      </patient>
    </patientRole>
  </recordTarget>
  <component>
    <section>
      <code code="10154-3" codeSystem="2.16.840.1.113883.6.1" displayName="Problem List"/>
      <entry>
        <observation classCode="OBS" moodCode="EVN">
          <code code="59621000" codeSystem="2.16.840.1.113883.6.96" displayName="Essential hypertension"/>
          <effectiveTime value="20160525"/>
        </observation>
      </entry>
    </section>
  </component>
  <component>
    <section>
      <code code="11369-6" codeSystem="2.16.840.1.113883.6.1" displayName="Immunizations"/>
      <entry>
        <substanceAdministration classCode="SBADM" moodCode="EVN">
          <effectiveTime value="20240501"/>
          <consumable>
            <manufacturedProduct>
              <code code="1119349007" codeSystem="2.16.840.1.113883.6.96" displayName="COVID-19 vaccine"/>
            </manufacturedProduct>
          </consumable>
        </substanceAdministration>
      </entry>
    </section>
  </component>
</ClinicalDocument>

```

#### After Stage 2 (Anonymized CDA)

Quasi-identifiers are transformed; removed elements continue to use `nullFlavor="MSK"`. Dates are shifted to match the FHIR Stage 2 example; postalCode generalized to 3 digits.

```
<ClinicalDocument xmlns="urn:hl7-org:v3">
  <recordTarget>
    <patientRole>
      <id root="urn:example:psyn2" extension="PID-9f8b1ea1"/>
      <addr><postalCode>321</postalCode></addr>
      <telecom nullFlavor="MSK"/>
      <patient>
        <name nullFlavor="MSK"/>
        <administrativeGenderCode code="F"/>
        <birthTime nullFlavor="MSK">
          <!-- Age band derived per policy -->
        </birthTime>
      </patient>
    </patientRole>
  </recordTarget>
  <component>
    <section>
      <code code="10154-3" codeSystem="2.16.840.1.113883.6.1" displayName="Problem List"/>
      <entry>
        <observation classCode="OBS" moodCode="EVN">
          <code code="59621000" codeSystem="2.16.840.1.113883.6.96" displayName="Essential hypertension"/>
          <effectiveTime value="20160610"/>
        </observation>
      </entry>
    </section>
  </component>
  <component>
    <section>
      <code code="11369-6" codeSystem="2.16.840.1.113883.6.1" displayName="Immunizations"/>
      <entry>
        <substanceAdministration classCode="SBADM" moodCode="EVN">
          <effectiveTime value="20240518"/>
          <consumable>
            <manufacturedProduct>
              <code code="1119349007" codeSystem="2.16.840.1.113883.6.96" displayName="COVID-19 vaccine"/>
            </manufacturedProduct>
          </consumable>
        </substanceAdministration>
      </entry>
    </section>
  </component>
</ClinicalDocument>

```

Notes:

* CDA uses `nullFlavor` (e.g., `MSK`) to indicate masked/removed content, whereas FHIR uses the Data Absent Reason extension.
* Pseudonymized identifiers mirror the FHIR Stage 1/2 examples (`PID-7ac6997e`, `PID-9f8b1ea1`).
* Dates and postal generalization match the FHIR Stage 2 transformations.

# Test fragment

Error processing command: Unable to find fragment resource Bundle/5d7d0b42-86be-4630-b284-6a9f3aab05bc pointed to in file /scratch/repo/input/pagecontent/ips-ehds-example 

