# Artifacts Summary - De-Identification Profile v0.0.1-current

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [IHE DeId Audit Creator](CapabilityStatement-IHE.DeId.AuditCreator.md) | CapabilityStatement for [DeIdentification Audit Creator](security.md) Actor in [DeIdentification Handbook](index.md).This Actor is derived off of the [ATNA Secure Application](https://profiles.ihe.net/ITI/TF/Volume1/ch-9.html#9.1.1.2) or [ATNA Secure Node](https://profiles.ihe.net/ITI/TF/Volume1/ch-9.html#9.1.1.1) actor with [ATNA ATX:FHIR Feed Option](https://profiles.ihe.net/ITI/TF/Volume1/ch-9.html).This Actor is derived off of the [Basic Audit Log Patterns (BALP)](https://profiles.ihe.net/ITI/BALP/index.html) [Audit Creator](https://profiles.ihe.net/ITI/BALP/volume-1.html#152111-audit-creator) recording rich audit log entries to ATNA.* This Actor is involved in the generation of De-Identified data, and thus would record [De-Identification Audit Events](StructureDefinition-IHE.BasicAudit.DeIdentification.Source.md)
* Ths Actor may be involved in events that uncover a Privacy Disclosure, and thus would record [Privacy Disclosure Audit Events](https://build.fhir.org/ig/IHE/ITI.BasicAudit/StructureDefinition-IHE.BasicAudit.PrivacyDisclosure.Source.html).
 |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Audit Event for De-Identification at Source](StructureDefinition-IHE.BasicAudit.DeIdentification.Source.md) | Defines constraints on the AuditEvent Resource to record when a De-Identification happens at the Source. Note that a De-Identification event often impacts many different patients, so many AuditEvent resources need to be created so that each Patient is individually represented. This prevents leakage of other patients' that were also De-Identified at the same time.* Export event
* subtype of deidentify or pseudonymize
* shall have source of itself
* shall have a source agent
* should have a recipient agent(s) if known
* may have user, app, organization agent(s) 
* combine with the Security Token pattern
 
* should have the custodian that released the data
* should have the authorizer that represented the patient (may be the patient)
* shall have a patient entity
* may have the consent that authorized the de-identification
* may have the authorizing client token (saml, jwt, etc)
* may have the set of data entity(ies)
 |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Audit Event Subtype for De-Identification](ValueSet-IHE.BasicAudit.DeIdentification.Subtype.md) | Defines the AuditEvent Subtype for De-Identification events. This is used to indicate that the AuditEvent is specifically for a De-Identification event. The code is based on the ISO 21089 lifecycle code for de-identification. |
| [Entity Type for De-Identification valueset](ValueSet-DeIdentificationEntityTypeVS.md) | ValueSet Entity Type for De-Identification |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Entity Type for De-Identification](CodeSystem-DeIdentificationEntityType.md) | These AuditEvent.entity.type are related to De-Identification policy identification. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Audit Example of De-Identification at source](AuditEvent-ex-auditDeIdentification-source.md) | Audit Example for a De-Identification from source perspective |
| [Audit Example of authorized Re-Identification at source](AuditEvent-ex-auditReIdentification-source.md) | Audit Example for an authorized Re-Identification from source perspective |
| [Ex-Patient-1-for-secondaryUse-pandemnicIPS-stage-0](Patient-d174bd1a-b368-41e6-83a2-af77f2b3c60f.md) |  |
| [Ex-Patient-1-for-secondaryUse-pandemnicIPS-stage-1](Patient-39c9964c-96b7-442d-afc1-2702106a9e57.md) |  |
| [Ex-Patient-1-for-secondaryUse-pandemnicIPS-stage-2](Patient-6274d469-7a4d-4a66-a261-e5e7b71af267.md) |  |
| [ex-Bundle-secondaryUse-pandemnicIPS-example-patient-1-stage-0](Bundle-80c516fd-9c84-4924-875b-bf0048979ae1.md) |  |
| [ex-Bundle-secondaryUse-pandemnicIPS-example-patient-1-stage-2](Bundle-6603561c-2888-4355-9df4-23675f6eb458.md) |  |
| [ex-DeathCertificateDocument-Bundle-pandemnicIPS-example-patient-1-stage-1](Bundle-e817cefe-a7c4-487a-8116-be23cf865f3f.md) |  |

