# ex-Bundle-secondaryUse-pandemnicIPS-example-patient-1-stage-2 - De-Identification Profile v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ex-Bundle-secondaryUse-pandemnicIPS-example-patient-1-stage-2**

## Example Bundle: ex-Bundle-secondaryUse-pandemnicIPS-example-patient-1-stage-2



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "6603561c-2888-4355-9df4-23675f6eb458",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639",
    "value" : "IHEEX-33159"
  },
  "type" : "document",
  "timestamp" : "2024-10-16T00:00:00Z",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:5392cf13-ccbd-485c-b81d-8b0695233e95",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "6274d469-7a4d-4a66-a261-e5e7b71af267",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Composition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_6274d469-7a4d-4a66-a261-e5e7b71af267\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition 6274d469-7a4d-4a66-a261-e5e7b71af267</b></p><a name=\"6274d469-7a4d-4a66-a261-e5e7b71af267\"> </a><a name=\"hc6274d469-7a4d-4a66-a261-e5e7b71af267\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Composition-uv-ips.html\">Composition (IPS)</a></p></div><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 60591-5}\">Patient summary Document</span></p><p><b>date</b>: 2024-10-16 00:00:00+0000</p><p><b>author</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-fd584c2f-5814-425d-9b00-0a5b1a6effee\">Practitioner Heps Simone MD(official)</a></p><p><b>title</b>: International Patient Summary</p><p><b>confidentiality</b>: normal</p><p><b>custodian</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-5bc0c003-a3cd-44f2-b3be-8cb256d0e83a\">Organization World Health Organization</a></p><h3>Events</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Period</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActClass PCPR}\">care provision</span></td><td>2024-10-16 00:00:00+0000 --&gt; 2024-10-16 00:00:00+0000</td></tr></table></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        },
        "date" : "2024-10-16T00:00:00Z",
        "author" : [
          {
            "reference" : "urn:uuid:fd584c2f-5814-425d-9b00-0a5b1a6effee"
          }
        ],
        "title" : "International Patient Summary",
        "confidentiality" : "N",
        "custodian" : {
          "reference" : "urn:uuid:5bc0c003-a3cd-44f2-b3be-8cb256d0e83a"
        },
        "event" : [
          {
            "code" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActClass",
                    "code" : "PCPR"
                  }
                ]
              }
            ],
            "period" : {
              "start" : "2024-10-16T00:00:00Z",
              "end" : "2024-10-16T00:00:00Z"
            }
          }
        ],
        "section" : [
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list - Reported"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Problem list section</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:c86543b7-4002-4ba6-9a9b-aaa4ecf01b7c"
              },
              {
                "reference" : "urn:uuid:b25745c5-e5de-446f-8bac-3baff9e75270"
              }
            ]
          },
          {
            "title" : "Allergies and Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Allergies and intolerances section</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:057e5b9c-89c7-411d-ad11-92114df5d287"
              }
            ]
          },
          {
            "title" : "Medication List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "History of Medication use Narrative"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Medication section</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:0aeb9ee8-4968-4342-b833-080dc1abe7c3"
              }
            ]
          },
          {
            "title" : "Past Problems",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11348-0",
                  "display" : "History of Past illness note"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">History of Past Problems Section</div>"
            },
            "emptyReason" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/list-empty-reason",
                  "code" : "withheld",
                  "display" : "Information Withheld"
                }
              ]
            }
          },
          {
            "title" : "History of Immunizations",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11369-6",
                  "display" : "History of Immunization note"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Immunizations section</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:c76c4f38-de14-4578-8fa6-ec6aad88c4ee"
              }
            ]
          },
          {
            "title" : "History of Procedures",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "47519-4",
                  "display" : "History of Procedures Document"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">History of Procedures section</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:b066f5b5-fe10-4f8b-8341-bf3a227e15c1"
              }
            ]
          },
          {
            "title" : "Diagnostic Results",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "30954-2",
                  "display" : "Relevant diagnostic tests/laboratory data note"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Results section</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:b2a55f80-c7f9-4d49-8023-226b2e735445"
              }
            ]
          },
          {
            "title" : "Social History",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "29762-2",
                  "display" : "Social history note"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Social History</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:ff4bccb4-b5d4-4e21-b12a-84bf6d04c710"
              }
            ]
          },
          {
            "title" : "Pregnancy History",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10162-6",
                  "display" : "History of Pregnancies Narrative"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Pregnancy section</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:c1f6d2f1-2899-4b68-8f62-f2d18e0766cb"
              }
            ]
          },
          {
            "title" : "Medical Devices",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "46264-8",
                  "display" : "History of Medical Device Use"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Results section</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:1499748c-bc94-4a6d-9d4e-d0e90b902411"
              }
            ]
          },
          {
            "title" : "Vital Signs",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8716-3",
                  "display" : "Vital signs note"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Vital Signs Section</div>"
            },
            "emptyReason" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/list-empty-reason",
                  "code" : "withheld",
                  "display" : "Information Withheld"
                }
              ]
            }
          },
          {
            "title" : "Plan of Care",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "18776-5",
                  "display" : "Plan of care note"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Plan of Care Section</div>"
            },
            "emptyReason" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/list-empty-reason",
                  "code" : "withheld",
                  "display" : "Information Withheld"
                }
              ]
            }
          },
          {
            "title" : "Advance Directives",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "42348-3",
                  "display" : "Advance healthcare directives"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Advance healthcare directives Information Withheld</div>"
            },
            "emptyReason" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/list-empty-reason",
                  "code" : "withheld",
                  "display" : "Information Withheld"
                }
              ]
            }
          },
          {
            "title" : "Alerts",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "104605-1",
                  "display" : "Alert"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Alerts Section</div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:60d35c97-adc0-4354-b606-2a582e7fa6b6"
              }
            ]
          },
          {
            "title" : "Functional Status",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "47420-5",
                  "display" : "Functional status assessment note"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Functional Status Section</div>"
            },
            "emptyReason" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/list-empty-reason",
                  "code" : "withheld",
                  "display" : "Information Withheld"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:5bc0c003-a3cd-44f2-b3be-8cb256d0e83a",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "5bc0c003-a3cd-44f2-b3be-8cb256d0e83a",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Organization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_5bc0c003-a3cd-44f2-b3be-8cb256d0e83a\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization 5bc0c003-a3cd-44f2-b3be-8cb256d0e83a</b></p><a name=\"5bc0c003-a3cd-44f2-b3be-8cb256d0e83a\"> </a><a name=\"hc5bc0c003-a3cd-44f2-b3be-8cb256d0e83a\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Organization-uv-ips.html\">Organization (IPS)</a></p></div><p><b>identifier</b>: <code>urn:oid:1.1.1.1.1.1.1.3</code>/WHO-CX</p><p><b>name</b>: World Health Organization</p></div>"
        },
        "identifier" : [
          {
            "system" : "urn:oid:1.1.1.1.1.1.1.3",
            "value" : "WHO-CX"
          }
        ],
        "name" : "World Health Organization"
      }
    },
    {
      "fullUrl" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "6274d469-7a4d-4a66-a261-e5e7b71af267",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Patient-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_6274d469-7a4d-4a66-a261-e5e7b71af267\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 6274d469-7a4d-4a66-a261-e5e7b71af267</b></p><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Patient-uv-ips.html\">Patient (IPS)</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td>true</td><td style=\"background-color: #f3f5da\" title=\"Known status of Patient\">Deceased:</td><td colspan=\"3\">2024-10-15</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\"><ul><li>-unknown-</li><li>3210 </li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Patient Links\">Links:</td><td colspan=\"3\"><ul><li>General Practitioner: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#Practitioner_9e57d970-d0ae-4a36-908f-1cad06f94f28\">Practitioner Joseph Yaser</a></li></ul></td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639",
            "value" : "IHEEX-33159"
          }
        ],
        "active" : true,
        "name" : [
          {
            "text" : "PseudoFamily",
            "family" : "PseudoFamily",
            "given" : ["PseudoGiven"]
          }
        ],
        "telecom" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
                "valueCode" : "masked"
              }
            ]
          }
        ],
        "gender" : "female",
        "birthDate" : "1996-08-16",
        "deceasedDateTime" : "2024-10-15",
        "address" : [
          {
            "postalCode" : "3210"
          }
        ],
        "generalPractitioner" : [
          {
            "reference" : "Practitioner/9e57d970-d0ae-4a36-908f-1cad06f94f28"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:fd584c2f-5814-425d-9b00-0a5b1a6effee",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "fd584c2f-5814-425d-9b00-0a5b1a6effee",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Practitioner-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_fd584c2f-5814-425d-9b00-0a5b1a6effee\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner fd584c2f-5814-425d-9b00-0a5b1a6effee</b></p><a name=\"fd584c2f-5814-425d-9b00-0a5b1a6effee\"> </a><a name=\"hcfd584c2f-5814-425d-9b00-0a5b1a6effee\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Practitioner-uv-ips.html\">Practitioner (IPS)</a></p></div><p><b>identifier</b>: <code>urn:oid:2.16.528.1.1007.3.1</code>/874635264 (use: official, ), <code>urn:oid:2.16.840.1.113883.2.4.6.3</code>/567IUI51C154 (use: usual, )</p><p><b>name</b>: Heps Simone MD(Official)</p><p><b>address</b>: Galapagosweg 91 Den Burg 9105 PZ NLD (work)</p><p><b>gender</b>: Female</p><p><b>birthDate</b>: 1971-11-07</p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "system" : "urn:oid:2.16.528.1.1007.3.1",
            "value" : "874635264"
          },
          {
            "use" : "usual",
            "system" : "urn:oid:2.16.840.1.113883.2.4.6.3",
            "value" : "567IUI51C154"
          }
        ],
        "name" : [
          {
            "use" : "official",
            "text" : "Heps Simone MD",
            "family" : "Heps",
            "given" : ["Simone"],
            "suffix" : ["MD"]
          }
        ],
        "address" : [
          {
            "use" : "work",
            "line" : ["Galapagosweg 91"],
            "city" : "Den Burg",
            "postalCode" : "9105 PZ",
            "country" : "NLD"
          }
        ],
        "gender" : "female",
        "birthDate" : "1971-11-07"
      }
    },
    {
      "fullUrl" : "urn:uuid:9e57d970-d0ae-4a36-908f-1cad06f94f28",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "9e57d970-d0ae-4a36-908f-1cad06f94f28",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Practitioner-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_9e57d970-d0ae-4a36-908f-1cad06f94f28\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 9e57d970-d0ae-4a36-908f-1cad06f94f28</b></p><a name=\"9e57d970-d0ae-4a36-908f-1cad06f94f28\"> </a><a name=\"hc9e57d970-d0ae-4a36-908f-1cad06f94f28\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Practitioner-uv-ips.html\">Practitioner (IPS)</a></p></div><p><b>name</b>: Joseph Yaser</p></div>"
        },
        "name" : [
          {
            "text" : "Joseph Yaser",
            "family" : "Joseph",
            "given" : ["Yaser"]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:0aeb9ee8-4968-4342-b833-080dc1abe7c3",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "0aeb9ee8-4968-4342-b833-080dc1abe7c3",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_0aeb9ee8-4968-4342-b833-080dc1abe7c3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 0aeb9ee8-4968-4342-b833-080dc1abe7c3</b></p><a name=\"0aeb9ee8-4968-4342-b833-080dc1abe7c3\"> </a><a name=\"hc0aeb9ee8-4968-4342-b833-080dc1abe7c3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>status</b>: Completed</p><p><b>medication</b>: <span title=\"Codes:{http://snomed.info/sct 116113006}\">Oseltamivir phosphate (substance)</span></p><p><b>subject</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p><p><b>effective</b>: 2024-10-01</p><p><b>dateAsserted</b>: 2024-10-01</p></div>"
        },
        "status" : "completed",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "116113006",
              "display" : "Oseltamivir phosphate (substance)"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        },
        "effectiveDateTime" : "2024-10-01",
        "dateAsserted" : "2024-10-01"
      }
    },
    {
      "fullUrl" : "urn:uuid:c86543b7-4002-4ba6-9a9b-aaa4ecf01b7c",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "c86543b7-4002-4ba6-9a9b-aaa4ecf01b7c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_c86543b7-4002-4ba6-9a9b-aaa4ecf01b7c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition c86543b7-4002-4ba6-9a9b-aaa4ecf01b7c</b></p><a name=\"c86543b7-4002-4ba6-9a9b-aaa4ecf01b7c\"> </a><a name=\"hcc86543b7-4002-4ba6-9a9b-aaa4ecf01b7c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>severity</b>: <span title=\"Codes:{http://snomed.info/sct 24484000}\">Severe</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 719865001}\">Influenza caused by pandemic influenza virus (disorder)</span></p><p><b>subject</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p><p><b>onset</b>: 2024-10-30</p><p><b>asserter</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-9e57d970-d0ae-4a36-908f-1cad06f94f28\">Practitioner Joseph Yaser</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "severity" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "24484000",
              "display" : "Severe"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "719865001",
              "display" : "Influenza caused by pandemic influenza virus (disorder)"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        },
        "onsetDateTime" : "2024-10-30",
        "asserter" : {
          "reference" : "urn:uuid:9e57d970-d0ae-4a36-908f-1cad06f94f28"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:b25745c5-e5de-446f-8bac-3baff9e75270",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "b25745c5-e5de-446f-8bac-3baff9e75270",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_b25745c5-e5de-446f-8bac-3baff9e75270\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition b25745c5-e5de-446f-8bac-3baff9e75270</b></p><a name=\"b25745c5-e5de-446f-8bac-3baff9e75270\"> </a><a name=\"hcb25745c5-e5de-446f-8bac-3baff9e75270\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>severity</b>: <span title=\"Codes:{http://snomed.info/sct 24484000}\">Severe</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 370221004}\">Severe asthma (disorder)</span></p><p><b>subject</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p><p><b>onset</b>: 2006-01-03</p><p><b>asserter</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-9e57d970-d0ae-4a36-908f-1cad06f94f28\">Practitioner Joseph Yaser</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "severity" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "24484000",
              "display" : "Severe"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "370221004",
              "display" : "Severe asthma (disorder)"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        },
        "onsetDateTime" : "2006-01-03",
        "asserter" : {
          "reference" : "urn:uuid:9e57d970-d0ae-4a36-908f-1cad06f94f28"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:b066f5b5-fe10-4f8b-8341-bf3a227e15c1",
      "resource" : {
        "resourceType" : "Procedure",
        "id" : "b066f5b5-fe10-4f8b-8341-bf3a227e15c1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Procedure-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Procedure_b066f5b5-fe10-4f8b-8341-bf3a227e15c1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Procedure b066f5b5-fe10-4f8b-8341-bf3a227e15c1</b></p><a name=\"b066f5b5-fe10-4f8b-8341-bf3a227e15c1\"> </a><a name=\"hcb066f5b5-fe10-4f8b-8341-bf3a227e15c1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Procedure-uv-ips.html\">Procedure (IPS)</a></p></div><p><b>status</b>: Completed</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 480571000146108}\">Artificial ventilation using ventilator (regime/therapy)</span></p><p><b>subject</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p><p><b>performed</b>: 2024-10-10</p><p><b>bodySite</b>: <span title=\"Codes:{http://snomed.info/sct 39607008}\">Lung structure</span></p><p><b>note</b>: </p><blockquote><div><p>Artificial ventilation using ventilaton performed</p>\n</div></blockquote></div>"
        },
        "status" : "completed",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "480571000146108",
              "display" : "Artificial ventilation using ventilator (regime/therapy)"
            }
          ],
          "text" : "Artificial ventilation using ventilator (regime/therapy)"
        },
        "subject" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        },
        "performedDateTime" : "2024-10-10",
        "bodySite" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "39607008",
                "display" : "Lung structure"
              }
            ]
          }
        ],
        "note" : [
          {
            "text" : "Artificial ventilation using ventilaton performed"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:057e5b9c-89c7-411d-ad11-92114df5d287",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "057e5b9c-89c7-411d-ad11-92114df5d287",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/AllergyIntolerance-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_057e5b9c-89c7-411d-ad11-92114df5d287\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance 057e5b9c-89c7-411d-ad11-92114df5d287</b></p><a name=\"057e5b9c-89c7-411d-ad11-92114df5d287\"> </a><a name=\"hc057e5b9c-89c7-411d-ad11-92114df5d287\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-AllergyIntolerance-uv-ips.html\">AllergyIntolerance (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-verification confirmed}\">Confirmed</span></p><p><b>type</b>: Allergy</p><p><b>category</b>: Medication</p><p><b>criticality</b>: High Risk</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 294647003}\">Allergy to component of vaccine product containing Influenza virus antigen (finding)</span></p><p><b>patient</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p><p><b>onset</b>: 2020-10-01</p><p><b>lastOccurrence</b>: 2020-10-01</p><h3>Reactions</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Manifestation</b></td><td><b>Severity</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 271807003}\">Rash</span></td><td>Moderate</td></tr></table></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed"
            }
          ]
        },
        "type" : "allergy",
        "category" : ["medication"],
        "criticality" : "high",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "294647003",
              "display" : "Allergy to component of vaccine product containing Influenza virus antigen (finding)"
            }
          ]
        },
        "patient" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        },
        "onsetDateTime" : "2020-10-01",
        "lastOccurrence" : "2020-10-01",
        "reaction" : [
          {
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "271807003",
                    "display" : "Rash"
                  }
                ]
              }
            ],
            "severity" : "moderate"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:b2a55f80-c7f9-4d49-8023-226b2e735445",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "b2a55f80-c7f9-4d49-8023-226b2e735445",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-results-laboratory-pathology-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_b2a55f80-c7f9-4d49-8023-226b2e735445\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation b2a55f80-c7f9-4d49-8023-226b2e735445</b></p><a name=\"b2a55f80-c7f9-4d49-8023-226b2e735445\"> </a><a name=\"hcb2a55f80-c7f9-4d49-8023-226b2e735445\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-results-laboratory-pathology-uv-ips.html\">Observation Results - Laboratory/Pathology (IPS)</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 109691-6}\">Influenza virus A Ag [Measurement] in Nasopharynx</span></p><p><b>subject</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p><p><b>effective</b>: 2024-10-30</p><p><b>performer</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-fd584c2f-5814-425d-9b00-0a5b1a6effee\">Practitioner Heps Simone MD(official)</a></p><p><b>value</b>: 13.2 g/dL</p><p><b>interpretation</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation H}\">High</span></p><p><b>note</b>: </p><blockquote><div><p>Positive for Influenza A</p>\n</div></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "109691-6",
              "display" : "Influenza virus A Ag [Measurement] in Nasopharynx"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        },
        "effectiveDateTime" : "2024-10-30",
        "performer" : [
          {
            "reference" : "urn:uuid:fd584c2f-5814-425d-9b00-0a5b1a6effee"
          }
        ],
        "valueQuantity" : {
          "value" : 13.2,
          "unit" : "g/dL"
        },
        "interpretation" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
                "code" : "H",
                "display" : "High"
              }
            ]
          }
        ],
        "note" : [
          {
            "text" : "Positive for Influenza A"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:c76c4f38-de14-4578-8fa6-ec6aad88c4ee",
      "resource" : {
        "resourceType" : "Immunization",
        "id" : "c76c4f38-de14-4578-8fa6-ec6aad88c4ee",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Immunization_c76c4f38-de14-4578-8fa6-ec6aad88c4ee\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Immunization c76c4f38-de14-4578-8fa6-ec6aad88c4ee</b></p><a name=\"c76c4f38-de14-4578-8fa6-ec6aad88c4ee\"> </a><a name=\"hcc76c4f38-de14-4578-8fa6-ec6aad88c4ee\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Immunization-uv-ips.html\">Immunization (IPS)</a></p></div><p><b>status</b>: Completed</p><p><b>vaccineCode</b>: <span title=\"Codes:{http://snomed.info/sct 1181000221105}\">Invluenza Vaccination</span></p><p><b>patient</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p><p><b>occurrence</b>: 2024-08-16</p><p><b>site</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActSite LA}\">left arm</span></p><p><b>route</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration IM}\">Injection, intramuscular</span></p><p><b>doseQuantity</b>: 0.5 mL</p><h3>Performers</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Function</b></td><td><b>Actor</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0443 OP}\">Ordering Provider</span></td><td><a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-9e57d970-d0ae-4a36-908f-1cad06f94f28\">Practitioner Joseph Yaser</a></td></tr></table><h3>ProtocolApplieds</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>TargetDisease</b></td><td><b>DoseNumber[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 719865001}\">Influenza caused by pandemic influenza virus (disorder)</span></td><td>2</td></tr></table></div>"
        },
        "status" : "completed",
        "vaccineCode" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1181000221105",
              "display" : "Vaccine product containing only Influenza virus antigen (medicinal product)"
            }
          ],
          "text" : "Invluenza Vaccination"
        },
        "patient" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        },
        "occurrenceDateTime" : "2024-08-16",
        "site" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ActSite",
              "code" : "LA",
              "display" : "left arm"
            }
          ]
        },
        "route" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RouteOfAdministration",
              "code" : "IM",
              "display" : "Injection, intramuscular"
            }
          ]
        },
        "doseQuantity" : {
          "value" : 0.5,
          "unit" : "mL"
        },
        "performer" : [
          {
            "function" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0443",
                  "code" : "OP"
                }
              ]
            },
            "actor" : {
              "reference" : "urn:uuid:9e57d970-d0ae-4a36-908f-1cad06f94f28"
            }
          }
        ],
        "protocolApplied" : [
          {
            "targetDisease" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "719865001",
                    "display" : "Influenza caused by pandemic influenza virus (disorder)"
                  }
                ]
              }
            ],
            "doseNumberPositiveInt" : 2
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:ff4bccb4-b5d4-4e21-b12a-84bf6d04c710",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "ff4bccb4-b5d4-4e21-b12a-84bf6d04c710",
        "meta" : {
          "profile" : [
            "https://profiles.ihe.net/PCC/ODH/StructureDefinition/odh-PastOrPresentJob"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_ff4bccb4-b5d4-4e21-b12a-84bf6d04c710\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation ff4bccb4-b5d4-4e21-b12a-84bf6d04c710</b></p><a name=\"ff4bccb4-b5d4-4e21-b12a-84bf6d04c710\"> </a><a name=\"hcff4bccb4-b5d4-4e21-b12a-84bf6d04c710\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://profiles.ihe.net/PCC/ODH/1.0.0/StructureDefinition-odh-PastOrPresentJob.html\">Past Or Present Job</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category social-history}\">Social History</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 11341-5}\">History of Occupation</span></p><p><b>subject</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p><p><b>effective</b>: 2016-03-10 --&gt; 2020-04-14</p><p><b>issued</b>: 2024-10-21 13:28:53+0200</p><p><b>performer</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-fd584c2f-5814-425d-9b00-0a5b1a6effee\">Practitioner Heps Simone MD(official)</a></p><p><b>value</b>: <span title=\"Codes:{https://profiles.ihe.net/PCC/ODH/CodeSystem/ISCO08 5321}\">Health Care Assistants</span></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 86188-0}\">History of Occupation Industry</span></td><td><span title=\"Codes:{https://profiles.ihe.net/PCC/ODH/CodeSystem/ISICRev4 871}\">Residential nursing care facilities</span></td></tr></table></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "social-history",
                "display" : "Social History"
              }
            ],
            "text" : "Social History"
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11341-5",
              "display" : "History of Occupation"
            }
          ],
          "text" : "History of Occupation"
        },
        "subject" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        },
        "effectivePeriod" : {
          "start" : "2016-03-10",
          "end" : "2020-04-14"
        },
        "issued" : "2024-10-21T13:28:53+02:00",
        "performer" : [
          {
            "reference" : "urn:uuid:fd584c2f-5814-425d-9b00-0a5b1a6effee"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://profiles.ihe.net/PCC/ODH/CodeSystem/ISCO08",
              "code" : "5321",
              "display" : "Health Care Assistants"
            }
          ]
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "86188-0",
                  "display" : "History of Occupation Industry"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://profiles.ihe.net/PCC/ODH/CodeSystem/ISICRev4",
                  "code" : "871",
                  "display" : "Residential nursing care facilities"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:c1f6d2f1-2899-4b68-8f62-f2d18e0766cb",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "c1f6d2f1-2899-4b68-8f62-f2d18e0766cb",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-status-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_c1f6d2f1-2899-4b68-8f62-f2d18e0766cb\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation c1f6d2f1-2899-4b68-8f62-f2d18e0766cb</b></p><a name=\"c1f6d2f1-2899-4b68-8f62-f2d18e0766cb\"> </a><a name=\"hcc1f6d2f1-2899-4b68-8f62-f2d18e0766cb\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-pregnancy-status-uv-ips.html\">Observation Pregnancy - Status (IPS)</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82810-3}\">Pregnancy status</span></p><p><b>subject</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p><p><b>effective</b>: 2014-02-01</p><p><b>performer</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-fd584c2f-5814-425d-9b00-0a5b1a6effee\">Practitioner Heps Simone MD(official)</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 77386006}\">Pregnant</span></p><p><b>hasMember</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-892bc1ee-cea1-490a-b0a4-ef2e3fbfd278\">Observation Delivery date Estimated</a></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "82810-3",
              "display" : "Pregnancy status"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        },
        "effectiveDateTime" : "2014-02-01",
        "performer" : [
          {
            "reference" : "urn:uuid:fd584c2f-5814-425d-9b00-0a5b1a6effee"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "77386006",
              "display" : "Pregnant"
            }
          ]
        },
        "hasMember" : [
          {
            "reference" : "urn:uuid:892bc1ee-cea1-490a-b0a4-ef2e3fbfd278"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:892bc1ee-cea1-490a-b0a4-ef2e3fbfd278",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "892bc1ee-cea1-490a-b0a4-ef2e3fbfd278",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-edd-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_892bc1ee-cea1-490a-b0a4-ef2e3fbfd278\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation 892bc1ee-cea1-490a-b0a4-ef2e3fbfd278</b></p><a name=\"892bc1ee-cea1-490a-b0a4-ef2e3fbfd278\"> </a><a name=\"hc892bc1ee-cea1-490a-b0a4-ef2e3fbfd278\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-pregnancy-edd-uv-ips.html\">Observation Pregnancy - Expected Delivery Date (IPS)</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 11778-8}\">Delivery date Estimated</span></p><p><b>subject</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p><p><b>effective</b>: 2024-10-17</p><p><b>performer</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-fd584c2f-5814-425d-9b00-0a5b1a6effee\">Practitioner Heps Simone MD(official)</a></p><p><b>value</b>: 2025-03-18</p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11778-8",
              "display" : "Delivery date Estimated"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        },
        "effectiveDateTime" : "2024-10-17",
        "performer" : [
          {
            "reference" : "urn:uuid:fd584c2f-5814-425d-9b00-0a5b1a6effee"
          }
        ],
        "valueDateTime" : "2025-03-18"
      }
    },
    {
      "fullUrl" : "urn:uuid:1499748c-bc94-4a6d-9d4e-d0e90b902411",
      "resource" : {
        "resourceType" : "DeviceUseStatement",
        "id" : "1499748c-bc94-4a6d-9d4e-d0e90b902411",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/DeviceUseStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"DeviceUseStatement_1499748c-bc94-4a6d-9d4e-d0e90b902411\"> </a><p class=\"res-header-id\"><b>Generated Narrative: DeviceUseStatement 1499748c-bc94-4a6d-9d4e-d0e90b902411</b></p><a name=\"1499748c-bc94-4a6d-9d4e-d0e90b902411\"> </a><a name=\"hc1499748c-bc94-4a6d-9d4e-d0e90b902411\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-DeviceUseStatement-uv-ips.html\">DeviceUseStatement (IPS)</a></p></div><p><b>status</b>: Completed</p><p><b>subject</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p><p><b>timing</b>: 2014-02-01</p><p><b>device</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-c66e2f88-0f51-4e3e-a2fb-94d63930aaa3\">Device: type = No known device use</a></p><p><b>note</b>: </p><blockquote><div><p>Device data required</p>\n</div></blockquote></div>"
        },
        "status" : "completed",
        "subject" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        },
        "timingDateTime" : "2014-02-01",
        "device" : {
          "reference" : "urn:uuid:c66e2f88-0f51-4e3e-a2fb-94d63930aaa3"
        },
        "note" : [
          {
            "text" : "Device data required"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:c66e2f88-0f51-4e3e-a2fb-94d63930aaa3",
      "resource" : {
        "resourceType" : "Device",
        "id" : "c66e2f88-0f51-4e3e-a2fb-94d63930aaa3",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Device-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Device_c66e2f88-0f51-4e3e-a2fb-94d63930aaa3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Device c66e2f88-0f51-4e3e-a2fb-94d63930aaa3</b></p><a name=\"c66e2f88-0f51-4e3e-a2fb-94d63930aaa3\"> </a><a name=\"hcc66e2f88-0f51-4e3e-a2fb-94d63930aaa3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Device-uv-ips.html\">Device (IPS)</a></p></div><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 787483001}\">No known device use</span></p><p><b>patient</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p></div>"
        },
        "type" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "787483001",
              "display" : "No known device use"
            }
          ]
        },
        "patient" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:60d35c97-adc0-4354-b606-2a582e7fa6b6",
      "resource" : {
        "resourceType" : "Flag",
        "id" : "60d35c97-adc0-4354-b606-2a582e7fa6b6",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Flag-alert-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Flag_60d35c97-adc0-4354-b606-2a582e7fa6b6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Flag 60d35c97-adc0-4354-b606-2a582e7fa6b6</b></p><a name=\"60d35c97-adc0-4354-b606-2a582e7fa6b6\"> </a><a name=\"hc60d35c97-adc0-4354-b606-2a582e7fa6b6\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Flag-alert-uv-ips.html\">Flag - Alert (IPS)</a></p></div><p><b>status</b>: Active</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/flag-category clinical}\">Clinical</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 370221004}\">Severe asthma (disorder)</span></p><p><b>subject</b>: <a href=\"Bundle-6603561c-2888-4355-9df4-23675f6eb458.html#urn-uuid-6274d469-7a4d-4a66-a261-e5e7b71af267\">PseudoFamily Female, DoB: 1996-08-16 ( urn:oid:1.3.6.1.4.1.21367.2011.2.5.5639#IHEEX-33159)</a></p></div>"
        },
        "status" : "active",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/flag-category",
                "code" : "clinical"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "370221004",
              "display" : "Severe asthma (disorder)"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:6274d469-7a4d-4a66-a261-e5e7b71af267"
        }
      }
    }
  ]
}

```
