# ex-DeathCertificateDocument-Bundle-pandemnicIPS-example-patient-1-stage-1 - De-Identification Profile v0.0.1-current

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ex-DeathCertificateDocument-Bundle-pandemnicIPS-example-patient-1-stage-1**

## Example Bundle: ex-DeathCertificateDocument-Bundle-pandemnicIPS-example-patient-1-stage-1



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "e817cefe-a7c4-487a-8116-be23cf865f3f",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-certificate-document"
    ]
  },
  "identifier" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/us/vr-common-library/StructureDefinition/CertificateNumber",
        "valueString" : "001621"
      },
      {
        "url" : "http://hl7.org/fhir/us/vr-common-library/StructureDefinition/AuxiliaryStateIdentifier1",
        "valueString" : "000000000001"
      },
      {
        "url" : "http://hl7.org/fhir/us/vr-common-library/StructureDefinition/AuxiliaryStateIdentifier2",
        "valueString" : "100000000001"
      }
    ],
    "system" : "http://nchs.cdc.gov/vrdr_id",
    "value" : "2024001621"
  },
  "type" : "document",
  "timestamp" : "2024-07-01T14:48:35.401641-04:00",
  "entry" : [
    {
      "fullUrl" : "http://www.example.org/fhir/Composition/DeathCertificate-pandemnicIPS-example-patient-1",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "DeathCertificate-pandemnicIPS-example-patient-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-certificate"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_DeathCertificate-pandemnicIPS-example-patient-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition DeathCertificate-pandemnicIPS-example-patient-1</b></p><a name=\"DeathCertificate-pandemnicIPS-example-patient-1\"> </a><a name=\"hcDeathCertificate-pandemnicIPS-example-patient-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-death-certificate.html\">Death Certificate</a></p></div><p><b>Filing Format</b>: <span title=\"Codes:{http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-filing-format-cs electronic}\">Electronic</span></p><p><b>Replacement Status of a Death Record (deprecated)</b>: <span title=\"Codes:{http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-replace-status-cs original}\">original record</span></p><p><b>State Specific Field</b>: State Specific Content</p><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 64297-5}\">Death certificate</span></p><p><b>date</b>: 2024-07-01 00:00:00+0000</p><p><b>author</b>: <a href=\"Bundle-e817cefe-a7c4-487a-8116-be23cf865f3f.html#Practitioner_Certifier-Example1\">Practitioner Jim Black (official)</a></p><p><b>title</b>: Death Certificate</p><h3>Attesters</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Mode</b></td><td><b>Time</b></td><td><b>Party</b></td></tr><tr><td style=\"display: none\">*</td><td>Legal</td><td>2024-07-21 16:39:40-0500</td><td><a href=\"Bundle-e817cefe-a7c4-487a-8116-be23cf865f3f.html#Practitioner_Certifier-Example1\">Practitioner Jim Black (official)</a></td></tr></table><h3>Events</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Detail</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://snomed.info/sct 307930005}\">Death certificate (record artifact)</span></td><td><a href=\"Bundle-e817cefe-a7c4-487a-8116-be23cf865f3f.html#Procedure_DeathCertification-Example1\">Procedure Death certification</a></td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/vrdr/StructureDefinition/FilingFormat",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-filing-format-cs",
                  "code" : "electronic"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.org/fhir/us/vrdr/StructureDefinition/ReplaceStatus",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-replace-status-cs",
                  "code" : "original"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.org/fhir/us/vrdr/StructureDefinition/StateSpecificField",
            "valueString" : "State Specific Content"
          }
        ],
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "64297-5",
              "display" : "Death certificate"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "date" : "2024-07-01T00:00:00Z",
        "author" : [
          {
            "reference" : "Practitioner/Certifier-Example1"
          }
        ],
        "title" : "Death Certificate",
        "attester" : [
          {
            "mode" : "legal",
            "time" : "2024-07-21T16:39:40-05:00",
            "party" : {
              "reference" : "Practitioner/Certifier-Example1"
            }
          }
        ],
        "event" : [
          {
            "code" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "307930005",
                    "display" : "Death certificate (record artifact)"
                  }
                ]
              }
            ],
            "detail" : [
              {
                "reference" : "Procedure/DeathCertification-Example1"
              }
            ]
          }
        ],
        "section" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code" : "DecedentDemographics"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
              },
              {
                "reference" : "RelatedPerson/DecedentFather-Example1"
              },
              {
                "reference" : "RelatedPerson/DecedentMother-Example1"
              },
              {
                "reference" : "RelatedPerson/DecedentSpouse-Example1"
              },
              {
                "reference" : "Observation/DecedentAge-Example1"
              },
              {
                "reference" : "Observation/DecedentUsualWork-Example1"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code" : "DeathInvestigation"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Observation/DecedentPregnancyStatus-Example1"
              },
              {
                "reference" : "Observation/DeathDate-Example2"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code" : "DeathCertification"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Practitioner/Certifier-Example1"
              },
              {
                "reference" : "Procedure/DeathCertification-Example1"
              },
              {
                "reference" : "Observation/MannerOfDeath-Example1"
              },
              {
                "reference" : "Observation/CauseOfDeathPart1-Example1"
              },
              {
                "reference" : "Observation/CauseOfDeathPart1-Example2"
              },
              {
                "reference" : "Observation/CauseOfDeathPart2-Example1"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code" : "DecedentDisposition"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Location/DispositionLocation-Example1"
              },
              {
                "reference" : "Organization/FuneralHome-Example1"
              },
              {
                "reference" : "Observation/DecedentDispositionMethod-Example1"
              },
              {
                "reference" : "Practitioner/Mortician-Example1"
              }
            ]
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-document-section-cs",
                  "code" : "CodedContent"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Observation/ActivityAtTimeOfDeath-Example1"
              },
              {
                "reference" : "Observation/PlaceOfInjury-Example1"
              },
              {
                "reference" : "Observation/CodedRaceAndEthnicity-Example1"
              },
              {
                "reference" : "Observation/ManualUnderlyingCauseOfDeath-Example1"
              },
              {
                "reference" : "Observation/AutomatedUnderlyingCauseOfDeath-Example1"
              },
              {
                "reference" : "Observation/RecordAxisCauseOfDeath-Example1"
              },
              {
                "reference" : "Observation/EntityAxisCauseOfDeath-Example1"
              },
              {
                "reference" : "Parameters/CodingStatusValues-Example1"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Patient/Ex-Patient-1-for-secondaryUse-pandemnicIPS-stage-1",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "39c9964c-96b7-442d-afc1-2702106a9e57",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Patient-uv-ips",
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-decedent"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_39c9964c-96b7-442d-afc1-2702106a9e57\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 39c9964c-96b7-442d-afc1-2702106a9e57</b></p><a name=\"39c9964c-96b7-442d-afc1-2702106a9e57\"> </a><a name=\"hc39c9964c-96b7-442d-afc1-2702106a9e57\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profiles: <a href=\"http://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Patient-uv-ips.html\">Patient (IPS)</a>, <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-decedent.html\">Decedent</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Known Marital status of Patient\">Marital Status:</td><td colspan=\"3\"><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-MaritalStatus S}\">Never Married</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\">5590 Lockwood Drive Danville VA US </td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Nominated Contact: Unknown\">Unknown:</td><td colspan=\"3\"><ul><li>Joe Smith</li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Sex on visual inspection at the time of death by the funeral home\"><a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-NVSS-SexAtDeath.html\">NVSS SexAtDeath</a></td><td colspan=\"3\"><span title=\"Codes:{http://hl7.org/fhir/administrative-gender F}\">Female</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Spouse is Alive.\"><a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-SpouseAlive.html\">Spouse Is Alive</a></td><td colspan=\"3\"><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v2-0136 Y}\">Yes</span></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The registered place of birth of the patient. A sytem may use the address.text if they don't store the birthPlace address in discrete elements.\"><a href=\"http://hl7.org/fhir/extensions/5.2.0/StructureDefinition-patient-birthPlace.html\">Patient Birth Place</a></td><td colspan=\"3\">Roanoke VA US </td></tr></table></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/vrdr/StructureDefinition/SpouseAlive",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                  "code" : "Y"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.org/fhir/us/vrdr/StructureDefinition/NVSS-SexAtDeath",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/administrative-gender",
                  "code" : "F",
                  "display" : "Female"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-birthPlace",
            "valueAddress" : {
              "city" : "Roanoke",
              "state" : "VA",
              "country" : "US"
            }
          }
        ],
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "SB",
                  "display" : "Social Beneficiary Identifier"
                }
              ]
            },
            "system" : "http://hl7.org/fhir/sid/us-ssn",
            "value" : "123456789"
          }
        ],
        "name" : [
          {
            "use" : "official",
            "family" : "Patricia",
            "given" : ["Jordana"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1996-08-16",
        "address" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/vr-common-library/StructureDefinition/Extension-within-city-limits-indicator-vr",
                "valueCoding" : {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0136",
                  "code" : "Y",
                  "display" : "Yes"
                }
              },
              {
                "url" : "http://hl7.org/fhir/us/vr-common-library/StructureDefinition/StreetName",
                "valueString" : "Lockwood"
              }
            ],
            "line" : ["5590 Lockwood Drive"],
            "city" : "Danville",
            "_city" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/us/vr-common-library/StructureDefinition/CityCode",
                  "valuePositiveInt" : 1234
                }
              ]
            },
            "district" : "Fairfax",
            "_district" : {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/us/vr-common-library/StructureDefinition/DistrictCode",
                  "valuePositiveInt" : 321
                }
              ]
            },
            "state" : "VA",
            "country" : "US"
          }
        ],
        "maritalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
              "code" : "S",
              "display" : "Never Married"
            }
          ]
        },
        "contact" : [
          {
            "relationship" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
                    "code" : "U"
                  }
                ],
                "text" : "Friend of family"
              }
            ],
            "name" : {
              "text" : "Joe Smith"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/RelatedPerson/DecedentFather-Example1",
      "resource" : {
        "resourceType" : "RelatedPerson",
        "id" : "DecedentFather-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-decedent-father"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"RelatedPerson_DecedentFather-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: RelatedPerson DecedentFather-Example1</b></p><a name=\"DecedentFather-Example1\"> </a><a name=\"hcDecedentFather-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-decedent-father.html\">Decedent Father</a></p></div><p><b>active</b>: true</p><p><b>patient</b>: <a href=\"Patient-39c9964c-96b7-442d-afc1-2702106a9e57.html\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</a></p><p><b>relationship</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-RoleCode FTH}\">father</span></p><p><b>name</b>: Decedent Dad(Official)</p></div>"
        },
        "active" : true,
        "patient" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "relationship" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
                "code" : "FTH"
              }
            ]
          }
        ],
        "name" : [
          {
            "use" : "official",
            "text" : "Decedent Dad",
            "family" : "Smith",
            "given" : ["John"],
            "suffix" : ["Sr"]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/RelatedPerson/DecedentMother-Example1",
      "resource" : {
        "resourceType" : "RelatedPerson",
        "id" : "DecedentMother-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-decedent-mother"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"RelatedPerson_DecedentMother-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: RelatedPerson DecedentMother-Example1</b></p><a name=\"DecedentMother-Example1\"> </a><a name=\"hcDecedentMother-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-decedent-mother.html\">Decedent Mother</a></p></div><p><b>active</b>: true</p><p><b>patient</b>: <a href=\"Patient-39c9964c-96b7-442d-afc1-2702106a9e57.html\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</a></p><p><b>relationship</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-RoleCode MTH}\">mother</span></p><p><b>name</b>: Decedent Mom(Name changed for Marriage)</p></div>"
        },
        "active" : true,
        "patient" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "relationship" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
                "code" : "MTH"
              }
            ]
          }
        ],
        "name" : [
          {
            "use" : "maiden",
            "text" : "Decedent Mom",
            "family" : "Suzette",
            "given" : ["Jane"]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/RelatedPerson/DecedentSpouse-Example1",
      "resource" : {
        "resourceType" : "RelatedPerson",
        "id" : "DecedentSpouse-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-decedent-spouse"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"RelatedPerson_DecedentSpouse-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: RelatedPerson DecedentSpouse-Example1</b></p><a name=\"DecedentSpouse-Example1\"> </a><a name=\"hcDecedentSpouse-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-decedent-spouse.html\">Decedent Spouse</a></p></div><p><b>active</b>: true</p><p><b>patient</b>: <a href=\"Patient-39c9964c-96b7-442d-afc1-2702106a9e57.html\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</a></p><p><b>relationship</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-RoleCode SPS}\">spouse</span></p><p><b>name</b>: Decedent Spouse(Name changed for Marriage)</p></div>"
        },
        "active" : true,
        "patient" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "relationship" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
                "code" : "SPS"
              }
            ]
          }
        ],
        "name" : [
          {
            "use" : "maiden",
            "text" : "Decedent Spouse",
            "family" : "Gazette",
            "given" : ["Samuel"],
            "suffix" : ["III"]
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Observation/DecedentAge-Example1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "DecedentAge-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-decedent-age"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_DecedentAge-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation DecedentAge-Example1</b></p><a name=\"DecedentAge-Example1\"> </a><a name=\"hcDecedentAge-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-decedent-age.html\">Decedent Age</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 39016-1}\">Age at death</span></p><p><b>subject</b>: <a href=\"Patient-39c9964c-96b7-442d-afc1-2702106a9e57.html\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</a></p><p><b>value</b>: 29 years<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codea = 'a')</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "39016-1"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "valueQuantity" : {
          "value" : 29,
          "unit" : "years",
          "system" : "http://unitsofmeasure.org",
          "code" : "a"
        }
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Observation/DecedentUsualWork-Example1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "DecedentUsualWork-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-decedent-usual-work"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_DecedentUsualWork-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation DecedentUsualWork-Example1</b></p><a name=\"DecedentUsualWork-Example1\"> </a><a name=\"hcDecedentUsualWork-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-decedent-usual-work.html\">Decedent Usual Work</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 21843-8}\">History of Usual occupation</span></p><p><b>subject</b>: <a href=\"Patient-39c9964c-96b7-442d-afc1-2702106a9e57.html\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</a></p><p><b>value</b>: <span title=\"Codes:{https://profiles.ihe.net/PCC/ODH/CodeSystem/ISCO08 5321}\">Health Care Assistants</span></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://loinc.org 86188-0}\">History of Occupation Industry</span></td><td><span title=\"Codes:{https://profiles.ihe.net/PCC/ODH/CodeSystem/ISICRev4 871}\">Residential nursing care facilities</span></td></tr></table></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "21843-8"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://profiles.ihe.net/PCC/ODH/CodeSystem/ISCO08",
              "code" : "5321",
              "display" : "Health Care Assistants"
            }
          ]
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "86188-0",
                  "display" : "History of Occupation Industry"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "https://profiles.ihe.net/PCC/ODH/CodeSystem/ISICRev4",
                  "code" : "871",
                  "display" : "Residential nursing care facilities"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Observation/DecedentPregnancyStatus-Example1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "DecedentPregnancyStatus-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-decedent-pregnancy-status"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_DecedentPregnancyStatus-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation DecedentPregnancyStatus-Example1</b></p><a name=\"DecedentPregnancyStatus-Example1\"> </a><a name=\"hcDecedentPregnancyStatus-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-decedent-pregnancy-status.html\">Decedent Pregnancy</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69442-2}\">Timing of recent pregnancy in relation to death</span></p><p><b>subject</b>: <a href=\"Patient-39c9964c-96b7-442d-afc1-2702106a9e57.html\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</a></p><p><b>value</b>: <span title=\"Codes:{http://hl7.org/fhir/us/vrdr/CodeSystem/CodeSystem-death-pregnancy-status 2}\">Pregnant at time of death</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69442-2"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/CodeSystem-death-pregnancy-status",
              "code" : "2",
              "display" : "Pregnant at time of death"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Observation/DeathDate-Example2",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "DeathDate-Example2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-date"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_DeathDate-Example2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation DeathDate-Example2</b></p><a name=\"DeathDate-Example2\"> </a><a name=\"hcDeathDate-Example2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-death-date.html\">Death Date</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 81956-5}\">Date and time of death [TimeStamp]</span></p><p><b>subject</b>: <a href=\"Patient-39c9964c-96b7-442d-afc1-2702106a9e57.html\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</a></p><p><b>effective</b>: 2024-06-30 16:39:40-0500</p><p><b>performer</b>: <a href=\"Bundle-e817cefe-a7c4-487a-8116-be23cf865f3f.html#Practitioner_Pronouncer-Example1\">Practitioner Jane Purple (official)</a></p><p><b>value</b>: <code>Partial Date Time Vital Records: </code></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 80616-6}\">Date and time pronounced dead [US Standard Certificate of Death]</span></p><p><b>value</b>: 2024-06-30 16:39:40-0500</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 58332-8}\">Location of death</span></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 440081000124100}\">Death in home</span></p></blockquote></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "81956-5"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "effectiveDateTime" : "2024-06-30T16:39:40-05:00",
        "performer" : [
          {
            "reference" : "Practitioner/Pronouncer-Example1"
          }
        ],
        "_valueDateTime" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "day",
                  "_valueUnsignedInt" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
                        "valueCode" : "unknown"
                      }
                    ]
                  }
                },
                {
                  "url" : "year",
                  "valueUnsignedInt" : 2024
                },
                {
                  "url" : "month",
                  "valueUnsignedInt" : 6
                },
                {
                  "url" : "time",
                  "valueTime" : "12:13:14",
                  "_valueTime" : {
                    "extension" : [
                      {
                        "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
                        "valueCode" : "unknown"
                      }
                    ]
                  }
                }
              ],
              "url" : "http://hl7.org/fhir/us/vr-common-library/StructureDefinition/Extension-partial-date-time-vr"
            }
          ]
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "80616-6"
                }
              ]
            },
            "valueDateTime" : "2024-06-30T16:39:40-05:00"
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "58332-8"
                }
              ]
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "440081000124100",
                  "display" : "Death in home"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Practitioner/Pronouncer-Example1",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "Pronouncer-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_Pronouncer-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner Pronouncer-Example1</b></p><a name=\"Pronouncer-Example1\"> </a><a name=\"hcPronouncer-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/core/STU5.0.1/StructureDefinition-us-core-practitioner.html\">US Core Practitioner Profile</a></p></div><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/5.0.0/NamingSystem-npi.html\" title=\"National Provider Identifier\">NPI</a>/9941339101</p><p><b>name</b>: Jane Purple (Official)</p><p><b>address</b>: 44 South Street Rockville MD 20854 US </p></div>"
        },
        "identifier" : [
          {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "9941339101"
          }
        ],
        "name" : [
          {
            "use" : "official",
            "family" : "Purple",
            "given" : ["Jane"]
          }
        ],
        "address" : [
          {
            "line" : ["44 South Street"],
            "city" : "Rockville",
            "state" : "MD",
            "postalCode" : "20854",
            "country" : "US"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Observation/MannerOfDeath-Example1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "MannerOfDeath-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-manner-of-death"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_MannerOfDeath-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation MannerOfDeath-Example1</b></p><a name=\"MannerOfDeath-Example1\"> </a><a name=\"hcMannerOfDeath-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-manner-of-death.html\">Manner of Death</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69449-7}\">Manner of death</span></p><p><b>subject</b>: <a href=\"Patient-39c9964c-96b7-442d-afc1-2702106a9e57.html\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</a></p><p><b>performer</b>: <a href=\"Bundle-e817cefe-a7c4-487a-8116-be23cf865f3f.html#Practitioner_Certifier-Example1\">Practitioner Jim Black (official)</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 38605008}\">Natural death</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69449-7"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "performer" : [
          {
            "reference" : "Practitioner/Certifier-Example1"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "38605008",
              "display" : "Natural death"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Practitioner/Certifier-Example1",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "Certifier-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-certifier"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_Certifier-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner Certifier-Example1</b></p><a name=\"Certifier-Example1\"> </a><a name=\"hcCertifier-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-certifier.html\">Death Certifier</a></p></div><p><b>Practitioner Role</b>: Certifier</p><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/5.0.0/NamingSystem-npi.html\" title=\"National Provider Identifier\">NPI</a>/9941339100</p><p><b>name</b>: Jim Black (Official)</p><p><b>address</b>: 44 South Street Bird in Hand PA 17505 US </p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/vrdr/StructureDefinition/practitioner-role",
            "valueCode" : "Certifier"
          }
        ],
        "identifier" : [
          {
            "system" : "http://hl7.org/fhir/sid/us-npi",
            "value" : "9941339100"
          }
        ],
        "name" : [
          {
            "use" : "official",
            "family" : "Black",
            "given" : ["Jim"]
          }
        ],
        "address" : [
          {
            "line" : ["44 South Street"],
            "city" : "Bird in Hand",
            "state" : "PA",
            "postalCode" : "17505",
            "country" : "US"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Procedure/DeathCertification-Example1",
      "resource" : {
        "resourceType" : "Procedure",
        "id" : "DeathCertification-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-death-certification"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Procedure_DeathCertification-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Procedure DeathCertification-Example1</b></p><a name=\"DeathCertification-Example1\"> </a><a name=\"hcDeathCertification-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-death-certification.html\">Death Certification Procedure</a></p></div><p><b>identifier</b>: 180</p><p><b>status</b>: Completed</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 308646001}\">Death certification</span></p><p><b>subject</b>: <a href=\"Patient-39c9964c-96b7-442d-afc1-2702106a9e57.html\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</a></p><p><b>performed</b>: 2024-01-21 16:39:40-0500</p><h3>Performers</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Function</b></td><td><b>Actor</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-NullFlavor OTH}\">Nurse Practitioner</span></td><td><a href=\"Bundle-e817cefe-a7c4-487a-8116-be23cf865f3f.html#Practitioner_Certifier-Example1\">Practitioner Jim Black (official)</a></td></tr></table></div>"
        },
        "identifier" : [
          {
            "value" : "180"
          }
        ],
        "status" : "completed",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "308646001",
              "display" : "Death certification"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "performedDateTime" : "2024-01-21T16:39:40-05:00",
        "performer" : [
          {
            "function" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-NullFlavor",
                  "code" : "OTH",
                  "display" : "Other"
                }
              ],
              "text" : "Nurse Practitioner"
            },
            "actor" : {
              "reference" : "Practitioner/Certifier-Example1"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Observation/CauseOfDeathPart1-Example1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "CauseOfDeathPart1-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-cause-of-death-part1"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_CauseOfDeathPart1-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation CauseOfDeathPart1-Example1</b></p><a name=\"CauseOfDeathPart1-Example1\"> </a><a name=\"hcCauseOfDeathPart1-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-cause-of-death-part1.html\">Cause Of Death Part 1</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69453-9}\">Cause of death [US Standard Certificate of Death]</span></p><p><b>subject</b>: <a href=\"Patient-39c9964c-96b7-442d-afc1-2702106a9e57.html\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</a></p><p><b>performer</b>: <a href=\"Bundle-e817cefe-a7c4-487a-8116-be23cf865f3f.html#Practitioner_Certifier-Example1\">Practitioner Jim Black (official)</a></p><p><b>value</b>: <span title=\"Codes:\">Covid-19</span></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-component-cs lineNumber}\">line number</span></p><p><b>value</b>: 1</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69440-6}\">Disease onset to death interval</span></p><p><b>value</b>: 4 hours</p></blockquote></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69453-9"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "performer" : [
          {
            "reference" : "Practitioner/Certifier-Example1"
          }
        ],
        "valueCodeableConcept" : {
          "text" : "Covid-19"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-component-cs",
                  "code" : "lineNumber"
                }
              ]
            },
            "valueInteger" : 1
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69440-6"
                }
              ]
            },
            "valueString" : "4 hours"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Observation/CauseOfDeathPart1-Example2",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "CauseOfDeathPart1-Example2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-cause-of-death-part1"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_CauseOfDeathPart1-Example2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation CauseOfDeathPart1-Example2</b></p><a name=\"CauseOfDeathPart1-Example2\"> </a><a name=\"hcCauseOfDeathPart1-Example2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-cause-of-death-part1.html\">Cause Of Death Part 1</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69453-9}\">Cause of death [US Standard Certificate of Death]</span></p><p><b>subject</b>: <a href=\"Patient-39c9964c-96b7-442d-afc1-2702106a9e57.html\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</a></p><p><b>performer</b>: <a href=\"Bundle-e817cefe-a7c4-487a-8116-be23cf865f3f.html#Practitioner_Certifier-Example1\">Practitioner Jim Black (official)</a></p><p><b>value</b>: <span title=\"Codes:\">Eclampsia</span></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-component-cs lineNumber}\">line number</span></p><p><b>value</b>: 2</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69440-6}\">Disease onset to death interval</span></p><p><b>value</b>: 3 months</p></blockquote></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69453-9"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "performer" : [
          {
            "reference" : "Practitioner/Certifier-Example1"
          }
        ],
        "valueCodeableConcept" : {
          "text" : "Eclampsia"
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-component-cs",
                  "code" : "lineNumber"
                }
              ]
            },
            "valueInteger" : 2
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "69440-6"
                }
              ]
            },
            "valueString" : "3 months"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Observation/CauseOfDeathPart2-Example1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "CauseOfDeathPart2-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-cause-of-death-part2"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_CauseOfDeathPart2-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation CauseOfDeathPart2-Example1</b></p><a name=\"CauseOfDeathPart2-Example1\"> </a><a name=\"hcCauseOfDeathPart2-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-cause-of-death-part2.html\">Cause of Death Part 2</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 69441-4}\">Other significant causes or conditions of death</span></p><p><b>subject</b>: <a href=\"Patient-39c9964c-96b7-442d-afc1-2702106a9e57.html\">Jordana Patricia (official) Female, DoB: 1996-08-16 ( Social Beneficiary Identifier: SSN#123456789)</a></p><p><b>performer</b>: <a href=\"Bundle-e817cefe-a7c4-487a-8116-be23cf865f3f.html#Practitioner_Certifier-Example1\">Practitioner Jim Black (official)</a></p><p><b>value</b>: <span title=\"Codes:\">hypertensive heart disease</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "69441-4"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/39c9964c-96b7-442d-afc1-2702106a9e57"
        },
        "performer" : [
          {
            "reference" : "Practitioner/Certifier-Example1"
          }
        ],
        "valueCodeableConcept" : {
          "text" : "hypertensive heart disease"
        }
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Location/DispositionLocation-Example1",
      "resource" : {
        "resourceType" : "Location",
        "id" : "DispositionLocation-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-disposition-location"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Location_DispositionLocation-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Location DispositionLocation-Example1</b></p><a name=\"DispositionLocation-Example1\"> </a><a name=\"hcDispositionLocation-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-disposition-location.html\">Disposition Location</a></p></div><p><b>name</b>: Rosewood Cemetary</p><p><b>type</b>: <span title=\"Codes:{http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-location-type-cs disposition}\">Disposition Location</span></p><p><b>address</b>: 303 Rosewood Ave Danville VA 24541 US </p><p><b>physicalType</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/location-physical-type si}\">Site</span></p></div>"
        },
        "name" : "Rosewood Cemetary",
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-location-type-cs",
                "code" : "disposition"
              }
            ]
          }
        ],
        "address" : {
          "line" : ["303 Rosewood Ave"],
          "city" : "Danville",
          "state" : "VA",
          "postalCode" : "24541",
          "country" : "US"
        },
        "physicalType" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/location-physical-type",
              "code" : "si",
              "display" : "Site"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Observation/RecordAxisCauseOfDeath-Example1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "RecordAxisCauseOfDeath-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-record-axis-cause-of-death"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_RecordAxisCauseOfDeath-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation RecordAxisCauseOfDeath-Example1</b></p><a name=\"RecordAxisCauseOfDeath-Example1\"> </a><a name=\"hcRecordAxisCauseOfDeath-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-record-axis-cause-of-death.html\">Record Axis Cause Of Death</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 80357-7}\">Cause of death record axis code [Automated]</span></p><p><b>subject</b>: NCHS generated</p><p><b>value</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10 U07.1}\">COVID-19</span></p><h3>Components</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-component-cs position}\">position</span></td><td>1</td></tr></table></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "80357-7"
            }
          ]
        },
        "subject" : {
          "display" : "NCHS generated"
        },
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10",
              "code" : "U07.1",
              "display" : "COVID-19"
            }
          ]
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-component-cs",
                  "code" : "position"
                }
              ]
            },
            "valueInteger" : 1
          }
        ]
      }
    },
    {
      "fullUrl" : "http://www.example.org/fhir/Observation/EntityAxisCauseOfDeath-Example1",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "EntityAxisCauseOfDeath-Example1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/vrdr/StructureDefinition/vrdr-entity-axis-cause-of-death"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_EntityAxisCauseOfDeath-Example1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation EntityAxisCauseOfDeath-Example1</b></p><a name=\"EntityAxisCauseOfDeath-Example1\"> </a><a name=\"hcEntityAxisCauseOfDeath-Example1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/vrdr/STU3/StructureDefinition-vrdr-entity-axis-cause-of-death.html\">Entity Axis Cause Of Death</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 80356-9}\">Cause of death entity axis code [Automated]</span></p><p><b>subject</b>: NCHS generated</p><p><b>value</b>: <span title=\"Codes:{http://hl7.org/fhir/sid/icd-10 U07.1}\">COVID-19</span></p><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-component-cs lineNumber}\">line number</span></p><p><b>value</b>: 1</p></blockquote><blockquote><p><b>component</b></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-component-cs position}\">position</span></p><p><b>value</b>: 1</p></blockquote></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "80356-9"
            }
          ]
        },
        "subject" : {
          "display" : "NCHS generated"
        },
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10",
              "code" : "U07.1",
              "display" : "COVID-19"
            }
          ]
        },
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-component-cs",
                  "code" : "lineNumber"
                }
              ]
            },
            "valueInteger" : 1
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/vrdr/CodeSystem/vrdr-component-cs",
                  "code" : "position"
                }
              ]
            },
            "valueInteger" : 1
          }
        ]
      }
    }
  ]
}

```
