# Download and Analysis - De-Identification Profile v0.0.1-current

* [**Table of Contents**](toc.md)
* **Download and Analysis**

## Download and Analysis

You can also download:

* [this entire guide](full-ig.zip),
* the definition resources in [json](definitions.json.zip), [xml](definitions.xml.zip), or [ttl](definitions.ttl.zip)
* the example resources in [json](examples.json.zip), [xml](examples.xml.zip) or [ttl](examples.ttl.zip) format.

The source code for this Implementation Guide can be found on [IHE ITI DeIdentification Handbook Github Repo](https://github.com/IHE/ITI.DeIdHandbook)

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (ihe.iti.deid.r4)](package.r4.tgz) and [R4B (ihe.iti.deid.r4b)](package.r4b.tgz) are available.

#### Dependency Table




#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright © 2011 by the National Electrical Manufacturers Association.

* [DICOM Controlled Terminology Definitions](http://hl7.org/fhir/R4/codesystem-dicom-dcim.html): [AuditEvent/ex-auditDeIdentification-source](AuditEvent-ex-auditDeIdentification-source.md), [AuditEvent/ex-auditReIdentification-source](AuditEvent-ex-auditReIdentification-source.md) and [AuditPrivacyDeIdentificationSource](StructureDefinition-IHE.BasicAudit.DeIdentification.Source.md)


* These codes are excerpted from ISO Standard, TS 21089-2017 - Health Informatics - Trusted End-to-End Information Flows, Copyright by ISO International. Copies of this standard are available through the ISO Web Site at www.iso.org.

* [ISO 21089 2017 Health Record Lifecycle Events](http://terminology.hl7.org/6.5.0/CodeSystem-iso-21089-lifecycle.html): [AuditEvent/ex-auditDeIdentification-source](AuditEvent-ex-auditDeIdentification-source.md), [AuditEvent/ex-auditReIdentification-source](AuditEvent-ex-auditReIdentification-source.md), [AuditEventSubtypeDeidentify](ValueSet-IHE.BasicAudit.DeIdentification.Subtype.md) and [AuditPrivacyDeIdentificationSource](StructureDefinition-IHE.BasicAudit.DeIdentification.Source.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [AuditEvent/ex-auditDeIdentification-source](AuditEvent-ex-auditDeIdentification-source.md) and [AuditPrivacyDeIdentificationSource](StructureDefinition-IHE.BasicAudit.DeIdentification.Source.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Audit event entity type](http://terminology.hl7.org/6.5.0/CodeSystem-audit-entity-type.html): [AuditEvent/ex-auditDeIdentification-source](AuditEvent-ex-auditDeIdentification-source.md), [AuditEvent/ex-auditReIdentification-source](AuditEvent-ex-auditReIdentification-source.md) and [AuditPrivacyDeIdentificationSource](StructureDefinition-IHE.BasicAudit.DeIdentification.Source.md)
* [AuditEventEntityRole](http://terminology.hl7.org/6.5.0/CodeSystem-object-role.html): [AuditEvent/ex-auditDeIdentification-source](AuditEvent-ex-auditDeIdentification-source.md), [AuditEvent/ex-auditReIdentification-source](AuditEvent-ex-auditReIdentification-source.md) and [AuditPrivacyDeIdentificationSource](StructureDefinition-IHE.BasicAudit.DeIdentification.Source.md)
* [Audit Event Source Type](http://terminology.hl7.org/6.5.0/CodeSystem-security-source-type.html): [AuditEvent/ex-auditDeIdentification-source](AuditEvent-ex-auditDeIdentification-source.md) and [AuditEvent/ex-auditReIdentification-source](AuditEvent-ex-auditReIdentification-source.md)
* [ActReason](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html): [AuditEvent/ex-auditDeIdentification-source](AuditEvent-ex-auditDeIdentification-source.md) and [AuditEvent/ex-auditReIdentification-source](AuditEvent-ex-auditReIdentification-source.md)


