# De-Identification Handbook Home - De-Identification Profile v0.0.1-current

* [**Table of Contents**](toc.md)
* **De-Identification Handbook Home**

## De-Identification Handbook Home

| | |
| :--- | :--- |
| *Official URL*:https://profiles.ihe.net/ITI/DeId/ImplementationGuide/ihe.iti.deid | *Version*:0.0.1-current |
| Draft as of 2026-01-07 | *Computable Name*:IHE_ITI_DeId |

This handbook explains the PROCESS for removing individually identifiable information from healthcare data. This includes de-identification, pseudonymization, re-linking, design considerations, techniques, and risks. The intended audience is IHE Profile editors and healthcare information technology implementers needing a guide for designing and implementing de-identification systems.

| |
| :--- |
| [Significant Changes, Open and Closed Issues](issues.md) |

### Organization of This Guide

This guide is organized into the following sections:

1. [Introduction to This Handbook](intro.md)
1. [Glossary](glossary.md)
1. [De-Identification, Pseudonymization, and Relinking](concepts.md)
* [Navigating the Complexity of Privacy Concepts](concepts.md#navigating-the-complexity-of-privacy-concepts)
* [Identifiability](concepts.md#identifiability)
* [Pseudonymization, De-Identification and Anonymization Explained](concepts.md#de-identification-pseudonymization-and-anonymization-explained)
* [Overall De-Identification Approach](concepts.md#overall-de-identification-approach)
* [Re-identification](concepts.md#re-identification)
* [Threats & Attacks](concepts.md#threats--attacks)

1. [Data Types](data-types.md)
1. [Techniques](algorithms.md)
* [Classification of de-identification techniques](algorithms.md#classification-of-de-identification-techniques)
* [De-Identifying Identifiers](algorithms.md#de-identifying-identifiers)
* [De-Identifying Sensitive Attributes](algorithms.md#de-identifying-identifiers)
* [Privacy Models](algorithms.md#privacy-models)

1. [Process](process.md)
* [Step 1 – Requirements Design](process.md#step-1--requirements-design)
* [Step 2 – De-identification Design](process.md#step-2--de-identification-design)
* [Step 3 – Design Validation](process.md#step-3--design-validation)
* [Step 4 – Implementation](process.md#step-4--implementation)
* [Step 5 – Implementation Validation](process.md#step-5--implementation-validation)
* [Step 6 – Periodic Review of Implementation](process.md#step-6--periodic-review-of-implementation)

1. [De-Identification and Pseudonymization for IHE Profile Editors](ihe-use.md)
1. [Security Considerations](security.md)
* [Design of De-Identification Algorithm](security.md#design-of-de-identification-algorithm)
* [Execution of De-Identification on Data](security.md#execution-of-de-identification-on-data)
* [ATNA and Other Logging Considerations](security.md#atna-and-other-logging-considerations)

1. Exemplar
* [FHIR Examples](fhir-example.md)
* [DICOM Examples](dicom-example.md)
* [HL7 2 Examples](hl7-example.md)
* [Family Planning](family-planning.md)

1. Other
* [Download and Analysis](download.md)
* [Significant Changes and Issues](issues.md)

1. [References](references.md)

See also the [Table of Contents](toc.md) and the index of [Artifacts](artifacts.md) defined as part of this implementation guide.

### Conformance Expectations

IHE uses the normative words: Shall, Should, and May according to [standards conventions](https://profiles.ihe.net/GeneralIntro/ch-E.html).

#### Must Support

The use of `mustSupport` in StructureDefinition profiles is equivalent to the IHE use of **R2** as defined in [Appendix Z](https://profiles.ihe.net/ITI/TF/Volume2/ch-Z.html#z.10-profiling-conventions-for-constraints-on-fhir).

`mustSupport` only has a meaning on items that are minimal cardinality of zero (0), and applies only to the source actor populating the data. The source actor shall populate the elements marked with MustSupport, if the concept is supported by the actor, a value exists, and security and consent rules permit. The consuming actors should handle these elements being populated or being absent/empty. Note that sometimes mustSupport will appear on elements with a minimal cardinality greater than zero (0), this is due to inheritance from a less constrained profile.

