# Guidance - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Guidance**

## Guidance

### Patient resource use cases

#### A new patient presents for healthcare.

A new patient presents for healthcare e.g. A casual patient books an appointment with GP, a new patient seeks to enrol at a GP, a patient presents at an Accident and Emergency department or afterhours clinic, a referral is received for a patient from a health provider. 
 This is a new patient not yet registered in the hospital or providers system.

* Steps involved: 
1. User searches the local system for patient.
1. User Adds the patient to the local system.
1. Local system searches the NHI for the patient[Match Patient.](/matchPatient.md)
1. User selects a record from the search results OR patient is not found in NHI and user adds new record to NHI[Create Patient.](/createPatient.md)
1. User compares the local and NHI details, confirms with the patient and makes corrections where appropriate using an**Update operation**(see appropriate use case).
1. System assigns NHI number and version to local record.
 

#### A returning patient presents for healthcare.

An existing patient known to the hospital or GP practice presents for healthcare e.g. Enrolled patient books or attends an appointment, a patient presents for an outpatient appointment, a patient presents for planned admission. 
 The patient details are already in the local system and an NHI number and version have previously been assigned.

* Steps involved: 
1. User finds the patient record in local system.
1. Local system looks up NHI to check if NHI version has changed[Get Patient.](/getPatient.md)
1. If NHI version has changed but the local attributes are still in line wth the NHI (the data of interest hasn't changed) update the local version only.
* Note: The version will change if Te Whatu Ora has linked two NHI records when duplicates have been discovered. The local system should use the live and the list of dormant NHI's to determine if any local records need to be merged. If the local system has their patient under a now dormant NHI number, the local NHI number should be changed to the live NHI number.

1. If an NHI patient attribute has changed or the local patient details have been updated, the user compares the local and NHI details and makes corrections where appropriate using an**Update operation**(see appropriate use case).

 

#### A notification is received that patient details have changed.

Information is received by the hospital or provider that patient information has changed. This may be a Notification from National enrolment service that the patient has died, the patient may contact the hospital or provider to provide a new address (Future notification service).

* Steps involved: 
1. Receive a notification of patient record change e.g. Death of patient.
1. Find patient in the local system.
1. Get the patient’s details from the NHI[Get Patient.](/getPatient.md)
1. Compare local with NHI and update as required using an**Update operation**(see appropriate use case).

 

#### A provider notices a discrepancy between local and NHI record, but does not have update access.

* Steps involved: 
1. Find patient in local system.
1. Read the patients file from the NHI[Get Patient.](/getPatient.md)
1. Confirm the record belongs to the patient.
1. Notice discrepancy between local and NHI record.
1. Contact the Te Whatu Ora contact centre (0800 855 066) so discrepancy can be updated.
 

#### A user needs to validate an NHI number.

I don't have access rights to view the NHI details. I want to validate the NHI number and the demographic details I have match the NHI patient details.

* Steps involved: 
1. Find patient in local system.
1. Validate Patient NHI number and Patient details[Validate Patient.](/validatePatient.md)
1. The NHI will return a bundle with an nhi-id if a validation has been successful. An empty bundle will be returned if unsuccessful.
 

#### Look up the patient's enrolled General Practice (GP)

* This use case requires permission to access a Patients NES enrollment information
* Steps involved:

#### Look up patient's contact details

* This use case requires permission to access the Patient Preferences information
* Steps involved:

### Multi-resource use cases

#### Lookup EDI for an enrolled patient’s General Practice

* This use case requires permission to access NES enrollment and HPI facility information

Steps involved:

1. The user initiates searching for an EDI number for a patient’s General Practice
1. The integrating application sends a read request for the Patient Resource using the nhi-id to the NHI FHIR API E.g. GET<Endpoint>/Patient/ZZZ0008
1. The request is validated - ALT: Validation failure. OperationOutcome resource returned
1. The Patient resource (containing the Patients enrolled General Practice details) is returned from the HPI
1. The integrating application sends a read request for the Facility details (Location resource) using the hpi-facility-id to the HPI FHIR API E.g. GET<Endpoint>/Location/F99999B
1. The request is validated - ALT: Validation failure. OperationOutcome resource returned
1. The Location resource is returned from the HPI
1. The integrating application extracts the messaging address containing the EDI number for the GP clinic

