# Create Patient - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Create Patient**

## Create Patient

### Create Patient Overview

The ‘Create Patient’ operation is initiated by a user who needs to create a new identity record for a person not found on the NHI. 
 The user has sourced the required identity information, done a thorough search of the NHI, and initiates a request to create a new patient identity record in the NHI.

**Expectations**

* Prior to adding a new identity record to the NHI an authorised user must complete a thorough [search of the NHI](/matchPatient.md) to ensure the patient does not already exist.
* Duplicate NHI records will not be checked upfront, but will create a task for a potential duplicate to be resolved.
* If the Patient is found in the NHI, then an **update operation** is required (See use cases for available operations). If not found then a new identitiy record may be created.

#### NHI FHIR Create Patient processing steps:

1. The user initiates creating a new patient in the integrating application
1. The integrating application sends an HTTP POST request (a FHIR create) containing the Patient details E.g. Post<Endpoint>/Patient/$create
1. The request is validated - ALT: Validation failure. OperationOutcome resource returned
1. A Patient record is created and a Patient ID (nhi-id) is issued
1. The NHPI FHIR API confirms a successful update – HTTP 201 Created status code
1. The integrating application indicates to the user the create has been successful
1. The integrating application retains the nhi-id and version number for future requests relating to this record

### Create Patient - In Parameters 

* Parameter name: patient
  * Parameter type: patient
  * Mandatory / Optional: Mandatory
  * Description: [ See Create Patient Profile](StructureDefinition-CreateNhiPatient.md)[ See Create Patient Operation definition](OperationDefinition-Patient-create.md)

### Create Patient Example

For a create patient example [click here](createPatientExample.md)

### Create Patient rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

#### Create Patient rules

* A Create Patient request must not create an NHI record which is a duplicate of another Patient’s identity
* A Create Patient request must include a: 
* [preferred name](/StructureDefinition-NhiPatient-definitions.md#Patient.name),
* [birth date](/StructureDefinition-NhiPatient-definitions.md#Patient.birthDate),
* [gender](/StructureDefinition-NhiPatient-definitions.md#Patient.gender),
* [ethnicity](/StructureDefinition-NhiPatient-definitions.md#Patient.extension:ethnicity),
* NZ Citizenship status,
* [Primary residential address](/StructureDefinition-NhiPatient-definitions.md#Patient.address), and
* An information source for each of the following items if they are present; birthdate, country of birth, nz citizenship, deceased date, name. 
* Note: A status of registered can only be added by an authorised agency [See glossary for definitions](/glossary.md).
 
 
* A request must update the source of information only when the information is also provided (birthdate, country of birth, nz citizenship, deceased date, name).
* A Create Patient request may include a: 
* birthplace
* **deceased date - note: future scope**
 

-------

* **Create Patient errors** 
* **Name is required**
* **birth date is a required field**
* **Gender is a required field**
* **Ethnicity is required**
* **NZ Citizenship is required**
* **Address is required**
* **Information source is a required field (birthdate, country of birth, nz citizenship, deceased date, and name)**
* **A source of registered can only be updated by an authorised agency**
 

#### Create Patient - Name rules

* A Patient must have: 
* at least one Active Name
* one, and only one, Active Name which is preferred.
 
* A name must have: 
* a [family](/StructureDefinition-NhiPatient-definitions.md#Patient.name.family) at minimum.
* a [preferred name flag](/StructureDefinition-NhiPatient-definitions.md#Patient.name.extension:preferred) (set to true - for add patient only)
* an information source.
 
* A name may have: 
* prefix (title),
* a [given](/StructureDefinition-NhiPatient-definitions.md#Patient.name.given) or
* ‘other’ given name (1)
* use
* name-use-extra (baby-of and unallocated)
 
* A name cannot be added with a name use = usual, official or anonymous, old
* A name can only include: Alphas (A-Z or a-z), hypens(-), spaces, apostrophes (TBC)
* The first character of a name must be an Alpha (A-Z or a-z) or apostrophe
* A name field must include at least one Alpha (A-Z or a-z) character
* A request must not create a duplicate of an existing name
* [‘babyof and unallocated names’](/StructureDefinition-NhiPatient-definitions.md#Patient.name.extension:nhi-name-use-extra) must have: 
* source = NPRF
* name use = temp
* name-use-extra ('babyof' or 'unallocated').
 
* Unallocated names can only be set by an authorised agency
* A name field which is not null must contain at least one alphabetic character.
* A 'Legacy Name' must only be submitted via a legacy HL7 update request

-------

* **Create Patient - Name errors** 
* A Patient must have only one active Preferred Name
* **A Patient name must contain a Surname and a Name Type, a preferred name flag and an information source**
* **A Baby of name must have source = NPRF, name use = temp**
* **Unallocted names can only be set by an authorised Agency**
* **A Patient’s given name and surname must start with a letter of the alphabet or an apostrophe**
* **Each populated Patient Name field must contain at least one letter**
* **Patient Name must not contain special characters**
* **Name can only be set to a ‘Registered’ value by an authorised Agency**
* **A source of HL7 or MIGR can only be submitted by a legacy update**
 

#### Create Patient - Birthdate rules

* A [birth date](/StructureDefinition-NhiPatient-definitions.md#Patient.birthDate) must be after 1 January 1900 and not a future date
* A birthdate must be a complete date and formatted either: 
* YYYYMMDD - DOB less than or equal to the current date;
* YYYYMM – less than or equal to the current month and year;
* YYYY – less than or equal to the current year
 
* A request to populate the Date of Birth Information Source must also populate the Date of Birth
* A web service request must not add any birth and death information with a Status of Registered, i.e. Registered Date of Birth, Registered Date of Death, Registered Country of Birth

-------

* **Create Patient - Birthdate errors** 
* **Patient Birthdate must be after After 1 January 1900 AND cannot be a future date**
* **A patient Birthdate is required when a patient Birthdate information source is present**
* **Birthdate can only be set to a ‘Registered’ value by an authorised agency**
 

#### Create Patient - Ethnicity rules

* A Patient must have at least one active set of valid [ethnicity](/StructureDefinition-NhiPatient-definitions.md#Patient.extension:ethnicity) information.
* A Patient must supply all ethnicities identified with when supplying ethnicity information
* A set of ethnicity codes must contain at least 1 ethnicity, only one instance of each selected ethnicity, no more than one ‘unspecified’ (residual) ethnicity code and can contain up to 6 ethnicities.

-------

* **Create Patient - Ethnicity errors** 
* **A Patient must have at least one valid ethnicity code, only one instance of each selected ethnicity, and no more than one ‘unspecified’ ethnicity code**
 

#### Create Patient - NZ Citizenship rules

* A Patient must have a NZ citizenship status
* A request to populate the NZ Citizenship Information Source must also populate the NZ Citizenship status value

-------

* **Create Patient - NZ Citizenship errors** 
* **An NZ Citizenship status is required when an NZ Citizenship Information Source is present**
 

#### Create Patient - Birthplace rules

* A place of birth must only be populated if a country of birth is present
* A request to populate the Country of Birth Information Source must also populate the Country of Birth

-------

* **Create Patient - Birthplace errors** 
* **Country of birth is required when a place of birth is present**
* **A Country of birth is required when a Country of Birth Information Source is present**
 

#### Create Patient - Deceased date rules

* A deceased date can only be added by an authorised agency
* If present, a [deceased date](/StructureDefinition-NhiPatient-definitions.md#Patient.deceased[x]) must be on or after birthdate, and not a future date
* deceased date must be a complete date and formatted either; 
* YYYYMMDD - DOD less than or equal to the current date;
* YYYYMM – less than or equal to the current month and year;
* YYYY – less than or equal to the current year.
 
* A request to populate the Date of Death Information Source must also populate the Date of Death
* A web service request must not add any birth and death information with a Status of Registered, i.e. Registered Date of Birth, Registered Date of Death, Registered Country of Birth

-------

* **Create Patient - Deceased date errors** 
* **Patient Date of death cannot be a future date**
* **A patient Date of Death is required when a patient Date of Death information source is present**
* **Deceased date can only be set to ‘Registered’ by an authorised Agency**
* **The Date of Birth must be less than or equal to the Date of Death**
 

#### Create Patient - Gender Rules

* A Patient must have a current gender, supplied as a valid gender code.
* A Patient may have a gender-original-text response
* If supplied, both gender code and gender-original-text will be recorded in the NHI.

-------

* **Create Patient - Gender errors**

#### Create Patient - Address rules

* A Patient must have a single Primary Residential Address (type = physical)
* An acceptable Patient Address must be: 
* Validated by an Address Service; OR
* User Qualified with a NotValidatedAddressReason
 
* A Patient can have a maximum of one residential and one mailing address (1 x address type = physical and 1 x type = postal)
* A Validated Address must include: 
* a valid nz-address-id
* Address-line-1 (that matches the address-line-1 returned by eSAM)
* Address Type (physical or postal)
 
* A validated postal address, must be an address where mail can be delivered (must be eSAM deliverable).
* The result of an address service 'find address' request using the values provided for the first line of the Address Location must: 
* result in a single validated address with a match score exceeding the match threshold, AND
* have a unique nz-address-id matching the ID provided in the request
 
* A Validated Address may include: 
* address-building-name (this is additional to address data returned by eSAM)
 
* An unvalidated-address must include: 
* not-validated-address-reason
* address-type
* address-line-1
* [Enough address information](/updateAddress.md#future-functionality-for-domicile-code) for the domicile code and DHB to be derived, if not, a domicile code must be supplied.
 
* An unvalidated-address may include: 
* address-building-name
* address-line-2
* address-suburb
* address-city
* address-postal-code
* address-country-code
* address-domicile-code
 
* The street address: (suburb, building-name, line, city, country) 
* must contain an alphanumeric first character,
* may contain any of [A-Z, a-z, 0-9 and these special characters - /',]
 

-------

* **Create Patient - Address errors** 
* **A Patient must have a primary residential address**
* **A Patient Address must either be validated by the MoH address service, or have a qualifier to indicate why the address cannot be validated**
* **A residential address must have a notional domicile code**
* **Validated address** 
* **Nz-address-id, Address line 1 and address type are required.**
* **Address-type is a required field and must be postal or physical**
* address-line must match the espatial value: <>
 
* **Unvalidated address** 
* Address line 1, address type, and not-validated-address-reason are required.
* **A Patient address must contain Address line 1, identify whether the address is residential or mailing, and whether it is the primary residential address**
 
* **Domicile / notional domicile code:** 
* **A residential address must have a notional domicile code**
* **A residential address must have a domicile code**
* **The address validation service was not available to validate this address; and a notional domicile code was not provided for this address, and could not be automatically assigned**
 
* **A Patient Address must either be validated by the MoH address service, or have a qualifier to indicate why the address cannot be validated**
* **Patient Address contains invalid text**
 

