# ZAA0792 - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ZAA0792**

## Example Patient: ZAA0792

version: 3384084

Profile: [NHI Patient](StructureDefinition-NhiPatient.md)

Jamie Matariki Female, DoB: 1985-06-02 ( https://standards.digital.health.nz/ns/nhi-id#NHI#ZAA0792 (use: official, ))

-------

| | |
| :--- | :--- |
| Other Id: | NHI/ZAA0806 (use: old, ) |
| Contact Detail | * 13 Tacitus Place Auckland 0629 NZ (home) (NZ Suburb: Totara Vale)
* 147 Quay Street Auckland 1010 NZ (home) (NZ Suburb: Auckland Central)
 |
| [District Health Board linked to a NZ Healthcare Service, Location or Patient](https://fhir.org.nz/ig/base/StructureDefinition-dhb.html) | Waitemata District Health Board |
| NZ Citizenship: | * source: Proof not Sighted
* status: The citizenship status is unknown
 |
| [NZ Ethnicity](https://fhir.org.nz/ig/base/StructureDefinition-nz-ethnicity.html) | New Zealand European |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "ZAA0792",
  "meta" : {
    "versionId" : "3384084",
    "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/NhiPatient"]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://standards.digital.health.nz/ns/ethnic-group-level-4-code",
            "version" : "2.0",
            "code" : "11111",
            "display" : "New Zealand European"
          }
        ],
        "text" : "New Zealand European"
      }
    },
    {
      "extension" : [
        {
          "url" : "source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "NPRF",
                "display" : "Proof not Sighted"
              }
            ],
            "text" : "Proof not Sighted"
          }
        },
        {
          "url" : "status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/nz-citizenship-status-code",
                "version" : "1.1.0",
                "code" : "unknown",
                "display" : "The citizenship status is unknown"
              }
            ],
            "text" : "The citizenship status is unknown"
          }
        }
      ],
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-citizenship"
    },
    {
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/dhb",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://standards.digital.health.nz/ns/dhb-code",
            "version" : "1.0.0",
            "code" : "G00013-C",
            "display" : "Waitemata District Health Board"
          }
        ],
        "text" : "Waitemata District Health Board"
      }
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "system" : "https://standards.digital.health.nz/ns/nhi-id",
      "value" : "ZAA0792",
      "assigner" : {
        "reference" : "Organization/G00001-G"
      }
    },
    {
      "use" : "old",
      "system" : "https://standards.digital.health.nz/ns/nhi-id",
      "value" : "ZAA0806",
      "assigner" : {
        "reference" : "Organization/G00001-G"
      }
    }
  ],
  "name" : [
    {
      "id" : "22",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : true
        }
      ],
      "family" : "Matariki",
      "given" : ["Jamie"]
    }
  ],
  "gender" : "female",
  "birthDate" : "1985-06-02",
  "_birthDate" : {
    "extension" : [
      {
        "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://standards.digital.health.nz/ns/information-source-code",
              "version" : "1.0.0",
              "code" : "HL7",
              "display" : "HL7 applied"
            }
          ],
          "text" : "HL7 applied"
        }
      }
    ]
  },
  "address" : [
    {
      "id" : "20",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-address-id",
          "valueString" : "131749"
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/domicile-code",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/domicile-code",
                "code" : "0230",
                "display" : "Target Road"
              }
            ],
            "text" : "Target Road"
          }
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/suburb",
          "valueString" : "Totara Vale"
        }
      ],
      "use" : "home",
      "type" : "physical",
      "line" : ["13 Tacitus Place"],
      "city" : "Auckland",
      "postalCode" : "0629",
      "country" : "NZ"
    },
    {
      "id" : "18",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-address-id",
          "valueString" : "3571798"
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/domicile-code",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/domicile-code",
                "code" : "0504",
                "display" : "Auckland Harbourside"
              }
            ],
            "text" : "Auckland Harbourside"
          }
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/suburb",
          "valueString" : "Auckland Central"
        }
      ],
      "use" : "home",
      "type" : "postal",
      "line" : ["147 Quay Street"],
      "city" : "Auckland",
      "postalCode" : "1010",
      "country" : "NZ"
    }
  ]
}

```
