# Set patient's preferred name - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Set patient's preferred name**

## OperationDefinition: Set patient's preferred name 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/set-preferred-name | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Set Preferred Nam |

 
Inactivate name 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-set-preferred-name",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/set-preferred-name",
  "version" : "1.6.5",
  "name" : "Set Preferred Nam",
  "title" : "Set patient's preferred name",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Inactivate name",
  "affectsState" : true,
  "code" : "set-preferred-name",
  "comment" : "The NHI is validated, the versionId is validated, the name.id is validated. If all request parameters are valid the name.preferred boolean is set to TRUE on the requested name and FALSE on the current preferred name.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "preferred-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The id of the name element to be set to be the preferred name (patient.name.id)",
      "type" : "integer"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
