# Update a patient's address. - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Update a patient's address.**

## OperationDefinition: Update a patient's address. 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/set-address | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Set Address |

 
An operation to to replace a name on a patient's record. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-set-address",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/set-address",
  "version" : "1.6.5",
  "name" : "Set Address",
  "title" : "Update a patient's address.",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "An operation to to replace a name on a patient's record.",
  "affectsState" : true,
  "code" : "set-address",
  "comment" : "The address is validated and the patient address is updated.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "address-type",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Must be physical or postal",
      "type" : "string"
    },
    {
      "name" : "nz-address-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The id of the validated address as returned by the eSAM address service",
      "type" : "string"
    },
    {
      "name" : "address-line",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The first line of the validated address as returned by eSAM",
      "type" : "string"
    },
    {
      "name" : "address-building-name",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Building name if required as additional address information, not returned by eSAM",
      "type" : "string"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
