# Consumer Facing Application Authentication Compliance Testing - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Consumer Facing Application Authentication Compliance Testing**

## Consumer Facing Application Authentication Compliance Testing

#### NHI Consumer Get tests

* NHI-Consumer-Get-5**TBD-MHA**: NHI-Consumer-Get-1
  * Describe the excpetion flow if the requested NHI is dormant, and that the live NHI has been returned.: application can clearly display that the information has come from the NHI rather than another source
  * Di.mha.test+INT-ZKV7457@gmail.com: Di.mha.test+INT-ZKV6957@gmail.com
  * * Outout: Notification to the user that the requested NHI was dormant and the live NHI has been returned 
* Output: Patient Live NHI returned should be XXXXXXX: Output: The application alerts the user that the information they are viewing has been returned from the NHI
  * Mandatory: Mandatory
* NHI-Consumer-Get-5**TBD-MHA**: NHI-Consumer-Get-2
  * Describe the excpetion flow if the requested NHI is dormant, and that the live NHI has been returned.: application can display all relevant patient information* NHI numbers 
*  All NHI numbers clearly labelled (live and dormant)
 
* Names 
*  All names clearly labelled, exclude any 'BabyOf' Names
*  Name details as appropriate
 
* Address 
* Residential address 
* Postal address if present
 
*  Gender 
* Gender code
* Gender-original-text if present
 
* Date of Birth
* Place of Birth
* Ethnicities 
* All (up to six)
 
* NZ Citizenship status
* DHB - optional

  * Di.mha.test+INT-ZKV7457@gmail.com: Di.mha.test+INT-ZKV6957@gmail.com
  * * Outout: Notification to the user that the requested NHI was dormant and the live NHI has been returned 
* Output: Patient Live NHI returned should be XXXXXXX: Output: Person's information clearly displayed
  * Mandatory: Mandatory(for data items being handled)
* NHI-Consumer-Get-5**TBD-MHA**: NHI-Consumer-Get-3
  * Describe the excpetion flow if the requested NHI is dormant, and that the live NHI has been returned.: application has an appropriate exception flow if a patient record has a Date of Death
  * Di.mha.test+INT-ZKV7457@gmail.com: Di.mha.test+INT-ZKV7015@gmail.com
  * * Outout: Notification to the user that the requested NHI was dormant and the live NHI has been returned 
* Output: Patient Live NHI returned should be XXXXXXX: Output: The application alerts the user of the exception flow and an appropriate business process to reslove data quality errors
  * Mandatory: Mandatory
* NHI-Consumer-Get-5**TBD-MHA**: NHI-Consumer-Get-4
  * Describe the excpetion flow if the requested NHI is dormant, and that the live NHI has been returned.: application can display all other identity data returned by the NHI in a Get response including:* A non validated residential (physical) and mailing (postal) address
* A year of birth
* Unknown citizenship

  * Di.mha.test+INT-ZKV7457@gmail.com: Di.mha.test+INT-ZKV7520@gmail.com
  * * Outout: Notification to the user that the requested NHI was dormant and the live NHI has been returned 
* Output: Patient Live NHI returned should be XXXXXXX: Output: All identity information is displayed for the patient. This is for a patient record that has partial information in some fields. The patient has:* A not validated physical address
* A not validated postal address
* Partial date of birth

  * Mandatory: Mandatory(for data items being handled)
* NHI-Consumer-Get-5**TBD-MHA**: NHI-Consumer-Get-6
  * Describe the excpetion flow if the requested NHI is dormant, and that the live NHI has been returned.: application can receive and display NHI responses that have fields populated with the maximum allowable sizes (e.g. A given name of 50 characters, Other given name(s) of 100 characters, Family Name of 100 characters)
  * Di.mha.test+INT-ZKV7457@gmail.com: Di.mha.test+INT-ZBE4905@gmail.com
  * * Outout: Notification to the user that the requested NHI was dormant and the live NHI has been returned 
* Output: Patient Live NHI returned should be XXXXXXX: * Output: Patient information supplied is displayed without loss of data
* This is for a patient record that has attribute values which are the maximum allowed field length in some fields
* The patient has the following fields fully populated in the test record (field lengths in parentheses):

  * Mandatory: Mandatory
* NHI-Consumer-Get-5**TBD-MHA**: NHI-Consumer-Get-7
  * Describe the excpetion flow if the requested NHI is dormant, and that the live NHI has been returned.: application behaves appropriately when a new format NHI number is returned
  * Di.mha.test+INT-ZKV7457@gmail.com: * Di.mha.test+INT-ZUG37LU@gmail.com

  * * Outout: Notification to the user that the requested NHI was dormant and the live NHI has been returned 
* Output: Patient Live NHI returned should be XXXXXXX: Output: Application does not error
  * Mandatory: Mandatory
* NHI-Consumer-Get-5**TBD-MHA**: NHI-Consumer-Get-8
  * Describe the excpetion flow if the requested NHI is dormant, and that the live NHI has been returned.: application can synchronize with local system in response to the NHI version changing
  * Di.mha.test+INT-ZKV7457@gmail.com: Di.mha.test+INT-ZCX7065@gmail.com
  * * Outout: Notification to the user that the requested NHI was dormant and the live NHI has been returned 
* Output: Patient Live NHI returned should be XXXXXXX: * Do a Get
* Update the patient details (to simulate a 3rd party updating the NHI info)
* Do another Get
* Demonstrate how end user can view the difference then synchronize

  * Mandatory: Mandatory
* NHI-Consumer-Get-5**TBD-MHA**: NHI-Consumer-Get-9
  * Describe the excpetion flow if the requested NHI is dormant, and that the live NHI has been returned.: application can handle a response when a patient has* only a family name
* only a given name

  * Di.mha.test+INT-ZKV7457@gmail.com: **Do all*** Di.mha.test+INT-ZKV8747@gmail.com
* Di.mha.test+INT-ZAV8657@gmail.com

  * * Outout: Notification to the user that the requested NHI was dormant and the live NHI has been returned 
* Output: Patient Live NHI returned should be XXXXXXX: * Output: 
* application does not error
* application returns all name parts when present
* order of name parts is clear to the user
 

  * Mandatory: mandatory

#### NHI Consumer set-address tests

* Reference: NHI-Consumer-set-address-1
  * Purpose – Demonstrate that the: application can replace the** primary residential address **on a patient record with a validated address
  * Input values: * Locate a validated address to use (this can be done using https://www.nzpost.co.nz/tools/address-postcode-finder) or use Health_UI 
* Add a new ** primary residential address ** to the patient record using the set-addresss operation

  * Expected outcome: * Input: Application can validate an address via e-SAM (using suggest or search)
* Input: An address request can be populated with appropriate information
* Output: The address that is displayed to the end user is the address that is returned in the update response

  * Mandatory: mandatory
* Reference: NHI-Consumer-set-address-2
  * Purpose – Demonstrate that the: application can add (or replace) the** postal address **on a patient record with a validated address
  * Input values: * Locate a validated address to use (this can be done using https://www.nzpost.co.nz/tools/address-postcode-finder) or use Health_UI 
* Add a new ** postal address ** to the patient record using the set-addresss operation

  * Expected outcome: * Input: Application can validate an address via e-SAM (using suggest or search)
* Input: An address request can be populated with appropriate information
* Output: The address that is displayed to the end user is the address that is returned in the update response

  * Mandatory: mandatory
* Reference: NHI-Consumer-set-address-3
  * Purpose – Demonstrate that the: application can remove the**postal address**on a patient record
  * Input values: *  Remove the **postal address** from the patient record using the $remove-postal-address operation

  * Expected outcome: * Output: The patient record has Postal address removed

  * Mandatory: mandatory
* Reference: NHI-Consumer-set-address-4
  * Purpose – Demonstrate that the: **Not currently implemented**Application will show the correct error when attempting to add the supplied address that has been previously removed from the patient record by NHI administration
  * Input values: *  address-line: 24 Anglesea Avenue 
*  nz-address-id: 967406 
*  address-type: physical

  * Expected outcome: Error: EM02004 - The Patient Address requested has been removed from the Patient record by Te Whatu Ora
  * Mandatory: Mandatory
* Reference: NHI-Consumer-set-address-5
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to add the following postal address for an undeliverable address
  * Input values: *  address-line: 748E Whitemans Valley Road 
*  nz-address-id: 3193368 
*  address-type: postal

  * Expected outcome: Error: EM02209 - A validated mailing address must be an address at which mail can be delivered
  * Mandatory: Mandatory
* Reference: NHI-Consumer-set-address-6
  * Purpose – Demonstrate that the: Application will show the correct error when attempting to add an address where the nz address id does not match the first line of the validated address
  * Input values: *  address-line: 24 Ranglesey Place 
*  nz-address-id: 1199146 
*  address-type: physical

  * Expected outcome: Error: "address-line must match the espatial value: ..."
  * Mandatory: Mandatory

#### NHI Consumer set-preferred-name tests

* Reference: NHI-Conumer-set-preferred-name-1
  * Purpose – Demonstrate that the: application can set the patients preferred name
  * Input values: * Do a Get Patient request to see active patient names
* Change the preferred name from the current name to another active name for the patient

  * Expected outcome: *  Input: 
*  An application can select a Patients preferred name from the active names list 
 
*  Output: 
*  The preferred name that is displayed to the end user is the name that was selected in the operation
*  The name is presented to the user with all name parts
 

  * Mandatory: mandatory

#### NHI Consumer Update-identity tests

* Reference: NHI-Consumer-update-identity-1Ethnicity
  * Purpose – Demonstrate that the: application can correctly re-collect ethnicity information from a person
  * Input values: Ethnicity question presented correctlyUpdate the set of ethnicity information based on the responses to the standard ethnicity collection question for the selected NHI number![](update-core-1.png)
  * Expected outcome: * Output: 
*  Person able to select their ethnicities 
* The application can update the patients ethnicity information
*  Patient’s ethnicity after update should be: 
*  11111 
*  21111 
*  31111
 
 

  * Mandatory: mandatory
* Reference: NHI-Consumer-update-identity-2Ethnicity
  * Purpose – Demonstrate that the: application can correctly re-collect ethnicity information from a person
  * Input values: Ethnicity question presented correctlyUpdate the set of ethnicity information based on the responses to the standard ethnicity collection question for the selected NHI number![](update-core-2.png)
  * Expected outcome: * Output: 
*  Person able to select their ethnicities 
* The application can update the patients ethnicity information
*  Patient’s ethnicity after update should be: 
*  11111 
*  34111 
*  51120 
*  4211 
 
 

  * Mandatory: mandatory
* Reference: NHI-Consumer-update-identity-3Ethnicity-error
  * Purpose – Demonstrate that the: application can display an error when ethnicity information invalidset of supplied ethnicities that includes a duplicate ethnicity
  * Input values: Update the ethnicity information for Patient: ZAA1063Ethnicities to use:* 32100 (Cook Islands Maori) and,
* 12948 (South African) and,
* 32100 (Cook Islands Maori)

  * Expected outcome: Output: EM02301 - "A Patient must have at least one valid ethnicity code, only one instance of each selected ethnicity, and no more than one ‘unspecified’ ethnicity code"
  * Mandatory: mandatory
* Reference: NHI-Consumer-update-identity-4Gender
  * Purpose – Demonstrate that the: application can correctly update a gender value on a patient's record
  * Input values: Change the gender from current gender to one of the three acceptable gender codes** Do all ***  Male
* Female
* Another gender

  * Expected outcome: Output:*  Patients gender coded updated corrctly

  * Mandatory: mandatory
* Reference: NHI-Consumer-update-identity-5Gender
  * Purpose – Demonstrate that the: application can correctly update the gender value and gender-original-text on a patient record
  * Input values: *  Change the gender code from current gender to 'Another gender' 
*  include an original text response that a patient might submit 

  * Expected outcome: Output:*  Patients gender coded updated corrctly

  * Mandatory: Mandatory if allowing a gendeer text update
* Reference: NHI-Consumer-update-identity-6Gender-error
  * Purpose – Demonstrate that the: application can display an error when gender-original-text updated without a gender value
  * Input values: Update the gender-original-text for Patient
  * Expected outcome: Output: EM07201 - "Is a required field - Patient.gender"
  * Mandatory: Mandatory if allowing a gendeer text update

