# API - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **API**

## API

A FHIR API in front of the New Zealand NHI

### REST APIs

#### Resource Level Interactions

##### Patient

**Interactions**

* Name: read
  * Verb: GET
  * URL: [base]/Patient/[nhi-id]
  * Documentation: Retrieve a Patient resource by Id
  * Scope: patient:Patient.r system/Patient.r

* Name: match
  * Definition: [ http://hl7.org/fhir/OperationDefinition/Patient-match ](OperationDefinition-Patient-match.md)
  * Verb: POST
  * URL: [base]/Patient/$match
  * Documentation: **Match**: with In parameter`onlyCertainMatches=0`(False) the operation will search the NHI by demographics using fuzzy logic. Returns a bundle of results with match scores.**Validate:**with In parameter`onlyCertainMatches=1`(True) the operation will validate known patient demographic details against an NHI number. Returns a bundle of results with one patient resource that only includes the live nhi-id.
  * Scope: system/Patient.s system/Patient.v
* Name: set-preferred-name
  * Definition: [ https://nhi-ig.hip.digital.health.nz/OperationDefinition/set-preferred-name ](OperationDefinition-Patient-set-preferred-name.md)
  * Verb: POST
  * URL: [base]/Patient/$set-preferred-name
  * Documentation: Set the patient's preferred name
  * Scope: patient:Patient.u system/Patient.u
* Name: set-address
  * Definition: [ https://nhi-ig.hip.digital.health.nz/OperationDefinition/set-address ](OperationDefinition-Patient-set-address.md)
  * Verb: POST
  * URL: [base]/Patient/$set-address
  * Documentation: Update a patient's address
  * Scope: patient:Patient.u system/Patient.u
* Name: set-unvalidated-address
  * Definition: [ https://nhi-ig.hip.digital.health.nz/OperationDefinition/set-unvalidated-address ](OperationDefinition-Patient-set-unvalidated-address.md)
  * Verb: POST
  * URL: [base]/Patient/$set-unvalidated-address
  * Documentation: Allows a user to replace a physical address OR add or replace a postal address with an unvalidated address
  * Scope: system/Patient.u
* Name: remove-postal-address
  * Definition: [ https://nhi-ig.hip.digital.health.nz/OperationDefinition/remove-postal-address ](OperationDefinition-Patient-remove-postal-address.md)
  * Verb: POST
  * URL: [base]/Patient/$remove-postal-address
  * Documentation: Remove a patient's postal address
  * Scope: patient:Patient.u system/Patient.u
* Name: update-birth
  * Definition: [ https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-birth ](OperationDefinition-Patient-update-birth.md)
  * Verb: POST
  * URL: [base]/Patient/$update-birth
  * Documentation: Update a patient's birth information
  * Scope: system/Patient.u
* Name: update-identity
  * Definition: [ https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-identity ](OperationDefinition-Patient-update-identity.md)
  * Verb: POST
  * URL: [base]/Patient/$update-identity
  * Documentation: An operation to update a patient's identity details.
  * Scope: patient:Patient.u system/Patient.u
* Name: add-name
  * Definition: [ https://nhi-ig.hip.digital.health.nz/OperationDefinition/add-name ](OperationDefinition-Patient-add-name.md)
  * Verb: POST
  * URL: [base]/Patient/$add-name
  * Documentation: Add a name to a patient's NHI record
  * Scope: system/Patient.u
* Name: replace-name
  * Definition: [ https://nhi-ig.hip.digital.health.nz/OperationDefinition/replace-name ](OperationDefinition-Patient-replace-name.md)
  * Verb: POST
  * URL: [base]/Patient/$replace-name
  * Documentation: An operation to replace a name on a patient's record
  * Scope: system/Patient.u
* Name: inactivate-name
  * Definition: [ https://nhi-ig.hip.digital.health.nz/OperationDefinition/inactivate-name ](OperationDefinition-Patient-inactivate-name.md)
  * Verb: POST
  * URL: [base]/Patient/$inactivate-name
  * Documentation: Inactivate a name that is currently active on a patients record
  * Scope: system/Patient.u
* Name: update-eligibility
  * Definition: [ https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-eligibility ](OperationDefinition-Patient-update-eligibility.md)
  * Verb: POST
  * URL: [base]/Patient/$update-eligibility
  * Documentation: Update a patient's citizenship information
  * Scope: system/Patient.u
* Name: create
  * Definition: [ https://nhi-ig.hip.digital.health.nz/OperationDefinition/create-patient ](OperationDefinition-Patient-create.md)
  * Verb: POST
  * URL: [base]/Patient/$create
  * Documentation: Create a new patient record in the NHI
  * Scope: system/Patient.c

