<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile NzAddress
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Address</sch:title>
    <sch:rule context="f:Address">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/nz-geocode']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/nz-geocode': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/suburb']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/suburb': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/building-name']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/building-name': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/domicile-code']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/domicile-code': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/nz-address-id']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/nz-address-id': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.nz/fhir/StructureDefinition/nhi-address-derived']) &lt;= 1">extension with URL = 'http://hl7.org.nz/fhir/StructureDefinition/nhi-address-derived': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:type) &gt;= 1">type: minimum cardinality of 'type' is 1</sch:assert>
      <sch:assert test="count(f:district) &lt;= 0">district: maximum cardinality of 'district' is 0</sch:assert>
      <sch:assert test="count(f:state) &lt;= 0">state: maximum cardinality of 'state' is 0</sch:assert>
      <sch:assert test="count(f:period) &lt;= 0">period: maximum cardinality of 'period' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
