# Update Birth - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Update Birth**

## Update Birth

### Update Birth Overview

The update birth operation allows an authorised user to update a persons birthdate and birthplace information on a persons identity record.

This includes:

* Bithdate
* Birthdate information source
* Birthplace: 
* Country
* information source
* place of birth
 

**Update-birth - Processing steps:**

1. The user provides patient details to be updated
1. The integrating application sends an HTTP Post request using the $update-birth operation to the NHI E.g. Post<Endpoint>/Patient/$update-birth
1. The request is validated - ALT: Validation failure. Operation Outcome resource returned
1. The provided patient attributes are updated
1. The updated record is returned with an HTTP 200 ok response
1. The integrating application displays the updated details to the user

#### Update-birth - In Parameters

* Parameter name: nhi
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The patients nhi number
* Parameter name: version-id
  * Parameter type: valueString
  * Mandatory / Optional: Mandatory
  * Description: The current patient version number
* Parameter name: birthdate
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The patients date of birth
* Parameter name: birthdate-information-source
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The information source for the patients date of birth
* Parameter name: country-of-birth
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The patient's country of birth
* Parameter name: country-of-birth-information-source
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The information source for the patient's country of birth
* Parameter name: place-of-birth
  * Parameter type: valueString
  * Mandatory / Optional: Optional
  * Description: The place where the person as born, E.g. Whangarei.Only populate if country-of-birth is populated

#### Update-identity - Behaviour

* The NHI is validated
* The Patient version-id is validated
* The parameters are validated
* If all request parameters are valid, the attributes are updated on the NHI.

#### Update-birth - Example request

```
{
  "resourceType": "Parameters",
  "id": "example",
  "parameter": [
    {
        "name" : "nhi",
        "valueString" : "ZGD9203"
    },
    {
        "name" : "version-id",
        "valueString" : "3321540"
    },
    {
        "name" : "birthdate",
        "valueString" : "2015-09-09" 
    },
    {
        "name" : "birthdate-information-source",
        "valueString" : "BREG" 
    },
    {
        "name" : "country-of-birth",
        "valueString" : "NZ" 
    },
    {
        "name" : "country-of-birth-information-source",
        "valueString" : "BREG" 
    },
    {
        "name" : "place-of-birth",
        "valueString" : "Whangarei" 
    }
  ]
}


```

#### Update-birth - Rules and errors

[For Request rules and errors click here](/general.md#request-rules-and-errors)

##### Patient update-birth rules

* An update request must contain: 
* the live NHI number for the Patient Record.
* the version number of the current Patient Record.
 
* An update request must not: 
* delete/inactivate mandatory information.
* modify or delete any information with a Status of Registered.
 
* An update request may: 
* populate the request parameter with the required value(s) to modify the existing NHI value for that parameter.
* not populate the request parameter to retain the existing NHI value for that parameter.
* modify active patient information which is not ‘registered’ or verified’ information.
* modify active patient information for which evidence has been sighted (“verified” information) Can modify a verified source to another verified source or verified to Registered.
 
* An update request which results in an attribute Status of Registered must only be submitted via an authorised Agency.
* An update request must not modify a record to the extent that the patient identity describes a different patient.
* An update requestt to update the value for a core identity field must also update the information source.
* An update request must update the source of information only when the information is also provided.
* **Patient update-birth errors** 
* **Patient NHI and version number are required**
* **Version number is incorrect**
* _The NHI Identifier provided is dormant. This record cannot be updated
* **Cannot delete mandatory data**
 

-------

##### Update-birth birthdate rules

* All [create patient birthdate rules apply](/createPatient.md#create-patient-birthdate-rules) and,
* An update will replace the current value

-------

* **Patient update-birth birthdate errors** 
* birth-date has been validated against a verified source, and must only be modified by authorised users
* birth-date can only be set to a ‘Registered’ value by an authorised Agency
* The patient identity information supplied may result in transformation of this NHI. Please resubmit or contact NHI administration.
* birth-date-information-source is required when birth-date is present
* birth-date is required when birth-date-information-source is present.
 

##### Update-birth birthplace rules

* All [create patient birthplace rules apply](/createPatient.md#create-patient-birthplace-rules) and,
* A request to update place-of-birth must also update country-of-birth
* A request to update country of birth must also update country-of-birth-information-source
* birth-place cannot be updated if source is ‘registered’ (BREG) [See Glossary](/glossary.md#birthplace-definitions)
* birth-place can only be updated to registered by an authorised agency
* A verified birthplace can be updated by another verified source, not by an unverified source.

-------

* **Patient update-birth birthdate errors** 
* birth-place has been validated against a verified source, and must only be modified by authorised users
* Can only modify a verified source to another verified source or verified to Registered (see Modification of registered information)
* birth-place can only be set to a ‘Registered’ value by an authorised Agency
* Cannot delete mandatory data
* country-of-birth-information-source is required when country-of-birth is present
* country-of-birth is required when country-of-birth-information-source is present.
 

