# NzAddressId - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **NzAddressId**

## Extension: NzAddressId 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org.nz/fhir/StructureDefinition/nz-address-id | *Version*:1.6.5 |
| Active as of 2026-01-26 | *Computable Name*:NzAddressId |

Uniquely identifies this address as a physical entity. Will remain constant over time even if address administrative data such as DPID change

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [NHI Address](StructureDefinition-NhiAddress.md)
* Examples for this Extension: [Patient/ZAA0792](Patient-ZAA0792.md), [Patient/create1](Patient-create1.md), [Patient/create2-error-](Patient-create2-error-.md) and [Patient/create3-errors](Patient-create3-errors.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.org.nz.fhir.ig.nhi|current/StructureDefinition/address-id)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-address-id.csv), [Excel](StructureDefinition-address-id.xlsx), [Schematron](StructureDefinition-address-id.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "address-id",
  "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-address-id",
  "version" : "1.6.5",
  "name" : "NzAddressId",
  "status" : "active",
  "date" : "2026-01-26T22:05:16+00:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Uniquely identifies this address as a physical entity. Will remain constant over time even if address administrative data such as DPID change",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Address"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "definition" : "Uniquely identifies this address as a physical entity. Will remain constant over time even if address administrative data such as DPID change"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.org.nz/fhir/StructureDefinition/nz-address-id"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
