# create2-error- - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **create2-error-**

## Example Patient: create2-error-

Profile: [Create NHI Patient](StructureDefinition-CreateNhiPatient.md)

ChewyBakA Male, DoB: 1972-06-05

-------

| | |
| :--- | :--- |
| Contact Detail | 24 Anglesey Place Palmerston North 4412 NZ (home) (NZ Suburb: Awapuni) |
| null: | * country: New Zealand
* source: Birth Certificate
 |
| NZ Citizenship: | * status: Yes
* source: Birth Certificate
 |
| [NZ Ethnicity](https://fhir.org.nz/ig/base/StructureDefinition-nz-ethnicity.html) | Māori |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "create2-error-",
  "meta" : {
    "profile" : [
      "http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://standards.digital.health.nz/ns/ethnic-group-level-4-code",
            "code" : "21111",
            "display" : "Māori"
          }
        ]
      }
    },
    {
      "extension" : [
        {
          "url" : "status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/nz-citizenship-status-code",
                "code" : "yes",
                "display" : "Yes"
              }
            ]
          }
        },
        {
          "url" : "source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "code" : "BRCT",
                "display" : "Birth Certificate"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-citizenship"
    },
    {
      "extension" : [
        {
          "url" : "country",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "NZ",
                "display" : "New Zealand"
              }
            ]
          }
        },
        {
          "url" : "source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "code" : "BRCT",
                "display" : "Birth Certificate"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/birth-place"
    }
  ],
  "name" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "code" : "NPRF",
                "display" : "Proof not Sighted"
              }
            ]
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : false
        }
      ],
      "given" : ["ChewyBakA"]
    }
  ],
  "gender" : "male",
  "birthDate" : "1972-06-05",
  "_birthDate" : {
    "extension" : [
      {
        "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://standards.digital.health.nz/ns/information-source-code",
              "code" : "HL7",
              "display" : "HL7 applied"
            }
          ]
        }
      }
    ]
  },
  "address" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-address-id",
          "valueString" : "1199146"
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/suburb",
          "valueString" : "Awapuni"
        }
      ],
      "use" : "home",
      "type" : "physical",
      "line" : ["24 Anglesey Place"],
      "city" : "Palmerston North",
      "postalCode" : "4412",
      "country" : "NZ"
    }
  ]
}

```
