# ZJM9397 - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ZJM9397**

## Example Patient: ZJM9397

version: 3386725

Profile: [NHI Patient](StructureDefinition-NhiPatient.md)

Jamie Joseph Ryan Female, DoB: 1972-06-05 ( https://standards.digital.health.nz/ns/nhi-id#NHI#ZJM9397 (use: official, ))

-------

| | |
| :--- | :--- |
| Contact Detail | * 74 Chancellor Street Christchurch NEW ZEALAND (home) (NZ Suburb: Richmond)
* 22 macron steet nowhere darkside 6066 SWITZERLAND (home) (NZ Suburb: darksideodthetracks)
 |
| null: | * country: New Zealand
* source: Birth Certificate
 |
| NZ Citizenship: | * source: Birth Register
* status: No
 |
| [NZ Ethnicity](https://fhir.org.nz/ig/base/StructureDefinition-nz-ethnicity.html) | Māori |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "ZJM9397",
  "meta" : {
    "versionId" : "3386725",
    "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/NhiPatient"]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://standards.digital.health.nz/ns/ethnic-group-level-4-code",
            "version" : "2.0",
            "code" : "21111",
            "display" : "Māori"
          }
        ],
        "text" : "Māori"
      }
    },
    {
      "extension" : [
        {
          "url" : "country",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "version" : "2013",
                "code" : "NZ",
                "display" : "New Zealand"
              }
            ],
            "text" : "New Zealand"
          }
        },
        {
          "url" : "source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "BRCT",
                "display" : "Birth Certificate"
              }
            ],
            "text" : "Birth Certificate"
          }
        }
      ],
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/birth-place"
    },
    {
      "extension" : [
        {
          "url" : "source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "BREG",
                "display" : "Birth Register"
              }
            ],
            "text" : "Birth Register"
          }
        },
        {
          "url" : "status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/nz-citizenship-status-code",
                "version" : "1.1.0",
                "code" : "no",
                "display" : "No"
              }
            ],
            "text" : "No"
          }
        }
      ],
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-citizenship"
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "system" : "https://standards.digital.health.nz/ns/nhi-id",
      "value" : "ZJM9397",
      "assigner" : {
        "reference" : "Organization/G00001-G"
      }
    }
  ],
  "name" : [
    {
      "id" : "11",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "NPRF",
                "display" : "Proof not Sighted"
              }
            ],
            "text" : "Proof not Sighted"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : false
        }
      ],
      "family" : "Ryan",
      "given" : ["Jamie", "Joseph"],
      "prefix" : ["MR"]
    },
    {
      "id" : "13",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "NPRF",
                "display" : "Proof not Sighted"
              }
            ],
            "text" : "Proof not Sighted"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : false
        }
      ],
      "family" : "James",
      "given" : ["Joseph", "Ryan"],
      "prefix" : ["MR"]
    },
    {
      "id" : "21",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "NPRF",
                "display" : "Proof not Sighted"
              }
            ],
            "text" : "Proof not Sighted"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : true
        }
      ],
      "use" : "nickname",
      "family" : "Ryan",
      "given" : ["Chewea"],
      "prefix" : ["MR"]
    },
    {
      "id" : "22",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : false
        }
      ],
      "given" : ["ChewyBakA"],
      "prefix" : ["MR"]
    }
  ],
  "gender" : "female",
  "_gender" : {
    "extension" : [
      {
        "url" : "http://hl7.org.nz/fhir/StructureDefinition/gender-original-text",
        "valueString" : "female-male"
      }
    ]
  },
  "birthDate" : "1972-06-05",
  "_birthDate" : {
    "extension" : [
      {
        "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://standards.digital.health.nz/ns/information-source-code",
              "version" : "1.0.0",
              "code" : "HL7",
              "display" : "HL7 applied"
            }
          ],
          "text" : "HL7 applied"
        }
      }
    ]
  },
  "address" : [
    {
      "id" : "50",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/address-not-validated-reason-code",
                "version" : "1.1",
                "code" : "NOSVC",
                "display" : "Address Service Unavailable"
              }
            ],
            "text" : "Address Service Unavailable"
          }
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/domicile-code",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/domicile-code",
                "code" : "2659",
                "display" : "Richmond North"
              }
            ],
            "text" : "Richmond North"
          }
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/suburb",
          "valueString" : "Richmond"
        }
      ],
      "use" : "home",
      "type" : "physical",
      "line" : ["74 Chancellor Street"],
      "city" : "Christchurch",
      "country" : "NEW ZEALAND"
    },
    {
      "id" : "49",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/building-name",
          "valueString" : "Building 11"
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/address-not-validated-reason-code",
                "version" : "1.1",
                "code" : "NFAB",
                "display" : "No Fixed Abode"
              }
            ],
            "text" : "No Fixed Abode"
          }
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/domicile-code",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/domicile-code",
                "code" : "9999",
                "display" : "Overseas resident"
              }
            ],
            "text" : "Overseas resident"
          }
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/suburb",
          "valueString" : "darksideodthetracks"
        }
      ],
      "use" : "home",
      "type" : "postal",
      "line" : ["22 macron steet", "nowhere"],
      "city" : "darkside",
      "postalCode" : "6066",
      "country" : "SWITZERLAND"
    }
  ]
}

```
