# ZAT2496 - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ZAT2496**

## Example Patient: ZAT2496

version: 3384207

Profile: [NHI Patient](StructureDefinition-NhiPatient.md)

Edward Rochester Male, DoB: 1914 ( https://standards.digital.health.nz/ns/nhi-id#NHI#ZAT2496 (use: official, ))

-------

| | |
| :--- | :--- |
| Deceased: | 2023-04 |
| Other Id: | NHI/ZAT2518 (use: old, ) |
| Contact Detail | Courtenay Place Wellington 6011 (home) (NZ Suburb: Te Aro) |
| null: | * country: New Zealand
* place-of-birth: Christchurch
* source: Birth Certificate
 |
| NZ Citizenship: | * source: Proof not Sighted
* status: The citizenship status is unknown
 |
| [NZ Ethnicity](https://fhir.org.nz/ig/base/StructureDefinition-nz-ethnicity.html) | * Assyrian
* Austrian
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "ZAT2496",
  "meta" : {
    "versionId" : "3384207",
    "profile" : ["http://hl7.org.nz/fhir/StructureDefinition/NhiPatient"]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://standards.digital.health.nz/ns/ethnic-group-level-4-code",
            "version" : "2.0",
            "code" : "51113",
            "display" : "Assyrian"
          }
        ],
        "text" : "Assyrian"
      }
    },
    {
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-ethnicity",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://standards.digital.health.nz/ns/ethnic-group-level-4-code",
            "version" : "2.0",
            "code" : "12913",
            "display" : "Austrian"
          }
        ],
        "text" : "Austrian"
      }
    },
    {
      "extension" : [
        {
          "url" : "country",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "version" : "2013",
                "code" : "NZ",
                "display" : "New Zealand"
              }
            ],
            "text" : "New Zealand"
          }
        },
        {
          "url" : "place-of-birth",
          "valueString" : "Christchurch"
        },
        {
          "url" : "source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "BRCT",
                "display" : "Birth Certificate"
              }
            ],
            "text" : "Birth Certificate"
          }
        }
      ],
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/birth-place"
    },
    {
      "extension" : [
        {
          "url" : "source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "NPRF",
                "display" : "Proof not Sighted"
              }
            ],
            "text" : "Proof not Sighted"
          }
        },
        {
          "url" : "status",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/nz-citizenship-status-code",
                "version" : "1.1.0",
                "code" : "unknown",
                "display" : "The citizenship status is unknown"
              }
            ],
            "text" : "The citizenship status is unknown"
          }
        }
      ],
      "url" : "http://hl7.org.nz/fhir/StructureDefinition/nz-citizenship"
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "system" : "https://standards.digital.health.nz/ns/nhi-id",
      "value" : "ZAT2496",
      "assigner" : {
        "reference" : "Organization/G00001-G"
      }
    },
    {
      "use" : "old",
      "system" : "https://standards.digital.health.nz/ns/nhi-id",
      "value" : "ZAT2518",
      "assigner" : {
        "reference" : "Organization/G00001-G"
      }
    }
  ],
  "name" : [
    {
      "id" : "15",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "NPRF",
                "display" : "Proof not Sighted"
              }
            ],
            "text" : "Proof not Sighted"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : false
        }
      ],
      "family" : "Rochester",
      "given" : ["Edward  "]
    },
    {
      "id" : "16",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/information-source-code",
                "version" : "1.0.0",
                "code" : "NPRF",
                "display" : "Proof not Sighted"
              }
            ],
            "text" : "Proof not Sighted"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : false
        }
      ],
      "family" : "Making",
      "given" : ["Poor", "Decision"],
      "prefix" : ["SIR"]
    },
    {
      "id" : "77",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : true
        }
      ],
      "family" : "Yossarian",
      "given" : ["John", "Test"]
    },
    {
      "id" : "78",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-preferred",
          "valueBoolean" : false
        }
      ],
      "family" : "Moh",
      "given" : ["Woody"]
    }
  ],
  "gender" : "male",
  "birthDate" : "1914",
  "_birthDate" : {
    "extension" : [
      {
        "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://standards.digital.health.nz/ns/information-source-code",
              "version" : "1.0.0",
              "code" : "NPRF",
              "display" : "Proof not Sighted"
            }
          ],
          "text" : "Proof not Sighted"
        }
      }
    ]
  },
  "deceasedDateTime" : "2023-04",
  "_deceasedDateTime" : {
    "extension" : [
      {
        "url" : "http://hl7.org.nz/fhir/StructureDefinition/information-source",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://standards.digital.health.nz/ns/information-source-code",
              "version" : "1.0.0",
              "code" : "MCCOD",
              "display" : "Medical Certificate Cause of Death"
            }
          ],
          "text" : "Medical Certificate Cause of Death"
        }
      }
    ]
  },
  "address" : [
    {
      "id" : "27",
      "extension" : [
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/not-validated-address-reason",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/address-not-validated-reason-code",
                "version" : "1.1",
                "code" : "OTHER",
                "display" : "Other"
              }
            ],
            "text" : "Other"
          }
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/domicile-code",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://standards.digital.health.nz/ns/domicile-code",
                "code" : "2125",
                "display" : "Willis Street-Cambridge Terrace"
              }
            ],
            "text" : "Willis Street-Cambridge Terrace"
          }
        },
        {
          "url" : "http://hl7.org.nz/fhir/StructureDefinition/suburb",
          "valueString" : "Te Aro"
        }
      ],
      "use" : "home",
      "type" : "physical",
      "line" : ["Courtenay Place"],
      "city" : "Wellington",
      "postalCode" : "6011"
    }
  ]
}

```
