# An operation to update a patients citizenship information - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **An operation to update a patients citizenship information**

## OperationDefinition: An operation to update a patients citizenship information 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-eligibility | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Update Eligibility |

 
Update eligibility. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-update-eligibility",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-eligibility",
  "version" : "1.6.5",
  "name" : "Update Eligibility",
  "title" : "An operation to update a patients citizenship information",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Update eligibility.",
  "affectsState" : true,
  "code" : "update-eligibility",
  "comment" : "The NHI is validated, the versionId is validated, the parameters validated. If all request parameters are valid the included items are updated on the Patients NHI record.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "nz-citizenship-status",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "NZ citizenship status",
      "type" : "string"
    },
    {
      "name" : "nz-citizenship-source",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "NZ citizenship status information source",
      "type" : "string"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
