# Update patient's birth details - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Update patient's birth details**

## OperationDefinition: Update patient's birth details 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-birth | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Update Birth Details |

 
Update patient's birth details. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-update-birth",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/update-birth",
  "version" : "1.6.5",
  "name" : "Update Birth Details",
  "title" : "Update patient's birth details",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "Update patient's birth details.",
  "affectsState" : true,
  "code" : "update-birth",
  "comment" : "The NHI is validated, the versionId is validated, the parameters validated. If all request parameters are valid the included items are updated on the Patients NHI record.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "birthdate",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The patient's date of birth",
      "type" : "string"
    },
    {
      "name" : "birthdate-information-source",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The information source for the patient's date of birth",
      "type" : "string"
    },
    {
      "name" : "country-of-birth",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The patient's country of birth",
      "type" : "string"
    },
    {
      "name" : "country-of-birth-information-source",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The information source for the patient's country of birth",
      "type" : "string"
    },
    {
      "name" : "place-of-birth",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "The place where the person as born, E.g. Whangārei. Only populate if country-of-birth is populated",
      "type" : "string"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
