# Remove a patient's postal address. - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Remove a patient's postal address.**

## OperationDefinition: Remove a patient's postal address. 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/remove-postal-address | *Version*:1.6.5 |
| Draft as of 2023-06-12 | *Computable Name*:Remove Postal Address |

 
An operation to add a name to a patient's NHI record 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-remove-postal-address",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/remove-postal-address",
  "version" : "1.6.5",
  "name" : "Remove Postal Address",
  "title" : "Remove a patient's postal address.",
  "status" : "draft",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2023-06-12T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "An operation to add a name to a patient's NHI record",
  "affectsState" : true,
  "code" : "remove-postal-address",
  "comment" : "The parameters are validated.  The postal address on the nhi record is made inactive.",
  "resource" : ["Patient"],
  "system" : false,
  "type" : false,
  "instance" : true,
  "parameter" : [
    {
      "name" : "nhi",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The Patient's nhi number",
      "type" : "string"
    },
    {
      "name" : "version-id",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The current value of the patient resources meta.versionId",
      "type" : "string"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
