# Patient-create - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient-create**

## OperationDefinition: Patient-create 

| | |
| :--- | :--- |
| *Official URL*:https://nhi-ig.hip.digital.health.nz/OperationDefinition/create-patient | *Version*:1.6.5 |
| Draft as of 2022-05-28 | *Computable Name*:Create Patient |

 
create a patient in the NHI 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Patient-create",
  "url" : "https://nhi-ig.hip.digital.health.nz/OperationDefinition/create-patient",
  "version" : "1.6.5",
  "name" : "Create Patient",
  "status" : "draft",
  "kind" : "operation",
  "date" : "2022-05-28T12:47:40+10:00",
  "publisher" : "Te Whatu Ora",
  "contact" : [
    {
      "name" : "Te Whatu Ora",
      "telecom" : [
        {
          "system" : "email",
          "value" : "mailto:integration@health.govt.nz"
        }
      ]
    }
  ],
  "description" : "create a patient in the NHI",
  "affectsState" : true,
  "code" : "create",
  "comment" : "The patient information is validated. If all request parameters are valid the new patient is created in the NHI",
  "resource" : ["Patient"],
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "patient",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "type" : "Patient",
      "targetProfile" : [
        "http://hl7.org.nz/fhir/StructureDefinition/CreateNhiPatient"
      ]
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "The updated patient resource",
      "type" : "Patient"
    },
    {
      "name" : "failure",
      "use" : "out",
      "min" : 0,
      "max" : "1",
      "documentation" : "Error response",
      "type" : "OperationOutcome"
    }
  ]
}

```
