# Get Match And Validate Patient Compliance Testing - New Zealand NHI IG v1.6.5

* [**Table of Contents**](toc.md)
* **Get Match And Validate Patient Compliance Testing**

## Get Match And Validate Patient Compliance Testing

#### NHI Patient GET tests

* Reference: NHI-GET-1
  * Purpose – Demonstrate that the: application displays the minimum patient information required to confirm identity:* Preferred name including Given Name(s), Family Name
* Date of Birth
* Gender
* Primary Address - including the building name

  * Input values: ZJS7596
  * Expected outcome: Output: Minimum identity information is displayed for the patient
  * Mandatory: Mandatory
* Reference: NHI-GET-2
  * Purpose – Demonstrate that the: application can display the Date of Death
  * Input values: ZAT2348
  * Expected outcome: Output: The application alerts the user that the patient is deceased and provides the date of death
  * Mandatory: Mandatory
* Reference: NHI-GET-3
  * Purpose – Demonstrate that the: application can display all other identity data returned by the NHI in a GET response including:* All patient names with all name parts
* Name Information Source
* Date of Birth Information Source
* Ethnicity information
* All patient addresses and address parts
* NZ Citizenship status
* Country of Birth
* Country of Birth source
* Place of Birth

  * Input values: ZAT2364
  * Expected outcome: Output: All identity information is displayed for the patient. The patient:* Is alive
* Has 4 names - no name use + preferred = true, no name use + preferred = false, one ‘baby of’, one maiden
* The preferred name should have all name parts populated
* Has two addresses, the primary resedential (physical) address is overseas and the mailing (postal) address is in NZ
* Has three ethnicities
* Is a NZ citizen

  * Mandatory: *Mandatory if the application is using the data
* Reference: NHI-GET-4
  * Purpose – Demonstrate that the: application can display all other identity data returned by the NHI in a GET response including:* A non validated primary address
* A year of birth and a year and month of death (partial dates)
* Unknown citizenship

  * Input values: ZAT2496
  * Expected outcome: Output: All identity information is displayed for the patient. This is for a patient record that has partial information in some fields. The patient has:* A not validated physical address
* Partial date of death
* Partial date of birth

  * Mandatory: Mandatory
* Reference: NHI-GET-5
  * Purpose – Demonstrate that the: application alerts the user that a requested NHI is dormant, and that the live NHI has been returned.
  * Input values: ZAT2518
  * Expected outcome: Outout: Notification to the user that the requested NHI was dormant and the live NHI has been returnedOutput: Patient Live NHI returned should be ZAT2496Output: Minimum identity information for the live NHI is displayed for the patient
  * Mandatory: Mandatory
* Reference: NHI-GET-6
  * Purpose – Demonstrate that the: application can receive and display NHI responses that have fields populated with the maximum allowable sizes (e.g. A given name of 50 characters, Other given name(s) of 100 characters, Family Name of 100 characters).
  * Input values: ZBE4905
  * Expected outcome: Output: Patient information supplied is displayed without loss of dataThis is for a patient record that has attribute values which are the maximum allowed field length in some fieldsThe patient has the following fields fully populated in the test record (field lengths in parentheses):* Given name (50)
* Other Given Name(s) (100)
* Family Name (100)
* Address line 1 (100)
* Address lines 2-5 (50)
* Building name/additional details (255)

  * Mandatory: Mandatory
* Reference: NHI-GET-7
  * Purpose – Demonstrate that the: application behaves appropriately when a new format NHI number is produced
  * Input values: * ZXE24NV
* ZUA48EH

  * Expected outcome: Output: Application does not error
  * Mandatory: Mandatory
* Reference: NHI-GET-8
  * Purpose – Demonstrate that the: application can synchronize with local system in response to the NHI version changing
  * Input values: ZCX7065
  * Expected outcome: * Do a GET
* Update the patient details (to simulate a 3rd party updating the NHI info)
* Do another GET
* Demonstrate how end user can view the difference then synchronize

  * Mandatory: Mandatory
* Reference: NHI-GET-9
  * Purpose – Demonstrate that the: application presents the address parts appropriately, including multiple addresses.
  * Input values: ZJM9567
  * Expected outcome: Output: All address formats are displayed appropriately
  * Mandatory: Mandatory
* Reference: NHI-GET-10
  * Purpose – Demonstrate that the: application can handle a response when a patient hasonly a family name (ZAU8023, ZAV8657);multiple names (ZHS7524)
  * Input values: **Do all**ZAU8023, ZAV8657ZHS7524
  * Expected outcome: Output:* application does not error
* application returns all name parts when present
* order of name parts is clear to the user

  * Mandatory: mandatory

#### NHI Patient GET tests - Enrolled GP

* Reference: NHI-GET-11
  * Purpose – Demonstrate that the: application can display the patients's enrolled General Practice details returned by the NHI in a GET response including:* The NES enrolment id
* enrolment.startDate
* enrolment.expiryDate
* Practitioner identifier (CPN) and name
* enrolling organisation ID and name
* Facility ID and name

  * Input values: 1. ZKC4641
* Practitioner
* Organisation
* Facility

1. ZKC4633
* Practitioner
* Organisation
* Facility

1. ZAN5358
* Organisation
* Facility


  * Expected outcome: Output:* application does not error
* application returns all General Practice details when present

  * Mandatory: Mandatory

#### NHI Patient GET tests - Contact details

* Reference: NHI-GET-12
  * Purpose – Demonstrate that the: application can display the patients's contact details returned by the NHI in a GET response including:* Home phone
* Mobile phone
* Email address

  * Input values: 1. ZKC4650
* Home phone
* Mobile phone
* Email address

1. ZKC4633
* Home phone
* Mobile phone
* Email address


  * Expected outcome: * Output: 
* application does not error
* application returns all Contact details when present
 

  * Mandatory: Mandatory

#### NHI Patient Match tests

* Reference: NHI-Match-1
  * Purpose – Demonstrate that the: application allows the user to search using the following attributes:* Name 
*  First name (Given Name) 
*  Middle name (Other given name) 
*  Last name (Family Name)

* Date of birth (Full or partial)
And to show that the application can present the minimum details to allow for adequate confirmation of identity.* Name 
*  First name (Given Name) 
*  Middle name (Other given name) 
*  Last name (Family Name)
 
* Date of birth (Full or partial)
* Gender
* Primary Address
* Date of Death
* NHI Identifier
* Match Score
* Display a flag/indicate when a patient in the search result has multiple names
Note:* The application must display multiple results if they are returned.
* Results must be presented in descending order of the match score.

  * Input values: *  Name 
* Given Name: Noah
* Middle Name: James
* Family Name: Owen
 
* Gender: M
* DOB: 1949-10-30 (30th October 1949)

  * Expected outcome: *  Input: Minimum search criteria can be entered
*  Output: 
* The top result returned in the search should be NHI ZAT4626
* Minimum search result identity attributes are all present in result list
 

  * Mandatory: mandatory
* Reference: NHI-Match-2 (if applicable)
  * Purpose – Demonstrate that the: application allows the user to search with additional match criteriaIf the application is populating any of these other parameters in your Match request then do this one tooThe additional criteria includes:* Address
* Date of Death
* Place of Birth
* Country of Birth
* Building name

  * Input values: * Name
* Gender: F
* Date of Birth: 28-09-1954
* Street: 167 Springfield Road
* Suburb: St Albans
* townOrCity: Christchurch
* dateOfDeath: 1975-05
* Place of Birth: Wellington
* Country of Birth: India (Code ‘IN’)
* Building name: Buildingnametest

  * Expected outcome: * Input: Additional Search Criteria can be populated
* Output:First result returned in the search result list should be NHI ZAT4642

  * Mandatory: mandatory (if applicable)
* Reference: NHI-Match-3
  * Purpose – Demonstrate that the: application can manage many NHI resources in the response bundle and that results are presented in descending order of the match score
  * Input values: * Name
*  Gender: F 
*  DOB: 03-07-2003 

  * Expected outcome: *  Input: Above criteria can be entered 
*  Output 
*  9 results are returned
* The top result returned is NHI: ZMP4241 Score: 99
 

  * Mandatory: mandatory
* Reference: NHI-Match-Error-1
  * Purpose – Demonstrate that the: application can return the appropriate error message to the user
  * Input values: Use a Match request to try and retrieve a record with Given Name: Rhetoric
  * Expected outcome: Output: Expected error message: Date of Birth is a required
  * Mandatory: mandatory
* Reference: NHI-Match-Error-2
  * Purpose – Demonstrate that the: application can return the appropriate error message to the user
  * Input values: Use a Match request to try and retrieve a record with Date of Birth: 28-09-1954
  * Expected outcome: Output: Expected error message: Name is required
  * Mandatory: mandatory

#### NHI Patient Match tests (Minimum data requirements)

* Reference: NHI-Match-4 (NHI-Get-1)
  * Purpose – Demonstrate that the: the application displays the minimum patient information required to confirm identity:* Preferred name including Given Name(s), Family Name
* Date of Birth
* Gender
* Primary Address - including the building name

  * Input values: Use a Match request to retrieve ZJS7596 and demonstrate how you display the NHI detailsFamily Name: MarakaGiven Names: Jamie, SusanDate of birth:25-08-1977Gender: FemaleAddress: 2 Tennyson Street, Napier South, Napier, 4110Use - HomeType - Physical
  * Expected outcome: Input: Above criteria can be enteredOutput: The top result returned is NHI: ZJS7596Output: Minimum identity information is displayed for the patient
  * Mandatory: Mandatory
* Reference: NHI-Match-5 (NHI-Get-2)
  * Purpose – Demonstrate that the: application can display the Date of Death
  * Input values: Use a Match request to retrieve ZAT2348 and demonstrate how you display the NHI detailsFamily Name: Smith-MartinGiven Names: Laura, RoseDate of birth:14-07-1970Gender: FemaleAddress:Not validated-address-reason - No Fixed Abode,Domicile code - D091,Use - Home,Type - Physical
  * Expected outcome: Input: Above criteria can be enteredOutput: The top result returned is NHI: ZAT2348Output: The application alerts the user that the patient is deceased and provides the date of death
  * Mandatory: Mandatory
* Reference: NHI-Match-6 (NHI-Get-3)
  * Purpose – Demonstrate that the: application can display all other identity data returned by the NHI in a GET response including:* All patient names with all name parts
* Name Information Source
* Date of Birth Information Source
* Ethnicity information
* All patient addresses and address parts
* NZ Citizenship status
* Country of Birth
* Country of Birth source
* Place of Birth

  * Input values: Use a Match request to retrieve ZAT2364 and demonstrate how you display the NHI detailsFamily Name: JohnGiven Names: Levi, SandsDate of birth:26-02-1995Gender: Male
  * Expected outcome: Input: Above criteria can be enteredOutput: All identity information is displayed for the patient.The patient:* Is alive
* Has 4 names - no name use + preferred = true, no name use + preferred = false, one ‘baby of’, one maiden
* The preferred name should have all name parts populated
* Has two addresses, the primary resedential (physical) address is overseas and the mailing (postal) address is in NZ
* Has three ethnicities
* Is a NZ citizen

  * Mandatory: Mandatory
* Reference: NHI-Match-7 (NHI-Get-4)
  * Purpose – Demonstrate that the: application can display all other identity data returned by the NHI in a GET response including:* A non validated primary address
* A year of birth and a year and month of death (partial dates)
* Unknown citizenship

  * Input values: Use a Match request to retrieve ZAT2496 and demonstrate how you display the NHI detailsFamily Name: YossarianGiven Names: John, TestDate of birth:01-01-1914Gender: Male
  * Expected outcome: Input: Above criteria can be enteredOutput: All identity information is displayed for the patient. This is for a patient record that has partial information in some fields. The patient has:* A not validated physical address
* Partial date of death
* Partial date of birth

  * Mandatory: Mandatory
* Reference: NHI-Match-8 (NHI-Get-6)
  * Purpose – Demonstrate that the: application can receive and display NHI responses that have fields populated with the maximum allowable sizes (e.g. A given name of 50 characters, Other given name(s) of 100 characters, Surname of 100 characters)
  * Input values: Use a Match request to retrieve ZBE4905 and demonstrate how you display the NHI detailsFamily Name: SurnameVeryLongLongLongnamewithtoomanycharactersVeryVeryVeryLongLongLongnamewithtoomanycharactersGiven Names: GivenVeryVeryLongLongLongnamewithtoomanycharacters, MiddleVeryLongLongLongnamewithtoomanycharactersVeryVeryVeryLongLongLongnamewithtoomanycharactersDate of birth:01-01-1974Gender: Female
  * Expected outcome: Input: Above criteria can be enteredOutput: The application can manage a patient record that has attribute values which are the maximum allowed field length in some fieldsThe patient has the following fields fully populated in the test record (field lengths in parentheses):* Given name (50)
* Other Given Name(s) (100)
* Surname (100)
* Address line 1 (100)
* Address lines 2-5 (50)
* Building name/additional details (255)

  * Mandatory: Mandatory
* Reference: NHI-Match-9 (NHI-Get-7)
  * Purpose – Demonstrate that the: application behaves appropriately when a new format NHI number is produced
  * Input values: Use a Match request to retrieve either ZXE24NV or ZUA48EH and demonstrate how you display the NHI details1.**ZXE24NV**Family Name: FEDERSTEINGiven Name: FRANKLINDate of birth:1999-04-04Gender: male2.**ZUA48EH**Family Name: BRADYGiven Names: THOMAS, JAMES TESTDate of birth:1971-11-11Gender: male
  * Expected outcome: Input: Above criteria can be enteredOutput: Application does not error
  * Mandatory: Mandatory
* Reference: NHI-Match-10 (NHI-Get-8)
  * Purpose – Demonstrate that the: application can synchronize with local system in response to the NHI version changing
  * Input values: Use a Match request to retrieve ZCX7065, using details:Family Name: ALLENGiven Name: JOSEPHDate of birth:01-04-1950Gender: Female
  * Expected outcome: * Do a Match
* Update the patient details (to simulate a 3rd party updating the NHI info)
* Do another Match
* Demonstrate how end user can view the difference then synchronize

  * Mandatory: Mandatory
* Reference: NHI-Match-11 (NHI-Get-9)
  * Purpose – Demonstrate that the: application presents the address parts appropriately, including multiple addresses
  * Input values: Use a Match request to retrieve ZJM9567 and demonstrate how you display the NHI detailsFamily Name: MultipleAddressGiven Name: FrancisDate of birth:12-12-1982Gender: Male
  * Expected outcome: Input: Above criteria can be enteredOutput: All address formats are displayed appropriately
  * Mandatory: Mandatory
* Reference: NHI-Match-12 (NHI-Get-10)
  * Purpose – Demonstrate that the: application can handle a response when a patient hasonly a surname;multiple names
  * Input values: Use a Match request to retrieve** all of the following **and demonstrate how you display the NHI details** 1. ZAU8023 - surname only **Family Name: MagiDate of birth:01-01-2012Gender: Unknown** 2. ZAV8657 - surname only **Family Name: CambridgeDate of birth:12-04-1960Gender: Male** 3. ZHS7524 - multiple names **Family Name: WILLISGiven Names: ELIZABETH, MARGARETDate of birth:15-06-2002Gender: Female
  * Expected outcome: Input: Above criteria can be entered for the 3 Match scenarios** 1. Output: The top result returned is NHI: ZAU8023 **** 2. Output: The top result returned is NHI: ZAV8657 **** 3. Output: The top result returned is NHI: ZHS7524 **Output: Application does not errorOutput: Application returns all name parts when presentOutput: Order of name parts is clear to the user
  * Mandatory: Mandatory

#### NHI Validate Patient tests

* Reference: NHI-Validate-1
  * Purpose – Demonstrate that the: application makes appropriate use or displays correct messaging for a positive Patient Validate with the minimum validate criteria*  NHI number
* Name
* Birthdate

  * Input values: *  NHI: ZJS7596
*  Name 
* Given Name: Jamie
* Middle Name: Susan
* Family Name: Maraka
 
* DOB: 1977-08-25 (25th August 1977)

  * Expected outcome: *  Input: Minimum validate criteria can be entered
*  Output: The validate should return a successful result

  * Mandatory: mandatory
* Reference: NHI-Validate-2
  * Purpose – Demonstrate that the: application makes appropriate use or displays correct messaging for a positive Patient Validate using other validate criteria
  * Input values: *  NHI: ZJS7596
*  Name 
* Given Name: Jamie
* Middle Name: Susan
* Family Name: Maraka
 
* Gender: Female
* DOB: 1977-08-25 (25th August 1977)
*  Address 
* Line: 2 Tennyson Street
* Suburb: Napier South
* City: Napier
* Postcode: 4110
 

  * Expected outcome: *  Input: Other validate criteria can be included
*  Output: The validate should return a successful result

  * Mandatory: mandatory
* Reference: NHI-Validate-3
  * Purpose – Demonstrate that the: application makes appropriate use or displays correct messaging for a negative Patient Validate
  * Input values: *  NHI: ZJK9604
*  Name 
* Given Name: Jaime
* Family Name: jones
 
* Gender: Female
* DOB: 1979-06-10 (10th June 1979)
*  Address 
* Line: "PO Box 525", "Whanganui 4541"
 

  * Expected outcome: *  Input: Validate criteria can be entered
*  Output: The validate should return a negative result (Empty bundle)

  * Mandatory: mandatory

