# ELGA.MOPED\ANWF 14 - Selbstzahler - FHIR® v5.0.0

* [**Table of Contents**](toc.md)
* [**Überblick & Sunshine Case**](anwendungsfaelle.md)
* **ANWF 14 - Selbstzahler**

## ANWF 14 - Selbstzahler

## Anwendungsfall 14: Selbstzahler

### Betroffene Akteure

| | |
| :--- | :--- |
| KH (Krankenhaus) | ✅ |
| LGF (Landesgesundheitsfonds) | ✅ |
| SV (Sozialversicherung) | ❌ |
| Bund | ✅ |

### Betroffene Behandlungsarten

| | |
| :--- | :--- |
| Ambulant | ✅ |
| Stationär | ✅ |

### Beschreibung: Selbstzahler

Vorgehensweise für Patienten, die nicht über die Sozialversicherungsschiene gemeldet werden, da sie Selbstzahler sind, jedoch im LKF aufscheinen.

### Beispiel

Nicht-EU Ausländer (z.B. US -Bürger), Patienten die über die Sozialhilfe oder Justizanstalten abgerechnet werden 

### Technische Hinweise

Die Composition Section zustaendigeSV bleibt in diesem Fall leer, was Auswirkungen auf die Berechtigungen und den weiteren Ablauf hat. Die Operation $melden ist z.B. in diesem Fall nicht erlaubt und würde fehlschlagen.

### Ablauf

```

---
    config:
      theme: 'base'
      themeVariables:
        primaryColor: '#dbdbdb'         
        actorBorder: '#666'
        noteBkgColor: '#f4f4f4'
        noteBorderColor: '#555'
    ---
    sequenceDiagram
    autonumber
    box rgb(245, 229, 153)
    actor KH as KH (Herz Jesu Krankenhaus)
    end
    box rgb(197, 247, 186)
    participant MP as Moped
    end
    box rgb(186, 196, 247)
    actor SV as SV (ÖGK Wien)
    end
    box rgb(247, 208, 186)
    actor LGF as LGF (Landesgesundheitsfonds Wien)
    end
    box rgb(252, 179, 179) 
    actor Bund as Bund 
    end

    KH->>MP: $aufnehmen
    Note over KH: Patient wird aufgenommen (mit einer Selbstzahler-Coverage)

    KH->>MP: $update
    Note over KH: Verlegung auf Abteilung Innere Medizin

    KH->>MP: $update
    Note over KH: Diagnose „Herzinsuffizienz“ und Leistung „EKG“ erfasst 

    KH->>MP: $entlassen
    Note over KH: Patient wird entlassen 

    loop $abrechnen / $entscheiden (vorläufig)
        KH->>MP: $abrechnen
        Note over KH: Abrechnung aller Leistungen eingereicht 

        LGF->>MP: $entscheiden
        Note over LGF: Alle Posten genehmigt (keine Änderungen)
    end 

    %% Finale Abrechnung und Entscheidung
    KH->>MP: final $abrechnen
    Note over KH: Finale Abrechnung nach Entlassung

    LGF->>MP: final $entscheiden
    Note over LGF: Endgültige Entscheidung zur Abrechnung 

    Bund->>MP: GET Composition?status=final
    Note over Bund: Zugriff auf finale Composition


```

### Relevante Profile

* Selbstzahler Coverage (TBD Link)

### Relevante Invarianten

### Mögliche Notifications

Keine relevanten Notifications für diesen Anwendungsfall identifiziert.

