# elga.moped#0.1.0: Moderne Patient:innenabrechnung und Datenkommunikation on FHIR (MOPED)

## Pages

* [ELGA.MOPED\Home - FHIR® v5.0.0](index.md)
* [ELGA.MOPED\ANWF 46 - VDAS Rückmeldung (Patient verstorben) - FHIR® v5.0.0](AF46.md)
* [ELGA.MOPED\MBDS Mapping - FHIR® v5.0.0](lkf_mapping.md)
* [ELGA.MOPED\ANWF 38-44 - LKF Daten - FHIR® v5.0.0](AF38bis44.md)
* [ELGA.MOPED\ANWF 10 - Klassenwechsel - FHIR® v5.0.0](AF10.md)
* [ELGA.MOPED\ANWF 48 - Mehrere aktive Fälle in MOPED - FHIR® v5.0.0](AF48.md)
* [ELGA.MOPED\ANWF 21,22 - Neugeborene - FHIR® v5.0.0](AF21u22.md)
* [ELGA.MOPED\ANWF 6 - Mehrmalige Aufnahme an einem Tag - FHIR® v5.0.0](AF6.md)
* [ELGA.MOPED\Stammdaten - FHIR® v5.0.0](stammdaten_mapping.md)
* [ELGA.MOPED\ANWF 3 - Ambulante Aufnahme - FHIR® v5.0.0](AF3.md)
* [ELGA.MOPED\ANWF 28-32 - SV Kostenübernahmevariationen - FHIR® v5.0.0](AF28bis32.md)
* [ELGA.MOPED\ANWF 1 - Planaufnahme - FHIR® v5.0.0](AF1.md)
* [ELGA.MOPED\ANWF 50 - Urgenz - FHIR® v5.0.0](AF50.md)
* [ELGA.MOPED\ANWF 18 - Transfer - FHIR® v5.0.0](AF18.md)
* [ELGA.MOPED\ANWF 49 - Aufrollung nach Speicherfrist - FHIR® v5.0.0](AF49.md)
* [ELGA.MOPED\LKF Jahresmeldung - FHIR® v5.0.0](jahresmeldungen_mapping.md)
* [ELGA.MOPED\ANWF 23-25 - Entlassung & Hauptdiagnose - FHIR® v5.0.0](AF23bis25.md)
* [ELGA.MOPED\Ka-Org Mapping - FHIR® v5.0.0](ka-org_mapping.md)
* [ELGA.MOPED\ANWF 45 - Jahresmeldung - FHIR® v5.0.0](AF45.md)
* [ELGA.MOPED\ANWF 11 - Versicherungswechsel - FHIR® v5.0.0](AF11.md)
* [ELGA.MOPED\Grundlegende Konzepte und Design-Entscheidungen - FHIR® v5.0.0](moped_konzepte.md)
* [ELGA.MOPED\ANWF 33-34 - Kostenmeldungen? - FHIR® v5.0.0](AF33u34.md)
* [ELGA.MOPED\ANWF 26 - Überlieger - FHIR® v5.0.0](AF26.md)
* [ELGA.MOPED\ANWF 20 - Urlaub - FHIR® v5.0.0](AF20.md)
* [ELGA.MOPED\Dependencies - FHIR® v5.0.0](dependencies.md)
* [ELGA.MOPED\Copyright - FHIR® v5.0.0](copyright.md)
* [ELGA.MOPED\ANWF 27 - Leistungen ohne Abrechnungsrelevanz - FHIR® v5.0.0](AF27.md)
* [ELGA.MOPED\Überblick & Sunshine Case - FHIR® v5.0.0](anwendungsfaelle.md)
* [ELGA.MOPED\Hintergrund - FHIR® v5.0.0](background.md)
* [ELGA.MOPED\ANWF 19 - Interne Verlegung - FHIR® v5.0.0](AF19.md)
* [ELGA.MOPED\ANWF 12,13,15,35-37 - Ausländerverrechnung und Regress - FHIR® v5.0.0](AF12.md)
* [ELGA.MOPED\ANWF 4,5 - Fallartwechsel - FHIR® v5.0.0](AF4u5.md)
* [ELGA.MOPED\ANWF 14 - Selbstzahler - FHIR® v5.0.0](AF14.md)
* [ELGA.MOPED\Impressum - FHIR® v5.0.0](imprint.md)
* [ELGA.MOPED\ANWF 51-52 - Asylierung - FHIR® v5.0.0](AF51u52.md)
* [ELGA.MOPED\ANWF 8,9,47 - Stammdatenabgleich - FHIR® v5.0.0](AF8u9u47.md)
* [ELGA.MOPED\Known Issues - FHIR® v5.0.0](known_issues.md)
* [ELGA.MOPED\Herausforderungen - FHIR® v5.0.0](challenges.md)
* [ELGA.MOPED\Mitwirkende - FHIR® v5.0.0](authors.md)
* [ELGA.MOPED\ANWF 2 - Stationäre Aufnahme - FHIR® v5.0.0](AF2.md)
* [ELGA.MOPED\ANWF 54 - Stammdatenänderung - FHIR® v5.0.0](AF54.md)
* [ELGA.MOPED\Umfang und Inhalt - FHIR® v5.0.0](scope_and_content.md)
* [ELGA.MOPED\Mappings - FHIR® v5.0.0](mappings.md)
* [ELGA.MOPED\ANWF 53 - Intensivaufenthalt - FHIR® v5.0.0](AF53.md)
* [ELGA.MOPED\Workflowmanagement - FHIR® v5.0.0](workflowmanagement.md)
* [ELGA.MOPED\ANWF 17 - Zwischenbetriebliche Leistungserbringung - FHIR® v5.0.0](AF17.md)
* [ELGA.MOPED\Artifacts Summary - FHIR® v5.0.0](artifacts.md)
* [ELGA.MOPED\Downloads - FHIR® v5.0.0](downloads.md)
* [ELGA.MOPED\Akteure - FHIR® v5.0.0](actors.md)
* [ELGA.MOPED\ANWF 7 - Behandlungsabbruch - FHIR® v5.0.0](AF7.md)
* [ELGA.MOPED\Obligations - FHIR® v5.0.0](obligations.md)

## Resources

### CodeSystems

* [Moped Aufnahmeart des Patienten](CodeSystem-AbgangsartCS.md)
* [Abrechnungsrelevanz der medizinischen Leistung](CodeSystem-AbrechnungsRelevanzCS.md)
* [Abrechnungsart Ausländerverrechnung CodeSystem](CodeSystem-AbrechnungsartAuslaenderverrechnungCS.md)
* [Altersgruppe des Patienten](CodeSystem-AltersgruppeCS.md)
* [Anwesenheitsart](CodeSystem-AnwesenheitsartCS.md)
* [Aufnahmeart2 des Patienten](CodeSystem-Aufnahmeart2CS.md)
* [Moped Aufnahmeart des Patienten](CodeSystem-AufnahmeartCS.md)
* [Behandlungsart](CodeSystem-BehandlungsartCS.md)
* [MOPED VAESupportingInformationCategory](CodeSystem-ClaimSupportingInformationCategoryCS.md)
* [Moped Composition Sections](CodeSystem-CompositionSectionsCS.md)
* [Akzeptierte Errors/Warnings - Codes 2025](CodeSystem-EWCodes2025CS.md)
* [Entlassungsart des Patienten](CodeSystem-EntlassungsartCS.md)
* [Fondsrelevanz](CodeSystem-FondsrelevanzCS.md)
* [LKF Abrechnungsgruppe Andere](CodeSystem-LKFAbrechnungsGruppeAndereCS.md)
* [LKF Abrechnungsknoten](CodeSystem-LKFAbrechnungsKnotenCS.md)
* [LKF Hauptdiagnosegruppen](CodeSystem-LKFHauptdiagnosegruppenCS.md)
* [LKF medizinische Einzelleistungen (MEL)](CodeSystem-LKFmedizinischeEinzelleistungenCS.md)
* [Moped Claim Item Category CodeSystem](CodeSystem-MopedClaimItemCategoryCS.md)
* [Claim Subtype CodeSystem](CodeSystem-MopedClaimSubTypeCS.md)
* [Claim Type CodeSystem](CodeSystem-MopedClaimTypeCS.md)
* [Moped Device Types CodeSystem](CodeSystem-MopedDeviceTypesCS.md)
* [Moped Encounter Participant Type CodeSystem](CodeSystem-MopedEncounterParticipantTypesCS.md)
* [Arten von Moped Encounter](CodeSystem-MopedEncounterTypesCS.md)
* [Arten von Moped Payment Types CS](CodeSystem-MopedPaymentTypesCS.md)
* [Sonderklasse CodeSystem](CodeSystem-SonderklasseCS.md)
* [Spezielle Betriebsform](CodeSystem-SpezielleBetriebsformenCS.md)
* [Spezielle Organisationsformen](CodeSystem-SpezielleOrganisationsformenCS.md)
* [Transportart](CodeSystem-TransportartCS.md)
* [Ursache für Behandlung](CodeSystem-UrsacheCS.md)
* [Status der Versichertenanspruchserklärung](CodeSystem-VAEStatusCS.md)
* [Verdacht auf Arbeits- oder Schuelerunfall CodeSystem](CodeSystem-VerdachtArbeitsSchuelerunfallCS.md)
* [Befreiung für den Verpflegskostenbeitrag](CodeSystem-VerpflegskostenBeitragsbefreiungCS.md)
* [Workflow Status eines Falls](CodeSystem-WorkflowStatusCS.md)
* [CodeSystem Zahlungskennzeichen Auslaenderverrechnung](CodeSystem-ZahlungskennzeichenAuslaenderverrechnungCS.md)
* [CodeSystem Zahlungskennzeichen Regress](CodeSystem-ZahlungskennzeichenRegressCS.md)

### ValueSets

* [Abgangsart des Patienten](ValueSet-AbgangsartVS.md)
* [Abrechnungsrelevanz der medizinischen Leistung](ValueSet-AbrechnungsRelevanzVS.md)
* [Abrechnungsart Ausländerverrechnung ValueSet](ValueSet-AbrechnungsartAuslaenderverrechnungVS.md)
* [Altersgruppe des Patienten](ValueSet-AltersgruppeVS.md)
* [Anwesenheitsart](ValueSet-AnwesenheitsartVS.md)
* [Aufnahmeart2 des Patienten](ValueSet-Aufnahmeart2VS.md)
* [Aufnahmeart des Patienten](ValueSet-AufnahmeartVS.md)
* [Behandlungsart](ValueSet-BehandlungsartVS.md)
* [MOPED VAESupportingInformationCategory](ValueSet-ClaimSupportingInformationCategoryVS.md)
* [Moped Composition Sections ValueSet](ValueSet-CompositionSectionsVS.md)
* [Akzeptierte Errors/Warnings - Codes 2025](ValueSet-EWCodes2025VS.md)
* [Entlassungsart des Patienten ambulant](ValueSet-EntlassungsartAVS.md)
* [Entlassungsart des Patienten stationär](ValueSet-EntlassungsartSVS.md)
* [Entlassungsart des Patienten ambulant + stationär](ValueSet-EntlassungsartVS.md)
* [Fondsrelevanz](ValueSet-FondsrelevanzVS.md)
* [HTTP Verb Insert Only](ValueSet-HTTPVerbInsertOnlyVS.md)
* [HTTP Verb Insert Update Delete](ValueSet-HTTPVerbInsertUpdateDeleteVS.md)
* [HTTP Verb Update Only](ValueSet-HTTPVerbUpdateOnlyVS.md)
* [ICD-10 AT](ValueSet-ICD10ATVS.md)
* [Kostenmeldung für (A/R/K)](ValueSet-KostenmeldungARKVS.md)
* [LKF Abrechnungsgruppe](ValueSet-LKFAbrechnungsGruppeVS.md)
* [LKF Abrechnungsknoten](ValueSet-LKFAbrechnungsKnotenVS.md)
* [LKF Diagnosetyp ValueSet](ValueSet-LKFDiagnoseTypVS.md)
* [LKF Hauptdiagnosegruppen](ValueSet-LKFHauptdiagnosegruppenVS.md)
* [LKF Leistungskatalog BMSGPK](ValueSet-LKFLeistungskatalogVS.md)
* [LKF Seitenlokalisation ValueSet](ValueSet-LKFSeitenlokalisationVS.md)
* [MOPED LKFSupportingInformationCategory](ValueSet-LKFSupportingInformationCategoryVS.md)
* [LKF medizinische Einzelleistungen (MEL)](ValueSet-LKFmedizinischeEinzelleistungenVS.md)
* [Moped Claim Item Category ValueSet](ValueSet-MopedClaimItemCategoryVS.md)
* [Claim Type ValueSet](ValueSet-MopedClaimTypeVS.md)
* [Moped Device Types ValueSet](ValueSet-MopedDeviceTypesVS.md)
* [Moped Encounter Participant Type ValueSet](ValueSet-MopedEncounterParticipantTypesVS.md)
* [Encounter Status bei der Aufnahme](ValueSet-MopedEncounterStatusAufnahmeVS.md)
* [Encounter Status bei Entlassung](ValueSet-MopedEncounterStatusEntlassungVS.md)
* [Encounter Status in Moped](ValueSet-MopedEncounterStatusVS.md)
* [Arten von Moped Encounter](ValueSet-MopedEncounterTypesVS.md)
* [LKF ClaimResponse Subtype ValueSet](ValueSet-MopedLKFRequestSubTypeVS.md)
* [Arten von Moped Payment Types VS](ValueSet-MopedPaymentTypesVS.md)
* [VAE Claim Subtype ValueSet](ValueSet-MopedVAERequestSubTypeVS.md)
* [Sonderklasse ValueSet](ValueSet-SonderklasseVS.md)
* [Spezielle Organisationsform](ValueSet-SpezielleOrganisationsformVS.md)
* [Transportart](ValueSet-TransportartVS.md)
* [Ursache für Behandlung](ValueSet-UrsacheVS.md)
* [Status der Versichertenanspruchserklärung](ValueSet-VAEStatusVS.md)
* [MOPED VAESupportingInformationCategory](ValueSet-VAESupportingInformationCategoryVS.md)
* [Verdacht auf Arbeits- oder Schuelerunfall ValueSet](ValueSet-VerdachtArbeitsSchuelerunfallVS.md)
* [Befreiung für den Verpflegskostenbeitrag](ValueSet-VerpflegskostenBeitragsbefreiungVS.md)
* [Workflow Status eines Falls](ValueSet-WorkflowStatusVS.md)
* [ValueSet Zahlungskennzeichen ARK](ValueSet-ZahlungskennzeichenVS.md)

### Resource Profiles

* [Bund Organization](StructureDefinition-BundOrganization.md)
* [Dachverband Organization](StructureDefinition-DachverbandOrganization.md)
* [MOPED Hauptversicherter](StructureDefinition-Hauptversicherter.md)
* [KH Organization](StructureDefinition-KHOrganization.md)
* [LGF Organization](StructureDefinition-LGFOrganization.md)
* [MOPED ARKRequest](StructureDefinition-MopedARKRequest.md)
* [MOPED ARKResponse](StructureDefinition-MopedARKResponse.md)
* [MOPED ARK Status Update - PaymentReconciliation](StructureDefinition-MopedARKStatusUpdate.md)
* [MOPED Abrechnen Bundle KH](StructureDefinition-MopedAbrechnenBundleKH.md)
* [MOPED Anfragen Bundle KH](StructureDefinition-MopedAnfragenBundleKH.md)
* [MOPED Anfragen Composition](StructureDefinition-MopedAnfragenComposition.md)
* [MOPED Antworten Bundle SV](StructureDefinition-MopedAntwortenBundleSV.md)
* [MOPED Aufnahme Composition](StructureDefinition-MopedAufnahmeComposition.md)
* [MOPED Aufnehmen Bundle KH](StructureDefinition-MopedAufnehmenBundleKH.md)
* [MOPED Beantworten Composition](StructureDefinition-MopedBeantwortenComposition.md)
* [MOPED Composition](StructureDefinition-MopedComposition.md)
* [MOPED Condition](StructureDefinition-MopedCondition.md)
* [MOPED Coverage](StructureDefinition-MopedCoverage.md)
* [MOPED Coverage für Selbstzahler](StructureDefinition-MopedCoverageSelbstzahler.md)
* [Moped Device](StructureDefinition-MopedDevice.md)
* [Moped Device XDok](StructureDefinition-MopedDeviceXDok.md)
* [MOPED Encounter](StructureDefinition-MopedEncounter.md)
* [MOPED Encounter Ambulant](StructureDefinition-MopedEncounterA.md)
* [MOPED Encounter Aufnahme Stationär](StructureDefinition-MopedEncounterAufnahmeS.md)
* [MOPED Encounter Bund](StructureDefinition-MopedEncounterBund.md)
* [MOPED Encounter Entlassung Stationär](StructureDefinition-MopedEncounterEntlassungS.md)
* [MOPED Encounter LGF](StructureDefinition-MopedEncounterLGF.md)
* [MOPED Encounter Stationär](StructureDefinition-MopedEncounterS.md)
* [MOPED Encounter SV](StructureDefinition-MopedEncounterSV.md)
* [MOPED Entlassung Aviso Composition](StructureDefinition-MopedEntlassenAvisoComposition.md)
* [MOPED Entlassen Bundle KH](StructureDefinition-MopedEntlassenBundle.md)
* [MOPED Entlassung vollständig Composition](StructureDefinition-MopedEntlassenVollstaendigComposition.md)
* [MOPED Entscheiden Bundle LGF](StructureDefinition-MopedEntscheidenLGFBundle.md)
* [MOPED KH Organisationseinheiten](StructureDefinition-MopedKHOrganisationseinheit.md)
* [MOPED LKFRequest](StructureDefinition-MopedLKFRequest.md)
* [MOPED LKFResponse](StructureDefinition-MopedLKFResponse.md)
* [MOPED Master Composition](StructureDefinition-MopedMasterComposition.md)
* [MOPED Melden Bundle LGF](StructureDefinition-MopedMeldenLGFBundle.md)
* [MOPED Patient](StructureDefinition-MopedPatient.md)
* [MOPED Patient Bund](StructureDefinition-MopedPatientBund.md)
* [MOPED Patient LGF](StructureDefinition-MopedPatientLGF.md)
* [MOPED Patient SV](StructureDefinition-MopedPatientSV.md)
* [MOPED Procedure](StructureDefinition-MopedProcedure.md)
* [MOPED QuestionnaireResponse einmelden Bundle](StructureDefinition-MopedQuestionnaireResponseEinmeldenBundle.md)
* [Moped QuestionnaireResponse](StructureDefinition-MopedQuestionnaireResponseFallbezogen.md)
* [Moped QuestionnaireResponse](StructureDefinition-MopedQuestionnaireResponseNichtFallbezogen.md)
* [MOPED TransferEncounter](StructureDefinition-MopedTransferEncounter.md)
* [MOPED TransferEncounter Ambulant](StructureDefinition-MopedTransferEncounterA.md)
* [MOPED TransferEncounter Intensiv](StructureDefinition-MopedTransferEncounterI.md)
* [MOPED TransferEncounter Stationär](StructureDefinition-MopedTransferEncounterS.md)
* [MOPED Update Bundle KH](StructureDefinition-MopedUpdateBundleKH.md)
* [MOPED Update Composition](StructureDefinition-MopedUpdateComposition.md)
* [MOPED VAERequest](StructureDefinition-MopedVAERequest.md)
* [MOPED VAERequest für die initiale Anfrage der VAE](StructureDefinition-MopedVAERequestInitial.md)
* [MOPED VAERequest für die Verlängerung der VAE](StructureDefinition-MopedVAERequestVerlaengerung.md)
* [MOPED VAEResponse](StructureDefinition-MopedVAEResponse.md)
* [SV Organization](StructureDefinition-SVOrganization.md)

### Extensions

* [Supporting Info Extension for ClaimResponse](StructureDefinition-MopedSupportingInfo.md)
* [Supporting Info Extension for ClaimResponse - FREMDRE Slice](StructureDefinition-MopedSupportingInfoFREMDRE.md)
* [Supporting Info Extension for ClaimResponse - OEGKELBNR Slice](StructureDefinition-MopedSupportingInfoOEGKELBNR.md)
* [Supporting Info Extension for ClaimResponse - Sonderklasse Slice](StructureDefinition-MopedSupportingInfoSonderklasse.md)
* [Supporting Info Extension for ClaimResponse - Vortageanzahl auf Kostenbeitrag](StructureDefinition-MopedSupportingInfoVortageanzahlAufKostenbeitrag.md)
* [Medizinische Leistung - Abrechnungsrelevanz](StructureDefinition-moped-ext-AbrechnungsRelevanz.md)
* [Abrechnungsart Ausländerverrechnung](StructureDefinition-moped-ext-AbrechnungsartAuslaenderverrechnung.md)
* [AddItemCategory](StructureDefinition-moped-ext-AddItemCategory.md)
* [AnzahlBeurlaubungen](StructureDefinition-moped-ext-AnzahlBeurlaubungen.md)
* [AnzahlVerlegungen](StructureDefinition-moped-ext-AnzahlVerlegungen.md)
* [Beihilfenaequivalent](StructureDefinition-moped-ext-Beihilfenaequivalent.md)
* [Betreuungsschein bei Ausländerverrechnung](StructureDefinition-moped-ext-Betreuungsschein.md)
* [Diagnosetyp](StructureDefinition-moped-ext-Diagnosetyp.md)
* [Kostenstelle](StructureDefinition-moped-ext-Kostenstelle.md)
* [Leistung - Anzahl](StructureDefinition-moped-ext-Leistungsanzahl.md)
* [Prozentsatz der Zahlung](StructureDefinition-moped-ext-PaymentPercentage.md)
* [Grund warum keine Zahlung erfolgte](StructureDefinition-moped-ext-ReasonForNonPayment.md)
* [Rechnungsnummer der Krankenanstalt bzw. des Landesgesundheitsfonds](StructureDefinition-moped-ext-RechnungsnummerKHLGF.md)
* [Tage ohne Einhebung des Kostenbeitrags](StructureDefinition-moped-ext-TageOhneKostenbeitrag.md)
* [Zahlungskennzeichen](StructureDefinition-moped-ext-Zahlungskennzeichen.md)
* [Altersgruppe](StructureDefinition-moped-ext-altersgruppe.md)
* [Aufnahmeart](StructureDefinition-moped-ext-aufnahmeart.md)
* [Abrechnung - Knoten](StructureDefinition-moped-ext-diagnoseKnoten.md)
* [Error/Warning](StructureDefinition-moped-ext-fehlerWarnung.md)
* [Fondsrelevanz](StructureDefinition-moped-ext-fondsrelevanz.md)
* [Unfalldatum](StructureDefinition-moped-ext-unfalldatum.md)
* [VDAS-ID - VersichertenDatenAbfrageService](StructureDefinition-moped-ext-vdasid.md)
* [VerpflegskostenBeitragsbefreiung](StructureDefinition-moped-ext-verpflegskostenBeitragsbefreiung.md)

### ActorDefinitions

* [Moped Bund Actor](ActorDefinition-MopedBundActor.md)
* [Moped Device Actor](ActorDefinition-MopedDeviceActor.md)
* [Moped KH Actor](ActorDefinition-MopedKHActor.md)
* [Moped LGF Actor](ActorDefinition-MopedLGFActor.md)
* [Moped SV Actor](ActorDefinition-MopedSVActor.md)

### ImplementationGuides

* [Moderne Patient:innenabrechnung und Datenkommunikation on FHIR (MOPED)](index.md)

### OperationDefinitions

* [MOPED auf VAERequest oder ARKRequest $antworten](OperationDefinition-MOPED.Auf.Request.Antworten.md)
* [MOPED Kosteninformation $melden](OperationDefinition-MOPED.Claim.Melden.md)
* [MOPED ClaimResponse $entscheiden ](OperationDefinition-MOPED.ClaimResponse.Entscheiden.md)
* [MOPED Daten $update](OperationDefinition-MOPED.Daten.Update.md)
* [MOPED Encounter $abrechnen](OperationDefinition-MOPED.Encounter.Abrechnen.md)
* [MOPED Patient $aufnehmen](OperationDefinition-MOPED.Patient.Aufnehmen.md)
* [MOPED Patient $entlassen](OperationDefinition-MOPED.Patient.Entlassen.md)
* [MOPED QuestionnaireResponse $einmelden](OperationDefinition-MOPED.QuestionnaireResponse.Einmelden.md)
* [MOPED Versichertenanspruchserklärung $anfragen](OperationDefinition-MOPED.VAERequest.Anfragen.md)

### Examples

* [LKFRequest42 (Claim)](Claim-LKFRequest42.md)
* [PJ1LKFRequest1 (Claim)](Claim-PJ1LKFRequest1.md)
* [PJ1VAERequest1 (Claim)](Claim-PJ1VAERequest1.md)
* [PJ2LKFRequest1 (Claim)](Claim-PJ2LKFRequest1.md)
* [PJ2VAERequest1 (Claim)](Claim-PJ2VAERequest1.md)
* [PJ1LKFResponse1 (ClaimResponse)](ClaimResponse-PJ1LKFResponse1.md)
* [PJ1VAEResponse1 (ClaimResponse)](ClaimResponse-PJ1VAEResponse1.md)
* [PJ2LKFResponse1 (ClaimResponse)](ClaimResponse-PJ2LKFResponse1.md)
* [PJ2VAEResponse1 (ClaimResponse)](ClaimResponse-PJ2VAEResponse1.md)
* [LKF Testdaten Fall (Composition)](Composition-Composition42.md)
* [PJ1CompositionNachAufnehmen (Composition)](Composition-PJ1CompositionAufnehmen.md)
* [Condition42.1 (Condition)](Condition-Condition42.1.md)
* [PJ1Condition1 (Condition)](Condition-PJ1Condition1.md)
* [PJ2Condition1 (Condition)](Condition-PJ2Condition1.md)
* [PJ2Condition2 (Condition)](Condition-PJ2Condition2.md)
* [PJ1Coverage (Coverage)](Coverage-PJ1Coverage.md)
* [PJ2Coverage (Coverage)](Coverage-PJ2Coverage.md)
* [XDokExampleDevice (Device)](Device-XDokExampleDevice.md)
* [Encounter42 (Encounter)](Encounter-Encounter42.md)
* [PJ1Encounter (Encounter)](Encounter-PJ1Encounter.md)
* [PJ1EncounterAufnahme (Encounter)](Encounter-PJ1EncounterAufnahme.md)
* [PJ1EncounterBasis (Encounter)](Encounter-PJ1EncounterBasis.md)
* [PJ1EncounterBund (Encounter)](Encounter-PJ1EncounterBund.md)
* [PJ1EncounterLGF (Encounter)](Encounter-PJ1EncounterLGF.md)
* [PJ1EncounterSV (Encounter)](Encounter-PJ1EncounterSV.md)
* [PJ1TransferEncounter1 (Encounter)](Encounter-PJ1TransferEncounter1.md)
* [PJ1TransferEncounter1Aufnahme (Encounter)](Encounter-PJ1TransferEncounter1Aufnahme.md)
* [PJ2Encounter (Encounter)](Encounter-PJ2Encounter.md)
* [PJ2TransferEncounter1 (Encounter)](Encounter-PJ2TransferEncounter1.md)
* [PJ2TransferEncounter2 (Encounter)](Encounter-PJ2TransferEncounter2.md)
* [PJ2TransferEncounter3 (Encounter)](Encounter-PJ2TransferEncounter3.md)
* [PJ2TransferEncounter4 (Encounter)](Encounter-PJ2TransferEncounter4.md)
* [PJ2TransferEncounter5 (Encounter)](Encounter-PJ2TransferEncounter5.md)
* [TransferEncounter42.1 (Encounter)](Encounter-TransferEncounter42.1.md)
* [TransferEncounter42.2 (Encounter)](Encounter-TransferEncounter42.2.md)
* [AbteilungHerzJesu1 (HealthcareService)](HealthcareService-AbteilungHerzJesu1.md)
* [AbteilungKHRied1 (HealthcareService)](HealthcareService-AbteilungKHRied1.md)
* [AbteilungKHRied2 (HealthcareService)](HealthcareService-AbteilungKHRied2.md)
* [AbteilungKHRied3 (HealthcareService)](HealthcareService-AbteilungKHRied3.md)
* [AbteilungKHRied4 (HealthcareService)](HealthcareService-AbteilungKHRied4.md)
* [KHK999ABT11111100 (HealthcareService)](HealthcareService-KHK999ABT11111100.md)
* [KHK999ABT12111100 (HealthcareService)](HealthcareService-KHK999ABT12111100.md)
* [KHK999ABT12118102 (HealthcareService)](HealthcareService-KHK999ABT12118102.md)
* [KHK999ABT16075000 (HealthcareService)](HealthcareService-KHK999ABT16075000.md)
* [KHK999ABT16111111 (HealthcareService)](HealthcareService-KHK999ABT16111111.md)
* [KHK999ABT16111112 (HealthcareService)](HealthcareService-KHK999ABT16111112.md)
* [KHK999ABT16211100 (HealthcareService)](HealthcareService-KHK999ABT16211100.md)
* [KHK999ABT16518011 (HealthcareService)](HealthcareService-KHK999ABT16518011.md)
* [LocationKHHerzJesu (Location)](Location-LocationKHHerzJesu.md)
* [LocationKHK999 (Location)](Location-LocationKHK999.md)
* [LocationKHRied (Location)](Location-LocationKHRied.md)
* [Testkrankenhaus (Organization)](Organization-KHK999.md)
* [Herz Jesu-Krankenhaus (Organization)](Organization-OrganizationHerzJesuKrankenhaus.md)
* [Krankenhaus der Barmherzigen Schwestern vom Hl. Vinzenz von Paul Ried (Organization)](Organization-OrganizationKrankenhausRied.md)
* [Wiener Gesundheitsfonds (WGF) (Organization)](Organization-OrganizationLGF.md)
* [OrganizationUeberweisendeOrganization1 (Organization)](Organization-OrganizationUeberweisendeOrganization1.md)
* [HJK Interne Ambulanz (Organization)](Organization-OrganizationUeberweisendeOrganization2.md)
* [Österreichische Gesundheitskasse Wien (Organization)](Organization-SV11.md)
* [Österreichische Gesundheitskasse Niederösterreich (Organization)](Organization-SV12.md)
* [Österreichische Gesundheitskasse Burgenland (Organization)](Organization-SV13.md)
* [Österreichische Gesundheitskasse Oberösterreich (Organization)](Organization-SV14.md)
* [Österreichische Gesundheitskasse Steiermark (Organization)](Organization-SV15.md)
* [Österreichische Gesundheitskasse Kärnten (Organization)](Organization-SV16.md)
* [Österreichische Gesundheitskasse Salzburg (Organization)](Organization-SV17.md)
* [Österreichische Gesundheitskasse Tirol (Organization)](Organization-SV18.md)
* [Österreichische Gesundheitskasse Vorarlberg (Organization)](Organization-SV19.md)
* [OrganizationAffiliationWgfHerzJesu (OrganizationAffiliation)](OrganizationAffiliation-OrganizationAffiliationWgfHerzJesu.md)
* [PJ1Patient (Patient)](Patient-PJ1Patient.md)
* [PJ2Patient (Patient)](Patient-PJ2Patient.md)
* [Patient42 (Patient)](Patient-Patient42.md)
* [Test1PatientBund (Patient)](Patient-Test1PatientBund.md)
* [Test1PatientLGF (Patient)](Patient-Test1PatientLGF.md)
* [Test1PatientOhneMaskierung (Patient)](Patient-Test1PatientOhneMaskierung.md)
* [Test1PatientSV (Patient)](Patient-Test1PatientSV.md)
* [PJ1Procedure1 (Procedure)](Procedure-PJ1Procedure1.md)
* [PJ2Procedure1 (Procedure)](Procedure-PJ2Procedure1.md)
* [PJ2Procedure2 (Procedure)](Procedure-PJ2Procedure2.md)
* [LKF A01 Questionnaire (Questionnaire)](Questionnaire-LKFA01Questionnaire.md)
* [LKF B01 Questionnaire (Questionnaire)](Questionnaire-LKFB01Questionnaire.md)
* [LKF B02 Questionnaire (Questionnaire)](Questionnaire-LKFB02Questionnaire.md)
* [LKF B03 Questionnaire (Questionnaire)](Questionnaire-LKFB03Questionnaire.md)
* [LKF B04 Questionnaire (Questionnaire)](Questionnaire-LKFB04Questionnaire.md)
* [LKF B05 Questionnaire (Questionnaire)](Questionnaire-LKFB05Questionnaire.md)
* [LKF B06 Questionnaire (Questionnaire)](Questionnaire-LKFB06Questionnaire.md)
* [LKF G01 Questionnaire (Questionnaire)](Questionnaire-LKFG01Questionnaire.md)
* [LKF G02 Questionnaire (Questionnaire)](Questionnaire-LKFG02Questionnaire.md)
* [LKF K01 Questionnaire (Questionnaire)](Questionnaire-LKFK01Questionnaire.md)
* [LKF K02 Questionnaire (Questionnaire)](Questionnaire-LKFK02Questionnaire.md)
* [LKF K03 Questionnaire (Questionnaire)](Questionnaire-LKFK03Questionnaire.md)
* [LKF K04 Questionnaire (Questionnaire)](Questionnaire-LKFK04Questionnaire.md)
* [LKF K05 Questionnaire (Questionnaire)](Questionnaire-LKFK05Questionnaire.md)
* [LKF K06 Questionnaire (Questionnaire)](Questionnaire-LKFK06Questionnaire.md)
* [LKF K07 Questionnaire (Questionnaire)](Questionnaire-LKFK07Questionnaire.md)
* [LKF K08 Questionnaire (Questionnaire)](Questionnaire-LKFK08Questionnaire.md)
* [LKF K09 Questionnaire (Questionnaire)](Questionnaire-LKFK09Questionnaire.md)
* [LKF K10 Questionnaire (Questionnaire)](Questionnaire-LKFK10Questionnaire.md)
* [LKF K11 Questionnaire (Questionnaire)](Questionnaire-LKFK11Questionnaire.md)
* [LKF K12 Questionnaire (Questionnaire)](Questionnaire-LKFK12Questionnaire.md)
* [LKF K13 Questionnaire (Questionnaire)](Questionnaire-LKFK13Questionnaire.md)
* [LKF K14 Questionnaire (Questionnaire)](Questionnaire-LKFK14Questionnaire.md)
* [LKF K15 Questionnaire (Questionnaire)](Questionnaire-LKFK15Questionnaire.md)
* [LKF K16 Questionnaire (Questionnaire)](Questionnaire-LKFK16Questionnaire.md)
* [LKF L01 Questionnaire (Questionnaire)](Questionnaire-LKFL01Questionnaire.md)
* [LKF L02 Questionnaire (Questionnaire)](Questionnaire-LKFL02Questionnaire.md)
* [LKF L03 Questionnaire (Questionnaire)](Questionnaire-LKFL03Questionnaire.md)
* [LKF L04 Questionnaire (Questionnaire)](Questionnaire-LKFL04Questionnaire.md)
* [SAPS3 Questionnaire (Questionnaire)](Questionnaire-LKFSAPS3Questionnaire.md)
* [I12 Questionnaire für TISS-A-Daten (Questionnaire)](Questionnaire-LKFTISSAQuestionnaire.md)
* [Stroke Unit Registermeldung – Patientendaten (Questionnaire)](Questionnaire-StrokeUnitQuestionnaire2025.md)
* [register-questionnaire (Questionnaire)](Questionnaire-register-questionnaire.md)
* [Stroke Unit Registermeldung – Patientendaten (Questionnaire)](Questionnaire-strokeunit-questionnaire.md)
* [SAPS42.1 (QuestionnaireResponse)](QuestionnaireResponse-SAPS42.1.md)
* [TISS42.1 (QuestionnaireResponse)](QuestionnaireResponse-TISS42.1.md)
* [TISS42.2 (QuestionnaireResponse)](QuestionnaireResponse-TISS42.2.md)
* [TISS42.3 (QuestionnaireResponse)](QuestionnaireResponse-TISS42.3.md)
* [TISSAQuestionnaireResponse (QuestionnaireResponse)](QuestionnaireResponse-TISSAQuestionnaireResponse.md)
* [Test2SAPS3QuestionnaireResponse1 (QuestionnaireResponse)](QuestionnaireResponse-Test2SAPS3QuestionnaireResponse1.md)
* [strokeunit-questionnaire-response-1 (QuestionnaireResponse)](QuestionnaireResponse-strokeunit-questionnaire-response-1.md)
* [neueVAE (SubscriptionTopic)](SubscriptionTopic-neueVAE.md)
* [VAEabgelehnt (SubscriptionTopic)](SubscriptionTopic-vaeAbgelehnt.md)
