# ELGA.MOPED\ANWF 20 - Urlaub - FHIR® v5.0.0

* [**Table of Contents**](toc.md)
* [**Überblick & Sunshine Case**](anwendungsfaelle.md)
* **ANWF 20 - Urlaub**

## ANWF 20 - Urlaub

## Anwendungsfall 20: Beurlaubung

### Betroffene Akteure

| | |
| :--- | :--- |
| KH (Krankenhaus) | ✅ |
| LGF (Landesgesundheitsfonds) | ✅ |
| SV (Sozialversicherung) | ✅ |
| Bund | ✅ |

### Betroffene Behandlungsarten

| | |
| :--- | :--- |
| Ambulant | ❌ |
| Stationär | ✅ |

### Beschreibung

Eine Patient unterbricht seinen stationären Aufenthalt und kommt an einem späteren Tag wieder. Bezeichnung: Urlaub bzw. Abwesenheit

### Beispiel

* TBD

### Technische Hinweise

Hier ist es wichtig zwischen dem Encounter (Aufenthalt) und dem TransferEncounter (Verlegung/Bewegung) zu unterscheiden.

```

---
    config:
      theme: 'base'
      themeVariables:
        primaryColor: '#dbdbdb'         
        actorBorder: '#666'
        noteBkgColor: '#f4f4f4'
        noteBorderColor: '#555'
    ---
    sequenceDiagram
    autonumber
    box rgb(245, 229, 153)
    actor KH as KH (Herz Jesu Krankenhaus)
    end
    box rgb(197, 247, 186)
    participant MP as Moped
    end
    box rgb(186, 196, 247)
    actor SV as SV (ÖGK Wien)
    end
    box rgb(247, 208, 186)
    actor LGF as LGF (Landesgesundheitsfonds Wien)
    end
    box rgb(252, 179, 179) 
    actor Bund as Bund 
    end

    KH->>MP: $aufnehmen
    Note over KH: Patient:in wird am 2025-07-20 auf Abteilung „Innere Medizin“ aufgenommen→ Encounter status: in-progress  TransferEncounter Abteilung: "Innere Medizin"

    loop Beurlaubungs-Zyklus
        KH->>MP: $update 
        Note over KH: Patient:in am 2025-07-22 auf Urlaub→ Encounter status: on-hold Verlegung auf TransferEncounter mit Funktionscode 100000

        KH->>MP: $update 
        Note over KH:Patient:in kehrt am 2025-07-24 zurück → Encounter status: in-progress TransferEncounter Abteilung: „Innere Medizin“
    end
    
```

### Relevante Profile

* [TransferEncounter Stationär (Bewegung)](StructureDefinition-MopedTransferEncounterS.md)
* [Encounter Stationär (Aufenthalt)](StructureDefinition-MopedEncounterS.md)

### Relevante Invarianten

### Mögliche Notifications

