# ELGA.MOPED\ANWF 19 - Interne Verlegung - FHIR® v5.0.0

* [**Table of Contents**](toc.md)
* [**Überblick & Sunshine Case**](anwendungsfaelle.md)
* **ANWF 19 - Interne Verlegung**

## ANWF 19 - Interne Verlegung

## Anwendungsfall 19: Interne Verlegung

### Betroffene Akteure

| | |
| :--- | :--- |
| KH (Krankenhaus) | ✅ |
| LGF (Landesgesundheitsfonds) | ✅ |
| SV (Sozialversicherung) | ✅ |
| Bund | ✅ |

### Betroffene Behandlungsarten

| | |
| :--- | :--- |
| Ambulant | ❌? |
| Stationär | ✅ |

### Beschreibung

Der Patient wird innerhalb einer Krankenanstalt verlegt. Sobald sich der Funktions(sub)code, egal an welcher Stelle, ändert, kommt es zu einer Änderung in MOPED. Bei jeder Verlegung muss alles übermittelt werden, was in einer X02 enthalten wäre (Interne Verlegung in einer Krankenanstalt ist auch ein Wechsel).

### Beispiel

* Patient wird von Bett/Zimmer zu Bett/Zimmer verlegt, gleiche Station –> keine MOPED Relevanz
* Patient wird von Station zu Station verlegt, ein Primariat (Subcode gleich) —> keine MOPED Relevanz
* Patient wird von Station A zu einer Station B mit anderem Funktionscode verlegt -> Bei Änderung des Funktions(sub)codes muss eine Verlegung in MOPED erfolgen

### Technische Hinweise

Hier ist es wichtig zwischen dem Encounter (Aufenthalt) und dem TransferEncounter (Verlegung/Bewegung) zu unterscheiden.

### Ablauf

```

---
    config:
      theme: 'base'
      themeVariables:
        primaryColor: '#dbdbdb'         
        actorBorder: '#666'
        noteBkgColor: '#f4f4f4'
        noteBorderColor: '#555'
    ---
    sequenceDiagram
    autonumber
    box rgb(245, 229, 153)
    actor KH as KH (Herz Jesu Krankenhaus)
    end
    box rgb(197, 247, 186)
    participant MP as Moped
    end
    box rgb(186, 196, 247)
    actor SV as SV (ÖGK Wien)
    end
    box rgb(247, 208, 186)
    actor LGF as LGF (Landesgesundheitsfonds Wien)
    end
    box rgb(252, 179, 179) 
    actor Bund as Bund 
    end

    %% Aufnahme
    KH->>MP: $aufnehmen
    Note over KH: POST Patient, Encounter, ... TransferEncounter mit Referenz auf Aufnahmeabteilung

    %% Interne Verlegung
    KH->>MP: $update – interne Verlegung
    Note over KH: PUT alter TransferEncounter (finished, Enddatum) + POST neuer TransferEncounter (neue Abteilung) 

```

### Relevante Profile

* [TransferEncounter Ambulant](StructureDefinition-MopedTransferEncounterA.md)
* [TransferEncounter Stationär](StructureDefinition-MopedTransferEncounterS.md)

### Relevante Invarianten

### Mögliche Notifications

