# ELGA.MOPED\ANWF 17 - Zwischenbetriebliche Leistungserbringung - FHIR® v5.0.0

* [**Table of Contents**](toc.md)
* [**Überblick & Sunshine Case**](anwendungsfaelle.md)
* **ANWF 17 - Zwischenbetriebliche Leistungserbringung**

## ANWF 17 - Zwischenbetriebliche Leistungserbringung

## Anwendungsfall 17: Zwischenbetriebliche Leistungserbringung

### Betroffene Akteure

| | |
| :--- | :--- |
| KH (Krankenhaus) | ✅ |
| LGF (Landesgesundheitsfonds) | ✅ |
| SV (Sozialversicherung) | ❌ |
| Bund | ✅ |

### Betroffene Behandlungsarten

| | |
| :--- | :--- |
| Ambulant | ❌ |
| Stationär | ✅ |

### Beschreibung

Patient befindet sich stationär in KH A und muss für eine z.B. Diagnostik in das KH B gebracht werden. Der stationäre Fall im KH A läuft weiter. Die Diagnostik/Therapie im KH B wird als ambulanter “zwischenbetrieblicher” Fall in geführt.

### Beispiel

* Ambulante oder tagesklinische Leistung in einem anderen Haus
* Konsiliarleistung durch ein anderes Krankenhaus
* Diagnostik oder Therapie an einem ausgelagerten Standort (z.B. Herzkatheter in einem anderen KH)

### Technische Hinweise

Nur das KH A interagiert in diesem Fall mit Moped.

### Ablauf

```

    ---
    config:
      theme: 'base'
      themeVariables:
        primaryColor: '#dbdbdb'         
        actorBorder: '#666'
        noteBkgColor: '#f4f4f4'
        noteBorderColor: '#555'
    ---
    sequenceDiagram
    autonumber
    box rgb(245, 229, 153)
    actor KHB as KH B
    end
    box rgb(245, 229, 153)
    actor KHA as KH A
    end
    box rgb(197, 247, 186)
    participant MP as Moped
    end
    box rgb(186, 196, 247)
    actor SV as SV (ÖGK Wien)
    end
    box rgb(247, 208, 186)
    actor LGF as LGF (Landesgesundheitsfonds Wien)
    end
    box rgb(252, 179, 179) 
    actor Bund as Bund 
    end

    KHA->>MP: $aufnehmen
    Note over KHA: Patient wird aufgenommen
    KHA-->>KHB: Patient wird ins KH B gebracht
    Note over KHA: Patient muss für Diagnostik in das KH B
    KHB-->>KHA: Patient wird zurück ins KH A gebracht
    Note over KHB: Diagnostik durchgeführt
    KHA->>MP: $update
    Note over KHA: KH A meldet die Leistung an Moped -> gibt im Procedure statt einer Referenz auf die  eigene Abteilung eine Referenz auf KH B an


```

### Relevante Profile

* [$update Bundle](StructureDefinition-MopedUpdateBundleKH.md)
* [Procedure](StructureDefinition-MopedProcedure.md)

### Relevante Invarianten

Keine relevanten Invarianten identifiziert.

### Mögliche Notifications

Keine relevanten Notifications identifiziert.

