# hl7.at.fhir.elga.aps.r4#0.2.0: Austrian Patient Summary (R4)

## Pages

* [Home](index.md)
* [Dependencies](dependencies.md)
* [Anwendungsfall 2 - APS lesen](use_case_2.md)
* [Publikationsinformationen](publication_info.md)
* [Copyright](copyright.md)
* [Autoren und Mitwirkende](contributors.md)
* [Hintergrund](background.md)
* [Impressum](imprint.md)
* [Überblick & Anwendungsbeispiel](use_case_overview.md)
* [Umfang und Inhalt](scope_and_content.md)
* [Anwendungsfall 1 - APS aggregieren](use_case_1.md)
* [Designentscheidungen](design_choices.md)
* [Artifacts Summary](artifacts.md)
* [Download](download.md)
* [Herausforderungen](challenges.md)

## Resources

### ValueSets

* [AT APS Immunization Vaccine Codes](ValueSet-at-aps-immunization-vaccine-codes.md)
* [AT APS ObservationInterpretation](ValueSet-at-aps-observationinterpretation.md)

### Resource Profiles

* [AT APS AllergyIntolerance](StructureDefinition-at-aps-allergyintolerance.md)
* [AT APS Bundle](StructureDefinition-at-aps-bundle.md)
* [AT APS CarePlan](StructureDefinition-at-aps-careplan.md)
* [AT APS ClinicalImpression](StructureDefinition-at-aps-clinicalimpression.md)
* [AT APS Composition](StructureDefinition-at-aps-composition.md)
* [AT APS Condition](StructureDefinition-at-aps-condition.md)
* [AT APS Consent](StructureDefinition-at-aps-consent.md)
* [AT APS Device](StructureDefinition-at-aps-device.md)
* [AT APS DeviceUseStatement](StructureDefinition-at-aps-deviceusestatement.md)
* [AT APS DiagnosticReport](StructureDefinition-at-aps-diagnosticreport.md)
* [AT APS DocumentReference](StructureDefinition-at-aps-documentreference.md)
* [AT APS Flag Alert](StructureDefinition-at-aps-flagalert.md)
* [AT APS ImagingStudy](StructureDefinition-at-aps-imagingstudy.md)
* [AT APS Immunization](StructureDefinition-at-aps-immunization.md)
* [AT APS Immunization](StructureDefinition-at-aps-immunizationrecommendation.md)
* [AT APS Medication](StructureDefinition-at-aps-medication.md)
* [AT APS MedicationAdministration](StructureDefinition-at-aps-medicationadministration.md)
* [AT APS MedicationDispense](StructureDefinition-at-aps-medicationdispense.md)
* [AT APS MedicationRequest](StructureDefinition-at-aps-medicationrequest.md)
* [AT APS MedicationStatement](StructureDefinition-at-aps-medicationstatement.md)
* [AT APS Observation](StructureDefinition-at-aps-observation.md)
* [AT APS Observation Alcohol Use](StructureDefinition-at-aps-observationalcoholuse.md)
* [AT APS Observation Pregnancy Expected Delivery Date](StructureDefinition-at-aps-observationpregnancyedd.md)
* [AT APS Observation Pregnancy Outcome](StructureDefinition-at-aps-observationpregnancyoutcome.md)
* [AT APS Observation Pregnancy Status](StructureDefinition-at-aps-observationpregnancystatus.md)
* [AT APS Observation Results Laboratory Pathology](StructureDefinition-at-aps-observationresultslaboratorypathology.md)
* [AT APS Observation Results Radiology](StructureDefinition-at-aps-observationresultsradiology.md)
* [AT APS Observation Tobacco Use](StructureDefinition-at-aps-observationtobaccouse.md)
* [AT APS Observation Vital Signs](StructureDefinition-at-aps-observationvitalsigns.md)
* [AT APS Organization](StructureDefinition-at-aps-organization.md)
* [AT APS Patient](StructureDefinition-at-aps-patient.md)
* [AT APS Practitioner](StructureDefinition-at-aps-practitioner.md)
* [AT APS PractitionerRole](StructureDefinition-at-aps-practitionerrole.md)
* [AT APS Procedure](StructureDefinition-at-aps-procedure.md)
* [AT APS Specimen](StructureDefinition-at-aps-specimen.md)

### CapabilityStatements

* [AT APS CapabilityStatement (Server)](CapabilityStatement-at-aps-capabilitystatement-server.md)

### ImplementationGuides

* [Austrian Patient Summary (R4)](index.md)

### Parameters

* [AtApsExpansionParametersSCT](Parameters-AtApsExpansionParametersSCT.md)

### Examples

* [at-aps-example-allergyintolerance-01 (AllergyIntolerance)](AllergyIntolerance-at-aps-example-allergyintolerance-01.md)
* [AtApsExample03Diabetes (Bundle)](Bundle-AtApsExample03Diabetes.md)
* [AtApsExampleBundle-Journey-1 (Bundle)](Bundle-AtApsExampleBundle-Journey-1.md)
* [AtApsExampleBundle-Journey-2 (Bundle)](Bundle-AtApsExampleBundle-Journey-2.md)
* [AtApsExampleBundle-Journey-3 (Bundle)](Bundle-AtApsExampleBundle-Journey-3.md)
* [AtApsExampleBundle01NoProblemsMedicationAllergies (Bundle)](Bundle-AtApsExampleBundle01NoProblemsMedicationAllergies.md)
* [AtApsExampleBundle02PreventiveMedicalCheckup (Bundle)](Bundle-AtApsExampleBundle02PreventiveMedicalCheckup.md)
* [AtApsExampleCareplan01 (CarePlan)](CarePlan-AtApsExampleCareplan01.md)
* [AtApsExampleClinicalImpression01 (ClinicalImpression)](ClinicalImpression-AtApsExampleClinicalImpression01.md)
* [AtApsExampleCondition01 (Condition)](Condition-AtApsExampleCondition01.md)
* [AtApsExampleConsent01 (Consent)](Consent-AtApsExampleConsent01.md)
* [at-aps-example-device-01 (Device)](Device-at-aps-example-device-01.md)
* [at-aps-example-device-02-software (Device)](Device-at-aps-example-device-02-software.md)
* [AtApsExampleDeviceUseStatement01 (DeviceUseStatement)](DeviceUseStatement-AtApsExampleDeviceUseStatement01.md)
* [AtApsExampleDiagnosticReport01 (DiagnosticReport)](DiagnosticReport-AtApsExampleDiagnosticReport01.md)
* [AtApsExampleDocumentReference01 (DocumentReference)](DocumentReference-AtApsExampleDocumentReference01.md)
* [AtApsExampleFlagAlert01 (Flag)](Flag-AtApsExampleFlagAlert01.md)
* [AtApsExampleImagingStudy01 (ImagingStudy)](ImagingStudy-AtApsExampleImagingStudy01.md)
* [at-aps-example-immunization-01-unknown (Immunization)](Immunization-at-aps-example-immunization-01-unknown.md)
* [at-aps-example-immunization-01 (Immunization)](Immunization-at-aps-example-immunization-01.md)
* [AtApsExampleImmunizationRecommendation01 (ImmunizationRecommendation)](ImmunizationRecommendation-AtApsExampleImmunizationRecommendation01.md)
* [AtApsExampleMedication01 (Medication)](Medication-AtApsExampleMedication01.md)
* [AtApsExampleMedicationAdministration01 (MedicationAdministration)](MedicationAdministration-AtApsExampleMedicationAdministration01.md)
* [AtApsExampleMedicationDispense01 (MedicationDispense)](MedicationDispense-AtApsExampleMedicationDispense01.md)
* [AtApsExampleMedicationRequest01 (MedicationRequest)](MedicationRequest-AtApsExampleMedicationRequest01.md)
* [AtApsExampleMedicationStatement01 (MedicationStatement)](MedicationStatement-AtApsExampleMedicationStatement01.md)
* [AtApsExampleObservation01 (Observation)](Observation-AtApsExampleObservation01.md)
* [AtApsExampleObservationPregnancyEdd01 (Observation)](Observation-AtApsExampleObservationPregnancyEdd01.md)
* [AtApsExampleObservationPregnancyOutcome01 (Observation)](Observation-AtApsExampleObservationPregnancyOutcome01.md)
* [AtApsExampleObservationPregnancyStatus01 (Observation)](Observation-AtApsExampleObservationPregnancyStatus01.md)
* [AtApsExampleObservationResultsLaboratoryPathology01 (Observation)](Observation-AtApsExampleObservationResultsLaboratoryPathology01.md)
* [AtApsExampleObservationResultsRadiology01 (Observation)](Observation-AtApsExampleObservationResultsRadiology01.md)
* [AtApsExampleObservationVitalSigns01 (Observation)](Observation-AtApsExampleObservationVitalSigns01.md)
* [at-aps-example-observation-01-exercise (Observation)](Observation-at-aps-example-observation-01-exercise.md)
* [at-aps-example-observationalcoholuse-01 (Observation)](Observation-at-aps-example-observationalcoholuse-01.md)
* [at-aps-example-observationtobaccouse-01 (Observation)](Observation-at-aps-example-observationtobaccouse-01.md)
* [Amadeus Spital (Organization)](Organization-AtApsExampleOrganization01.md)
* [at-aps-example-patient-01 (Patient)](Patient-at-aps-example-patient-01.md)
* [at-aps-example-practitioner-01 (Practitioner)](Practitioner-at-aps-example-practitioner-01.md)
* [at-aps-example-procedure-01 (Procedure)](Procedure-at-aps-example-procedure-01.md)
* [AtApsExampleSpecimen01 (Specimen)](Specimen-AtApsExampleSpecimen01.md)
