# AtApsBundle-Beispiel 3 - Austrian Patient Summary (R4) v0.2.0



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "AtApsExample03Diabetes",
  "meta" : {
    "profile" : [
      "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-bundle"
    ]
  },
  "identifier" : {
    "system" : "http://system-to-be-defined.com",
    "value" : "63fef90a-be11-4ddf-aece-d77da15c4f20"
  },
  "type" : "document",
  "timestamp" : "2025-01-08T14:01:30+00:00",
  "entry" : [
    {
      "fullUrl" : "urn:uuid:212fdc76-ccc3-40bf-8cdd-82f2ef88bd7b",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "AtApsExample03Diabetes-composition",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-composition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_AtApsExample03Diabetes-composition\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Composition AtApsExample03Diabetes-composition</b></p><a name=\"AtApsExample03Diabetes-composition\"> </a><a name=\"hcAtApsExample03Diabetes-composition\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-composition.html\">AT APS Composition</a></p></div><p><b>status</b>: Final</p><p><b>type</b>: <span title=\"Codes:{http://loinc.org 60591-5}\">Patient summary</span></p><p><b>date</b>: 2024-02-08 14:01:30+0000</p><p><b>author</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-75db30ee-7028-486c-929a-c5126837f472\">Dr. IV-Ärztin</a></p><p><b>title</b>: Diabetes Leitdokument</p><p><b>custodian</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-f6266e6a-f63d-4673-b2de-3dff11e619d6\">Muster-Organisation</a></p></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        },
        "date" : "2024-02-08T14:01:30+00:00",
        "author" : [
          {
            "reference" : "urn:uuid:75db30ee-7028-486c-929a-c5126837f472",
            "display" : "Dr. IV-Ärztin"
          }
        ],
        "title" : "Diabetes Leitdokument",
        "custodian" : {
          "reference" : "urn:uuid:f6266e6a-f63d-4673-b2de-3dff11e619d6",
          "display" : "Muster-Organisation"
        },
        "section" : [
          {
            "title" : "Medikationsliste",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Medikationsanamnese"
                }
              ]
            },
            "text" : {
              "status" : "empty",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Narrativer Text muss generiert werden.</p></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:acac4c94-a752-4cf5-9a6b-0d84237d5076",
                "display" : "AtApsExample03Diabetes-medication-summary-1"
              }
            ]
          },
          {
            "title" : "Allergien und Intoleranzen",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergien und unerwünschte Wirkungen"
                }
              ]
            },
            "text" : {
              "status" : "empty",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Narrativer Text muss generiert werden.</p></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:768eb9cb-00f3-4ab1-bfc2-ff835cb3b89b",
                "display" : "AtApsExample03Diabetes-allergy-1"
              }
            ]
          },
          {
            "title" : "Gesundheitsprobleme und Risiken",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problemliste"
                }
              ]
            },
            "text" : {
              "status" : "empty",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Narrativer Text muss generiert werden.</p></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:72e85b9d-004d-4104-b166-86d129948bae",
                "display" : "AtApsExample03Diabetes-problem-1"
              },
              {
                "reference" : "urn:uuid:82fa32f6-39d6-4fc9-9624-90a48fd3d3a5",
                "display" : "AtApsExample03Diabetes-problem-2"
              },
              {
                "reference" : "urn:uuid:61db6213-22ab-405a-825a-0ae6905fad1e",
                "display" : "AtApsExample03Diabetes-problem-3"
              },
              {
                "reference" : "urn:uuid:61db6213-22ab-405a-825a-0ae6905fad2e",
                "display" : "AtApsExample03Diabetes-problem-6"
              },
              {
                "reference" : "urn:uuid:9d1c0b74-20c1-4603-a95a-71e6a1dc8fde",
                "display" : "AtApsExample03Diabetes-problem-5"
              },
              {
                "reference" : "urn:uuid:caa77334-fbfc-4129-a101-1b01c595dd91",
                "display" : "AtApsExample03Diabetes-problem-14"
              },
              {
                "reference" : "urn:uuid:fa46fccb-5c24-4a40-a478-d6da4902ff33",
                "display" : "AtApsExample03Diabetes-problem-17"
              }
            ]
          },
          {
            "title" : "Eingriffe und Therapien",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "47519-4",
                  "display" : "Anamnese der Prozeduren oder Maßnahmen"
                }
              ]
            },
            "text" : {
              "status" : "empty",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Narrativer Text muss generiert werden.</p></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:75c46c35-8f4e-4232-b026-5672c60d076a",
                "display" : "AtApsExample03Diabetes-procedure-history-1"
              }
            ]
          },
          {
            "title" : "Implantate, medizinische Geräte und Heilbehelfe",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "46264-8",
                  "display" : "Anamnese zum Einsatz von Medizinprodukten"
                }
              ]
            },
            "text" : {
              "status" : "empty",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Narrativer Text muss generiert werden.</p></div>"
            },
            "emptyReason" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/list-empty-reason",
                  "code" : "nilknown"
                }
              ]
            }
          },
          {
            "title" : "Diagnostische Resultate",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "30954-2",
                  "display" : "Relevante diagnostische Tests und/oder Labordaten"
                }
              ]
            },
            "text" : {
              "status" : "empty",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Narrativer Text muss generiert werden.</p></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:725bcf71-22e6-473b-a879-49a4b63cd654",
                "display" : "AtApsExample03Diabetes-diagnostic-result-1"
              }
            ]
          },
          {
            "title" : "Vitalparameter",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8716-3",
                  "display" : "Vitalparameter"
                }
              ]
            },
            "text" : {
              "status" : "empty",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Narrativer Text muss generiert werden.</p></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:74c5e186-d765-4c93-a624-c9b0746e8142",
                "display" : "AtApsExample03Diabetes-vital-sign-1"
              }
            ]
          },
          {
            "title" : "Vergangene Gesundheitsprobleme und Risiken",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11348-0",
                  "display" : "Vergangene Gesundheitsprobleme und Risiken"
                }
              ]
            },
            "text" : {
              "status" : "empty",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Narrativer Text muss generiert werden.</p></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:82301518-66ca-4b4c-821d-087adf643cc4",
                "display" : "AtApsExample03Diabetes-illness-history-1"
              }
            ]
          },
          {
            "title" : "Behandlungsplan",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "18776-5",
                  "display" : "Behandlungsplan - Notiz"
                }
              ]
            },
            "text" : {
              "status" : "empty",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Narrativer Text muss generiert werden.</p></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:39cd75da-2456-46a9-a703-89d8b65ae63b",
                "display" : "AtApsExample03Diabetes-schulung-1"
              }
            ]
          },
          {
            "title" : "Lebensstil / Soziale Umstände und Verhalten",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "29762-2",
                  "display" : "Sozialanamnese"
                }
              ]
            },
            "text" : {
              "status" : "empty",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Narrativer Text muss generiert werden.</p></div>"
            },
            "entry" : [
              {
                "reference" : "urn:uuid:d0a5bbf1-6d01-4d44-bac5-05f12c98411e",
                "display" : "AtApsExample03Diabetes-social-history-1"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "001",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-patient"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_001\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient 001</b></p><a name=\"001\"> </a><a name=\"hc001\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-patient.html\">AT APS Patient</a></p></div><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Susi Testpatientin  Female, DoB: 1950-11-12 ( Social Security number: 0000121150)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Other Id (see the one above)\">Other Id:</td><td colspan=\"3\">Patient internal identifier/0002</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Ways to contact the Patient\">Contact Detail</td><td colspan=\"3\">Am Schulweg 5 Hainfeld 3100 AUT (home)</td></tr></table></div>"
        },
        "identifier" : [
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "SS",
                  "display" : "Social Security number"
                }
              ]
            },
            "system" : "urn:oid:1.2.40.0.10.1.4.3.1",
            "value" : "0000121150",
            "assigner" : {
              "display" : "Dachverband der österreichischen Sozialversicherungsträger"
            }
          },
          {
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PI",
                  "display" : "Patient internal identifier"
                }
              ]
            },
            "system" : "urn:oid:1.2.3.4.5",
            "value" : "0002",
            "assigner" : {
              "display" : "Ein GDA in Österreich"
            }
          }
        ],
        "name" : [
          {
            "family" : "Testpatientin",
            "given" : ["Susi"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1950-11-12",
        "address" : [
          {
            "use" : "home",
            "line" : ["Am Schulweg 5"],
            "city" : "Hainfeld",
            "postalCode" : "3100",
            "country" : "AUT"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:75db30ee-7028-486c-929a-c5126837f472",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "AtApsExample03Diabetes-author",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-practitioner"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_AtApsExample03Diabetes-author\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner AtApsExample03Diabetes-author</b></p><a name=\"AtApsExample03Diabetes-author\"> </a><a name=\"hcAtApsExample03Diabetes-author\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-practitioner.html\">AT APS Practitioner</a></p></div><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-uri.html\" title=\"As defined by RFC 3986 (http://www.ietf.org/rfc/rfc3986.txt)(with many schemes defined in many RFCs). For OIDs and UUIDs, use the URN form (urn:oid:(note: lowercase) and urn:uuid:). See http://www.ietf.org/rfc/rfc3001.txt and http://www.ietf.org/rfc/rfc4122.txt \r\n\r\nThis oid is used as an identifier II.root to indicate the the extension is an absolute URI (technically, an IRI). Typically, this is used for OIDs and GUIDs. Note that when this OID is used with OIDs and GUIDs, the II.extension should start with urn:oid or urn:uuid: \r\n\r\nNote that this OID is created to aid with interconversion between CDA and FHIR - FHIR uses urn:ietf:rfc:3986 as equivalent to this OID. URIs as identifiers appear more commonly in FHIR.\r\n\r\nThis OID may also be used in CD.codeSystem.\">Uniform Resource Identifier (URI)</a>/urn:oid:1.2.40.0.10.99.1.2.3.4</p><p><b>name</b>: Gabriele IV-Ärztin </p></div>"
        },
        "identifier" : [
          {
            "system" : "urn:ietf:rfc:3986",
            "value" : "urn:oid:1.2.40.0.10.99.1.2.3.4",
            "assigner" : {
              "display" : "Bundesministerium für Gesundheit"
            }
          }
        ],
        "name" : [
          {
            "family" : "IV-Ärztin",
            "given" : ["Gabriele"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:f6266e6a-f63d-4673-b2de-3dff11e619d6",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "AtApsExample03Diabetes-organization",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_AtApsExample03Diabetes-organization\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization AtApsExample03Diabetes-organization</b></p><a name=\"AtApsExample03Diabetes-organization\"> </a><a name=\"hcAtApsExample03Diabetes-organization\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-organization.html\">AT APS Organization</a></p></div><p><b>name</b>: Muster-Organization</p></div>"
        },
        "name" : "Muster-Organization"
      }
    },
    {
      "fullUrl" : "urn:uuid:72e85b9d-004d-4104-b166-86d129948bae",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "AtApsExample03Diabetes-problem-1",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-condition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_AtApsExample03Diabetes-problem-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition AtApsExample03Diabetes-problem-1</b></p><a name=\"AtApsExample03Diabetes-problem-1\"> </a><a name=\"hcAtApsExample03Diabetes-problem-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-condition.html\">AT APS Condition</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 700379002}\">CKD - Chronische Niereninsuffizienz Grad 3B</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "700379002",
              "display" : "CKD - Chronische Niereninsuffizienz Grad 3B"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:82fa32f6-39d6-4fc9-9624-90a48fd3d3a5",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "AtApsExample03Diabetes-problem-2",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-condition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_AtApsExample03Diabetes-problem-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition AtApsExample03Diabetes-problem-2</b></p><a name=\"AtApsExample03Diabetes-problem-2\"> </a><a name=\"hcAtApsExample03Diabetes-problem-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-condition.html\">AT APS Condition</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 711150003}\">Langfristige Einnahme von Antikoagulantien</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "711150003",
              "display" : "Langfristige Einnahme von Antikoagulantien"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:61db6213-22ab-405a-825a-0ae6905fad1e",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "AtApsExample03Diabetes-problem-3",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-condition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_AtApsExample03Diabetes-problem-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition AtApsExample03Diabetes-problem-3</b></p><a name=\"AtApsExample03Diabetes-problem-3\"> </a><a name=\"hcAtApsExample03Diabetes-problem-3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-condition.html\">AT APS Condition</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 105401000119101}\">Diabetes mellitus aufgrund einer Verletzung der Bauchspeicheldrüse</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p><p><b>recordedDate</b>: 2024-02-08 14:01:30+0000</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "105401000119101",
              "display" : "Diabetes mellitus aufgrund einer Verletzung der Bauchspeicheldrüse"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        },
        "recordedDate" : "2024-02-08T14:01:30+00:00"
      }
    },
    {
      "fullUrl" : "urn:uuid:61db6213-22ab-405a-825a-0ae6905fad2e",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "AtApsExample03Diabetes-problem-6",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-condition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_AtApsExample03Diabetes-problem-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition AtApsExample03Diabetes-problem-6</b></p><a name=\"AtApsExample03Diabetes-problem-6\"> </a><a name=\"hcAtApsExample03Diabetes-problem-6\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-condition.html\">AT APS Condition</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 280137006}\">Diabetischer Fuß</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p><p><b>recordedDate</b>: 2021-02-08 14:01:30+0000</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "280137006",
              "display" : "Diabetischer Fuß"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        },
        "recordedDate" : "2021-02-08T14:01:30+00:00"
      }
    },
    {
      "fullUrl" : "urn:uuid:9d1c0b74-20c1-4603-a95a-71e6a1dc8fde",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "AtApsExample03Diabetes-problem-5",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-condition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_AtApsExample03Diabetes-problem-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition AtApsExample03Diabetes-problem-5</b></p><a name=\"AtApsExample03Diabetes-problem-5\"> </a><a name=\"hcAtApsExample03Diabetes-problem-5\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-condition.html\">AT APS Condition</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 38341003}\">Arterielle Hypertonie</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "38341003",
              "display" : "Arterielle Hypertonie"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:caa77334-fbfc-4129-a101-1b01c595dd91",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "AtApsExample03Diabetes-problem-14",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-condition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_AtApsExample03Diabetes-problem-14\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition AtApsExample03Diabetes-problem-14</b></p><a name=\"AtApsExample03Diabetes-problem-14\"> </a><a name=\"hcAtApsExample03Diabetes-problem-14\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-condition.html\">AT APS Condition</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 312824007}\">Familienanamnese: Kolonkarzinom</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "312824007",
              "display" : "Familienanamnese: Kolonkarzinom"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:fa46fccb-5c24-4a40-a478-d6da4902ff33",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "AtApsExample03Diabetes-problem-17",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-condition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_AtApsExample03Diabetes-problem-17\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition AtApsExample03Diabetes-problem-17</b></p><a name=\"AtApsExample03Diabetes-problem-17\"> </a><a name=\"hcAtApsExample03Diabetes-problem-17\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-condition.html\">AT APS Condition</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical inactive}\">Inactive</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status provisional}\">Provisional</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 2556008}\">Parodontalerkrankung</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p><h3>Stages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Assessment</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-f235c566-01aa-457d-ab49-9e422df69863\">AtApsExample03Diabetes-problem-17-assessment-1</a></td></tr></table></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "inactive",
              "display" : "Inactive"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "provisional",
              "display" : "Provisional"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "2556008",
              "display" : "Parodontalerkrankung"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        },
        "stage" : [
          {
            "assessment" : [
              {
                "reference" : "urn:uuid:f235c566-01aa-457d-ab49-9e422df69863",
                "display" : "AtApsExample03Diabetes-problem-17-assessment-1"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:f235c566-01aa-457d-ab49-9e422df69863",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "AtApsExample03Diabetes-problem-17-assessment-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_AtApsExample03Diabetes-problem-17-assessment-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation AtApsExample03Diabetes-problem-17-assessment-1</b></p><a name=\"AtApsExample03Diabetes-problem-17-assessment-1\"> </a><a name=\"hcAtApsExample03Diabetes-problem-17-assessment-1\"> </a><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category exam}\">Exam</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 1237049003}\">Bewertung der Risikofaktoren für Parodontalerkrankungen</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p><p><b>effective</b>: 2024-02-08 08:30:00+0100</p><p><b>performer</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-75db30ee-7028-486c-929a-c5126837f472\">Dr. IV-Ärztin</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 723509005}\">Hohes Risiko</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "exam",
                "display" : "Exam"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1237049003",
              "display" : "Bewertung der Risikofaktoren für Parodontalerkrankungen"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        },
        "effectiveDateTime" : "2024-02-08T08:30:00+01:00",
        "performer" : [
          {
            "reference" : "urn:uuid:75db30ee-7028-486c-929a-c5126837f472",
            "display" : "Dr. IV-Ärztin"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "723509005",
              "display" : "Hohes Risiko"
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:39cd75da-2456-46a9-a703-89d8b65ae63b",
      "resource" : {
        "resourceType" : "CarePlan",
        "id" : "AtApsExample03Diabetes-schulung-1",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-careplan"
          ]
        },
        "text" : {
          "status" : "additional",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"CarePlan_AtApsExample03Diabetes-schulung-1\"> </a><p>Schulung zur Verbesserung der Mobilität</p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith",
            "valueUri" : "http://example.org/protocol-for-heart-association-event"
          }
        ],
        "identifier" : [
          {
            "value" : "12345"
          }
        ],
        "basedOn" : [
          {
            "display" : "Schulungen für Diabetespatienten"
          }
        ],
        "replaces" : [
          {
            "display" : "Plan"
          }
        ],
        "partOf" : [
          {
            "display" : "Plan"
          }
        ],
        "status" : "active",
        "intent" : "plan",
        "category" : [
          {
            "text" : "Plan zur Patientenschulung"
          }
        ],
        "title" : "Spezialschulung für Diabetespatienten mit Retinophatie",
        "description" : "Information über eine Veranstaltung des Diabetes",
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        },
        "period" : {
          "end" : "2024-04-12"
        },
        "created" : "2024-03-29",
        "author" : {
          "reference" : "urn:uuid:75db30ee-7028-486c-929a-c5126837f472",
          "display" : "Dr. IV-Ärztin"
        },
        "addresses" : [
          {
            "reference" : "urn:uuid:61db6213-22ab-405a-825a-0ae6905fad1e",
            "display" : "AtApsExample03Diabetes-problem-3"
          }
        ],
        "activity" : [
          {
            "outcomeCodeableConcept" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "408443003",
                    "display" : "Allgemeines Verfahren"
                  }
                ]
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:acac4c94-a752-4cf5-9a6b-0d84237d5076",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "AtApsExample03Diabetes-medication-summary-1",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-medicationstatement"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_AtApsExample03Diabetes-medication-summary-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement AtApsExample03Diabetes-medication-summary-1</b></p><a name=\"AtApsExample03Diabetes-medication-summary-1\"> </a><a name=\"hcAtApsExample03Diabetes-medication-summary-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-medicationstatement.html\">AT APS MedicationStatement</a></p></div><p><b>status</b>: Active</p><p><b>medication</b>: <span title=\"Codes:{https://termgit.elga.gv.at/CodeSystem/asp-liste 2443061}\">EBETREXAT TBL 10MG</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p><p><b>effective</b>: 2024-02-08 10:31:58+0200 --&gt; (ongoing)</p><blockquote><p><b>dosage</b></p><p><b>sequence</b>: 1</p><p><b>timing</b>: Night, Once</p><p><b>route</b>: <span title=\"Codes:{http://snomed.info/sct 26643006}\">Oraler Verabreichungsweg</span></p><h3>DoseAndRates</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Dose[x]</b></td></tr><tr><td style=\"display: none\">*</td><td>2 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{TAB} = '{TAB}')</span></td></tr></table></blockquote></div>"
        },
        "status" : "active",
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://termgit.elga.gv.at/CodeSystem/asp-liste",
              "code" : "2443061",
              "display" : "EBETREXAT TBL 10MG"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        },
        "effectivePeriod" : {
          "start" : "2024-02-08T10:31:58+02:00"
        },
        "dosage" : [
          {
            "sequence" : 1,
            "timing" : {
              "repeat" : {
                "dayOfWeek" : ["fri"],
                "when" : ["NIGHT"]
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "26643006",
                  "display" : "Oraler Verabreichungsweg"
                }
              ]
            },
            "doseAndRate" : [
              {
                "doseQuantity" : {
                  "value" : 2,
                  "unit" : "Tablet",
                  "system" : "http://unitsofmeasure.org",
                  "code" : "{TAB}"
                }
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:768eb9cb-00f3-4ab1-bfc2-ff835cb3b89b",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "AtApsExample03Diabetes-allergy-1",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-allergyintolerance"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_AtApsExample03Diabetes-allergy-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance AtApsExample03Diabetes-allergy-1</b></p><a name=\"AtApsExample03Diabetes-allergy-1\"> </a><a name=\"hcAtApsExample03Diabetes-allergy-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-allergyintolerance.html\">AT APS AllergyIntolerance</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 89055006}\">Benzylpenicillin-Natrium</span></p><p><b>patient</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p><p><b>asserter</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-75db30ee-7028-486c-929a-c5126837f472\">Dr. IV-Ärztin</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active",
              "display" : "Active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "89055006",
              "display" : "Benzylpenicillin-Natrium"
            }
          ]
        },
        "patient" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        },
        "asserter" : {
          "reference" : "urn:uuid:75db30ee-7028-486c-929a-c5126837f472",
          "display" : "Dr. IV-Ärztin"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:75c46c35-8f4e-4232-b026-5672c60d076a",
      "resource" : {
        "resourceType" : "Procedure",
        "id" : "AtApsExample03Diabetes-procedure-history-1",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-procedure"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Procedure_AtApsExample03Diabetes-procedure-history-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Procedure AtApsExample03Diabetes-procedure-history-1</b></p><a name=\"AtApsExample03Diabetes-procedure-history-1\"> </a><a name=\"hcAtApsExample03Diabetes-procedure-history-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-procedure.html\">AT APS Procedure</a></p></div><p><b>status</b>: Completed</p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 770606008}\">Totalersatz des linken Hüftgelenks</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p><p><b>performed</b>: 2010</p></div>"
        },
        "status" : "completed",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "770606008",
              "display" : "Totalersatz des linken Hüftgelenks"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        },
        "performedDateTime" : "2010"
      }
    },
    {
      "fullUrl" : "urn:uuid:725bcf71-22e6-473b-a879-49a4b63cd654",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "AtApsExample03Diabetes-diagnostic-result-1",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-observationresultslaboratorypathology"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_AtApsExample03Diabetes-diagnostic-result-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation AtApsExample03Diabetes-diagnostic-result-1</b></p><a name=\"AtApsExample03Diabetes-diagnostic-result-1\"> </a><a name=\"hcAtApsExample03Diabetes-diagnostic-result-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-observationresultslaboratorypathology.html\">AT APS Observation Results Laboratory Pathology</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category laboratory}\">Laboratory</span>, <span title=\"Codes:{https://termgit.elga.gv.at/CodeSystem/elga-laborparameterergaenzung 300}\">Hämatologie</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 882-1}\">AB0 und Rh-Blutgruppensysteme [Typ] in Blut</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p><p><b>effective</b>: 2024-02-08 07:34:06+0100</p><p><b>performer</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-82f802a7-56a9-49b4-a675-95da08f0d7a6\">Amadeus Spital - Labor</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 278149003}\">Blutgruppe A Rh(D) positiv</span></p><p><b>specimen</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-e3567418-073e-4fd7-af4e-5fd7ee4785f7\">AtApsExample03Diabetes-diagnostic-specimen-1</a></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory",
                "display" : "Laboratory"
              }
            ]
          },
          {
            "coding" : [
              {
                "system" : "https://termgit.elga.gv.at/CodeSystem/elga-laborparameterergaenzung",
                "code" : "300",
                "display" : "Hämatologie"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "882-1",
              "display" : "AB0 und Rh-Blutgruppensysteme [Typ] in Blut"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        },
        "effectiveDateTime" : "2024-02-08T07:34:06+01:00",
        "performer" : [
          {
            "reference" : "urn:uuid:82f802a7-56a9-49b4-a675-95da08f0d7a6",
            "display" : "Amadeus Spital - Labor"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "278149003",
              "display" : "Blutgruppe A Rh(D) positiv"
            }
          ]
        },
        "specimen" : {
          "reference" : "urn:uuid:e3567418-073e-4fd7-af4e-5fd7ee4785f7",
          "display" : "AtApsExample03Diabetes-diagnostic-specimen-1"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:82f802a7-56a9-49b4-a675-95da08f0d7a6",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "AtApsExample03Diabetes-diagnostic-result-performer-1",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_AtApsExample03Diabetes-diagnostic-result-performer-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization AtApsExample03Diabetes-diagnostic-result-performer-1</b></p><a name=\"AtApsExample03Diabetes-diagnostic-result-performer-1\"> </a><a name=\"hcAtApsExample03Diabetes-diagnostic-result-performer-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-organization.html\">AT APS Organization</a></p></div><p><b>identifier</b>: <a href=\"http://terminology.hl7.org/6.2.0/NamingSystem-uri.html\" title=\"As defined by RFC 3986 (http://www.ietf.org/rfc/rfc3986.txt)(with many schemes defined in many RFCs). For OIDs and UUIDs, use the URN form (urn:oid:(note: lowercase) and urn:uuid:). See http://www.ietf.org/rfc/rfc3001.txt and http://www.ietf.org/rfc/rfc4122.txt \r\n\r\nThis oid is used as an identifier II.root to indicate the the extension is an absolute URI (technically, an IRI). Typically, this is used for OIDs and GUIDs. Note that when this OID is used with OIDs and GUIDs, the II.extension should start with urn:oid or urn:uuid: \r\n\r\nNote that this OID is created to aid with interconversion between CDA and FHIR - FHIR uses urn:ietf:rfc:3986 as equivalent to this OID. URIs as identifiers appear more commonly in FHIR.\r\n\r\nThis OID may also be used in CD.codeSystem.\">Uniform Resource Identifier (URI)</a>/urn:oid:1.2.40.0.34.99.4613</p><p><b>name</b>: Amadeus Spital - Labor</p><p><b>telecom</b>: <a href=\"tel:+43.1.3453446.0\">+43.1.3453446.0</a>, fax: +43.1.3453446.4674, <a href=\"mailto:info@amadeusspital.at\">info@amadeusspital.at</a>, <a href=\"https://www.amadeusspital.at\">https://www.amadeusspital.at</a></p><p><b>address</b>: Währinger Gürtel 18-20 Wien 1090 AUT </p></div>"
        },
        "identifier" : [
          {
            "system" : "urn:ietf:rfc:3986",
            "value" : "urn:oid:1.2.40.0.34.99.4613",
            "assigner" : {
              "display" : "Bundesministerium für Gesundheit"
            }
          }
        ],
        "name" : "Amadeus Spital - Labor",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "+43.1.3453446.0"
          },
          {
            "system" : "fax",
            "value" : "+43.1.3453446.4674"
          },
          {
            "system" : "email",
            "value" : "info@amadeusspital.at"
          },
          {
            "system" : "url",
            "value" : "https://www.amadeusspital.at"
          }
        ],
        "address" : [
          {
            "line" : ["Währinger Gürtel 18-20"],
            "city" : "Wien",
            "postalCode" : "1090",
            "country" : "AUT"
          }
        ]
      }
    },
    {
      "fullUrl" : "urn:uuid:e3567418-073e-4fd7-af4e-5fd7ee4785f7",
      "resource" : {
        "resourceType" : "Specimen",
        "id" : "AtApsExample03Diabetes-diagnostic-specimen-1",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-specimen"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Specimen_AtApsExample03Diabetes-diagnostic-specimen-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Specimen AtApsExample03Diabetes-diagnostic-specimen-1</b></p><a name=\"AtApsExample03Diabetes-diagnostic-specimen-1\"> </a><a name=\"hcAtApsExample03Diabetes-diagnostic-specimen-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-specimen.html\">AT APS Specimen</a></p></div><p><b>status</b>: Unavailable</p><p><b>type</b>: <span title=\"Codes:{http://snomed.info/sct 119297000}\">Blutprobe</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p></div>"
        },
        "status" : "unavailable",
        "type" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "119297000",
              "display" : "Blutprobe"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:74c5e186-d765-4c93-a624-c9b0746e8142",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "AtApsExample03Diabetes-vital-sign-1",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-observationvitalsigns"
          ]
        },
        "language" : "de-AT",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"de-AT\" lang=\"de-AT\"><a name=\"Observation_AtApsExample03Diabetes-vital-sign-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation AtApsExample03Diabetes-vital-sign-1</b></p><a name=\"AtApsExample03Diabetes-vital-sign-1\"> </a><a name=\"hcAtApsExample03Diabetes-vital-sign-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\">Language: de-AT</p><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-observationvitalsigns.html\">AT APS Observation Vital Signs</a></p></div><p><b>status</b>: Final</p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/observation-category vital-signs}\">Vital Signs</span></p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 8302-2}\">Körpergröße</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p><p><b>effective</b>: 2024-02-08 08:30:00+0100</p><p><b>performer</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-75db30ee-7028-486c-929a-c5126837f472\">Dr. IV-Ärztin</a></p><p><b>value</b>: 173 cm<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codecm = 'cm')</span></p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8302-2",
              "display" : "Körpergröße"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        },
        "effectiveDateTime" : "2024-02-08T08:30:00+01:00",
        "performer" : [
          {
            "reference" : "urn:uuid:75db30ee-7028-486c-929a-c5126837f472",
            "display" : "Dr. IV-Ärztin"
          }
        ],
        "valueQuantity" : {
          "value" : 173,
          "unit" : "cm",
          "system" : "http://unitsofmeasure.org",
          "code" : "cm"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:82301518-66ca-4b4c-821d-087adf643cc4",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "AtApsExample03Diabetes-illness-history-1",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-condition"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_AtApsExample03Diabetes-illness-history-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition AtApsExample03Diabetes-illness-history-1</b></p><a name=\"AtApsExample03Diabetes-illness-history-1\"> </a><a name=\"hcAtApsExample03Diabetes-illness-history-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-condition.html\">AT APS Condition</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical resolved}\">Resolved</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-ver-status confirmed}\">Confirmed</span></p><p><b>category</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-category problem-list-item}\">Problem List Item</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 161419000}\">Zustand nach Masern</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "resolved",
              "display" : "Resolved"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
              "code" : "confirmed",
              "display" : "Confirmed"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
                "code" : "problem-list-item",
                "display" : "Problem List Item"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "161419000",
              "display" : "Zustand nach Masern"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        }
      }
    },
    {
      "fullUrl" : "urn:uuid:d0a5bbf1-6d01-4d44-bac5-05f12c98411e",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "AtApsExample03Diabetes-social-history-1",
        "meta" : {
          "profile" : [
            "https://fhir.hl7.at/elga/aps/r4/StructureDefinition/at-aps-observationtobaccouse"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_AtApsExample03Diabetes-social-history-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation AtApsExample03Diabetes-social-history-1</b></p><a name=\"AtApsExample03Diabetes-social-history-1\"> </a><a name=\"hcAtApsExample03Diabetes-social-history-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"StructureDefinition-at-aps-observationtobaccouse.html\">AT APS Observation Tobacco Use</a></p></div><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 72166-2}\">Raucherstatus</span></p><p><b>subject</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8\">Maria Musterfrau</a></p><p><b>effective</b>: 2019-07-15</p><p><b>performer</b>: <a href=\"Bundle-AtApsExample03Diabetes.html#urn-uuid-75db30ee-7028-486c-929a-c5126837f472\">Dr. IV-Ärztin</a></p><p><b>value</b>: <span title=\"Codes:{http://snomed.info/sct 8517006}\">Ehemalig rauchende Person</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "72166-2",
              "display" : "Raucherstatus"
            }
          ]
        },
        "subject" : {
          "reference" : "urn:uuid:0fed5ebe-ca8f-4ad1-aba4-ddad45bd6cc8",
          "display" : "Maria Musterfrau"
        },
        "effectiveDateTime" : "2019-07-15",
        "performer" : [
          {
            "reference" : "urn:uuid:75db30ee-7028-486c-929a-c5126837f472",
            "display" : "Dr. IV-Ärztin"
          }
        ],
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "8517006",
              "display" : "Ehemalig rauchende Person"
            }
          ]
        }
      }
    }
  ]
}

```
