<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile ObservationDefinition
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:ObservationDefinition/f:title</sch:title>
    <sch:rule context="f:ObservationDefinition/f:title">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/pharm-quality/StructureDefinition/Extension-test-comment-pq']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/pharm-quality/StructureDefinition/Extension-test-comment-pq': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ObservationDefinition/f:qualifiedValue/f:appliesTo</sch:title>
    <sch:rule context="f:ObservationDefinition/f:qualifiedValue/f:appliesTo">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/pharm-quality/StructureDefinition/Extension-test-comment-pq']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/pharm-quality/StructureDefinition/Extension-test-comment-pq': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:text) &lt;= 1">text: maximum cardinality of 'text' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ObservationDefinition/f:qualifiedValue/f:range</sch:title>
    <sch:rule context="f:ObservationDefinition/f:qualifiedValue/f:range">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/pharm-quality/StructureDefinition/Extension-qualified-value-target-pq']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/pharm-quality/StructureDefinition/Extension-qualified-value-target-pq': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:low) &lt;= 1">low: maximum cardinality of 'low' is 1</sch:assert>
      <sch:assert test="count(f:high) &lt;= 1">high: maximum cardinality of 'high' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
