/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;

public class CenterBorderColor {
    private final HColor center;
    private final HColor border;
    private final String style;

    public CenterBorderColor(HColor center, HColor border) {
        this(center, border, null);
    }

    public CenterBorderColor(HColor center, HColor border, String style) {
        this.center = center;
        this.border = border;
        this.style = style;
    }

    public UGraphic apply(UGraphic ug) {
        if (!this.isOk()) {
            throw new IllegalStateException();
        }
        ug = ug.apply(this.center.bg());
        ug = this.border == null ? ug.apply(this.center) : ug.apply(this.border);
        return ug;
    }

    public boolean isOk() {
        return this.center != null;
    }

    public final HColor getCenter() {
        return this.center;
    }

    public final String getStyle() {
        return this.style;
    }

    public CenterBorderColor unlinearTo(CenterBorderColor other, int completion) {
        HColor newCenter = HColors.unlinear(this.center, other.center, completion);
        HColor newBorder = HColors.unlinear(this.border, other.border, completion);
        return new CenterBorderColor(newCenter, newBorder, this.style);
    }
}

