/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.klimt.UBackground;
import net.sourceforge.plantuml.klimt.UChange;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicNo;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UEmpty;
import net.sourceforge.plantuml.klimt.shape.UHorizontalLine;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.svek.image.ContainingEllipse;
import net.sourceforge.plantuml.utils.ObjectUtils;

public class Footprint {
    private final StringBounder stringBounder;

    public Footprint(StringBounder stringBounder) {
        this.stringBounder = stringBounder;
    }

    public ContainingEllipse getEllipse(UDrawable drawable, double alpha) {
        MyUGraphic ug = new MyUGraphic();
        drawable.drawU(ug);
        List all = ug.all;
        ContainingEllipse circle = new ContainingEllipse(alpha);
        for (XPoint2D pt : all) {
            circle.append(pt);
        }
        return circle;
    }

    class MyUGraphic
    extends UGraphicNo {
        private final List<XPoint2D> all;

        public MyUGraphic() {
            super(Footprint.this.stringBounder, UTranslate.none());
            this.all = new ArrayList<XPoint2D>();
        }

        private MyUGraphic(MyUGraphic other, UChange change) {
            super(other.getStringBounder(), change instanceof UTranslate ? other.getTranslate().compose((UTranslate)change) : other.getTranslate());
            if (!ObjectUtils.instanceOfAny(change, UBackground.class, HColor.class, UStroke.class, UTranslate.class)) {
                throw new UnsupportedOperationException(change.getClass().toString());
            }
            this.all = other.all;
        }

        @Override
        public UGraphic apply(UChange change) {
            return new MyUGraphic(this, change);
        }

        public void draw(UShape shape) {
            double x = this.getTranslate().getDx();
            double y = this.getTranslate().getDy();
            if (shape instanceof UText) {
                this.drawText(x, y, (UText)shape);
            } else if (!(shape instanceof UHorizontalLine) && !(shape instanceof ULine)) {
                if (shape instanceof UImage) {
                    this.drawImage(x, y, (UImage)shape);
                } else if (shape instanceof UPath) {
                    this.drawPath(x, y, (UPath)shape);
                } else if (shape instanceof URectangle) {
                    this.drawRectangle(x, y, (URectangle)shape);
                } else if (shape instanceof UEllipse) {
                    this.drawEllipse(x, y, (UEllipse)shape);
                } else if (shape instanceof UEmpty) {
                    this.drawEmpty(x, y, (UEmpty)shape);
                } else {
                    throw new UnsupportedOperationException(shape.getClass().toString());
                }
            }
        }

        @Override
        public ColorMapper getColorMapper() {
            return ColorMapper.IDENTITY;
        }

        private void addPoint(double x, double y) {
            this.all.add(new XPoint2D(x, y));
        }

        private void drawText(double x, double y, UText text) {
            XDimension2D dim = this.getStringBounder().calculateDimension(text.getFontConfiguration().getFont(), text.getText());
            this.addPoint(x, y -= dim.getHeight() - 1.5);
            this.addPoint(x, y + dim.getHeight());
            this.addPoint(x + dim.getWidth(), y);
            this.addPoint(x + dim.getWidth(), y + dim.getHeight());
        }

        private void drawImage(double x, double y, UImage image) {
            this.addPoint(x, y);
            this.addPoint(x, y + (double)image.getHeight());
            this.addPoint(x + (double)image.getWidth(), y);
            this.addPoint(x + (double)image.getWidth(), y + (double)image.getHeight());
        }

        private void drawPath(double x, double y, UPath path) {
            this.addPoint(x + path.getMinX(), y + path.getMinY());
            this.addPoint(x + path.getMaxX(), y + path.getMaxY());
        }

        private void drawRectangle(double x, double y, URectangle rect) {
            this.addPoint(x, y);
            this.addPoint(x + rect.getWidth(), y + rect.getHeight());
        }

        private void drawEllipse(double x, double y, UEllipse rect) {
            this.addPoint(x, y);
            this.addPoint(x + rect.getWidth(), y + rect.getHeight());
        }

        private void drawEmpty(double x, double y, UEmpty rect) {
            this.addPoint(x, y);
            this.addPoint(x + rect.getWidth(), y + rect.getHeight());
        }
    }
}

