/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.gitlog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.gitlog.CursorPosition;

public class Commit {
    private final String name;
    private final String comment;
    private final CursorPosition position;

    public Commit(String name, CursorPosition position) {
        this.name = name;
        this.position = position;
        this.comment = position.getCommentInLine();
        if (!position.matches("* ") && !position.matches("*-")) {
            throw new IllegalArgumentException();
        }
    }

    public String getComment() {
        return this.comment;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        Commit other = (Commit)obj;
        return this.name.equals(other.name);
    }

    public String toString() {
        return this.name;
    }

    public List<CursorPosition> getCandidatesForDown() {
        ArrayList<CursorPosition> result = new ArrayList<CursorPosition>();
        if (this.position.move(0, 1).matches("*")) {
            result.add(this.position.move(0, 1));
        }
        CursorPosition current = this.position;
        Commit.addAbove(result, current);
        while (true) {
            if ((current = current.move(1, 0)).matches(".")) {
                Commit.addAbove(result, current);
                continue;
            }
            if (!current.matches("-")) break;
        }
        return Collections.unmodifiableList(result);
    }

    private static void addAbove(List<CursorPosition> result, CursorPosition here) {
        if (here.move(0, 1).matches("|")) {
            result.add(here.move(0, 1));
        }
        if (here.move(1, 1).matches("\\")) {
            result.add(here.move(1, 1));
        }
        if (here.move(-1, 1).matches("/")) {
            result.add(here.move(-1, 1));
        }
    }

    public List<Commit> getAncestors() {
        ArrayList<Commit> result = new ArrayList<Commit>();
        for (CursorPosition pos : this.getCandidatesForDown()) {
            CursorPosition down = pos.getDownFromHere();
            result.add(down.getCommit());
        }
        return Collections.unmodifiableList(result);
    }

    public String getName() {
        return this.name;
    }

    public final CursorPosition getPosition() {
        return this.position;
    }
}

