<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile ObservationDefinition
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:ObservationDefinition</sch:title>
    <sch:rule context="f:ObservationDefinition">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/livd/StructureDefinition/ext-device']) &gt;= 1">extension with URL = 'http://hl7.org/fhir/uv/livd/StructureDefinition/ext-device': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/uv/livd/StructureDefinition/ext-vendorReferenceIdentifier']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/uv/livd/StructureDefinition/ext-vendorReferenceIdentifier': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:category) &lt;= 0">category: maximum cardinality of 'category' is 0</sch:assert>
      <sch:assert test="count(f:permittedDataType) &lt;= 1">permittedDataType: maximum cardinality of 'permittedDataType' is 1</sch:assert>
      <sch:assert test="count(f:multipleResultsAllowed) &lt;= 0">multipleResultsAllowed: maximum cardinality of 'multipleResultsAllowed' is 0</sch:assert>
      <sch:assert test="count(f:preferredReportName) &lt;= 0">preferredReportName: maximum cardinality of 'preferredReportName' is 0</sch:assert>
      <sch:assert test="count(f:qualifiedInterval) &lt;= 0">qualifiedInterval: maximum cardinality of 'qualifiedInterval' is 0</sch:assert>
      <sch:assert test="count(f:normalCodedValueSet) &lt;= 0">normalCodedValueSet: maximum cardinality of 'normalCodedValueSet' is 0</sch:assert>
      <sch:assert test="count(f:abnormalCodedValueSet) &lt;= 0">abnormalCodedValueSet: maximum cardinality of 'abnormalCodedValueSet' is 0</sch:assert>
      <sch:assert test="count(f:criticalCodedValueSet) &lt;= 0">criticalCodedValueSet: maximum cardinality of 'criticalCodedValueSet' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
